/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.DocumentGuardedTextUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateAction
extends EditorAction {
    public DuplicateAction() {
        super((EditorActionHandler)new Handler());
    }

    public static void duplicateLineOrSelectedBlockAtCaret(Editor editor) {
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (editor.getSelectionModel().hasSelection()) {
            int start2 = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            String s = document.getCharsSequence().subSequence(start2, end).toString();
            document.insertString(end, (CharSequence)s);
            caretModel.moveToOffset(end + s.length());
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            editor.getSelectionModel().setSelection(end, end + s.length());
        } else {
            DuplicateAction.duplicateLinesRange(editor, document, caretModel.getVisualPosition(), caretModel.getVisualPosition());
        }
    }

    @Nullable
    static Couple<Integer> duplicateLinesRange(Editor editor, Document document, VisualPosition rangeStart, VisualPosition rangeEnd) {
        Pair<LogicalPosition, LogicalPosition> lines2 = EditorUtil.calcSurroundingRange(editor, rangeStart, rangeEnd);
        int offset = editor.getCaretModel().getOffset();
        LogicalPosition lineStart = (LogicalPosition)lines2.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines2.second;
        int start2 = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        if (end <= start2) {
            return null;
        }
        Object s = document.getCharsSequence().subSequence(start2, end).toString();
        int newOffset = end + offset - start2;
        int selectionStart = end;
        if (nextLineStart.line == document.getLineCount() - 1 && nextLineStart.column > 0) {
            s = "\n" + (String)s;
            ++newOffset;
            ++selectionStart;
        }
        DocumentGuardedTextUtil.insertString(document, end, (CharSequence)s);
        editor.getCaretModel().moveToOffset(newOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return Couple.of((Object)selectionStart, (Object)(end + ((String)s).length()));
    }

    public void update(Editor editor, Presentation presentation2, DataContext dataContext) {
        super.update(editor, presentation2, dataContext);
        if (editor.getSelectionModel().hasSelection()) {
            presentation2.setText(EditorBundle.message((String)"action.duplicate.selection", (Object[])new Object[0]), true);
        } else {
            presentation2.setText(EditorBundle.message((String)"action.duplicate.line", (Object[])new Object[0]), true);
        }
    }

    private static class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            DuplicateAction.duplicateLineOrSelectedBlockAtCaret(editor);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(3);
            }
            return !editor.isOneLineMode() || editor.getSelectionModel().hasSelection();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/DuplicateAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeWriteAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

