/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.util.Key;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorLocation {
    private final Editor myEditor;
    private final Point myPoint;
    private VisualPosition myVisualPosition;
    private LogicalPosition myLogicalPosition;
    private int myOffset;
    private int[] myVisualLineYRange;
    private FoldRegion myCollapsedRegion;
    private static final FoldRegion NO_REGION = new FoldRegion(){

        public boolean isExpanded() {
            return false;
        }

        public void setExpanded(boolean expanded) {
        }

        @NotNull
        public String getPlaceholderText() {
            return "";
        }

        public Editor getEditor() {
            return null;
        }

        @Nullable
        public FoldingGroup getGroup() {
            return null;
        }

        public boolean shouldNeverExpand() {
            return false;
        }

        @NotNull
        public Document getDocument() {
            throw new UnsupportedOperationException();
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public boolean isValid() {
            return false;
        }

        public void setGreedyToLeft(boolean greedy) {
        }

        public void setGreedyToRight(boolean greedy) {
        }

        public boolean isGreedyToRight() {
            return false;
        }

        public boolean isGreedyToLeft() {
            return false;
        }

        public void dispose() {
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorLocation$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    EditorLocation(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            EditorLocation.$$$reportNull$$$0(0);
        }
        if (point == null) {
            EditorLocation.$$$reportNull$$$0(1);
        }
        this.myOffset = -1;
        this.myCollapsedRegion = NO_REGION;
        this.myEditor = editor;
        this.myPoint = point;
    }

    @NotNull
    Point getPoint() {
        Point point = this.myPoint;
        if (point == null) {
            EditorLocation.$$$reportNull$$$0(2);
        }
        return point;
    }

    @NotNull
    VisualPosition getVisualPosition() {
        if (this.myVisualPosition == null) {
            this.myVisualPosition = this.myEditor.xyToVisualPosition(this.myPoint);
        }
        VisualPosition visualPosition = this.myVisualPosition;
        if (visualPosition == null) {
            EditorLocation.$$$reportNull$$$0(3);
        }
        return visualPosition;
    }

    int getVisualLineStartY() {
        if (this.myVisualLineYRange == null) {
            this.myVisualLineYRange = this.myEditor.visualLineToYRange(this.getVisualPosition().line);
        }
        return this.myVisualLineYRange[0];
    }

    int getVisualLineEndY() {
        if (this.myVisualLineYRange == null) {
            this.myVisualLineYRange = this.myEditor.visualLineToYRange(this.getVisualPosition().line);
        }
        return this.myVisualLineYRange[1];
    }

    @NotNull
    LogicalPosition getLogicalPosition() {
        if (this.myLogicalPosition == null) {
            this.myLogicalPosition = this.myEditor.visualToLogicalPosition(this.getVisualPosition());
        }
        LogicalPosition logicalPosition = this.myLogicalPosition;
        if (logicalPosition == null) {
            EditorLocation.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    int getOffset() {
        if (this.myOffset < 0) {
            this.myOffset = this.myEditor.logicalPositionToOffset(this.getLogicalPosition());
        }
        return this.myOffset;
    }

    FoldRegion getCollapsedRegion() {
        if (this.myCollapsedRegion == NO_REGION) {
            this.myCollapsedRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(this.getOffset());
        }
        return this.myCollapsedRegion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorLocation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

