/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.EditorFragmentRenderer;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.ErrorStripeMarkersModel;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.InspectionPopupManager;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.InspectionWidgetActionProvider;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.MouseMovementTracker;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.BooleanSupplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorMarkupModelImpl
extends MarkupModelImpl
implements EditorMarkupModel,
CaretListener,
BulkAwareDocumentListener.Simple,
VisibleAreaListener {
    private static final TooltipGroup ERROR_STRIPE_TOOLTIP_GROUP = new TooltipGroup("ERROR_STRIPE_TOOLTIP_GROUP", 0);
    private static final JBValue SCROLLBAR_WIDTH = new JBValue.UIInteger("Editor.scrollBarWidth", 14);
    private static final ColorKey HOVER_BACKGROUND = ColorKey.createColorKey((String)"ActionButton.hoverBackground", (Color)JBUI.CurrentTheme.ActionButton.hoverBackground());
    private static final ColorKey PRESSED_BACKGROUND = ColorKey.createColorKey((String)"ActionButton.pressedBackground", (Color)JBUI.CurrentTheme.ActionButton.pressedBackground());
    private static final ColorKey ICON_TEXT_COLOR = ColorKey.createColorKey((String)"ActionButton.iconTextForeground", (Color)UIUtil.getContextHelpForeground());
    private static final int QUICK_ANALYSIS_TIMEOUT = 3000;
    private static final Logger LOG = Logger.getInstance(EditorMarkupModelImpl.class);
    @NotNull
    private final EditorImpl myEditor;
    @Nullable
    private ErrorStripeRenderer myErrorStripeRenderer;
    private final MergingUpdateQueue myStatusUpdates;
    private final ErrorStripeMarkersModel myErrorStripeMarkersModel;
    private boolean dimensionsAreValid;
    private int myEditorScrollbarTop;
    private int myEditorTargetHeight;
    private int myEditorSourceHeight;
    @Nullable
    private ProperTextRange myDirtyYPositions;
    private static final ProperTextRange WHOLE_DOCUMENT = new ProperTextRange(0, 0);
    @NotNull
    private ErrorStripTooltipRendererProvider myTooltipRendererProvider;
    private int myMinMarkHeight;
    @NotNull
    private final EditorFragmentRenderer myEditorFragmentRenderer;
    private final MouseMovementTracker myMouseMovementTracker;
    private int myRowAdjuster;
    private int myWheelAccumulator;
    private int myLastVisualLine;
    private WeakReference<LightweightHint> myCurrentHint;
    private int myCurrentHintAnchorY;
    private boolean myKeepHint;
    private final ActionToolbar statusToolbar;
    private boolean showToolbar;
    private boolean trafficLightVisible;
    private final ComponentListener toolbarComponentListener;
    private Rectangle cachedToolbarBounds;
    private final JLabel smallIconLabel;
    private AnalyzerStatus analyzerStatus;
    private boolean hasAnalyzed;
    private boolean isAnalyzing;
    private boolean showNavigation;
    private boolean reportErrorStripeInconsistency;
    private InspectionPopupManager myPopupManager;
    private final Disposable resourcesDisposable;
    private final Alarm statusTimer;
    private final Map<InspectionWidgetActionProvider, AnAction> extensionActions;
    private static final Key<List<StatusItem>> EXPANDED_STATUS = new Key("EXPANDED_STATUS");
    private static final Key<Boolean> TRANSLUCENT_STATE = new Key("TRANSLUCENT_STATE");

    private int getMinMarkHeight() {
        return JBUIScale.scale((int)this.myMinMarkHeight);
    }

    private static int getThinGap() {
        return JBUIScale.scale((int)2);
    }

    private static int getMaxStripeSize() {
        return JBUIScale.scale((int)4);
    }

    private static int getMaxMacThumbWidth() {
        return JBUIScale.scale((int)10);
    }

    private static int getStatusIconSize() {
        return JBUIScale.scale((int)18);
    }

    EditorMarkupModelImpl(final @NotNull EditorImpl editor) {
        if (editor == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(0);
        }
        super(editor.getDocument());
        this.myEditorScrollbarTop = -1;
        this.myEditorTargetHeight = -1;
        this.myEditorSourceHeight = -1;
        this.myTooltipRendererProvider = new BasicTooltipRendererProvider();
        this.myMouseMovementTracker = new MouseMovementTracker();
        this.cachedToolbarBounds = new Rectangle();
        this.reportErrorStripeInconsistency = true;
        this.resourcesDisposable = Disposer.newDisposable();
        this.statusTimer = new Alarm(this.resourcesDisposable);
        this.extensionActions = new HashMap<InspectionWidgetActionProvider, AnAction>();
        this.myEditor = editor;
        this.myEditorFragmentRenderer = new EditorFragmentRenderer(editor);
        this.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
        this.myPopupManager = new InspectionPopupManager(() -> this.analyzerStatus, editor, (AnAction)new CompactViewAction());
        this.showToolbar = EditorSettingsExternalizable.getInstance().isShowInspectionWidget();
        this.trafficLightVisible = true;
        final AnAction nextErrorAction = this.createAction("GotoNextError", AllIcons.Actions.FindAndShowNextMatchesSmall);
        final AnAction prevErrorAction = this.createAction("GotoPreviousError", AllIcons.Actions.FindAndShowPrevMatchesSmall);
        DefaultActionGroup navigateGroup = new DefaultActionGroup(new AnAction[]{prevErrorAction, nextErrorAction}){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabledAndVisible(EditorMarkupModelImpl.this.showNavigation);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$1", "update"));
            }
        };
        StatusAction statusAction = new StatusAction();
        DefaultActionGroup actions2 = new DefaultActionGroup(new AnAction[]{this.createEPActions(), statusAction, navigateGroup});
        final EditorToolbarButtonLook editorButtonLook = new EditorToolbarButtonLook();
        this.statusToolbar = new ActionToolbarImpl("EditorInspectionsToolbar", (ActionGroup)actions2, true){

            @Override
            public void addNotify() {
                this.setTargetComponent(editor.getContentComponent());
                super.addNotify();
            }

            @Override
            protected void paintComponent(Graphics g) {
                editorButtonLook.paintBackground(g, (JComponent)this, EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
            }

            @Override
            @NotNull
            protected Color getSeparatorColor() {
                Color separatorColor = EditorMarkupModelImpl.this.myEditor.getColorsScheme().getColor(EditorColors.SEPARATOR_BELOW_COLOR);
                Color color = separatorColor != null ? separatorColor : super.getSeparatorColor();
                if (color == null) {
                    2.$$$reportNull$$$0(0);
                }
                return color;
            }

            @Override
            protected int getSeparatorHeight() {
                return EditorMarkupModelImpl.getStatusIconSize();
            }

            @Override
            @NotNull
            protected ActionButton createToolbarButton(@NotNull AnAction action2, ActionButtonLook look, @NotNull String place, @NotNull Presentation presentation2, @NotNull Dimension minimumSize) {
                if (action2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (place == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (presentation2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (minimumSize == null) {
                    2.$$$reportNull$$$0(4);
                }
                ActionButton actionButton = new ActionButton(action2, presentation2, place, minimumSize){

                    @Override
                    public void updateIcon() {
                        super.updateIcon();
                        this.revalidate();
                        this.repaint();
                    }

                    @Override
                    public Insets getInsets() {
                        return this.myAction == nextErrorAction ? JBUI.insets((int)2, (int)1) : (this.myAction == prevErrorAction ? JBUI.insets((int)2, (int)1, (int)2, (int)2) : JBUI.insets((int)2));
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Icon icon2 = this.getIcon();
                        Dimension size2 = new Dimension(icon2.getIconWidth(), icon2.getIconHeight());
                        int minSize = EditorMarkupModelImpl.getStatusIconSize();
                        size2.width = Math.max(size2.width, minSize);
                        size2.height = Math.max(size2.height, minSize);
                        JBInsets.addTo((Dimension)size2, (Insets)this.getInsets());
                        return size2;
                    }
                };
                actionButton.setLook(editorButtonLook);
                ActionButton actionButton2 = actionButton;
                if (actionButton2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                return actionButton2;
            }

            @Override
            @NotNull
            protected JComponent createCustomComponent(@NotNull CustomComponentAction action2, @NotNull Presentation presentation2) {
                JComponent component2;
                if (action2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (presentation2 == null) {
                    2.$$$reportNull$$$0(7);
                }
                if ((component2 = super.createCustomComponent(action2, presentation2)) instanceof ActionButton) {
                    ((ActionButton)component2).setLook(editorButtonLook);
                }
                JComponent jComponent = component2;
                if (jComponent == null) {
                    2.$$$reportNull$$$0(8);
                }
                return jComponent;
            }

            @Override
            public void doLayout() {
                LayoutManager layoutManager = this.getLayout();
                if (layoutManager != null) {
                    layoutManager.layoutContainer(this);
                } else {
                    super.doLayout();
                }
            }

            @Override
            protected Dimension updatePreferredSize(Dimension preferredSize) {
                return preferredSize;
            }

            @Override
            protected Dimension updateMinimumSize(Dimension minimumSize) {
                return minimumSize;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$2";
                        break;
                    }
                    case 1: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "minimumSize";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSeparatorColor";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$2";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createToolbarButton";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCustomComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createToolbarButton";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "createCustomComponent";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.statusToolbar.setMiniMode(true);
        this.toolbarComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Component toolbar = event.getComponent();
                if (toolbar.getWidth() > 0 && toolbar.getHeight() > 0) {
                    EditorMarkupModelImpl.this.updateTrafficLightVisibility();
                }
            }
        };
        JComponent toolbar = this.statusToolbar.getComponent();
        toolbar.setLayout(new StatusComponentLayout());
        toolbar.addComponentListener(this.toolbarComponentListener);
        toolbar.setBorder(JBUI.Borders.empty((int)2));
        this.smallIconLabel = new JLabel();
        this.smallIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                EditorMarkupModelImpl.this.myPopupManager.hidePopup();
                if (EditorMarkupModelImpl.this.analyzerStatus != null) {
                    EditorMarkupModelImpl.this.analyzerStatus.getController().toggleProblemsView();
                }
            }

            @Override
            public void mouseEntered(MouseEvent event) {
                EditorMarkupModelImpl.this.myPopupManager.scheduleShow(event);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                EditorMarkupModelImpl.this.myPopupManager.scheduleHide();
            }
        });
        this.smallIconLabel.setOpaque(false);
        this.smallIconLabel.setBackground((Color)new JBColor(() -> this.myEditor.getColorsScheme().getDefaultBackground()));
        this.smallIconLabel.setVisible(false);
        NonOpaquePanel statusPanel = new NonOpaquePanel();
        statusPanel.setVisible(!this.myEditor.isOneLineMode());
        statusPanel.setLayout(new BoxLayout((Container)statusPanel, 0));
        statusPanel.add(toolbar);
        statusPanel.add(this.smallIconLabel);
        ((JBScrollPane)this.myEditor.getScrollPane()).setStatusComponent((JComponent)statusPanel);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(this.resourcesDisposable);
        connection.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                if (action2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (action2 instanceof HintManagerImpl.ActionToIgnore) {
                    return;
                }
                EditorMarkupModelImpl.this.myPopupManager.hidePopup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$5";
                objectArray[2] = "beforeActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(LafManagerListener.TOPIC, source -> this.myPopupManager.updateUI());
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                EditorMarkupModelImpl.this.showToolbar = EditorSettingsExternalizable.getInstance().isShowInspectionWidget() && (EditorMarkupModelImpl.this.analyzerStatus == null || EditorMarkupModelImpl.this.analyzerStatus.getController().enableToolbar());
                EditorMarkupModelImpl.this.updateTrafficLightVisibility();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$6", "selectionChanged"));
            }
        });
        this.myStatusUpdates = new MergingUpdateQueue(this.getClass().getName(), 50, true, MergingUpdateQueue.ANY_COMPONENT, this.resourcesDisposable);
        this.myErrorStripeMarkersModel = new ErrorStripeMarkersModel(this.myEditor, this.resourcesDisposable);
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        if (event == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(1);
        }
        this.updateTrafficLightVisibility();
    }

    public void afterDocumentChange(@NotNull Document document) {
        if (document == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(2);
        }
        this.myPopupManager.hidePopup();
        this.updateTrafficLightVisibility();
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(3);
        }
        this.updateTrafficLightVisibility();
    }

    private void updateTrafficLightVisibility() {
        this.myStatusUpdates.queue(Update.create((Object)"visibility", this::doUpdateTrafficLightVisibility));
    }

    private void doUpdateTrafficLightVisibility() {
        if (this.trafficLightVisible) {
            if (this.showToolbar && this.myEditor.myView != null) {
                this.statusToolbar.setTargetComponent((JComponent)this.myEditor.getContentComponent());
                VisualPosition pos = this.myEditor.getCaretModel().getPrimaryCaret().getVisualPosition();
                Point point = this.myEditor.visualPositionToXY(pos);
                point = SwingUtilities.convertPoint(this.myEditor.getContentComponent(), point, this.myEditor.getScrollPane());
                JComponent stComponent = this.statusToolbar.getComponent();
                if (stComponent.isVisible()) {
                    Rectangle bounds2 = SwingUtilities.convertRectangle(stComponent, stComponent.getBounds(), this.myEditor.getScrollPane());
                    if (!bounds2.isEmpty() && bounds2.contains(point)) {
                        this.cachedToolbarBounds = bounds2;
                        stComponent.setVisible(false);
                        this.smallIconLabel.setVisible(true);
                    }
                } else if (!this.cachedToolbarBounds.contains(point)) {
                    stComponent.setVisible(true);
                    this.smallIconLabel.setVisible(false);
                }
            } else {
                this.statusToolbar.getComponent().setVisible(false);
                this.smallIconLabel.setVisible(true);
            }
        } else {
            this.statusToolbar.getComponent().setVisible(false);
            this.smallIconLabel.setVisible(false);
        }
    }

    private DefaultActionGroup createEPActions() {
        final DefaultActionGroup epActions = new DefaultActionGroup();
        InspectionWidgetActionProvider.EP_NAME.getExtensionList().forEach(extension2 -> {
            AnAction action2 = extension2.createAction((Editor)this.myEditor);
            if (action2 != null) {
                this.extensionActions.put((InspectionWidgetActionProvider)extension2, action2);
                epActions.add(action2);
            }
        });
        InspectionWidgetActionProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<InspectionWidgetActionProvider>(){

            public void extensionAdded(@NotNull InspectionWidgetActionProvider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    7.$$$reportNull$$$0(1);
                }
                AnAction action2 = extension2.createAction((Editor)EditorMarkupModelImpl.this.myEditor);
                EditorMarkupModelImpl.this.extensionActions.put(extension2, action2);
                epActions.add(action2);
            }

            public void extensionRemoved(@NotNull InspectionWidgetActionProvider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                AnAction action2;
                if (extension2 == null) {
                    7.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    7.$$$reportNull$$$0(3);
                }
                if ((action2 = EditorMarkupModelImpl.this.extensionActions.remove(extension2)) != null) {
                    epActions.remove(action2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.resourcesDisposable);
        return epActions;
    }

    private AnAction createAction(@NotNull String id2, @NotNull Icon icon2) {
        if (id2 == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(4);
        }
        if (icon2 == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(5);
        }
        AnAction delegate2 = ActionManager.getInstance().getAction(id2);
        MarkupModelDelegateAction result2 = new MarkupModelDelegateAction(delegate2, icon2);
        result2.copyShortcutFrom(delegate2);
        return result2;
    }

    private int offsetToLine(int offset, @NotNull Document document) {
        if (document == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(6);
        }
        if (offset < 0) {
            return 0;
        }
        if (offset > document.getTextLength()) {
            return this.myEditor.getVisibleLineCount();
        }
        return this.myEditor.offsetToVisualLine(offset);
    }

    private void repaintVerticalScrollBar() {
        this.myEditor.getVerticalScrollBar().repaint();
    }

    void recalcEditorDimensions() {
        EditorImpl.MyScrollBar scrollBar = this.myEditor.getVerticalScrollBar();
        int scrollBarHeight = Math.max(0, scrollBar.getSize().height);
        this.myEditorScrollbarTop = scrollBar.getDecScrollButtonHeight();
        assert (this.myEditorScrollbarTop >= 0);
        int editorScrollbarBottom = scrollBar.getIncScrollButtonHeight();
        this.myEditorTargetHeight = scrollBarHeight - this.myEditorScrollbarTop - editorScrollbarBottom;
        this.myEditorSourceHeight = this.myEditor.getPreferredHeight();
        this.dimensionsAreValid = scrollBarHeight != 0;
    }

    public void setTrafficLightIconVisible(boolean value2) {
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            if (value2 != this.trafficLightVisible) {
                this.trafficLightVisible = value2;
                this.updateTrafficLightVisibility();
            }
            this.repaint();
        }
    }

    public void repaintTrafficLightIcon() {
        if (this.myErrorStripeRenderer == null) {
            return;
        }
        this.myStatusUpdates.queue(Update.create((Object)"icon", () -> {
            AnalyzerStatus newStatus;
            if (this.myErrorStripeRenderer != null && !AnalyzerStatus.equals((AnalyzerStatus)(newStatus = this.myErrorStripeRenderer.getStatus()), (AnalyzerStatus)this.analyzerStatus)) {
                this.changeStatus(newStatus);
            }
        }));
    }

    private void changeStatus(AnalyzerStatus newStatus) {
        this.statusTimer.cancelAllRequests();
        boolean resetAnalyzingStatus = this.analyzerStatus != null && this.analyzerStatus.isTextStatus() && this.analyzerStatus.getAnalyzingType() == AnalyzingType.COMPLETE;
        this.analyzerStatus = newStatus;
        AnalyzingType type = this.analyzerStatus.getAnalyzingType();
        this.smallIconLabel.setIcon(type == AnalyzingType.COMPLETE || type == AnalyzingType.SUSPENDED ? this.analyzerStatus.getIcon() : AllIcons.General.InspectionsEye);
        if (this.showToolbar != this.analyzerStatus.getController().enableToolbar()) {
            this.showToolbar = EditorSettingsExternalizable.getInstance().isShowInspectionWidget() && this.analyzerStatus.getController().enableToolbar();
            this.updateTrafficLightVisibility();
        }
        boolean analyzing = this.analyzerStatus.getAnalyzingType() != AnalyzingType.COMPLETE;
        this.hasAnalyzed = !resetAnalyzingStatus && (this.hasAnalyzed || this.isAnalyzing && !analyzing);
        this.isAnalyzing = analyzing;
        if (this.analyzerStatus.getAnalyzingType() != AnalyzingType.EMPTY) {
            this.showNavigation = this.analyzerStatus.getShowNavigation();
        } else {
            this.statusTimer.addRequest(() -> {
                this.hasAnalyzed = false;
                ActivityTracker.getInstance().inc();
            }, 3000);
        }
        this.myPopupManager.updateVisiblePopup();
        ActivityTracker.getInstance().inc();
    }

    private LightweightHint getCurrentHint() {
        if (this.myCurrentHint == null) {
            return null;
        }
        LightweightHint hint = (LightweightHint)this.myCurrentHint.get();
        if (hint == null || !hint.isVisible()) {
            this.myCurrentHint = null;
            hint = null;
        }
        return hint;
    }

    @NotNull
    private static Rectangle getBoundsOnScreen(@NotNull LightweightHint hint) {
        if (hint == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(7);
        }
        JComponent component2 = hint.getComponent();
        Point location = hint.getLocationOn(component2);
        SwingUtilities.convertPointToScreen(location, component2);
        return new Rectangle(location, hint.getSize());
    }

    private boolean showToolTipByMouseMove(@NotNull MouseEvent e) {
        boolean isVisible2;
        int visualLine;
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(8);
        }
        MouseEvent me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), 0, e.getY() + 1, e.getClickCount(), e.isPopupTrigger());
        LightweightHint currentHint = this.getCurrentHint();
        if (currentHint != null && (this.myKeepHint || this.myMouseMovementTracker.isMovingTowards(e, EditorMarkupModelImpl.getBoundsOnScreen(currentHint)))) {
            return true;
        }
        this.myLastVisualLine = visualLine = this.getVisualLineByEvent(e);
        Rectangle area = this.myEditor.getScrollingModel().getVisibleArea();
        int visualY = this.myEditor.visualLineToY(visualLine);
        boolean bl = isVisible2 = this.myWheelAccumulator == 0 && area.contains(area.x, visualY);
        if (UIUtil.uiParents((Component)this.myEditor.getComponent(), (boolean)false).filter(EditorWindowHolder.class).isEmpty() || isVisible2 || !UISettings.getInstance().getShowEditorToolTip()) {
            HashSet highlighters = new HashSet();
            this.getNearestHighlighters(this, me.getY(), highlighters);
            this.getNearestHighlighters(((EditorEx)this.getEditor()).getFilteredDocumentMarkupModel(), me.getY(), highlighters);
            if (highlighters.isEmpty()) {
                return false;
            }
            int y = e.getY();
            RangeHighlighter nearest = this.getNearestRangeHighlighter(e);
            if (nearest != null) {
                ProperTextRange range2 = this.offsetsToYPositions(nearest.getStartOffset(), nearest.getEndOffset());
                int eachStartY = range2.getStartOffset();
                int eachEndY = range2.getEndOffset();
                y = eachStartY + (eachEndY - eachStartY) / 2;
            }
            if (currentHint != null && y == this.myCurrentHintAnchorY) {
                return true;
            }
            me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), me.getX(), y + 1, e.getClickCount(), e.isPopupTrigger());
            TooltipRenderer bigRenderer = this.myTooltipRendererProvider.calcTooltipRenderer(highlighters);
            if (bigRenderer != null) {
                LightweightHint hint = this.showTooltip(bigRenderer, EditorMarkupModelImpl.createHint(me).setForcePopup(true));
                this.myCurrentHint = new WeakReference<LightweightHint>(hint);
                this.myCurrentHintAnchorY = y;
                this.myKeepHint = false;
                this.myMouseMovementTracker.reset();
                return true;
            }
            return false;
        }
        float rowRatio = (float)visualLine / (float)(this.myEditor.getVisibleLineCount() - 1);
        int y = this.myRowAdjuster != 0 ? (int)(rowRatio * (float)this.myEditor.getVerticalScrollBar().getHeight()) : me.getY();
        me = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), y, me.getClickCount(), me.isPopupTrigger());
        ArrayList highlighters = new ArrayList();
        this.collectRangeHighlighters(this, visualLine, highlighters);
        this.collectRangeHighlighters(this.myEditor.getFilteredDocumentMarkupModel(), visualLine, highlighters);
        this.myEditorFragmentRenderer.show(visualLine, highlighters, me.isAltDown(), EditorMarkupModelImpl.createHint(me));
        return true;
    }

    private static HintHint createHint(MouseEvent me) {
        return new HintHint(me).setAwtTooltip(true).setPreferredPosition(Balloon.Position.atLeft).setBorderInsets((Insets)JBUI.insets((int)1)).setShowImmediately(true).setAnimationEnabled(false);
    }

    private int getVisualLineByEvent(@NotNull MouseEvent e) {
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(9);
        }
        int y = e.getY();
        if (e.getSource() == this.myEditor.getVerticalScrollBar() && y == this.myEditor.getVerticalScrollBar().getHeight() - 1) {
            ++y;
        }
        return EditorMarkupModelImpl.fitLineToEditor(this.myEditor, this.myEditor.offsetToVisualLine(this.yPositionToOffset(y + this.myWheelAccumulator, true)));
    }

    static int fitLineToEditor(EditorImpl editor, int visualLine) {
        int lineCount = editor.getVisibleLineCount();
        int shift = 0;
        if (visualLine >= lineCount - 1) {
            CharSequence sequence = editor.getDocument().getCharsSequence();
            shift = sequence.length() < 1 ? 0 : (sequence.charAt(sequence.length() - 1) == '\n' ? 1 : 0);
        }
        return Math.max(0, Math.min(lineCount - shift, visualLine));
    }

    private int getOffset(int visualLine, boolean startLine) {
        return this.myEditor.visualPositionToOffset(new VisualPosition(visualLine, startLine ? 0 : Integer.MAX_VALUE));
    }

    private void collectRangeHighlighters(@NotNull MarkupModelEx markupModel, int visualLine, @NotNull Collection<? super RangeHighlighterEx> highlighters) {
        if (markupModel == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(10);
        }
        if (highlighters == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(11);
        }
        int startOffset = this.getOffset(EditorMarkupModelImpl.fitLineToEditor(this.myEditor, visualLine - EditorFragmentRenderer.PREVIEW_LINES), true);
        int endOffset = this.getOffset(EditorMarkupModelImpl.fitLineToEditor(this.myEditor, visualLine + EditorFragmentRenderer.PREVIEW_LINES), false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            Object tooltip2 = highlighter.getErrorStripeTooltip();
            if (!(tooltip2 == null || tooltip2 instanceof HighlightInfo && ((HighlightInfo)tooltip2).type == HighlightInfoType.TODO || highlighter.getStartOffset() >= endOffset || highlighter.getEndOffset() <= startOffset || highlighter.getErrorStripeMarkColor(this.myEditor.getColorsScheme()) == null)) {
                highlighters.add((RangeHighlighterEx)highlighter);
            }
            return true;
        }));
    }

    @Nullable
    private RangeHighlighter getNearestRangeHighlighter(@NotNull MouseEvent e) {
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(12);
        }
        ArrayList highlighters = new ArrayList();
        this.getNearestHighlighters(this, e.getY(), highlighters);
        this.getNearestHighlighters(this.myEditor.getFilteredDocumentMarkupModel(), e.getY(), highlighters);
        RangeHighlighter nearestMarker = null;
        int yPos = 0;
        for (RangeHighlighter highlighter : highlighters) {
            int newYPos = this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset()).getStartOffset();
            if (nearestMarker != null && Math.abs(yPos - e.getY()) <= Math.abs(newYPos - e.getY())) continue;
            nearestMarker = highlighter;
            yPos = newYPos;
        }
        return nearestMarker;
    }

    private void getNearestHighlighters(@NotNull MarkupModelEx markupModel, int scrollBarY, @NotNull Collection<? super RangeHighlighter> nearest) {
        if (markupModel == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(13);
        }
        if (nearest == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(14);
        }
        int startOffset = this.yPositionToOffset(scrollBarY - this.getMinMarkHeight(), true);
        int endOffset = this.yPositionToOffset(scrollBarY + this.getMinMarkHeight(), false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            ProperTextRange range2;
            if (highlighter.getErrorStripeMarkColor(this.myEditor.getColorsScheme()) != null && scrollBarY >= (range2 = this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset())).getStartOffset() - this.getMinMarkHeight() * 2 && scrollBarY <= range2.getEndOffset() + this.getMinMarkHeight() * 2) {
                nearest.add((RangeHighlighter)highlighter);
            }
            return true;
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doClick(@NotNull MouseEvent e) {
        int offset;
        if (e == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(15);
        }
        RangeHighlighter marker = this.getNearestRangeHighlighter(e);
        LogicalPosition logicalPositionToScroll = null;
        LightweightHint editorPreviewHint = this.myEditorFragmentRenderer.getEditorPreviewHint();
        if (marker == null) {
            if (editorPreviewHint == null) return;
            logicalPositionToScroll = this.myEditor.visualToLogicalPosition(new VisualPosition(this.myEditorFragmentRenderer.getStartVisualLine(), 0));
            offset = this.myEditor.getDocument().getLineStartOffset(logicalPositionToScroll.line);
        } else {
            offset = marker.getStartOffset();
        }
        DocumentEx doc = this.myEditor.getDocument();
        if (doc.getLineCount() > 0 && editorPreviewHint == null) {
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            this.myEditor.getCaretModel().moveToOffset(lineEnd);
        }
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToOffset(offset);
        this.myEditor.getSelectionModel().removeSelection();
        ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
        scrollingModel.disableAnimation();
        if (logicalPositionToScroll != null) {
            int lineY = this.myEditor.logicalPositionToXY((LogicalPosition)logicalPositionToScroll).y;
            int relativePopupOffset = this.myEditorFragmentRenderer.getRelativeY();
            scrollingModel.scrollVertically(lineY - relativePopupOffset);
        } else {
            scrollingModel.scrollToCaret(ScrollType.CENTER);
        }
        scrollingModel.enableAnimation();
        if (marker == null) return;
        this.myErrorStripeMarkersModel.fireErrorMarkerClicked(marker, e);
    }

    @Override
    public void setErrorStripeVisible(boolean val) {
        if (val) {
            this.disposeErrorPanel();
            MyErrorPanel panel2 = new MyErrorPanel();
            this.myEditor.getVerticalScrollBar().setPersistentUI((ScrollBarUI)((Object)panel2));
        } else {
            this.myEditor.getVerticalScrollBar().setPersistentUI(JBScrollBar.createUI(null));
        }
        this.myErrorStripeMarkersModel.setActive(val);
    }

    @Nullable
    private MyErrorPanel getErrorPanel() {
        ScrollBarUI ui2 = this.myEditor.getVerticalScrollBar().getUI();
        return ui2 instanceof MyErrorPanel ? (MyErrorPanel)((Object)ui2) : null;
    }

    @NotNull
    ErrorStripeMarkersModel getErrorStripeMarkersModel() {
        ErrorStripeMarkersModel errorStripeMarkersModel = this.myErrorStripeMarkersModel;
        if (errorStripeMarkersModel == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(16);
        }
        return errorStripeMarkersModel;
    }

    @Override
    public void setErrorPanelPopupHandler(@NotNull PopupHandler handler2) {
        if (handler2 == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            errorPanel.setPopupHandler(handler2);
        }
    }

    @Override
    public void setErrorStripTooltipRendererProvider(@NotNull ErrorStripTooltipRendererProvider provider2) {
        if (provider2 == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(18);
        }
        this.myTooltipRendererProvider = provider2;
    }

    @Override
    @NotNull
    public ErrorStripTooltipRendererProvider getErrorStripTooltipRendererProvider() {
        ErrorStripTooltipRendererProvider errorStripTooltipRendererProvider = this.myTooltipRendererProvider;
        if (errorStripTooltipRendererProvider == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(19);
        }
        return errorStripTooltipRendererProvider;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(20);
        }
        return editorImpl;
    }

    @Override
    public void setErrorStripeRenderer(@Nullable ErrorStripeRenderer renderer2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myErrorStripeRenderer instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myErrorStripeRenderer));
        }
        this.myErrorStripeRenderer = renderer2;
        if (renderer2 instanceof Disposable) {
            Disposer.register((Disposable)this.resourcesDisposable, (Disposable)((Disposable)renderer2));
        }
    }

    @Override
    @Nullable
    public ErrorStripeRenderer getErrorStripeRenderer() {
        return this.myErrorStripeRenderer;
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.resourcesDisposable);
        this.disposeErrorPanel();
        this.statusToolbar.getComponent().removeComponentListener(this.toolbarComponentListener);
        ((JBScrollPane)this.myEditor.getScrollPane()).setStatusComponent(null);
        this.myErrorStripeRenderer = null;
        this.myTooltipRendererProvider = new BasicTooltipRendererProvider();
        this.myEditorFragmentRenderer.clearHint();
        this.myPopupManager.hidePopup();
        this.myPopupManager = null;
        this.extensionActions.clear();
        super.dispose();
    }

    private void disposeErrorPanel() {
        MyErrorPanel panel2 = this.getErrorPanel();
        if (panel2 != null) {
            panel2.uninstallListeners();
        }
    }

    public void rebuild() {
        this.myErrorStripeMarkersModel.rebuild();
    }

    void repaint() {
        this.repaint(-1, -1);
    }

    void repaint(int startOffset, int endOffset) {
        ProperTextRange range2 = this.offsetsToYPositions(startOffset, endOffset);
        this.markDirtied(range2);
        if (startOffset == -1 || endOffset == -1) {
            this.myDirtyYPositions = WHOLE_DOCUMENT;
        }
        EditorImpl.MyScrollBar bar2 = this.myEditor.getVerticalScrollBar();
        ((Component)((Object)bar2)).repaint(0, range2.getStartOffset(), ((JComponent)((Object)bar2)).getWidth(), range2.getLength() + this.getMinMarkHeight());
    }

    private boolean isMirrored() {
        return this.myEditor.isMirrored();
    }

    private boolean transparent() {
        return !this.myEditor.shouldScrollBarBeOpaque();
    }

    private void hideMyEditorPreviewHint() {
        this.myEditorFragmentRenderer.hideHint();
        this.myRowAdjuster = 0;
        this.myWheelAccumulator = 0;
        this.myLastVisualLine = 0;
    }

    private LightweightHint showTooltip(TooltipRenderer tooltipObject, @NotNull HintHint hintHint) {
        if (hintHint == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(21);
        }
        this.hideMyEditorPreviewHint();
        return TooltipController.getInstance().showTooltipByMouseMove(this.myEditor, hintHint.getTargetPoint(), tooltipObject, this.myEditor.getVerticalScrollbarOrientation() == 1, ERROR_STRIPE_TOOLTIP_GROUP, hintHint);
    }

    @Override
    public void addErrorMarkerListener(@NotNull ErrorStripeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(22);
        }
        if (parent == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(23);
        }
        this.myErrorStripeMarkersModel.addErrorMarkerListener(listener2, parent);
    }

    private void markDirtied(@NotNull ProperTextRange yPositions) {
        if (yPositions == null) {
            EditorMarkupModelImpl.$$$reportNull$$$0(24);
        }
        if (this.myDirtyYPositions != WHOLE_DOCUMENT) {
            int start2 = Math.max(0, yPositions.getStartOffset() - this.myEditor.getLineHeight());
            int end = this.myEditorScrollbarTop + this.myEditorTargetHeight == 0 ? yPositions.getEndOffset() + this.myEditor.getLineHeight() : Math.min(this.myEditorScrollbarTop + this.myEditorTargetHeight, yPositions.getEndOffset() + this.myEditor.getLineHeight());
            ProperTextRange adj = new ProperTextRange(start2, Math.max(end, start2));
            this.myDirtyYPositions = this.myDirtyYPositions == null ? adj : this.myDirtyYPositions.union((TextRange)adj);
        }
        this.myEditorScrollbarTop = 0;
        this.myEditorSourceHeight = 0;
        this.myEditorTargetHeight = 0;
        this.dimensionsAreValid = false;
    }

    @Override
    public void setMinMarkHeight(int minMarkHeight) {
        this.myMinMarkHeight = Math.min(minMarkHeight, EditorMarkupModelImpl.getMaxStripeSize());
    }

    @Override
    public boolean isErrorStripeVisible() {
        return this.getErrorPanel() != null;
    }

    @NotNull
    private ProperTextRange offsetsToYPositions(int start2, int end) {
        int endY;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        DocumentEx document = this.myEditor.getDocument();
        int startLineNumber = end == -1 ? 0 : this.offsetToLine(start2, document);
        int editorStartY = this.myEditor.visualLineToY(startLineNumber);
        int editorTargetHeight = Math.max(0, this.myEditorTargetHeight);
        int startY = this.myEditorSourceHeight < editorTargetHeight ? this.myEditorScrollbarTop + editorStartY : this.myEditorScrollbarTop + (int)((float)editorStartY / (float)this.myEditorSourceHeight * (float)editorTargetHeight);
        int endLineNumber = this.offsetToLine(end, document);
        if (end == -1 || start2 == -1) {
            endY = Math.min(this.myEditorSourceHeight, editorTargetHeight);
        } else if (startLineNumber == endLineNumber) {
            endY = startY;
        } else if (this.myEditorSourceHeight < editorTargetHeight) {
            endY = this.myEditorScrollbarTop + this.myEditor.visualLineToY(endLineNumber);
        } else {
            int editorEndY = this.myEditor.visualLineToY(endLineNumber);
            endY = this.myEditorScrollbarTop + (int)((float)editorEndY / (float)this.myEditorSourceHeight * (float)editorTargetHeight);
        }
        if (endY < startY) {
            endY = startY;
        }
        return new ProperTextRange(startY, endY);
    }

    private int yPositionToOffset(int y, boolean beginLine) {
        int editorY;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        int safeY = Math.max(0, y - this.myEditorScrollbarTop);
        if (this.myEditorSourceHeight < this.myEditorTargetHeight) {
            editorY = safeY;
        } else {
            float fraction = Math.max(0.0f, Math.min(1.0f, (float)safeY / (float)this.myEditorTargetHeight));
            editorY = (int)(fraction * (float)this.myEditorSourceHeight);
        }
        VisualPosition visual = this.myEditor.xyToVisualPosition(new Point(0, editorY));
        int line = this.myEditor.visualToLogicalPosition((VisualPosition)visual).line;
        DocumentEx document = this.myEditor.getDocument();
        if (line < 0) {
            return 0;
        }
        if (line >= document.getLineCount()) {
            return document.getTextLength();
        }
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (beginLine) {
            int offset = document.getLineStartOffset(line);
            FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
            return startCollapsed != null ? Math.min(offset, startCollapsed.getStartOffset()) : offset;
        }
        int offset = document.getLineEndOffset(line);
        FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
        return startCollapsed != null ? Math.max(offset, startCollapsed.getEndOffset()) : offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nearest";
                break;
            }
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintHint";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yPositions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorStripeMarkersModel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorStripTooltipRendererProvider";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "afterDocumentChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visibleAreaChanged";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBoundsOnScreen";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showToolTipByMouseMove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVisualLineByEvent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectRangeHighlighters";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNearestRangeHighlighter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNearestHighlighters";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doClick";
                break;
            }
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setErrorPanelPopupHandler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setErrorStripTooltipRendererProvider";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addErrorMarkerListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "markDirtied";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MarkupModelDelegateAction
    extends DumbAwareAction
    implements ActionWithDelegate<AnAction> {
        private final AnAction myDelegate;

        private MarkupModelDelegateAction(@NotNull AnAction delegate2, Icon icon2) {
            if (icon2 == null) {
                MarkupModelDelegateAction.$$$reportNull$$$0(0);
            }
            super(delegate2.getTemplatePresentation().getText(), null, icon2);
            this.myDelegate = delegate2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MarkupModelDelegateAction.$$$reportNull$$$0(1);
            }
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)EditorMarkupModelImpl.this.myEditor.getProject());
            AnActionEvent delegateEvent = AnActionEvent.createFromAnAction((AnAction)this.myDelegate, (InputEvent)e.getInputEvent(), (String)"EditorInspectionsToolbar", (DataContext)EditorMarkupModelImpl.this.myEditor.getDataContext());
            if (focusManager.getFocusOwner() != EditorMarkupModelImpl.this.myEditor.getContentComponent()) {
                focusManager.requestFocus((Component)EditorMarkupModelImpl.this.myEditor.getContentComponent(), true).doWhenDone(() -> this.myDelegate.actionPerformed(delegateEvent));
            } else {
                this.myDelegate.actionPerformed(delegateEvent);
            }
        }

        @NotNull
        public AnAction getDelegate() {
            AnAction anAction2 = this.myDelegate;
            if (anAction2 == null) {
                MarkupModelDelegateAction.$$$reportNull$$$0(2);
            }
            return anAction2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MarkupModelDelegateAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MarkupModelDelegateAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class CompactViewAction
    extends ToggleAction {
        CompactViewAction() {
            super(EditorBundle.message((String)"iw.compact.view", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                CompactViewAction.$$$reportNull$$$0(0);
            }
            return !EditorMarkupModelImpl.this.showToolbar;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                CompactViewAction.$$$reportNull$$$0(1);
            }
            EditorMarkupModelImpl.this.showToolbar = !state;
            EditorSettingsExternalizable.getInstance().setShowInspectionWidget(EditorMarkupModelImpl.this.showToolbar);
            EditorMarkupModelImpl.this.updateTrafficLightVisibility();
            ActionsCollector.getInstance().record(e.getProject(), (AnAction)this, e, null);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CompactViewAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            e.getPresentation().setEnabled(EditorMarkupModelImpl.this.analyzerStatus == null || EditorMarkupModelImpl.this.analyzerStatus.getController().enableToolbar());
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$CompactViewAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class EditorToolbarButtonLook
    extends ActionButtonLook {
        private EditorToolbarButtonLook() {
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, int state) {
        }

        @Override
        public void paintLookBorder(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
            if (g == null) {
                EditorToolbarButtonLook.$$$reportNull$$$0(0);
            }
            if (rect == null) {
                EditorToolbarButtonLook.$$$reportNull$$$0(1);
            }
            if (color == null) {
                EditorToolbarButtonLook.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void paintBorder(Graphics g, JComponent component2, Color color) {
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, @ActionButtonComponent.ButtonState int state) {
            Color color;
            if (state == 0) {
                return;
            }
            Rectangle rect = new Rectangle(component2.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
            EditorColorsScheme scheme2 = EditorMarkupModelImpl.this.myEditor.getColorsScheme();
            Color color2 = color = state == -1 ? scheme2.getColor(PRESSED_BACKGROUND) : scheme2.getColor(HOVER_BACKGROUND);
            if (color != null) {
                ActionButtonLook.SYSTEM_LOOK.paintLookBackground(g, rect, color);
            }
        }

        @Override
        public void paintBackground(Graphics g, JComponent component2, Color color) {
            ActionButtonLook.SYSTEM_LOOK.paintBackground(g, component2, color);
        }

        @Override
        public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon2, int x, int y) {
            if (icon2 != null) {
                boolean isDark = ColorUtil.isDark((Color)EditorMarkupModelImpl.this.myEditor.getColorsScheme().getDefaultBackground());
                super.paintIcon(g, actionButton, IconLoader.getDarkIcon((Icon)icon2, (boolean)isDark), x, y);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rect";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "color";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorToolbarButtonLook";
            objectArray[2] = "paintLookBorder";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StatusComponentLayout
    implements LayoutManager {
        private final List<Pair<Component, String>> actionButtons = new ArrayList<Pair<Component, String>>();

        private StatusComponentLayout() {
        }

        @Override
        public void addLayoutComponent(String s, Component component2) {
            this.actionButtons.add((Pair<Component, String>)Pair.pair((Object)component2, (Object)s));
        }

        @Override
        public void removeLayoutComponent(Component component2) {
            for (int i2 = 0; i2 < this.actionButtons.size(); ++i2) {
                if (!Comparing.equal((Object)component2, (Object)((Component)this.actionButtons.get((int)i2).first))) continue;
                this.actionButtons.remove(i2);
                break;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension prefSize;
            JBDimension size2 = JBUI.emptySize();
            for (Pair<Component, String> c : this.actionButtons) {
                if (!((Component)c.first).isVisible()) continue;
                prefSize = ((Component)c.first).getPreferredSize();
                size2.height = Math.max(size2.height, prefSize.height);
            }
            for (Pair<Component, String> c : this.actionButtons) {
                if (!((Component)c.first).isVisible()) continue;
                prefSize = ((Component)c.first).getPreferredSize();
                Insets i2 = ((JComponent)c.first).getInsets();
                JBInsets.removeFrom((Dimension)prefSize, (Insets)i2);
                if ("Constraint.Separator".equals(c.second)) {
                    size2.width += prefSize.width + i2.left + i2.right;
                    continue;
                }
                int maxBareHeight = size2.height - i2.top - i2.bottom;
                size2.width += Math.max(prefSize.width, maxBareHeight) + i2.left + i2.right;
            }
            if (size2.width > 0 && size2.height > 0) {
                JBInsets.addTo((Dimension)size2, (Insets)container.getInsets());
            }
            return size2;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension prefSize = this.preferredLayoutSize(container);
            if (prefSize.width > 0 && prefSize.height > 0) {
                Insets i2 = container.getInsets();
                JBInsets.removeFrom((Dimension)prefSize, (Insets)i2);
                int offset = i2.left;
                for (Pair<Component, String> c : this.actionButtons) {
                    if (!((Component)c.first).isVisible()) continue;
                    Dimension cPrefSize = ((Component)c.first).getPreferredSize();
                    if (c.first instanceof StatusButton) {
                        ((Component)c.first).setBounds(offset, i2.top, cPrefSize.width, prefSize.height);
                        offset += cPrefSize.width;
                        continue;
                    }
                    Insets jcInsets = ((JComponent)c.first).getInsets();
                    JBInsets.removeFrom((Dimension)cPrefSize, (Insets)jcInsets);
                    if ("Constraint.Separator".equals(c.second)) {
                        ((Component)c.first).setBounds(offset, i2.top, cPrefSize.width, prefSize.height);
                        offset += cPrefSize.width;
                        continue;
                    }
                    int maxBareHeight = prefSize.height - jcInsets.top - jcInsets.bottom;
                    int width = Math.max(cPrefSize.width, maxBareHeight) + jcInsets.left + jcInsets.right;
                    ((Component)c.first).setBounds(offset, i2.top, width, prefSize.height);
                    offset += width;
                }
            }
        }
    }

    private static final class StatusButton
    extends JPanel {
        private static final int LEFT_RIGHT_INDENT = 5;
        private static final int INTER_GROUP_OFFSET = 6;
        private boolean mousePressed;
        private boolean mouseHover;
        private final ActionButtonLook buttonLook;
        private final MouseListener mouseListener;
        private final PropertyChangeListener presentationPropertyListener;
        private final Presentation presentation;
        private final EditorColorsScheme colorsScheme;
        private boolean translucent;

        private StatusButton(final @NotNull AnAction action2, final @NotNull Presentation presentation2, @NotNull ActionButtonLook buttonLook2, final @NotNull String place, @NotNull EditorColorsScheme colorsScheme, final @NotNull InspectionPopupManager popupManager, final @NotNull BooleanSupplier hasNavButtons) {
            if (action2 == null) {
                StatusButton.$$$reportNull$$$0(0);
            }
            if (presentation2 == null) {
                StatusButton.$$$reportNull$$$0(1);
            }
            if (buttonLook2 == null) {
                StatusButton.$$$reportNull$$$0(2);
            }
            if (place == null) {
                StatusButton.$$$reportNull$$$0(3);
            }
            if (colorsScheme == null) {
                StatusButton.$$$reportNull$$$0(4);
            }
            if (popupManager == null) {
                StatusButton.$$$reportNull$$$0(5);
            }
            if (hasNavButtons == null) {
                StatusButton.$$$reportNull$$$0(6);
            }
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.buttonLook = buttonLook2;
            this.presentation = presentation2;
            this.colorsScheme = colorsScheme;
            this.presentationPropertyListener = l -> {
                String propName = l.getPropertyName();
                if (propName.equals(EXPANDED_STATUS.toString()) && l.getNewValue() != null) {
                    List newStatus = (List)l.getNewValue();
                    this.updateContents(newStatus);
                    this.translucent = false;
                    this.revalidate();
                    this.repaint();
                } else if (propName.equals(TRANSLUCENT_STATE.toString())) {
                    this.translucent = l.getNewValue() == Boolean.TRUE;
                    this.repaint();
                }
            };
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (SwingUtilities.isLeftMouseButton(me)) {
                        this.showInspectionsHint(me);
                    }
                }

                private void showInspectionsHint(MouseEvent me) {
                    DataContext context2 = this.getDataContext();
                    AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)me, (String)place, (Presentation)presentation2, (DataContext)context2, (boolean)false, (boolean)true);
                    if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false)) {
                        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)event);
                        ActionsCollector.getInstance().record(event.getProject(), action2, event, null);
                        ActionToolbar toolbar = ActionToolbar.findToolbarBy((Component)this);
                        if (toolbar != null) {
                            toolbar.updateActionsImmediately();
                        }
                    }
                }

                private void showContextMenu(MouseEvent me) {
                    DefaultActionGroup group2 = new DefaultActionGroup();
                    if (0 < group2.getChildrenCount()) {
                        JBPopupMenu.showByEvent((MouseEvent)me, (String)"EditorInspectionsToolbar", (ActionGroup)group2);
                    }
                }

                @Override
                public void mousePressed(MouseEvent me) {
                    if (me.isPopupTrigger()) {
                        this.showContextMenu(me);
                    }
                    mousePressed = true;
                    this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                    if (me.isPopupTrigger()) {
                        this.showContextMenu(me);
                    }
                    mousePressed = false;
                    this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                    mouseHover = true;
                    popupManager.scheduleShow(me);
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent me) {
                    mouseHover = false;
                    popupManager.scheduleHide();
                    this.repaint();
                }
            };
            List newStatus = (List)presentation2.getClientProperty(EXPANDED_STATUS);
            if (newStatus != null) {
                this.updateContents(newStatus);
            }
            this.setBorder(new Border(){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }

                @Override
                public Insets getBorderInsets(Component c) {
                    return hasNavButtons.getAsBoolean() ? JBUI.insets((int)2, (int)2, (int)2, (int)0) : JBUI.insets((int)2);
                }
            });
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.presentation.addPropertyChangeListener(this.presentationPropertyListener);
            this.addMouseListener(this.mouseListener);
        }

        @Override
        public void removeNotify() {
            this.presentation.removePropertyChangeListener(this.presentationPropertyListener);
            this.removeMouseListener(this.mouseListener);
        }

        private DataContext getDataContext() {
            return ActionToolbar.getDataContextFor((Component)this);
        }

        private void updateContents(@NotNull List<StatusItem> status) {
            if (status == null) {
                StatusButton.$$$reportNull$$$0(7);
            }
            this.removeAll();
            this.setEnabled(!status.isEmpty());
            this.setVisible(!status.isEmpty());
            GridBag gc = new GridBag().nextLine();
            if (status.size() == 1 && StringUtil.isEmpty((String)status.get(0).getText())) {
                this.add((Component)this.createStyledLabel(null, status.get(0).getIcon(), 0), gc.next().weightx(1.0).weighty(1.0).fillCell());
            } else if (status.size() > 0) {
                int leftRightOffset = JBUIScale.scale((int)5);
                this.add(Box.createHorizontalStrut(leftRightOffset), gc.next());
                int counter = 0;
                for (StatusItem item : status) {
                    this.add((Component)this.createStyledLabel(item.getText(), item.getIcon(), 2), gc.next().insetLeft(counter++ > 0 ? 6 : 0).fillCell().weighty(1.0));
                }
                this.add(Box.createHorizontalStrut(leftRightOffset), gc.next());
            }
        }

        private JLabel createStyledLabel(@Nullable @Nls String text2, @Nullable Icon icon2, int alignment) {
            JLabel label2 = new JLabel(text2, icon2, alignment){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void paintComponent(Graphics graphics) {
                    Graphics2D g2 = (Graphics2D)graphics.create();
                    try {
                        float alpha = translucent ? 0.5f : 1.0f;
                        g2.setComposite(AlphaComposite.getInstance(3, alpha));
                        super.paintComponent(g2);
                    }
                    finally {
                        g2.dispose();
                    }
                }

                @Override
                public void setUI(LabelUI ui2) {
                    super.setUI(ui2);
                    if (!SystemInfo.isWindows) {
                        Font font = this.getFont();
                        font = new FontUIResource(font.deriveFont(font.getStyle(), font.getSize() - JBUIScale.scale((int)2)));
                        this.setFont(font);
                    }
                }
            };
            label2.setForeground((Color)new JBColor(() -> (Color)ObjectUtils.notNull((Object)this.colorsScheme.getColor(ICON_TEXT_COLOR), (Object)ICON_TEXT_COLOR.getDefaultColor())));
            label2.setIconTextGap(JBUIScale.scale((int)1));
            return label2;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int state = this.mousePressed ? -1 : (this.mouseHover ? 1 : 0);
            this.buttonLook.paintBackground(graphics, (JComponent)this, state);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.getComponentCount() == 0) {
                return JBUI.emptySize();
            }
            Dimension size2 = super.getPreferredSize();
            Insets i2 = this.getInsets();
            size2.height = Math.max(EditorMarkupModelImpl.getStatusIconSize() + i2.top + i2.bottom, size2.height);
            size2.width = Math.max(EditorMarkupModelImpl.getStatusIconSize() + i2.left + i2.right, size2.width);
            return size2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buttonLook";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorsScheme";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popupManager";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasNavButtons";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$StatusButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateContents";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class StatusAction
    extends DumbAwareAction
    implements CustomComponentAction {
        private StatusAction() {
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                StatusAction.$$$reportNull$$$0(0);
            }
            if (place == null) {
                StatusAction.$$$reportNull$$$0(1);
            }
            return new StatusButton((AnAction)this, presentation2, new EditorToolbarButtonLook(), place, EditorMarkupModelImpl.this.myEditor.getColorsScheme(), EditorMarkupModelImpl.this.myPopupManager, () -> EditorMarkupModelImpl.this.showNavigation);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StatusAction.$$$reportNull$$$0(2);
            }
            EditorMarkupModelImpl.this.myPopupManager.hidePopup();
            if (EditorMarkupModelImpl.this.analyzerStatus != null) {
                EditorMarkupModelImpl.this.analyzerStatus.getController().toggleProblemsView();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StatusAction.$$$reportNull$$$0(3);
            }
            Presentation presentation2 = e.getPresentation();
            if (EditorMarkupModelImpl.this.analyzerStatus != null) {
                List<StatusItem> newStatus = EditorMarkupModelImpl.this.analyzerStatus.getExpandedStatus();
                Icon newIcon = EditorMarkupModelImpl.this.analyzerStatus.getIcon();
                if (!EditorMarkupModelImpl.this.hasAnalyzed || EditorMarkupModelImpl.this.analyzerStatus.getAnalyzingType() != AnalyzingType.EMPTY) {
                    if (newStatus.isEmpty()) {
                        newStatus = Collections.singletonList(new StatusItem("", newIcon));
                        presentation2.putClientProperty(EXPANDED_STATUS, newStatus);
                    }
                    if (!Objects.equals(presentation2.getClientProperty(EXPANDED_STATUS), newStatus)) {
                        presentation2.putClientProperty(EXPANDED_STATUS, newStatus);
                    }
                    presentation2.putClientProperty(TRANSLUCENT_STATE, (Object)(EditorMarkupModelImpl.this.analyzerStatus.getAnalyzingType() != AnalyzingType.COMPLETE ? 1 : 0));
                } else {
                    presentation2.putClientProperty(TRANSLUCENT_STATE, (Object)true);
                }
            } else {
                presentation2.putClientProperty(EXPANDED_STATUS, Collections.emptyList());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$StatusAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCustomComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class BasicTooltipRendererProvider
    implements ErrorStripTooltipRendererProvider {
        private BasicTooltipRendererProvider() {
        }

        @Override
        public TooltipRenderer calcTooltipRenderer(@NotNull Collection<? extends RangeHighlighter> highlighters) {
            if (highlighters == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(0);
            }
            LineTooltipRenderer bigRenderer = null;
            HashSet<String> tooltips = null;
            for (RangeHighlighter rangeHighlighter : highlighters) {
                String text2;
                Object tooltipObject = rangeHighlighter.getErrorStripeTooltip();
                if (tooltipObject == null || (text2 = tooltipObject instanceof HighlightInfo ? ((HighlightInfo)tooltipObject).getToolTip() : tooltipObject.toString()) == null) continue;
                if (tooltips == null) {
                    tooltips = new HashSet<String>();
                }
                if (!tooltips.add(text2)) continue;
                if (bigRenderer == null) {
                    bigRenderer = new LineTooltipRenderer(text2, new Object[]{highlighters});
                    continue;
                }
                bigRenderer.addBelow(text2);
            }
            return bigRenderer;
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text2) {
            if (text2 == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(1);
            }
            return new LineTooltipRenderer(text2, new Object[]{text2});
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text2, int width) {
            if (text2 == null) {
                BasicTooltipRendererProvider.$$$reportNull$$$0(2);
            }
            return new LineTooltipRenderer(text2, width, new Object[]{text2});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "highlighters";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider";
            objectArray[2] = "calcTooltipRenderer";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @DirtyUI
    private class MyErrorPanel
    extends ButtonlessScrollBarUI
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    UISettingsListener {
        private PopupHandler myHandler;
        @Nullable
        private BufferedImage myCachedTrack;
        private int myCachedHeight = -1;

        private MyErrorPanel() {
        }

        public void dropCache() {
            this.myCachedTrack = null;
            this.myCachedHeight = -1;
        }

        public boolean alwaysShowTrack() {
            if (this.scrollbar.getOrientation() == 1) {
                return !EditorMarkupModelImpl.this.transparent();
            }
            return super.alwaysShowTrack();
        }

        public void installUI(JComponent c) {
            super.installUI(c);
            this.dropCache();
        }

        public void uninstallUI(@NotNull JComponent c) {
            if (c == null) {
                MyErrorPanel.$$$reportNull$$$0(0);
            }
            super.uninstallUI(c);
            this.dropCache();
        }

        protected void installListeners() {
            super.installListeners();
            this.scrollbar.addMouseMotionListener(this);
            this.scrollbar.addMouseListener(this);
            this.scrollbar.addMouseWheelListener(this);
        }

        protected void uninstallListeners() {
            this.scrollbar.removeMouseMotionListener(this);
            this.scrollbar.removeMouseListener(this);
            super.uninstallListeners();
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            if (uiSettings == null) {
                MyErrorPanel.$$$reportNull$$$0(1);
            }
            if (!uiSettings.getShowEditorToolTip()) {
                EditorMarkupModelImpl.this.hideMyEditorPreviewHint();
            }
            EditorMarkupModelImpl.this.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
            EditorMarkupModelImpl.this.repaintTrafficLightIcon();
            EditorMarkupModelImpl.this.repaintVerticalScrollBar();
            EditorMarkupModelImpl.this.myPopupManager.updateVisiblePopup();
        }

        protected void paintThumb(@NotNull Graphics g, @NotNull JComponent c, Rectangle thumbBounds) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(2);
            }
            if (c == null) {
                MyErrorPanel.$$$reportNull$$$0(3);
            }
            if (this.isMacOverlayScrollbar()) {
                if (!EditorMarkupModelImpl.this.isMirrored()) {
                    super.paintThumb(g, c, thumbBounds);
                } else {
                    Graphics2D g2d = (Graphics2D)g;
                    AffineTransform old = g2d.getTransform();
                    AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                    tx.translate(-c.getWidth(), 0.0);
                    g2d.transform(tx);
                    super.paintThumb(g, c, thumbBounds);
                    g2d.setTransform(old);
                }
            } else {
                super.paintThumb(g, c, thumbBounds);
            }
        }

        protected boolean isThumbTranslucent() {
            return true;
        }

        protected int getThumbOffset(int value2) {
            if (SystemInfo.isMac || Registry.is((String)"editor.full.width.scrollbar")) {
                return EditorMarkupModelImpl.this.getMinMarkHeight() + JBUIScale.scale((int)2);
            }
            return super.getThumbOffset(value2);
        }

        protected boolean isDark() {
            return EditorMarkupModelImpl.this.myEditor.isDarkEnough();
        }

        protected boolean alwaysPaintThumb() {
            return true;
        }

        protected Rectangle getMacScrollBarBounds(Rectangle baseBounds, boolean thumb) {
            Rectangle bounds2 = super.getMacScrollBarBounds(baseBounds, thumb);
            bounds2.width = Math.min(bounds2.width, EditorMarkupModelImpl.getMaxMacThumbWidth());
            int b2 = bounds2.width / 2;
            bounds2.x = EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.getMinMarkHeight() + SCROLLBAR_WIDTH.get() / 2 - b2;
            return bounds2;
        }

        protected int getThickness() {
            return SCROLLBAR_WIDTH.get() + EditorMarkupModelImpl.getThinGap() + EditorMarkupModelImpl.this.getMinMarkHeight();
        }

        protected void paintTrack(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle trackBounds) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(4);
            }
            if (c == null) {
                MyErrorPanel.$$$reportNull$$$0(5);
            }
            if (trackBounds == null) {
                MyErrorPanel.$$$reportNull$$$0(6);
            }
            if (EditorMarkupModelImpl.this.myEditor.isDisposed()) {
                return;
            }
            if (EditorMarkupModelImpl.this.transparent()) {
                this.doPaintTrack(g, c, trackBounds);
            } else {
                super.paintTrack(g, c, trackBounds);
            }
        }

        protected void doPaintTrack(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle bounds2) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(7);
            }
            if (c == null) {
                MyErrorPanel.$$$reportNull$$$0(8);
            }
            if (bounds2 == null) {
                MyErrorPanel.$$$reportNull$$$0(9);
            }
            Rectangle clip = g.getClipBounds().intersection(bounds2);
            if (clip.height == 0) {
                return;
            }
            Rectangle componentBounds = c.getBounds();
            ProperTextRange docRange = ProperTextRange.create((int)0, (int)componentBounds.height);
            if (this.myCachedTrack == null || this.myCachedHeight != componentBounds.height) {
                this.myCachedTrack = UIUtil.createImage((Component)c, (int)componentBounds.width, (int)componentBounds.height, (int)2);
                this.myCachedHeight = componentBounds.height;
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                EditorMarkupModelImpl.this.dimensionsAreValid = false;
                this.paintTrackBasement(this.myCachedTrack.getGraphics(), new Rectangle(0, 0, componentBounds.width, componentBounds.height));
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions == WHOLE_DOCUMENT) {
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions != null) {
                Graphics2D imageGraphics = this.myCachedTrack.createGraphics();
                EditorMarkupModelImpl.this.myDirtyYPositions = EditorMarkupModelImpl.this.myDirtyYPositions.intersection((TextRange)docRange);
                if (EditorMarkupModelImpl.this.myDirtyYPositions == null) {
                    EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                }
                this.repaint(imageGraphics, componentBounds.width, EditorMarkupModelImpl.this.myDirtyYPositions);
                EditorMarkupModelImpl.this.myDirtyYPositions = null;
            }
            UIUtil.drawImage((Graphics)g, (BufferedImage)this.myCachedTrack, null, (int)0, (int)0);
        }

        private void paintTrackBasement(@NotNull Graphics g, @NotNull Rectangle bounds2) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(10);
            }
            if (bounds2 == null) {
                MyErrorPanel.$$$reportNull$$$0(11);
            }
            if (EditorMarkupModelImpl.this.transparent()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setComposite(AlphaComposite.getInstance(1));
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                g2.setComposite(AlphaComposite.getInstance(3));
            } else {
                g.setColor(EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            }
        }

        @NotNull
        protected Color adjustColor(Color c) {
            Color color = this.isMacOverlayScrollbar() ? super.adjustColor(c) : EditorImpl.adjustThumbColor(super.adjustColor(c), this.isDark());
            if (color == null) {
                MyErrorPanel.$$$reportNull$$$0(12);
            }
            return color;
        }

        private void repaint(@NotNull Graphics g, int gutterWidth, @NotNull ProperTextRange yrange) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(13);
            }
            if (yrange == null) {
                MyErrorPanel.$$$reportNull$$$0(14);
            }
            Rectangle clip = new Rectangle(0, yrange.getStartOffset(), gutterWidth, yrange.getLength() + EditorMarkupModelImpl.this.getMinMarkHeight());
            this.paintTrackBasement(g, clip);
            int startOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y - EditorMarkupModelImpl.this.getMinMarkHeight(), true);
            int endOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y + clip.height, false);
            Shape oldClip = g.getClip();
            g.clipRect(clip.x, clip.y, clip.width, clip.height);
            this.drawErrorStripeMarkers(g, startOffset, endOffset);
            g.setClip(oldClip);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawErrorStripeMarkers(@NotNull Graphics g, int startOffset, int endOffset) {
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(15);
            }
            PriorityQueue<PositionedStripe> thinEnds = new PriorityQueue<PositionedStripe>(5, Comparator.comparingInt(o -> o.yEnd));
            PriorityQueue<PositionedStripe> wideEnds = new PriorityQueue<PositionedStripe>(5, Comparator.comparingInt(o -> o.yEnd));
            ArrayList<PositionedStripe> thinStripes = new ArrayList<PositionedStripe>();
            ArrayList<PositionedStripe> wideStripes = new ArrayList<PositionedStripe>();
            int[] thinYStart = new int[1];
            int[] wideYStart = new int[1];
            MarkupIterator<RangeHighlighterEx> iterator2 = EditorMarkupModelImpl.this.myErrorStripeMarkersModel.highlighterIterator(startOffset, endOffset);
            try {
                ContainerUtil.process(iterator2, highlighter -> {
                    Color color;
                    int i2;
                    boolean isThin = highlighter.isThinErrorStripeMark();
                    int[] yStart = isThin ? thinYStart : wideYStart;
                    List stripes = isThin ? thinStripes : wideStripes;
                    Queue ends = isThin ? thinEnds : wideEnds;
                    ProperTextRange range2 = EditorMarkupModelImpl.this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset());
                    int ys = range2.getStartOffset();
                    int ye = range2.getEndOffset();
                    if (ye - ys < EditorMarkupModelImpl.this.getMinMarkHeight()) {
                        ye = ys + EditorMarkupModelImpl.this.getMinMarkHeight();
                    }
                    yStart[0] = this.drawStripesEndingBefore(ys, ends, stripes, g, yStart[0]);
                    int layer = highlighter.getLayer();
                    PositionedStripe stripe = null;
                    for (i2 = 0; i2 < stripes.size(); ++i2) {
                        PositionedStripe s = (PositionedStripe)stripes.get(i2);
                        if (s.layer == layer) {
                            stripe = s;
                            break;
                        }
                        if (s.layer < layer) break;
                    }
                    if ((color = highlighter.getErrorStripeMarkColor(EditorMarkupModelImpl.this.myEditor.getColorsScheme())) == null) {
                        if (EditorMarkupModelImpl.this.reportErrorStripeInconsistency) {
                            EditorMarkupModelImpl.this.reportErrorStripeInconsistency = false;
                            LOG.error("Error stripe marker has no color. highlighter: " + highlighter);
                        }
                        return true;
                    }
                    if (stripe == null) {
                        if (i2 == 0 && yStart[0] != ys) {
                            if (!stripes.isEmpty()) {
                                PositionedStripe top = (PositionedStripe)stripes.get(0);
                                this.drawSpot(g, top.thin, yStart[0], ys, top.color);
                            }
                            yStart[0] = ys;
                        }
                        stripe = new PositionedStripe(color, ye, isThin, layer);
                        stripes.add(i2, stripe);
                        ends.offer(stripe);
                    } else if (stripe.yEnd < ye) {
                        if (!color.equals(stripe.color)) {
                            if (i2 == 0 && yStart[0] != ys) {
                                this.drawSpot(g, stripe.thin, yStart[0], ys, stripe.color);
                                yStart[0] = ys;
                            }
                            stripe.color = color;
                        }
                        ends.remove(stripe);
                        stripe.yEnd = ye;
                        ends.offer(stripe);
                    }
                    return true;
                });
            }
            finally {
                iterator2.dispose();
            }
            this.drawStripesEndingBefore(Integer.MAX_VALUE, thinEnds, thinStripes, g, thinYStart[0]);
            this.drawStripesEndingBefore(Integer.MAX_VALUE, wideEnds, wideStripes, g, wideYStart[0]);
        }

        private int drawStripesEndingBefore(int ys, @NotNull Queue<? extends PositionedStripe> ends, @NotNull List<PositionedStripe> stripes, @NotNull Graphics g, int yStart) {
            PositionedStripe endingStripe;
            if (ends == null) {
                MyErrorPanel.$$$reportNull$$$0(16);
            }
            if (stripes == null) {
                MyErrorPanel.$$$reportNull$$$0(17);
            }
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(18);
            }
            while (!ends.isEmpty() && (endingStripe = ends.peek()) != null && endingStripe.yEnd <= ys) {
                ends.remove();
                int i2 = stripes.indexOf(endingStripe);
                stripes.remove(i2);
                if (i2 != 0) continue;
                this.drawSpot(g, endingStripe.thin, yStart, endingStripe.yEnd, endingStripe.color);
                yStart = endingStripe.yEnd;
            }
            return yStart;
        }

        private void drawSpot(@NotNull Graphics g, boolean thinErrorStripeMark, int yStart, int yEnd, @NotNull Color color) {
            int x;
            int paintWidth;
            if (g == null) {
                MyErrorPanel.$$$reportNull$$$0(19);
            }
            if (color == null) {
                MyErrorPanel.$$$reportNull$$$0(20);
            }
            if (thinErrorStripeMark) {
                paintWidth = EditorMarkupModelImpl.this.getMinMarkHeight();
                int n = x = EditorMarkupModelImpl.this.isMirrored() ? this.getThickness() - paintWidth : 0;
                if (yEnd - yStart < 6) {
                    yEnd += yEnd - --yStart - 1;
                }
            } else {
                x = EditorMarkupModelImpl.this.isMirrored() ? 0 : EditorMarkupModelImpl.this.getMinMarkHeight() + EditorMarkupModelImpl.getThinGap();
                paintWidth = SCROLLBAR_WIDTH.get();
            }
            g.setColor(color);
            g.fillRect(x, yStart, paintWidth, yEnd - yStart);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(21);
            }
            CommandProcessor.getInstance().executeCommand(EditorMarkupModelImpl.this.myEditor.getProject(), () -> this.doMouseClicked(e), EditorBundle.message((String)"move.caret.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorMarkupModelImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, EditorMarkupModelImpl.this.getDocument());
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(22);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(23);
            }
        }

        private int getWidth() {
            return this.scrollbar.getWidth();
        }

        private void doMouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(24);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)EditorMarkupModelImpl.this.myEditor.getContentComponent(), true));
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth()) {
                EditorMarkupModelImpl.this.doClick(e);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(25);
            }
            EditorImpl.MyScrollBar scrollBar = EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar();
            int buttonHeight = scrollBar.getDecScrollButtonHeight();
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth() && EditorMarkupModelImpl.this.showToolTipByMouseMove(e)) {
                UIUtil.setCursor((Component)this.scrollbar, (Cursor)Cursor.getPredefinedCursor(12));
                return;
            }
            this.cancelMyToolTips(e, false);
            if (this.scrollbar.getCursor().equals(Cursor.getPredefinedCursor(12))) {
                this.scrollbar.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(26);
            }
            if (EditorMarkupModelImpl.this.myEditorFragmentRenderer.getEditorPreviewHint() == null) {
                MouseEventAdapter.redispatch((MouseEvent)e, (Component)e.getComponent().getParent());
                return;
            }
            int units = e.getUnitsToScroll();
            if (units == 0) {
                return;
            }
            if (EditorMarkupModelImpl.this.myLastVisualLine < EditorMarkupModelImpl.this.myEditor.getVisibleLineCount() - 1 && units > 0 || EditorMarkupModelImpl.this.myLastVisualLine > 0 && units < 0) {
                EditorMarkupModelImpl.this.myWheelAccumulator += units;
            }
            EditorMarkupModelImpl.this.myRowAdjuster = EditorMarkupModelImpl.this.myWheelAccumulator / EditorMarkupModelImpl.this.myEditor.getLineHeight();
            EditorMarkupModelImpl.this.showToolTipByMouseMove(e);
        }

        private void cancelMyToolTips(MouseEvent e, boolean checkIfShouldSurvive) {
            EditorMarkupModelImpl.this.hideMyEditorPreviewHint();
            TooltipController tooltipController = TooltipController.getInstance();
            if (!checkIfShouldSurvive || !tooltipController.shouldSurvive(e)) {
                tooltipController.cancelTooltip(ERROR_STRIPE_TOOLTIP_GROUP, e, true);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(27);
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(28);
            }
            EditorMarkupModelImpl.this.hideMyEditorPreviewHint();
            LightweightHint currentHint = EditorMarkupModelImpl.this.getCurrentHint();
            if (currentHint != null && !EditorMarkupModelImpl.this.myKeepHint) {
                this.closeHintOnMovingMouseAway(currentHint);
            }
        }

        private void closeHintOnMovingMouseAway(LightweightHint hint) {
            Disposable disposable2 = Disposer.newDisposable();
            IdeEventQueue.getInstance().addDispatcher(e -> {
                if (e.getID() == 501) {
                    EditorMarkupModelImpl.this.myKeepHint = true;
                    Disposer.dispose((Disposable)disposable2);
                } else if (e.getID() == 503 && !hint.isInsideHint(new RelativePoint((MouseEvent)e))) {
                    hint.hide();
                    Disposer.dispose((Disposable)disposable2);
                }
                return false;
            }, disposable2);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                MyErrorPanel.$$$reportNull$$$0(29);
            }
            this.cancelMyToolTips(e, true);
        }

        private void setPopupHandler(@NotNull PopupHandler handler2) {
            if (handler2 == null) {
                MyErrorPanel.$$$reportNull$$$0(30);
            }
            if (this.myHandler != null) {
                this.scrollbar.removeMouseListener((MouseListener)this.myHandler);
            }
            this.myHandler = handler2;
            this.scrollbar.addMouseListener((MouseListener)handler2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiSettings";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: 
                case 13: 
                case 15: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trackBounds";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yrange";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ends";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stripes";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "uninstallUI";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "uiSettingsChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "paintThumb";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "paintTrack";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "doPaintTrack";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "paintTrackBasement";
                    break;
                }
                case 12: {
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "repaint";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "drawErrorStripeMarkers";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "drawStripesEndingBefore";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "drawSpot";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseClicked";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "mousePressed";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseReleased";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "doMouseClicked";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseMoved";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseWheelMoved";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseEntered";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseExited";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseDragged";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "setPopupHandler";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PositionedStripe {
        @NotNull
        private Color color;
        private int yEnd;
        private final boolean thin;
        private final int layer;

        private PositionedStripe(@NotNull Color color, int yEnd, boolean thin, int layer) {
            if (color == null) {
                PositionedStripe.$$$reportNull$$$0(0);
            }
            this.color = color;
            this.yEnd = yEnd;
            this.thin = thin;
            this.layer = layer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$PositionedStripe", "<init>"));
        }
    }
}

