/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service
public final class VisibleEditorsTracker {
    private final Set<Editor> myEditorsVisibleOnCommandStart = new HashSet<Editor>();
    private long myCurrentCommandStart;
    private long myLastCommandFinish;

    public static VisibleEditorsTracker getInstance() {
        return (VisibleEditorsTracker)ApplicationManager.getApplication().getService(VisibleEditorsTracker.class);
    }

    public boolean wasEditorVisibleOnCommandStart(Editor editor) {
        return this.myEditorsVisibleOnCommandStart.contains(editor);
    }

    public long getCurrentCommandStart() {
        return this.myCurrentCommandStart;
    }

    public long getLastCommandFinish() {
        return this.myLastCommandFinish;
    }

    private void commandStarted() {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (editor.getComponent().isShowing()) {
                this.myEditorsVisibleOnCommandStart.add(editor);
            }
            ((ScrollingModelImpl)editor.getScrollingModel()).finishAnimation();
            this.myCurrentCommandStart = System.currentTimeMillis();
        }
    }

    private void commandFinished() {
        this.myEditorsVisibleOnCommandStart.clear();
        this.myLastCommandFinish = System.currentTimeMillis();
    }

    static final class MyCommandListener
    implements CommandListener {
        MyCommandListener() {
        }

        public void commandStarted(@NotNull CommandEvent event) {
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(0);
            }
            VisibleEditorsTracker.getInstance().commandStarted();
        }

        public void commandFinished(@NotNull CommandEvent event) {
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(1);
            }
            VisibleEditorsTracker.getInstance().commandFinished();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/editor/impl/VisibleEditorsTracker$MyCommandListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

