/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapEngine;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListener;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class SoftWrapApplianceManager
implements Dumpable {
    private static final Logger LOG = Logger.getInstance(SoftWrapApplianceManager.class);
    private static final int QUICK_DUMMY_WRAPPING = Integer.MAX_VALUE;
    private static final int QUICK_WRAP_CHAR_COUNT = 1000;
    private final List<SoftWrapAwareDocumentParsingListener> myListeners;
    private final SoftWrapsStorage myStorage;
    private final EditorImpl myEditor;
    private SoftWrapPainter myPainter;
    private final CachingSoftWrapDataMapper myDataMapper;
    private int myLastTopLeftCornerOffset;
    private VisibleAreaWidthProvider myWidthProvider;
    private IncrementalCacheUpdateEvent myEventBeingProcessed;
    private boolean myCustomIndentUsedLastTime;
    private int myCustomIndentValueUsedLastTime;
    private int myVisibleAreaWidth;
    private boolean myInProgress;
    private boolean myIsDirty;
    private IncrementalCacheUpdateEvent myDocumentChangedEvent;
    private int myAvailableWidth;

    public SoftWrapApplianceManager(@NotNull SoftWrapsStorage storage2, @NotNull EditorImpl editor, @NotNull SoftWrapPainter painter, CachingSoftWrapDataMapper dataMapper) {
        if (storage2 == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(1);
        }
        if (painter == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(2);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIsDirty = true;
        this.myAvailableWidth = Integer.MAX_VALUE;
        this.myStorage = storage2;
        this.myEditor = editor;
        this.myPainter = painter;
        this.myDataMapper = dataMapper;
        this.myWidthProvider = new DefaultVisibleAreaWidthProvider(editor);
        this.myEditor.getScrollingModel().addVisibleAreaListener(e -> {
            this.updateAvailableArea();
            this.updateLastTopLeftCornerOffset();
        });
    }

    public void registerSoftWrapIfNecessary() {
        this.recalculateIfNecessary();
    }

    public void reset() {
        this.myIsDirty = true;
        for (SoftWrapAwareDocumentParsingListener listener2 : this.myListeners) {
            listener2.reset();
        }
    }

    private void recalculate(IncrementalCacheUpdateEvent e) {
        if (this.myIsDirty) {
            return;
        }
        if (this.myVisibleAreaWidth <= 0) {
            this.myIsDirty = true;
            return;
        }
        this.recalculateSoftWraps(e);
        this.onRecalculationEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculate(@NotNull List<? extends Segment> ranges) {
        if (ranges == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(3);
        }
        if (this.myIsDirty) {
            return;
        }
        if (this.myVisibleAreaWidth <= 0) {
            this.myIsDirty = true;
            return;
        }
        ranges.sort((o1, o2) -> {
            int startDiff = o1.getStartOffset() - o2.getStartOffset();
            return startDiff == 0 ? o2.getEndOffset() - o1.getEndOffset() : startDiff;
        });
        final int[] lastRecalculatedOffset = new int[]{0};
        SoftWrapAwareDocumentParsingListenerAdapter listener2 = new SoftWrapAwareDocumentParsingListenerAdapter(){

            @Override
            public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                lastRecalculatedOffset[0] = event.getActualEndOffset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager$1", "onRecalculationEnd"));
            }
        };
        this.myListeners.add(listener2);
        try {
            for (Segment segment : ranges) {
                int lastOffset = lastRecalculatedOffset[0];
                if (segment.getEndOffset() <= lastOffset) continue;
                this.recalculateSoftWraps(new IncrementalCacheUpdateEvent(Math.max(segment.getStartOffset(), lastOffset), segment.getEndOffset(), this.myEditor));
            }
        }
        finally {
            this.myListeners.remove(listener2);
        }
        this.onRecalculationEnd();
    }

    public void recalculateAll() {
        this.reset();
        this.myStorage.removeAll();
        this.myVisibleAreaWidth = this.myAvailableWidth;
        this.myCustomIndentUsedLastTime = this.myEditor.getSettings().isUseCustomSoftWrapIndent();
        this.myCustomIndentValueUsedLastTime = this.myEditor.getSettings().getCustomSoftWrapIndent();
        this.recalculateSoftWraps();
    }

    private boolean recalculateSoftWraps() {
        if (!this.myIsDirty) {
            return true;
        }
        if (this.myVisibleAreaWidth <= 0) {
            return false;
        }
        this.myIsDirty = false;
        this.recalculateSoftWraps(new IncrementalCacheUpdateEvent(this.myEditor.getDocument()));
        this.onRecalculationEnd();
        return true;
    }

    private void onRecalculationEnd() {
        this.updateLastTopLeftCornerOffset();
        for (SoftWrapAwareDocumentParsingListener listener2 : this.myListeners) {
            listener2.recalculationEnds();
        }
    }

    private void recalculateSoftWraps(@NotNull IncrementalCacheUpdateEvent event) {
        if (event == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(4);
        }
        if (this.myInProgress) {
            LOG.error("Detected race condition at soft wraps recalculation", new Throwable(), new Attachment[]{AttachmentFactory.createContext(this.myEditor.dumpState(), event)});
        }
        this.myInProgress = true;
        try {
            this.myEventBeingProcessed = event;
            this.notifyListenersOnCacheUpdateStart(event);
            int endOffsetUpperEstimate = this.getEndOffsetUpperEstimate(event);
            if (this.myVisibleAreaWidth == Integer.MAX_VALUE) {
                this.doRecalculateSoftWrapsRoughly(event);
            } else {
                new SoftWrapEngine(this.myEditor, this.myPainter, this.myStorage, this.myDataMapper, event, this.myVisibleAreaWidth, this.myCustomIndentUsedLastTime ? this.myCustomIndentValueUsedLastTime : -1).generate();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Soft wrap recalculation done: " + event.toString() + ". " + (event.getActualEndOffset() - event.getStartOffset()) + " characters processed");
            }
            if (event.getActualEndOffset() > endOffsetUpperEstimate) {
                LOG.error("Unexpected error at soft wrap recalculation", new Attachment[]{new Attachment("softWrapModel.txt", this.myEditor.getSoftWrapModel().toString())});
            }
            this.notifyListenersOnCacheUpdateEnd(event);
            this.myEventBeingProcessed = null;
        }
        finally {
            this.myInProgress = false;
        }
        Project project = this.myEditor.getProject();
        VirtualFile file2 = this.myEditor.getVirtualFile();
        if (project != null && file2 != null && this.myEditor.getUserData(EditorImpl.FORCED_SOFT_WRAPS) != null) {
            if (this.myStorage.isEmpty()) {
                this.myEditor.putUserData(EditorImpl.SOFT_WRAPS_EXIST, null);
            } else if (this.myEditor.getUserData(EditorImpl.SOFT_WRAPS_EXIST) == null) {
                this.myEditor.putUserData(EditorImpl.SOFT_WRAPS_EXIST, Boolean.TRUE);
                EditorNotifications.getInstance((Project)project).updateNotifications(file2);
            }
        }
    }

    private void doRecalculateSoftWrapsRoughly(IncrementalCacheUpdateEvent event) {
        DocumentEx document = this.myEditor.getDocument();
        int lineCount = document.getLineCount();
        int offset = event.getStartOffset();
        int line = document.getLineNumber(offset);
        int mandatoryEnd = event.getMandatoryEndOffset();
        while (true) {
            if ((offset += 1000) >= document.getLineEndOffset(line)) {
                if (++line >= lineCount) {
                    offset = document.getTextLength();
                } else {
                    offset = document.getLineStartOffset(line);
                    if (offset <= mandatoryEnd || this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1) != null) continue;
                }
                break;
            }
            FoldRegion foldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (foldRegion != null) {
                offset = foldRegion.getEndOffset();
                line = document.getLineNumber(offset);
            }
            if (DocumentUtil.isInsideSurrogatePair(document, offset)) {
                ++offset;
            }
            if (offset >= document.getLineEndOffset(line)) continue;
            SoftWrapImpl wrap2 = new SoftWrapImpl(new TextChangeImpl("\n", offset), 1, 1);
            this.myStorage.storeOrReplace(wrap2);
            if (offset > mandatoryEnd && this.myDataMapper.matchesOldSoftWrap(wrap2, event.getLengthDiff())) break;
        }
        event.setActualEndOffset(offset);
    }

    private int getEndOffsetUpperEstimate(IncrementalCacheUpdateEvent event) {
        int endOffsetUpperEstimate = EditorUtil.getNotFoldedLineEndOffset(this.myEditor, event.getMandatoryEndOffset());
        int line = this.myEditor.getDocument().getLineNumber(endOffsetUpperEstimate);
        if (line < this.myEditor.getDocument().getLineCount() - 1) {
            endOffsetUpperEstimate = this.myEditor.getDocument().getLineStartOffset(line + 1);
        }
        return endOffsetUpperEstimate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recalculateIfNecessary() {
        if (this.myInProgress) {
            return false;
        }
        boolean indentChanged = false;
        IndentType currentIndentType = this.getIndentToUse();
        boolean useCustomIndent = currentIndentType == IndentType.CUSTOM;
        int currentCustomIndent = this.myEditor.getSettings().getCustomSoftWrapIndent();
        if (useCustomIndent ^ this.myCustomIndentUsedLastTime || useCustomIndent && this.myCustomIndentValueUsedLastTime != currentCustomIndent) {
            indentChanged = true;
        }
        this.myCustomIndentUsedLastTime = useCustomIndent;
        this.myCustomIndentValueUsedLastTime = currentCustomIndent;
        int currentVisibleAreaWidth = this.myAvailableWidth;
        if (!indentChanged && this.myVisibleAreaWidth == currentVisibleAreaWidth) {
            return this.recalculateSoftWraps();
        }
        JScrollBar scrollBar = this.myEditor.getScrollPane().getVerticalScrollBar();
        int verticalScrollBarWidth = scrollBar.getWidth();
        if (verticalScrollBarWidth <= 0) {
            verticalScrollBarWidth = scrollBar.getPreferredSize().width;
        }
        if (currentVisibleAreaWidth - this.myVisibleAreaWidth == verticalScrollBarWidth) {
            this.myVisibleAreaWidth = currentVisibleAreaWidth;
            return this.recalculateSoftWraps();
        }
        ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
        int yScrollOffset = scrollingModel.getVerticalScrollOffset();
        int anchorOffset = this.myLastTopLeftCornerOffset;
        int softWrapsBefore = this.getNumberOfSoftWrapsBefore(anchorOffset);
        this.reset();
        this.myStorage.removeAll();
        this.myVisibleAreaWidth = currentVisibleAreaWidth;
        boolean result2 = this.recalculateSoftWraps();
        if (!result2) {
            return false;
        }
        int softWrapsNow = this.getNumberOfSoftWrapsBefore(anchorOffset);
        if (softWrapsNow != softWrapsBefore) {
            scrollingModel.disableAnimation();
            try {
                scrollingModel.scrollVertically(yScrollOffset + (softWrapsNow - softWrapsBefore) * this.myEditor.getLineHeight());
            }
            finally {
                scrollingModel.enableAnimation();
            }
        }
        this.updateLastTopLeftCornerOffset();
        return true;
    }

    private void updateLastTopLeftCornerOffset() {
        int visibleAreaTopY = this.myEditor.getScrollingModel().getVisibleArea().y;
        if (visibleAreaTopY == 0) {
            this.myLastTopLeftCornerOffset = 0;
        } else {
            int visualLine = 1 + this.myEditor.yToVisualLine(visibleAreaTopY);
            this.myLastTopLeftCornerOffset = this.myEditor.visualLineStartOffset(visualLine);
        }
    }

    private int getNumberOfSoftWrapsBefore(int offset) {
        int i2 = this.myStorage.getSoftWrapIndex(offset);
        return i2 >= 0 ? i2 : -i2 - 1;
    }

    private IndentType getIndentToUse() {
        return this.myEditor.getSettings().isUseCustomSoftWrapIndent() ? IndentType.CUSTOM : IndentType.NONE;
    }

    public boolean addListener(@NotNull SoftWrapAwareDocumentParsingListener listener2) {
        if (listener2 == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(5);
        }
        return this.myListeners.add(listener2);
    }

    public boolean removeListener(@NotNull SoftWrapAwareDocumentParsingListener listener2) {
        if (listener2 == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(6);
        }
        return this.myListeners.remove(listener2);
    }

    private void notifyListenersOnCacheUpdateStart(IncrementalCacheUpdateEvent event) {
        for (int i2 = 0; i2 < this.myListeners.size(); ++i2) {
            SoftWrapAwareDocumentParsingListener listener2 = this.myListeners.get(i2);
            listener2.onCacheUpdateStart(event);
        }
    }

    private void notifyListenersOnCacheUpdateEnd(IncrementalCacheUpdateEvent event) {
        for (int i2 = 0; i2 < this.myListeners.size(); ++i2) {
            SoftWrapAwareDocumentParsingListener listener2 = this.myListeners.get(i2);
            listener2.onRecalculationEnd(event);
        }
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDocumentChangedEvent = new IncrementalCacheUpdateEvent(event, this.myEditor);
    }

    public void documentChanged(DocumentEvent event, boolean processAlsoLineEnd) {
        int lineEndOffset;
        LOG.assertTrue(this.myDocumentChangedEvent != null);
        this.recalculate(this.myDocumentChangedEvent);
        if (processAlsoLineEnd && (lineEndOffset = DocumentUtil.getLineEndOffset(this.myDocumentChangedEvent.getMandatoryEndOffset(), event.getDocument())) > this.myDocumentChangedEvent.getActualEndOffset()) {
            this.recalculate(new IncrementalCacheUpdateEvent(lineEndOffset, lineEndOffset, this.myEditor));
        }
        this.myDocumentChangedEvent = null;
    }

    public void setWidthProvider(@NotNull VisibleAreaWidthProvider widthProvider) {
        if (widthProvider == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(7);
        }
        this.myWidthProvider = widthProvider;
        this.reset();
    }

    @NotNull
    public VisibleAreaWidthProvider getWidthProvider() {
        VisibleAreaWidthProvider visibleAreaWidthProvider = this.myWidthProvider;
        if (visibleAreaWidthProvider == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(8);
        }
        return visibleAreaWidthProvider;
    }

    @NotNull
    public String dumpState() {
        String string = String.format("recalculation in progress: %b; event being processed: %s, available width: %d, visible width: %d, dirty: %b", this.myInProgress, this.myEventBeingProcessed, this.myAvailableWidth, this.myVisibleAreaWidth, this.myIsDirty);
        if (string == null) {
            SoftWrapApplianceManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    public String toString() {
        return this.dumpState();
    }

    @TestOnly
    public void setSoftWrapPainter(SoftWrapPainter painter) {
        this.myPainter = painter;
    }

    public void updateAvailableArea() {
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        if (visibleArea.isEmpty()) {
            return;
        }
        int width = this.myWidthProvider.getVisibleAreaWidth();
        if (width <= 0) {
            return;
        }
        this.myAvailableWidth = width;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widthProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/softwrap/mapping/SoftWrapApplianceManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidthProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "recalculate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recalculateSoftWraps";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setWidthProvider";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultVisibleAreaWidthProvider
    implements VisibleAreaWidthProvider {
        private final EditorImpl myEditor;

        DefaultVisibleAreaWidthProvider(EditorImpl editor) {
            this.myEditor = editor;
        }

        @Override
        public int getVisibleAreaWidth() {
            int rightMargin;
            Insets insets = this.myEditor.getContentComponent().getInsets();
            int width = Math.max(0, this.myEditor.getScrollingModel().getVisibleArea().width - insets.left - insets.right);
            if (this.myEditor.isInDistractionFreeMode() && (rightMargin = this.myEditor.getSettings().getRightMargin(this.myEditor.getProject())) > 0) {
                width = Math.min(width, rightMargin * EditorUtil.getPlainSpaceWidth(this.myEditor));
            }
            return width;
        }
    }

    @FunctionalInterface
    public static interface VisibleAreaWidthProvider {
        public int getVisibleAreaWidth();
    }

    static enum IndentType {
        NONE,
        CUSTOM;

    }
}

