/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IgnoreExternalProjectAction
extends ExternalSystemToggleAction {
    private static final Logger LOG = Logger.getInstance(IgnoreExternalProjectAction.class);

    public IgnoreExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.messagePointer((String)"action.ignore.external.projects.text", (Object[])new Object[]{"External", 1}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.ignore.external.projects.description", (Object[])new Object[]{"external", 1}));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(0);
        }
        ProjectSystemId projectSystemId = this.getSystemId(e);
        List<ExternalSystemNode<ExternalConfigPathAware>> projectNodes = IgnoreExternalProjectAction.getProjectNodes(e);
        if (projectNodes.isEmpty()) {
            return;
        }
        final Project project = this.getProject(e);
        ExternalSystemActionsCollector.trigger(project, projectSystemId, (AnAction)this, e);
        projectNodes.forEach(projectNode -> projectNode.setIgnored(state));
        final Set uniqueExternalProjects = projectNodes.stream().map(projectNode -> {
            DataNode projectDataNode;
            String externalProjectPath = ((ExternalConfigPathAware)projectNode.getData()).getLinkedExternalProjectPath();
            ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo(project, projectSystemId, externalProjectPath);
            DataNode dataNode = projectDataNode = externalProjectInfo == null ? null : externalProjectInfo.getExternalProjectStructure();
            if (projectDataNode == null && LOG.isDebugEnabled()) {
                LOG.debug(String.format("external project data not found, path: %s, data: %s", externalProjectPath, externalProjectInfo));
            }
            return projectDataNode;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, e.getPresentation().getText(), false){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                uniqueExternalProjects.forEach(externalProjectInfo -> ((ProjectDataManager)ApplicationManager.getApplication().getService(ProjectDataManager.class)).importData(externalProjectInfo, project, true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/action/IgnoreExternalProjectAction$1", "run"));
            }
        });
    }

    @Override
    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(1);
        }
        boolean selected2 = super.isSelected(e);
        ProjectSystemId systemId2 = this.getSystemId(e);
        String systemIdNameText = systemId2 != null ? systemId2.getReadableName() : "External";
        String systemIdNameDescription = systemId2 != null ? systemId2.getReadableName() : "external";
        int size2 = IgnoreExternalProjectAction.getProjectNodes(e).size();
        if (selected2) {
            this.setText(e, ExternalSystemBundle.message((String)"action.unignore.external.projects.text", (Object[])new Object[]{systemIdNameText, size2}));
            this.setDescription(e, ExternalSystemBundle.message((String)"action.unignore.external.projects.description", (Object[])new Object[]{systemIdNameDescription, size2}));
        } else {
            this.setText(e, ExternalSystemBundle.message((String)"action.ignore.external.projects.text", (Object[])new Object[]{systemIdNameText, size2}));
            this.setDescription(e, ExternalSystemBundle.message((String)"action.ignore.external.projects.description", (Object[])new Object[]{systemIdNameDescription, size2}));
        }
        return selected2;
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(2);
        }
        if (!super.isEnabled(e)) {
            return false;
        }
        return !IgnoreExternalProjectAction.getProjectNodes(e).isEmpty();
    }

    @Override
    protected boolean doIsSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists(IgnoreExternalProjectAction.getProjectNodes(e), projectNode -> projectNode.isIgnored());
    }

    @NotNull
    private static List<ExternalSystemNode<ExternalConfigPathAware>> getProjectNodes(@NotNull AnActionEvent e) {
        List selectedNodes;
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(4);
        }
        if ((selectedNodes = (List)e.getData(ExternalSystemDataKeys.SELECTED_NODES)) == null || selectedNodes.isEmpty()) {
            List<ExternalSystemNode<ExternalConfigPathAware>> list2 = Collections.emptyList();
            if (list2 == null) {
                IgnoreExternalProjectAction.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List<ExternalSystemNode<ExternalConfigPathAware>> list3 = selectedNodes.stream().map(node2 -> node2 instanceof ModuleNode || node2 instanceof ProjectNode ? node2 : null).filter(Objects::nonNull).collect(Collectors.toList());
        if (list3 == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(6);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/IgnoreExternalProjectAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/IgnoreExternalProjectAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doIsSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProjectNodes";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

