/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autolink;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"createExtensionDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "unlinkedProjectAware", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "getProjectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "externalProjectPath", "", "linkAndLoadProjectWithLoadingConfirmation", "", "intellij.platform.externalSystem.impl"})
public final class UnlinkedProjectUtilsKt {
    @NotNull
    public static final ExternalSystemProjectId getProjectId(@NotNull ExternalSystemUnlinkedProjectAware $this$getProjectId, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectId, (String)"$this$getProjectId");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        return new ExternalSystemProjectId($this$getProjectId.getSystemId(), externalProjectPath);
    }

    public static final void linkAndLoadProjectWithLoadingConfirmation(@NotNull ExternalSystemUnlinkedProjectAware $this$linkAndLoadProjectWithLoadingConfirmation, @NotNull Project project, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)$this$linkAndLoadProjectWithLoadingConfirmation, (String)"$this$linkAndLoadProjectWithLoadingConfirmation");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        ExternalSystemUtil.confirmLoadingUntrustedProject(project, $this$linkAndLoadProjectWithLoadingConfirmation.getSystemId());
        $this$linkAndLoadProjectWithLoadingConfirmation.linkAndLoadProject(project, externalProjectPath);
    }

    @NotNull
    public static final Disposable createExtensionDisposable(@NotNull Project project, @NotNull ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)unlinkedProjectAware, (String)"unlinkedProjectAware");
        Disposable disposable2 = ExtensionPointUtil.createExtensionDisposable((Object)unlinkedProjectAware, (ExtensionPointName)ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"ExtensionPointUtil.creat\u2026nkedProjectAware.EP_NAME)");
        Disposable disposable3 = disposable2;
        boolean bl = false;
        boolean bl2 = false;
        Disposable it = disposable3;
        boolean bl3 = false;
        Disposer.register((Disposable)((Disposable)project), (Disposable)it);
        return disposable3;
    }
}

