/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypeSelectable;
import com.intellij.openapi.fileTypes.impl.RemovedMappingTracker;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

class ConflictingFileTypeMappingTracker {
    private final RemovedMappingTracker myRemovedMappingTracker;

    @NotNull
    ResolveConflictResult warnAndResolveConflict(@NotNull FileNameMatcher matcher, @Nullable FileTypeManagerImpl.FileTypeWithDescriptor oldFtd, @NotNull FileTypeManagerImpl.FileTypeWithDescriptor newFtd) {
        if (matcher == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(0);
        }
        if (newFtd == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(1);
        }
        FileType oldFileType = oldFtd == null ? null : oldFtd.fileType;
        FileType newFileType = newFtd.fileType;
        if (oldFileType == null || oldFileType.equals(newFileType) || oldFileType instanceof AbstractFileType) {
            return new ResolveConflictResult((FileTypeManagerImpl.FileTypeWithDescriptor)ObjectUtils.notNull((Object)oldFtd, (Object)newFtd), "", "", true);
        }
        ResolveConflictResult result2 = ConflictingFileTypeMappingTracker.resolveConflict(matcher, oldFtd, newFtd);
        if (!result2.approved) {
            if (oldFtd.fileType.equals(newFileType)) {
                throw new IllegalArgumentException("expected different file types but got " + result2.resolved);
            }
            this.showConflictNotification(null, matcher, oldFtd, result2);
        }
        ResolveConflictResult resolveConflictResult = result2;
        if (resolveConflictResult == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(2);
        }
        return resolveConflictResult;
    }

    @NotNull
    @VisibleForTesting
    static ResolveConflictResult resolveConflict(@NotNull FileNameMatcher matcher, @NotNull FileTypeManagerImpl.FileTypeWithDescriptor oldFtd, @NotNull FileTypeManagerImpl.FileTypeWithDescriptor newFtd) {
        boolean isNewJetBrains;
        if (matcher == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(3);
        }
        if (oldFtd == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(4);
        }
        if (newFtd == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(5);
        }
        assert (!oldFtd.equals(newFtd)) : oldFtd;
        if (newFtd.pluginDescriptor.isBundled() && (!oldFtd.pluginDescriptor.isBundled() || ConflictingFileTypeMappingTracker.isCorePlugin(newFtd.pluginDescriptor) && !ConflictingFileTypeMappingTracker.isCorePlugin(oldFtd.pluginDescriptor))) {
            FileTypeManagerImpl.FileTypeWithDescriptor ftd = newFtd;
            newFtd = oldFtd;
            oldFtd = ftd;
        }
        PluginDescriptor oldPlugin = oldFtd.pluginDescriptor;
        PluginDescriptor newPlugin = newFtd.pluginDescriptor;
        FileType oldFileType = oldFtd.fileType;
        FileType newFileType = newFtd.fileType;
        String oldPluginName = oldPlugin.isBundled() ? "bundled" : oldPlugin.getName();
        String explanation = FileTypesBundle.message("notification.content.file.type.reassigned.explanation", matcher.getPresentableString());
        if (!newPlugin.isBundled() || ConflictingFileTypeMappingTracker.isCorePlugin(oldPlugin) && !ConflictingFileTypeMappingTracker.isCorePlugin(newPlugin)) {
            boolean approved = oldPlugin.isBundled();
            String message2 = FileTypesBundle.message("notification.content.file.type.reassigned.plugin", matcher.getPresentableString(), oldPluginName, newFileType.getDisplayName(), newPlugin.getName());
            return new ResolveConflictResult(newFtd, message2, explanation, approved);
        }
        if (oldFileType == NativeFileType.INSTANCE) {
            String message3 = FileTypesBundle.message("notification.content.file.pattern.was.reassigned.to", matcher.getPresentableString(), newFileType.getDisplayName());
            return new ResolveConflictResult(newFtd, message3, explanation, true);
        }
        boolean isOldJetBrains = PluginManagerCore.isVendorJetBrains(StringUtil.notNullize((String)oldPlugin.getVendor()));
        if (isOldJetBrains != (isNewJetBrains = PluginManagerCore.isVendorJetBrains(StringUtil.notNullize((String)newPlugin.getVendor())))) {
            FileTypeManagerImpl.FileTypeWithDescriptor result2 = isOldJetBrains ? newFtd : oldFtd;
            String message4 = FileTypesBundle.message("notification.content.file.pattern.was.reassigned.to", matcher.getPresentableString(), result2.fileType.getDisplayName());
            return new ResolveConflictResult(result2, message4, explanation, true);
        }
        String message5 = FileTypesBundle.message("notification.content.file.pattern.was.reassigned.to", matcher.getPresentableString(), oldFileType.getDisplayName());
        return new ResolveConflictResult(oldFtd, message5, explanation, false);
    }

    private static boolean isCorePlugin(@NotNull PluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(6);
        }
        return PluginManagerCore.CORE_ID.equals((Object)descriptor2.getPluginId());
    }

    ConflictingFileTypeMappingTracker(@NotNull RemovedMappingTracker removedMappingTracker) {
        if (removedMappingTracker == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(7);
        }
        this.myRemovedMappingTracker = removedMappingTracker;
    }

    private void showConflictNotification(@Nullable Project project, @NotNull FileNameMatcher matcher, @NotNull FileTypeManagerImpl.FileTypeWithDescriptor oldFtd, @NotNull ResolveConflictResult result2) {
        if (matcher == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(8);
        }
        if (oldFtd == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(10);
        }
        FileType resolvedFileType = result2.resolved.fileType;
        @Nls String notificationText = result2.notification;
        String oldDisplayName = oldFtd.fileType.getDisplayName();
        String resolvedDisplayName = resolvedFileType.getDisplayName();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Notification notification = new Notification(NotificationGroup.getGroupTitle((String)"File type conflict"), notificationText, result2.explanation, NotificationType.INFORMATION);
            String message2 = result2.resolved.pluginDescriptor.isBundled() ? FileTypesBundle.message("notification.content.conflict.confirm.reassign", resolvedDisplayName) : FileTypesBundle.message("notification.content.conflict.confirm.reassign.from.plugin", resolvedDisplayName, result2.resolved.pluginDescriptor.getName());
            notification.addAction((AnAction)NotificationAction.createSimple((String)message2, () -> {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    this.myRemovedMappingTracker.add(matcher, oldFtd.getName(), true);
                    ((FileTypeManagerImpl)FileTypeManager.getInstance()).associate(result2.resolved, matcher, true);
                });
                notification.expire();
                String m = FileTypesBundle.message("dialog.message.file.pattern.was.assigned.to", matcher.getPresentableString(), resolvedDisplayName);
                ConflictingFileTypeMappingTracker.showReassignedInfoNotification(project, m);
            }));
            String revertMessage = oldFtd.pluginDescriptor.isBundled() ? FileTypesBundle.message("notification.content.revert.reassign", oldDisplayName) : FileTypesBundle.message("notification.content.revert.reassign.from.plugin", oldDisplayName, oldFtd.pluginDescriptor.getName());
            notification.addAction((AnAction)NotificationAction.createSimple((String)revertMessage, () -> {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    this.myRemovedMappingTracker.add(matcher, resolvedFileType.getName(), true);
                    ((FileTypeManagerImpl)FileTypeManager.getInstance()).associate(oldFtd, matcher, true);
                });
                notification.expire();
                String m = FileTypesBundle.message("dialog.message.file.pattern.was.reassigned.back.to", matcher.getPresentableString(), oldDisplayName);
                ConflictingFileTypeMappingTracker.showReassignedInfoNotification(project, m);
            }));
            if (!oldFtd.fileType.isReadOnly()) {
                notification.addAction((AnAction)NotificationAction.createSimple((String)FileTypesBundle.message("notification.content.edit", oldDisplayName), () -> ConflictingFileTypeMappingTracker.editFileType(project, oldFtd.fileType)));
            }
            if (!resolvedFileType.isReadOnly()) {
                notification.addAction((AnAction)NotificationAction.createSimple((String)FileTypesBundle.message("notification.content.edit", resolvedDisplayName), () -> ConflictingFileTypeMappingTracker.editFileType(project, resolvedFileType)));
            }
            Notifications.Bus.notify((Notification)notification, (Project)project);
        }, project == null ? ApplicationManager.getApplication().getDisposed() : project.getDisposed());
    }

    private static void showReassignedInfoNotification(@Nullable Project project, @NotNull @NlsContexts.NotificationContent String message2) {
        if (message2 == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(11);
        }
        new Notification(NotificationGroup.getGroupTitle((String)"Pattern reassigned"), FileTypesBundle.message("dialog.title.pattern.reassigned", new Object[0]), message2, NotificationType.INFORMATION).notify(project);
    }

    private static void editFileType(@Nullable Project project, @NotNull FileType fileType) {
        if (fileType == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(12);
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(project, configurable2 -> configurable2 instanceof SearchableConfigurable && ((SearchableConfigurable)configurable2).getId().equals("preferences.fileTypes"), configurable2 -> {
            if (configurable2 instanceof ConfigurableWrapper) {
                configurable2 = (Configurable)((ConfigurableWrapper)configurable2).getConfigurable();
            }
            FileTypeSelectable fileTypeSelectable = (FileTypeSelectable)configurable2;
            fileTypeSelectable.selectFileType(fileType);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFtd";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/ConflictingFileTypeMappingTracker";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFtd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedMappingTracker";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/ConflictingFileTypeMappingTracker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "warnAndResolveConflict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "warnAndResolveConflict";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflict";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCorePlugin";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showConflictNotification";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showReassignedInfoNotification";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "editFileType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ResolveConflictResult {
        @NotNull
        final FileTypeManagerImpl.FileTypeWithDescriptor resolved;
        @NotNull
        @Nls
        final String notification;
        @NotNull
        @Nls
        final String explanation;
        final boolean approved;

        ResolveConflictResult(@NotNull FileTypeManagerImpl.FileTypeWithDescriptor resolved2, @NotNull @Nls String notification, @NotNull @Nls String explanation, boolean approved) {
            if (resolved2 == null) {
                ResolveConflictResult.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                ResolveConflictResult.$$$reportNull$$$0(1);
            }
            if (explanation == null) {
                ResolveConflictResult.$$$reportNull$$$0(2);
            }
            this.resolved = resolved2;
            this.notification = notification;
            this.explanation = explanation;
            this.approved = approved;
        }

        public String toString() {
            return "ResolveConflictResult: resolved=" + this.resolved + "; explanation='" + this.explanation + "'; notification='" + this.notification + "'; approved=" + this.approved;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "explanation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileTypes/impl/ConflictingFileTypeMappingTracker$ResolveConflictResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

