/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.EmptyIcon;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTypeWithDescriptorRenderer<T>
extends SimpleListCellRenderer<T> {
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    @NotNull
    private final ListModel<? extends T> myModel;
    private final Function<? super T, ? extends FileType> myConverter;
    @Nullable
    private Set<String> myDuplicateDescriptions;

    FileTypeWithDescriptorRenderer(@NotNull ListModel<? extends T> model2, @NotNull Function<? super T, ? extends FileType> converter) {
        if (model2 == null) {
            FileTypeWithDescriptorRenderer.$$$reportNull$$$0(0);
        }
        if (converter == null) {
            FileTypeWithDescriptorRenderer.$$$reportNull$$$0(1);
        }
        this.myModel = model2;
        this.myConverter = converter;
        model2.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                FileTypeWithDescriptorRenderer.this.myDuplicateDescriptions = null;
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                FileTypeWithDescriptorRenderer.this.myDuplicateDescriptions = null;
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FileTypeWithDescriptorRenderer.this.myDuplicateDescriptions = null;
            }
        });
    }

    public void customize(@NotNull JList<? extends T> list2, T t, int index2, boolean selected2, boolean hasFocus) {
        if (list2 == null) {
            FileTypeWithDescriptorRenderer.$$$reportNull$$$0(2);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        FileType value2 = this.myConverter.apply(t);
        Icon icon2 = value2.getIcon();
        if (icon2 != null) {
            layeredIcon.setIcon(icon2, 1, (-icon2.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon2.getIconHeight()) / 2);
        }
        this.setIcon(layeredIcon);
        String description2 = value2.getDescription();
        if (this.isDuplicated(description2)) {
            this.setText(description2 + " (" + value2.getName() + ")");
        } else {
            this.setText(description2);
        }
    }

    private boolean isDuplicated(String description2) {
        if (this.myDuplicateDescriptions == null) {
            this.myDuplicateDescriptions = new HashSet<String>();
            HashSet<String> filter = new HashSet<String>();
            for (int i2 = 0; i2 < this.myModel.getSize(); ++i2) {
                String s = this.myConverter.apply(this.myModel.getElementAt(i2)).getDescription();
                if (filter.add(s)) continue;
                this.myDuplicateDescriptions.add(s);
            }
        }
        return this.myDuplicateDescriptions.contains(description2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeWithDescriptorRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "customize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

