/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableVisitor
implements Predicate<Configurable> {
    public static final Predicate<Configurable> ALL = configurable2 -> true;

    @Override
    public boolean test(Configurable configurable2) {
        return this.accept(configurable2);
    }

    protected abstract boolean accept(@NotNull Configurable var1);

    @Nullable
    public final Configurable find(ConfigurableGroup ... groups2) {
        if (groups2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(0);
        }
        return ConfigurableVisitor.find((Predicate<? super Configurable>)this, Arrays.asList(groups2));
    }

    @Nullable
    public static Configurable findById(@NotNull String id2, @NotNull List<? extends ConfigurableGroup> groups2) {
        if (id2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(1);
        }
        if (groups2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(2);
        }
        return ConfigurableVisitor.find((? super Configurable configurable2) -> id2.equals(ConfigurableVisitor.getId(configurable2)), groups2);
    }

    @Nullable
    public static Configurable findByType(@NotNull Class<? extends Configurable> type, @NotNull List<? extends ConfigurableGroup> groups2) {
        if (type == null) {
            ConfigurableVisitor.$$$reportNull$$$0(3);
        }
        if (groups2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(4);
        }
        return ConfigurableVisitor.find((? super Configurable configurable2) -> ConfigurableWrapper.cast(type, (UnnamedConfigurable)configurable2) != null, groups2);
    }

    @Nullable
    public static Configurable find(@NotNull Predicate<? super Configurable> visitor, @NotNull List<? extends ConfigurableGroup> groups2) {
        if (visitor == null) {
            ConfigurableVisitor.$$$reportNull$$$0(5);
        }
        if (groups2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(6);
        }
        for (ConfigurableGroup configurableGroup : groups2) {
            Configurable result2 = ConfigurableVisitor.find(visitor, configurableGroup.getConfigurables());
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Configurable find(@NotNull Predicate<? super Configurable> visitor, Configurable @NotNull [] configurables) {
        if (visitor == null) {
            ConfigurableVisitor.$$$reportNull$$$0(7);
        }
        if (configurables == null) {
            ConfigurableVisitor.$$$reportNull$$$0(8);
        }
        for (Configurable configurable2 : configurables) {
            if (!visitor.test((Configurable)configurable2)) continue;
            return configurable2;
        }
        for (Configurable configurable2 : configurables) {
            Configurable.Composite composite2;
            Configurable result2;
            if (!(configurable2 instanceof Configurable.Composite) || (result2 = ConfigurableVisitor.find(visitor, (composite2 = (Configurable.Composite)configurable2).getConfigurables())) == null) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    public static List<Configurable> findAll(@NotNull Predicate<? super Configurable> visitor, @NotNull List<? extends ConfigurableGroup> groups2) {
        if (visitor == null) {
            ConfigurableVisitor.$$$reportNull$$$0(9);
        }
        if (groups2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(10);
        }
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        Consumer<Configurable> consumer = configurable2 -> {
            if (visitor.test((Configurable)configurable2)) {
                list2.add((Configurable)configurable2);
            }
        };
        for (ConfigurableGroup configurableGroup : groups2) {
            ConfigurableVisitor.collect(consumer, configurableGroup.getConfigurables());
        }
        ArrayList<Configurable> arrayList = list2;
        if (arrayList == null) {
            ConfigurableVisitor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    public static void collect(@NotNull Consumer<? super Configurable> visitor, Configurable @NotNull [] configurables) {
        if (visitor == null) {
            ConfigurableVisitor.$$$reportNull$$$0(12);
        }
        if (configurables == null) {
            ConfigurableVisitor.$$$reportNull$$$0(13);
        }
        for (Configurable configurable2 : configurables) {
            visitor.accept((Configurable)configurable2);
            if (!(configurable2 instanceof Configurable.Composite)) continue;
            ConfigurableVisitor.collect(visitor, ((Configurable.Composite)configurable2).getConfigurables());
        }
    }

    @NotNull
    public static String getId(@NotNull Configurable configurable2) {
        if (configurable2 == null) {
            ConfigurableVisitor.$$$reportNull$$$0(14);
        }
        String string = configurable2 instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable2).getId() : configurable2.getClass().getName();
        if (string == null) {
            ConfigurableVisitor.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/ConfigurableVisitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableVisitor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findByType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 11: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static final class ByID
    extends ConfigurableVisitor {
        private final String id;

        public ByID(@NotNull String id2) {
            if (id2 == null) {
                ByID.$$$reportNull$$$0(0);
            }
            this.id = id2;
        }

        @Override
        protected boolean accept(@NotNull Configurable configurable2) {
            if (configurable2 == null) {
                ByID.$$$reportNull$$$0(1);
            }
            return this.id.equals(ByID.getId(configurable2));
        }

        @Nullable
        public Configurable find(@NotNull List<? extends ConfigurableGroup> groups2) {
            if (groups2 == null) {
                ByID.$$$reportNull$$$0(2);
            }
            return ByID.find((Predicate<? super Configurable>)this, groups2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/options/ex/ConfigurableVisitor$ByID";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "find";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

