/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEventsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.LightColors;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ConfigurableEditor
extends AbstractEditor
implements AnActionListener,
AWTEventListener {
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("SettingsModification", 1000, false, (JComponent)this, (Disposable)this, (JComponent)this);
    private final ConfigurableCardPanel myCardPanel = new ConfigurableCardPanel(){

        @Override
        protected JComponent create(Configurable configurable2) {
            JComponent content2 = super.create(configurable2);
            return content2 != null ? content2 : ConfigurableEditor.this.createDefaultContent(configurable2);
        }
    };
    private final JLabel myErrorLabel = new JLabel();
    private final AbstractAction myApplyAction = new AbstractAction(CommonBundle.getApplyButtonText()){

        @Override
        public void actionPerformed(ActionEvent event) {
            ConfigurableEditor.this.apply();
        }
    };
    private final AbstractAction myResetAction = new AbstractAction(UIBundle.message((String)"configurable.reset.action.name", (Object[])new Object[0])){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ConfigurableEditor.this.myConfigurable != null) {
                ConfigurableCardPanel.reset(ConfigurableEditor.this.myConfigurable);
                ConfigurableEditor.this.updateCurrent(ConfigurableEditor.this.myConfigurable, true);
                FeatureUsageUiEventsKt.getUiEventLogger().logResetConfigurable(ConfigurableEditor.this.myConfigurable);
            }
        }
    };
    private Configurable myConfigurable;

    ConfigurableEditor(Disposable parent) {
        super(parent);
    }

    ConfigurableEditor(Disposable parent, Configurable configurable2) {
        super(parent);
        this.init(configurable2, parent instanceof SettingsEditor);
    }

    protected void init(Configurable configurable2, boolean enableError) {
        this.myApplyAction.setEnabled(false);
        this.myResetAction.putValue("ShortDescription", UIBundle.message((String)"configurable.reset.action.description", (Object[])new Object[0]));
        this.myResetAction.setEnabled(false);
        this.myErrorLabel.setOpaque(true);
        this.myErrorLabel.setEnabled(enableError);
        this.myErrorLabel.setVisible(false);
        this.myErrorLabel.setVerticalTextPosition(1);
        this.myErrorLabel.setBorder((Border)JBUI.Borders.empty((int)10, (int)15, (int)15, (int)15));
        this.myErrorLabel.setBackground(LightColors.RED);
        this.add("South", RelativeFont.HUGE.install((Component)this.myErrorLabel));
        this.add("Center", this.myCardPanel);
        Disposer.register((Disposable)this, (Disposable)this.myCardPanel);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(TOPIC, (Object)this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 56L);
        if (configurable2 != null) {
            this.myConfigurable = configurable2;
            this.myCardPanel.select(configurable2, true).doWhenDone(() -> this.postUpdateCurrent(configurable2));
        }
        this.updateCurrent(configurable2, false);
    }

    @Override
    void disposeOnce() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.myCardPanel.removeAll();
    }

    @Override
    String getHelpTopic() {
        return this.myConfigurable == null ? null : this.myConfigurable.getHelpTopic();
    }

    @Override
    Action getApplyAction() {
        return this.myApplyAction;
    }

    @Override
    Action getResetAction() {
        return this.myResetAction;
    }

    @Override
    boolean apply() {
        this.updateIfCurrent(this.myConfigurable);
        return this.setError(ConfigurableEditor.apply(this.myApplyAction.isEnabled() ? this.myConfigurable : null));
    }

    @Override
    boolean cancel(AWTEvent source) {
        this.myConfigurable.cancel();
        return super.cancel(source);
    }

    void openLink(Configurable configurable2) {
        ShowSettingsUtil.getInstance().editConfigurable((Component)this, configurable2);
    }

    public final void beforeEditorTyping(char ch, @NotNull DataContext context2) {
        if (context2 == null) {
            ConfigurableEditor.$$$reportNull$$$0(0);
        }
    }

    public final void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ConfigurableEditor.$$$reportNull$$$0(1);
        }
        if (event == null) {
            ConfigurableEditor.$$$reportNull$$$0(2);
        }
    }

    public final void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
        if (action2 == null) {
            ConfigurableEditor.$$$reportNull$$$0(3);
        }
        if (event == null) {
            ConfigurableEditor.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            ConfigurableEditor.$$$reportNull$$$0(5);
        }
        this.requestUpdate();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        if (this.myConfigurable == null) {
            return null;
        }
        JComponent preferred = this.myConfigurable.getPreferredFocusedComponent();
        return preferred == null ? UIUtil.getPreferredFocusedComponent((Container)this.getContent(this.myConfigurable)) : preferred;
    }

    @Override
    public final void eventDispatched(AWTEvent event) {
        switch (event.getID()) {
            case 501: 
            case 502: 
            case 506: {
                MouseEvent me = (MouseEvent)event;
                if (!SwingUtilities.isDescendingFrom(me.getComponent(), this) && !this.isPopupOverEditor(me.getComponent())) break;
                this.requestUpdate();
                break;
            }
            case 401: 
            case 402: {
                KeyEvent ke = (KeyEvent)event;
                if (!SwingUtilities.isDescendingFrom(ke.getComponent(), this)) break;
                this.requestUpdate();
            }
        }
    }

    void requestUpdate() {
        final Configurable configurable2 = this.myConfigurable;
        this.myQueue.queue(new Update(this){

            public void run() {
                ConfigurableEditor.this.updateIfCurrent(configurable2);
            }

            public boolean isExpired() {
                return ConfigurableEditor.this.myConfigurable != configurable2;
            }
        });
    }

    private boolean isPopupOverEditor(Component component2) {
        Window editor = ComponentUtil.getWindow((Component)this);
        if (editor != null) {
            Window popup2 = ComponentUtil.getWindow((Component)component2);
            if (popup2 == editor) {
                return true;
            }
            if (popup2 != null && editor == popup2.getParent()) {
                if (popup2 instanceof JDialog) {
                    JDialog dialog2 = (JDialog)popup2;
                    return Dialog.ModalityType.MODELESS == dialog2.getModalityType();
                }
                return popup2 instanceof JWindow;
            }
        }
        return false;
    }

    void updateCurrent(Configurable configurable2, boolean reset2) {
        boolean modified = configurable2 != null && configurable2.isModified();
        this.myApplyAction.setEnabled(modified);
        this.myResetAction.setEnabled(modified);
        if (!modified && reset2) {
            this.setError(null);
        }
    }

    void postUpdateCurrent(Configurable configurable2) {
    }

    final void updateIfCurrent(Configurable configurable2) {
        if (this.myConfigurable == configurable2) {
            this.updateCurrent(configurable2, false);
        }
    }

    @NotNull
    final Promise<? super Object> select(Configurable configurable2) {
        assert (!this.myDisposed) : "Already disposed";
        ActionCallback callback2 = this.myCardPanel.select(configurable2, false);
        callback2.doWhenDone(() -> {
            this.myConfigurable = configurable2;
            this.updateCurrent(configurable2, false);
            this.postUpdateCurrent(configurable2);
            if (configurable2 != null) {
                FeatureUsageUiEventsKt.getUiEventLogger().logSelectConfigurable(configurable2);
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)callback2);
        if (promise == null) {
            ConfigurableEditor.$$$reportNull$$$0(6);
        }
        return promise;
    }

    final boolean setError(ConfigurationException exception) {
        if (exception == null) {
            this.myErrorLabel.setVisible(false);
            return true;
        }
        if (this.myErrorLabel.isEnabled()) {
            this.myErrorLabel.setText(HtmlChunk.body().children(new HtmlChunk[]{HtmlChunk.text((String)exception.getTitle()).wrapWith("strong"), HtmlChunk.text((String)":"), HtmlChunk.br(), HtmlChunk.text((String)exception.getMessage())}).wrapWith("html").toString());
            this.myErrorLabel.setVisible(true);
        } else {
            Messages.showMessageDialog((Component)this, (String)exception.getMessage(), (String)exception.getTitle(), (Icon)Messages.getErrorIcon());
        }
        return false;
    }

    final JComponent getContent(Configurable configurable2) {
        return (JComponent)this.myCardPanel.getValue(configurable2, false);
    }

    final JComponent readContent(Configurable configurable2) {
        return (JComponent)this.myCardPanel.getValue(configurable2, true);
    }

    private JComponent createDefaultContent(Configurable configurable2) {
        String description2;
        JPanel content2 = new JPanel(new BorderLayout());
        content2.setBorder((Border)JBUI.Borders.empty((int)11, (int)16, (int)16, (int)16));
        SortedConfigurableGroup group2 = configurable2 instanceof SortedConfigurableGroup ? (SortedConfigurableGroup)configurable2 : null;
        String string = description2 = group2 == null ? null : group2.getDescription();
        if (description2 == null) {
            description2 = IdeBundle.message((String)"label.select.configuration.element", (Object[])new Object[0]);
            content2.add("Center", new JLabel(description2, 0));
            content2.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        } else {
            content2.add("North", new JLabel(description2));
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            content2.add("Center", panel2);
            panel2.add(Box.createVerticalStrut(10));
            for (Configurable current2 : group2.getConfigurables()) {
                ActionLink label2 = new ActionLink(current2.getDisplayName(), e -> this.openLink(current2));
                label2.setBorder((Border)JBUI.Borders.empty((int)1, (int)17, (int)3, (int)1));
                panel2.add((Component)label2);
            }
        }
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)content2, (boolean)true);
        pane2.setHorizontalScrollBarPolicy(31);
        return pane2;
    }

    static ConfigurationException apply(Configurable configurable2) {
        if (configurable2 != null) {
            try {
                configurable2.apply();
                FeatureUsageUiEventsKt.getUiEventLogger().logApplyConfigurable(configurable2);
            }
            catch (ConfigurationException exception) {
                return exception;
            }
        }
        return null;
    }

    @Nullable
    Configurable getConfigurable() {
        return this.myConfigurable;
    }

    void reload() {
        this.myCardPanel.removeAll();
        this.myConfigurable = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/ConfigurableEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/ConfigurableEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeEditorTyping";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "afterActionPerformed";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

