/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

class SimpleBanner
extends JPanel {
    private final AnimatedIcon.Default myAnimatedIcon = new AnimatedIcon.Default();
    private boolean myShowProgress;
    protected final JPanel myLeftPanel;
    protected final JLabel myProgress = new JLabel(EmptyIcon.ICON_16);
    protected Component myLeftComponent;
    protected Component myCenterComponent;

    SimpleBanner() {
        super(new BorderLayout(10, 0));
        this.myLeftPanel = new NonOpaquePanel((LayoutManager)new FlowLayout(1, 0, 0){

            @Override
            public Dimension preferredLayoutSize(Container target2) {
                return SimpleBanner.this.getPreferredLeftPanelSize(super.preferredLayoutSize(target2));
            }

            @Override
            public void layoutContainer(Container target2) {
                super.layoutContainer(target2);
                SimpleBanner.this.baselineLayout();
            }
        });
        this.myLeftPanel.add(this.myProgress);
        this.add("West", this.myLeftPanel);
    }

    Dimension getPreferredLeftPanelSize(Dimension size2) {
        return size2;
    }

    private void baselineLayout() {
        Component template = this.getBaselineTemplate();
        if (template == null) {
            return;
        }
        int baseline = template.getBaseline(template.getWidth(), template.getHeight());
        if (baseline == -1) {
            return;
        }
        int components = this.myLeftPanel.getComponentCount();
        for (int i2 = 0; i2 < components; ++i2) {
            Component component2 = this.myLeftPanel.getComponent(i2);
            if (component2 == template) continue;
            int y = component2 instanceof JLabel ? (int)(JBUIScale.scale((float)1.5f) + (float)(template.getHeight() - component2.getHeight()) / 2.0f) : baseline - component2.getBaseline(component2.getWidth(), component2.getHeight());
            component2.setLocation(component2.getX(), y);
        }
    }

    void setLeftComponent(Component component2) {
        if (this.myLeftComponent != null) {
            this.myLeftPanel.remove(this.myLeftComponent);
            this.myLeftComponent = null;
        }
        if (component2 != null) {
            this.myLeftComponent = component2;
            this.myLeftPanel.add(component2, 0);
        }
        this.updateProgressBorder();
    }

    void setCenterComponent(Component component2) {
        if (this.myCenterComponent != null) {
            this.remove(this.myCenterComponent);
        }
        this.myCenterComponent = component2;
        if (component2 != null) {
            this.add(component2);
        }
    }

    void showProgress(boolean start2) {
        this.myShowProgress = start2;
        this.myProgress.setIcon((Icon)(start2 ? this.myAnimatedIcon : EmptyIcon.ICON_16));
        this.updateProgressBorder();
    }

    void updateProgressBorder() {
        this.myProgress.setBorder((Border)(this.myShowProgress ? JBUI.Borders.emptyLeft((int)10) : null));
    }

    boolean canShow() {
        return this.myLeftComponent != null || this.myCenterComponent != null || this.myShowProgress;
    }

    Component getBaselineTemplate() {
        return this.myCenterComponent;
    }
}

