/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.CommonBundle;
import com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ProgressBarUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u001a\u0018\u0000 ?2\u00020\u0001:\u0002?@B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\r\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020'J\u0013\u0010)\u001a\u00020'2\u000b\u0010*\u001a\u00070\u0007\u00a2\u0006\u0002\b\bJ\b\u0010+\u001a\u00020'H\u0002J\b\u0010,\u001a\u00020'H\u0016J\b\u0010-\u001a\u00020'H\u0002J\u000e\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\u0005J\u001a\u00100\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u00102\u001a\u00020!H\u0003J\u0006\u00103\u001a\u00020\u0015J\b\u00104\u001a\u0004\u0018\u00010\u0017J\u0006\u00105\u001a\u00020\u001bJ\u0006\u00106\u001a\u00020'J\u0006\u00107\u001a\u00020'J\u0017\u00108\u001a\u00020'2\r\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\bH\u0002J\b\u00109\u001a\u00020\u0005H\u0002J\b\u0010:\u001a\u00020'H\u0002J\b\u0010;\u001a\u00020'H\u0002J\b\u0010<\u001a\u00020'H\u0002J\u0006\u0010=\u001a\u00020'J\u0006\u0010>\u001a\u00020'R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/openapi/progress/util/ProgressDialog;", "Lcom/intellij/openapi/Disposable;", "myProgressWindow", "Lcom/intellij/openapi/progress/util/ProgressWindow;", "myShouldShowBackground", "", "cancelText", "", "Lorg/jetbrains/annotations/Nls;", "myParentWindow", "Ljava/awt/Window;", "(Lcom/intellij/openapi/progress/util/ProgressWindow;ZLjava/lang/String;Ljava/awt/Window;)V", "myBackgroundButton", "Ljavax/swing/JButton;", "myCancelButton", "myDisableCancelAlarm", "Lcom/intellij/util/SingleAlarm;", "myEnableCancelAlarm", "myLastTimeDrawn", "", "myPanel", "Ljavax/swing/JPanel;", "myPopup", "Lcom/intellij/openapi/ui/DialogWrapper;", "myProgressBar", "Ljavax/swing/JProgressBar;", "myRepaintRunnable", "Ljava/lang/Runnable;", "myRepaintedFlag", "myStartMillis", "myText2Label", "Lcom/intellij/ui/components/JBLabel;", "myTextLabel", "Ljavax/swing/JLabel;", "myTitlePanel", "Lcom/intellij/ui/TitlePanel;", "myUpdateAlarm", "myWasShown", "background", "", "cancel", "changeCancelButtonText", "text", "createCenterPanel", "dispose", "doCancelAction", "enableCancelButtonIfNeeded", "enable", "fitTextToLabel", "fullText", "label", "getPanel", "getPopup", "getRepaintRunnable", "hide", "hideImmediately", "initDialog", "isWriteActionProgress", "setCancelButtonDisabledInEDT", "setCancelButtonEnabledInEDT", "setupUI", "show", "update", "Companion", "MyDialogWrapper", "intellij.platform.ide.impl"})
public final class ProgressDialog
implements Disposable {
    private long myLastTimeDrawn;
    private final SingleAlarm myUpdateAlarm;
    private boolean myWasShown;
    private final long myStartMillis;
    private final Runnable myRepaintRunnable;
    private final JPanel myPanel;
    private final JLabel myTextLabel;
    private final JBLabel myText2Label;
    private final JButton myCancelButton;
    private final JButton myBackgroundButton;
    private final JProgressBar myProgressBar;
    private boolean myRepaintedFlag;
    private final TitlePanel myTitlePanel;
    private DialogWrapper myPopup;
    private final SingleAlarm myDisableCancelAlarm;
    private final SingleAlarm myEnableCancelAlarm;
    private final ProgressWindow myProgressWindow;
    private final boolean myShouldShowBackground;
    private final Window myParentWindow;
    public static final int UPDATE_INTERVAL = 50;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void setupUI() {
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.emptyInsets(), -1, -1, false, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)JBUI.insets((int)6, (int)10, (int)10, (int)10), -1, -1, false, false));
        panel2.setOpaque(false);
        this.myPanel.add((Component)panel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, (Insets)JBUI.emptyInsets(), -1, -1, false, false));
        innerPanel.setPreferredSize(new Dimension(SystemInfo.isMac ? 350 : JBUIScale.scale((int)450), -1));
        panel2.add((Component)innerPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 2, null, null, null));
        innerPanel.add((Component)this.myTextLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, new Dimension(0, -1), null, null));
        this.myText2Label.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        innerPanel.add((Component)this.myText2Label, new GridConstraints(2, 0, 1, 1, 9, 1, 7, 0, new Dimension(0, -1), null, null));
        this.myProgressBar.putClientProperty("html.disable", Boolean.FALSE);
        innerPanel.add((Component)this.myProgressBar, new GridConstraints(1, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        innerPanel.add((Component)new JLabel(" "), new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        innerPanel.add((Component)new JLabel(" "), new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.emptyInsets(), -1, -1, false, false));
        panel2.add((Component)buttonPanel, new GridConstraints(0, 1, 1, 1, 0, 1, 1, 2, null, null, null));
        this.myCancelButton.setText(CommonBundle.getCancelButtonText());
        DialogUtil.registerMnemonic((AbstractButton)this.myCancelButton, (char)'&');
        buttonPanel.add((Component)this.myCancelButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundButton.setText(CommonBundle.message((String)"button.background", (Object[])new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myBackgroundButton, (char)'&');
        buttonPanel.add((Component)this.myBackgroundButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myPanel.add((Component)this.myTitlePanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    @Contract(pure=true)
    private final String fitTextToLabel(String fullText, JLabel label2) {
        block7: {
            block6: {
                if (fullText == null) break block6;
                CharSequence charSequence = fullText;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block7;
            }
            return " ";
        }
        String newFullText = ((Object)StringUtil.last((CharSequence)fullText, (int)500, (boolean)true)).toString();
        while (label2.getFontMetrics(label2.getFont()).stringWidth(newFullText) > label2.getWidth()) {
            int sep = StringsKt.indexOf$default((CharSequence)newFullText, (char)File.separatorChar, (int)4, (boolean)false, (int)4, null);
            if (sep < 0) {
                return newFullText;
            }
            StringBuilder stringBuilder = new StringBuilder().append("...");
            String string = newFullText;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(sep);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            newFullText = stringBuilder.append(string3).toString();
        }
        return newFullText;
    }

    private final void initDialog(String cancelText) {
        if (SystemInfo.isMac) {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)((Component)this.myText2Label));
        }
        this.myText2Label.setForeground(UIUtil.getContextHelpForeground());
        this.myCancelButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ProgressDialog this$0;

            public final void actionPerformed(ActionEvent it) {
                ProgressDialog.access$doCancelAction(this.this$0);
            }
            {
                this.this$0 = progressDialog;
            }
        });
        this.myCancelButton.registerKeyboardAction(new ActionListener(this){
            final /* synthetic */ ProgressDialog this$0;

            public final void actionPerformed(ActionEvent it) {
                if (ProgressDialog.access$getMyCancelButton$p(this.this$0).isEnabled()) {
                    ProgressDialog.access$doCancelAction(this.this$0);
                }
            }
            {
                this.this$0 = progressDialog;
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        if (cancelText != null) {
            this.myProgressWindow.setCancelButtonText(cancelText);
        }
        this.myProgressBar.setIndeterminate(this.myProgressWindow.isIndeterminate());
        this.myProgressBar.setMaximum(100);
        this.createCenterPanel();
        this.myTitlePanel.setActive(true);
        WindowMoveListener moveListener2 = new WindowMoveListener(this, (Component)this.myTitlePanel){
            final /* synthetic */ ProgressDialog this$0;

            @NotNull
            protected Component getView(@NotNull Component component2) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                Container container = SwingUtilities.getAncestorOfClass(DialogWrapperDialog.class, component2);
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"SwingUtilities.getAncest\u2026g::class.java, component)");
                return container;
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        this.myTitlePanel.addMouseListener((MouseListener)moveListener2);
        this.myTitlePanel.addMouseMotionListener((MouseMotionListener)moveListener2);
    }

    public void dispose() {
        UIUtil.disposeProgress((JProgressBar)this.myProgressBar);
        UIUtil.dispose((Component)((Component)this.myTitlePanel));
        UIUtil.dispose((Component)this.myBackgroundButton);
        UIUtil.dispose((Component)this.myCancelButton);
        this.myEnableCancelAlarm.cancelAllRequests();
        this.myDisableCancelAlarm.cancelAllRequests();
    }

    @NotNull
    public final JPanel getPanel() {
        return this.myPanel;
    }

    @NotNull
    public final Runnable getRepaintRunnable() {
        return this.myRepaintRunnable;
    }

    @Nullable
    public final DialogWrapper getPopup() {
        return this.myPopup;
    }

    public final void changeCancelButtonText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.myCancelButton.setText(text2);
    }

    private final void doCancelAction() {
        if (this.myProgressWindow.myShouldShowCancel) {
            this.myProgressWindow.cancel();
        }
    }

    public final void cancel() {
        this.enableCancelButtonIfNeeded(false);
    }

    private final void setCancelButtonEnabledInEDT() {
        this.myCancelButton.setEnabled(true);
    }

    private final void setCancelButtonDisabledInEDT() {
        this.myCancelButton.setEnabled(false);
    }

    public final void enableCancelButtonIfNeeded(boolean enable2) {
        if (this.myProgressWindow.myShouldShowCancel && !this.myUpdateAlarm.isDisposed()) {
            SingleAlarm.request$default(enable2 ? this.myEnableCancelAlarm : this.myDisableCancelAlarm, false, 0, 3, null);
        }
    }

    private final void createCenterPanel() {
        if (this.myProgressWindow.myCancelText != null) {
            this.myCancelButton.setText(this.myProgressWindow.myCancelText);
        }
        this.myCancelButton.setVisible(this.myProgressWindow.myShouldShowCancel);
        this.myBackgroundButton.setVisible(this.myShouldShowBackground);
        this.myBackgroundButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ProgressDialog this$0;

            public final void actionPerformed(ActionEvent it) {
                if (ProgressDialog.access$getMyShouldShowBackground$p(this.this$0)) {
                    ProgressDialog.access$getMyProgressWindow$p(this.this$0).background();
                }
            }
            {
                this.this$0 = progressDialog;
            }
        });
    }

    public final synchronized void update() {
        if (this.myRepaintedFlag) {
            if (System.currentTimeMillis() > this.myLastTimeDrawn + (long)50) {
                this.myRepaintedFlag = false;
                EdtExecutorService.getInstance().execute(this.myRepaintRunnable);
            } else if (!this.myUpdateAlarm.isDisposed() && this.myUpdateAlarm.isEmpty()) {
                EdtExecutorService.getInstance().execute(new Runnable(this){
                    final /* synthetic */ ProgressDialog this$0;

                    public final void run() {
                        if (!ProgressDialog.access$getMyUpdateAlarm$p(this.this$0).isDisposed()) {
                            SingleAlarm singleAlarm = ProgressDialog.access$getMyUpdateAlarm$p(this.this$0);
                            ModalityState modalityState = ProgressDialog.access$getMyProgressWindow$p(this.this$0).getModalityState();
                            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"myProgressWindow.modalityState");
                            singleAlarm.request(modalityState);
                        }
                    }
                    {
                        this.this$0 = progressDialog;
                    }
                });
            }
        }
    }

    public final synchronized void background() {
        if (this.myShouldShowBackground) {
            this.myBackgroundButton.setEnabled(false);
        }
        this.hide();
    }

    public final void hide() {
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((ProgressDialog)this.receiver).hideImmediately();
            }
        };
        ApplicationManager.getApplication().invokeLater(new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        }, ModalityState.any());
    }

    public final void hideImmediately() {
        if (this.myPopup != null) {
            DialogWrapper dialogWrapper2 = this.myPopup;
            Intrinsics.checkNotNull((Object)dialogWrapper2);
            dialogWrapper2.close(1);
            this.myPopup = null;
        }
    }

    public final void show() {
        if (this.myWasShown) {
            return;
        }
        this.myWasShown = true;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isHeadlessEnvironment() || this.myParentWindow == null) {
            return;
        }
        if (this.myPopup != null) {
            DialogWrapper dialogWrapper2 = this.myPopup;
            Intrinsics.checkNotNull((Object)dialogWrapper2);
            dialogWrapper2.close(1);
        }
        MyDialogWrapper popup2 = this.myParentWindow.isShowing() ? new MyDialogWrapper(this.myParentWindow, this.myProgressWindow.myShouldShowCancel) : new MyDialogWrapper(this.myProgressWindow.myProject, this.myProgressWindow.myShouldShowCancel);
        this.myPopup = popup2;
        popup2.setUndecorated(true);
        if (popup2.getPeer() instanceof DialogWrapperPeerImpl) {
            DialogWrapperPeer dialogWrapperPeer = popup2.getPeer();
            if (dialogWrapperPeer == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.ui.impl.DialogWrapperPeerImpl");
            }
            ((DialogWrapperPeerImpl)dialogWrapperPeer).setAutoRequestFocus(false);
            if (this.isWriteActionProgress()) {
                popup2.setModal(false);
            }
        }
        popup2.pack();
        Disposer.register((Disposable)popup2.getDisposable(), (Disposable)new Disposable(this){
            final /* synthetic */ ProgressDialog this$0;

            public final void dispose() {
                ProgressDialog.access$getMyProgressWindow$p(this.this$0).exitModality();
            }
            {
                this.this$0 = progressDialog;
            }
        });
        popup2.show();
        SwingUtilities.invokeLater(new Runnable(this){
            final /* synthetic */ ProgressDialog this$0;

            public final void run() {
                if (ProgressDialog.access$getMyPopup$p(this.this$0) != null) {
                    DialogWrapper dialogWrapper2 = ProgressDialog.access$getMyPopup$p(this.this$0);
                    Intrinsics.checkNotNull((Object)dialogWrapper2);
                    if (!dialogWrapper2.isDisposed()) {
                        Component originalFocusOwner;
                        Window window = SwingUtilities.getWindowAncestor(ProgressDialog.access$getMyCancelButton$p(this.this$0));
                        if (window != null && (originalFocusOwner = window.getMostRecentFocusOwner()) != null) {
                            DialogWrapper dialogWrapper3 = ProgressDialog.access$getMyPopup$p(this.this$0);
                            Intrinsics.checkNotNull((Object)dialogWrapper3);
                            Disposer.register((Disposable)dialogWrapper3.getDisposable(), (Disposable)new Disposable(originalFocusOwner){
                                final /* synthetic */ Component $originalFocusOwner;

                                public final void dispose() {
                                    this.$originalFocusOwner.requestFocusInWindow();
                                }
                                {
                                    this.$originalFocusOwner = component2;
                                }
                            });
                        }
                        ProgressDialog.access$getMyCancelButton$p(this.this$0).requestFocusInWindow();
                        ProgressDialog.access$getMyRepaintRunnable$p(this.this$0).run();
                    }
                }
            }
            {
                this.this$0 = progressDialog;
            }
        });
    }

    private final boolean isWriteActionProgress() {
        return this.myProgressWindow instanceof PotemkinProgress;
    }

    public ProgressDialog(@NotNull ProgressWindow myProgressWindow, boolean myShouldShowBackground, @Nullable String cancelText, @Nullable Window myParentWindow) {
        Intrinsics.checkNotNullParameter((Object)myProgressWindow, (String)"myProgressWindow");
        this.myProgressWindow = myProgressWindow;
        this.myShouldShowBackground = myShouldShowBackground;
        this.myParentWindow = myParentWindow;
        this.myLastTimeDrawn = -1L;
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((ProgressDialog)this.receiver).update();
            }
        };
        this.myUpdateAlarm = new SingleAlarm(new /* invalid duplicate definition of identical inner class */, 500, this, null, null, 24, null);
        this.myStartMillis = System.currentTimeMillis();
        this.myRepaintRunnable = new Runnable(this){
            final /* synthetic */ ProgressDialog this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                String text2 = ProgressDialog.access$getMyProgressWindow$p(this.this$0).getText();
                double fraction = ProgressDialog.access$getMyProgressWindow$p(this.this$0).getFraction();
                String text22 = ProgressDialog.access$getMyProgressWindow$p(this.this$0).getText2();
                if (ProgressDialog.access$getMyProgressBar$p(this.this$0).isShowing()) {
                    ProgressDialog.access$getMyProgressBar$p(this.this$0).setIndeterminate(ProgressDialog.access$getMyProgressWindow$p(this.this$0).isIndeterminate());
                    ProgressDialog.access$getMyProgressBar$p(this.this$0).setValue((int)(fraction * (double)100));
                    if (ProgressDialog.access$getMyProgressBar$p(this.this$0).isIndeterminate() && ProgressDialog.access$isWriteActionProgress(this.this$0) && ProgressDialog.access$getMyProgressBar$p(this.this$0).getUI() instanceof DarculaProgressBarUI) {
                        ProgressBarUI progressBarUI = ProgressDialog.access$getMyProgressBar$p(this.this$0).getUI();
                        if (progressBarUI == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarUI");
                        }
                        ((DarculaProgressBarUI)progressBarUI).updateIndeterminateAnimationIndex(ProgressDialog.access$getMyStartMillis$p(this.this$0));
                    }
                }
                ProgressDialog.access$getMyTextLabel$p(this.this$0).setText(ProgressDialog.access$fitTextToLabel(this.this$0, text2, ProgressDialog.access$getMyTextLabel$p(this.this$0)));
                ProgressDialog.access$getMyText2Label$p(this.this$0).setText(ProgressDialog.access$fitTextToLabel(this.this$0, text22, (JLabel)ProgressDialog.access$getMyText2Label$p(this.this$0)));
                ProgressDialog.access$getMyTitlePanel$p(this.this$0).setText(StringUtil.defaultIfEmpty((String)ProgressDialog.access$getMyProgressWindow$p(this.this$0).getTitle(), (String)" "));
                ProgressDialog.access$setMyLastTimeDrawn$p(this.this$0, System.currentTimeMillis());
                ProgressDialog progressDialog = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (progressDialog) {
                    boolean bl3 = false;
                    ProgressDialog.access$setMyRepaintedFlag$p(this.this$0, true);
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = progressDialog;
            }
        };
        this.myPanel = new JPanel();
        this.myTextLabel = new JLabel(" ");
        this.myText2Label = new JBLabel("");
        this.myCancelButton = new JButton();
        this.myBackgroundButton = new JButton();
        this.myProgressBar = new JProgressBar();
        this.myRepaintedFlag = true;
        this.myTitlePanel = new TitlePanel();
        function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ProgressDialog.access$setCancelButtonDisabledInEDT((ProgressDialog)this.receiver);
            }
        };
        this.myDisableCancelAlarm = new SingleAlarm(new /* invalid duplicate definition of identical inner class */, 500, null, Alarm.ThreadToUse.SWING_THREAD, ModalityState.any());
        function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ProgressDialog.access$setCancelButtonEnabledInEDT((ProgressDialog)this.receiver);
            }
        };
        this.myEnableCancelAlarm = new SingleAlarm(new /* invalid duplicate definition of identical inner class */, 500, null, Alarm.ThreadToUse.SWING_THREAD, ModalityState.any());
        this.setupUI();
        this.initDialog(cancelText);
    }

    public static final /* synthetic */ JButton access$getMyCancelButton$p(ProgressDialog $this) {
        return $this.myCancelButton;
    }

    public static final /* synthetic */ boolean access$getMyShouldShowBackground$p(ProgressDialog $this) {
        return $this.myShouldShowBackground;
    }

    public static final /* synthetic */ SingleAlarm access$getMyUpdateAlarm$p(ProgressDialog $this) {
        return $this.myUpdateAlarm;
    }

    public static final /* synthetic */ DialogWrapper access$getMyPopup$p(ProgressDialog $this) {
        return $this.myPopup;
    }

    public static final /* synthetic */ void access$setMyPopup$p(ProgressDialog $this, DialogWrapper dialogWrapper2) {
        $this.myPopup = dialogWrapper2;
    }

    public static final /* synthetic */ Runnable access$getMyRepaintRunnable$p(ProgressDialog $this) {
        return $this.myRepaintRunnable;
    }

    public static final /* synthetic */ JProgressBar access$getMyProgressBar$p(ProgressDialog $this) {
        return $this.myProgressBar;
    }

    public static final /* synthetic */ boolean access$isWriteActionProgress(ProgressDialog $this) {
        return $this.isWriteActionProgress();
    }

    public static final /* synthetic */ long access$getMyStartMillis$p(ProgressDialog $this) {
        return $this.myStartMillis;
    }

    public static final /* synthetic */ JLabel access$getMyTextLabel$p(ProgressDialog $this) {
        return $this.myTextLabel;
    }

    public static final /* synthetic */ String access$fitTextToLabel(ProgressDialog $this, String fullText, JLabel label2) {
        return $this.fitTextToLabel(fullText, label2);
    }

    public static final /* synthetic */ JBLabel access$getMyText2Label$p(ProgressDialog $this) {
        return $this.myText2Label;
    }

    public static final /* synthetic */ TitlePanel access$getMyTitlePanel$p(ProgressDialog $this) {
        return $this.myTitlePanel;
    }

    public static final /* synthetic */ long access$getMyLastTimeDrawn$p(ProgressDialog $this) {
        return $this.myLastTimeDrawn;
    }

    public static final /* synthetic */ void access$setMyLastTimeDrawn$p(ProgressDialog $this, long l) {
        $this.myLastTimeDrawn = l;
    }

    public static final /* synthetic */ boolean access$getMyRepaintedFlag$p(ProgressDialog $this) {
        return $this.myRepaintedFlag;
    }

    public static final /* synthetic */ void access$setMyRepaintedFlag$p(ProgressDialog $this, boolean bl) {
        $this.myRepaintedFlag = bl;
    }

    public static final /* synthetic */ void access$setCancelButtonDisabledInEDT(ProgressDialog $this) {
        $this.setCancelButtonDisabledInEDT();
    }

    public static final /* synthetic */ void access$setCancelButtonEnabledInEDT(ProgressDialog $this) {
        $this.setCancelButtonEnabledInEDT();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000b\u001a\u00020\fH\u0014J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0014J\b\u0010\u0019\u001a\u00020\u0005H\u0014J\b\u0010\u001a\u001a\u00020\u0005H\u0002R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "cancellable", "", "(Lcom/intellij/openapi/progress/util/ProgressDialog;Lcom/intellij/openapi/project/Project;Z)V", "parent", "Ljava/awt/Component;", "(Lcom/intellij/openapi/progress/util/ProgressDialog;Ljava/awt/Component;Z)V", "myIsCancellable", "createCenterPanel", "Ljavax/swing/JComponent;", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createPeer", "Lcom/intellij/openapi/ui/DialogWrapperPeer;", "canBeParent", "owner", "Ljava/awt/Window;", "applicationModalIfPossible", "createSouthPanel", "doCancelAction", "", "init", "isProgressDialog", "useLightPopup", "intellij.platform.ide.impl"})
    private final class MyDialogWrapper
    extends DialogWrapper {
        private final boolean myIsCancellable;

        public void doCancelAction() {
            if (this.myIsCancellable) {
                ProgressDialog.this.doCancelAction();
            }
        }

        @NotNull
        protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
            DialogWrapperPeer dialogWrapperPeer;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (this.useLightPopup()) {
                DialogWrapperPeer dialogWrapperPeer2;
                try {
                    dialogWrapperPeer2 = new GlassPaneDialogWrapperPeer(this, parent);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    dialogWrapperPeer2 = super.createPeer(parent, canBeParent);
                }
                DialogWrapperPeer dialogWrapperPeer3 = dialogWrapperPeer2;
                dialogWrapperPeer = dialogWrapperPeer3;
                Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer3, (String)"try {\n          GlassPan\u2026t, canBeParent)\n        }");
            } else {
                DialogWrapperPeer dialogWrapperPeer4 = super.createPeer(parent, canBeParent);
                dialogWrapperPeer = dialogWrapperPeer4;
                Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer4, (String)"super.createPeer(parent, canBeParent)");
            }
            return dialogWrapperPeer;
        }

        @NotNull
        protected DialogWrapperPeer createPeer(@NotNull Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
            DialogWrapperPeer dialogWrapperPeer;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            if (this.useLightPopup()) {
                DialogWrapperPeer dialogWrapperPeer2;
                try {
                    dialogWrapperPeer2 = new GlassPaneDialogWrapperPeer(this);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    dialogWrapperPeer2 = super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).myProgressWindow.myProject), canBeParent, applicationModalIfPossible);
                }
                DialogWrapperPeer dialogWrapperPeer3 = dialogWrapperPeer2;
                dialogWrapperPeer = dialogWrapperPeer3;
                Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer3, (String)"try {\n          GlassPan\u2026odalIfPossible)\n        }");
            } else {
                DialogWrapperPeer dialogWrapperPeer4 = super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).myProgressWindow.myProject), canBeParent, applicationModalIfPossible);
                dialogWrapperPeer = dialogWrapperPeer4;
                Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer4, (String)"super.createPeer(WindowM\u2026plicationModalIfPossible)");
            }
            return dialogWrapperPeer;
        }

        private final boolean useLightPopup() {
            return System.getProperty("vintage.progress") == null;
        }

        @NotNull
        protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent) {
            DialogWrapperPeer dialogWrapperPeer;
            if (System.getProperty("vintage.progress") == null) {
                DialogWrapperPeer dialogWrapperPeer2;
                try {
                    dialogWrapperPeer2 = new GlassPaneDialogWrapperPeer(project, this);
                }
                catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                    dialogWrapperPeer2 = super.createPeer(project, canBeParent);
                }
                DialogWrapperPeer dialogWrapperPeer3 = dialogWrapperPeer2;
                dialogWrapperPeer = dialogWrapperPeer3;
                Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer3, (String)"try {\n          GlassPan\u2026t, canBeParent)\n        }");
            } else {
                DialogWrapperPeer dialogWrapperPeer4 = super.createPeer(project, canBeParent);
                dialogWrapperPeer = dialogWrapperPeer4;
                Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer4, (String)"super.createPeer(project, canBeParent)");
            }
            return dialogWrapperPeer;
        }

        protected void init() {
            super.init();
            this.setUndecorated(true);
            JRootPane jRootPane = this.getRootPane();
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"rootPane");
            jRootPane.setWindowDecorationStyle(0);
            ProgressDialog.this.myPanel.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
        }

        protected boolean isProgressDialog() {
            return true;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return ProgressDialog.this.myPanel;
        }

        @Nullable
        protected JComponent createSouthPanel() {
            return null;
        }

        @Nullable
        protected Border createContentPaneBorder() {
            return null;
        }

        public MyDialogWrapper(Project project, boolean cancellable) {
            super(project, false);
            this.init();
            this.myIsCancellable = cancellable;
        }

        public MyDialogWrapper(Component parent, boolean cancellable) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(parent, false);
            this.init();
            this.myIsCancellable = cancellable;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/progress/util/ProgressDialog$Companion;", "", "()V", "UPDATE_INTERVAL", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

