/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class TooManyUsagesStatus {
    private static final Key<TooManyUsagesStatus> KEY = Key.create((String)"TooManyUsagesStatus");
    private static final NullStatus NULL_STATUS = new NullStatus();
    private final ProgressIndicator myIndicator;
    private final AtomicReference<Status> tooManyUsagesStatus;
    private final CountDownLatch waitWhileUserClick;

    private TooManyUsagesStatus(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            TooManyUsagesStatus.$$$reportNull$$$0(0);
        }
        this.tooManyUsagesStatus = new AtomicReference<Status>(Status.FEW_USAGES);
        this.waitWhileUserClick = new CountDownLatch(1);
        this.myIndicator = indicator2;
    }

    @NotNull
    public static TooManyUsagesStatus getFrom(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            TooManyUsagesStatus.$$$reportNull$$$0(1);
        }
        TooManyUsagesStatus data2 = indicator2 instanceof UserDataHolder ? (TooManyUsagesStatus)((UserDataHolder)indicator2).getUserData(KEY) : null;
        TooManyUsagesStatus tooManyUsagesStatus = data2 == null ? NULL_STATUS : data2;
        if (tooManyUsagesStatus == null) {
            TooManyUsagesStatus.$$$reportNull$$$0(2);
        }
        return tooManyUsagesStatus;
    }

    public static TooManyUsagesStatus createFor(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            TooManyUsagesStatus.$$$reportNull$$$0(3);
        }
        TooManyUsagesStatus data2 = null;
        if (indicator2 instanceof UserDataHolder) {
            data2 = new TooManyUsagesStatus(indicator2);
            ((UserDataHolder)indicator2).putUserData(KEY, (Object)data2);
        }
        return data2;
    }

    public boolean switchTooManyUsagesStatus() {
        return this.tooManyUsagesStatus.get() == Status.FEW_USAGES && this.tooManyUsagesStatus.compareAndSet(Status.FEW_USAGES, Status.WARNING_DIALOG_SHOWN);
    }

    public void userResponded() {
        this.waitWhileUserClick.countDown();
        this.tooManyUsagesStatus.set(Status.USER_RESPONDED);
    }

    public void pauseProcessingIfTooManyUsages() {
        if (this.tooManyUsagesStatus.get() == Status.WARNING_DIALOG_SHOWN) {
            long start2 = System.currentTimeMillis();
            try {
                while (System.currentTimeMillis() < start2 + 2000L && !this.waitWhileUserClick.await(10L, TimeUnit.MILLISECONDS) && !this.myIndicator.isCanceled()) {
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/TooManyUsagesStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/TooManyUsagesStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFrom";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NullStatus
    extends TooManyUsagesStatus {
        private NullStatus() {
            super((ProgressIndicator)new EmptyProgressIndicator());
        }

        @Override
        public boolean switchTooManyUsagesStatus() {
            return false;
        }

        @Override
        public void userResponded() {
        }

        @Override
        public void pauseProcessingIfTooManyUsages() {
        }
    }

    public static enum Status {
        FEW_USAGES,
        WARNING_DIALOG_SHOWN,
        USER_RESPONDED;

    }
}

