/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.indexing.ID;
import com.intellij.util.messages.MessageBus;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class NoAccessDuringPsiEvents {
    private static final Logger LOG = Logger.getInstance(NoAccessDuringPsiEvents.class);
    private static final Set<String> ourReportedTraces = new HashSet<String>();

    public static void checkCallContext(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            NoAccessDuringPsiEvents.$$$reportNull$$$0(0);
        }
        NoAccessDuringPsiEvents.checkCallContext("access index #" + indexId.getName());
    }

    public static void checkCallContext(@NotNull String contextDescription) {
        if (contextDescription == null) {
            NoAccessDuringPsiEvents.$$$reportNull$$$0(1);
        }
        if (NoAccessDuringPsiEvents.isInsideEventProcessing() && ourReportedTraces.add(DebugUtil.currentStackTrace())) {
            LOG.error("It's prohibited to " + contextDescription + " during event dispatching");
        }
    }

    public static boolean isInsideEventProcessing() {
        Application application = ApplicationManager.getApplication();
        if (!application.isWriteAccessAllowed()) {
            return false;
        }
        MessageBus bus = application.getMessageBus();
        return bus.hasUndeliveredEvents(VirtualFileManager.VFS_CHANGES) || bus.hasUndeliveredEvents(PsiModificationTracker.TOPIC) || bus.hasUndeliveredEvents(ProjectTopics.PROJECT_ROOTS) || bus.hasUndeliveredEvents(AdditionalLibraryRootsListener.TOPIC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indexId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "contextDescription";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/project/NoAccessDuringPsiEvents";
        objectArray[2] = "checkCallContext";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

