/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.startup.StartupActivity;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkStartupChecker;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "checkUnknownSdks", "", "project", "Lcom/intellij/openapi/project/Project;", "runActivity", "intellij.platform.lang.impl"})
public final class UnknownSdkStartupChecker
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.checkUnknownSdks(project);
        UnknownSdkResolver.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<UnknownSdkResolver>(this, project){
            final /* synthetic */ UnknownSdkStartupChecker this$0;
            final /* synthetic */ Project $project;

            public void extensionAdded(@NotNull UnknownSdkResolver extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }

            public void extensionRemoved(@NotNull UnknownSdkResolver extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }
        }, (Disposable)project);
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(this){
            final /* synthetic */ UnknownSdkStartupChecker this$0;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Project project = event.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"event.project");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, project);
            }
            {
                this.this$0 = this$0;
            }
        });
        ProjectRootManagerEx.getInstanceEx((Project)project).addProjectJdkListener(new ProjectRootManagerEx.ProjectJdkListener(this, project){
            final /* synthetic */ UnknownSdkStartupChecker this$0;
            final /* synthetic */ Project $project;

            public final void projectJdkChanged() {
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }
            {
                this.this$0 = unknownSdkStartupChecker;
                this.$project = project;
            }
        });
        project.getMessageBus().connect().subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(this, project){
            final /* synthetic */ UnknownSdkStartupChecker this$0;
            final /* synthetic */ Project $project;

            public void jdkAdded(@NotNull Sdk jdk) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }

            public void jdkRemoved(@NotNull Sdk jdk) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }

            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
                Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
                UnknownSdkStartupChecker.access$checkUnknownSdks(this.this$0, this.$project);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }
        });
    }

    private final void checkUnknownSdks(Project project) {
        if (project.isDisposed() || project.isDefault()) {
            return;
        }
        if (project instanceof ProjectEx) {
            Object object;
            boolean bl = false;
            try {
                object = Result.Companion;
                boolean bl2 = false;
                Disposable disposable2 = ((ProjectEx)project).getEarlyDisposable();
                boolean bl3 = false;
                object = Result.constructor-impl((Object)disposable2);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)object)) {
                return;
            }
        }
        UnknownSdkTracker.getInstance(project).updateUnknownSdks();
    }

    public static final /* synthetic */ void access$checkUnknownSdks(UnknownSdkStartupChecker $this, Project project) {
        $this.checkUnknownSdks(project);
    }
}

