/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShelvedChangeList
implements JDOMExternalizable,
ExternalizableScheme {
    private static final Logger LOG = Logger.getInstance(ShelvedChangeList.class);
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String ATTRIBUTE_DATE = "date";
    @NonNls
    private static final String ATTRIBUTE_RECYCLED_CHANGELIST = "recycled";
    @NonNls
    private static final String ATTRIBUTE_TOBE_DELETED_CHANGELIST = "toDelete";
    @NonNls
    private static final String ATTRIBUTE_DELETED_CHANGELIST = "deleted";
    @NonNls
    private static final String ELEMENT_BINARY = "binary";
    public Path path;
    @NlsSafe
    public String DESCRIPTION;
    public Date DATE;
    private volatile List<ShelvedChange> myChanges;
    private List<ShelvedBinaryFile> myBinaryFiles;
    private boolean myRecycled;
    private boolean myToDelete;
    private boolean myIsDeleted;
    private String mySchemeName;

    ShelvedChangeList() {
    }

    public ShelvedChangeList(@NotNull Path path2, @NlsSafe String description2, List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> shelvedChanges) {
        if (path2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(0);
        }
        if (shelvedChanges == null) {
            ShelvedChangeList.$$$reportNull$$$0(1);
        }
        this(path2, description2, binaryFiles, shelvedChanges, System.currentTimeMillis());
    }

    ShelvedChangeList(@NotNull Path path2, @NlsSafe String description2, List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> shelvedChanges, long time) {
        if (path2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(2);
        }
        if (shelvedChanges == null) {
            ShelvedChangeList.$$$reportNull$$$0(3);
        }
        this.path = path2;
        this.DESCRIPTION = description2;
        this.DATE = new Date(time);
        this.myBinaryFiles = binaryFiles;
        this.mySchemeName = this.DESCRIPTION;
        this.myChanges = shelvedChanges;
    }

    public boolean isRecycled() {
        return this.myRecycled;
    }

    public void setRecycled(boolean recycled) {
        this.myRecycled = recycled;
    }

    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        if (element2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(4);
        }
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element2);
        this.path = null;
        for (Element child2 : element2.getChildren()) {
            String value2;
            if (!child2.getName().equals("option") || !"PATH".equals(child2.getAttributeValue(NAME_ATTRIBUTE)) || (value2 = child2.getAttributeValue("value", "")).isEmpty()) continue;
            this.path = Paths.get(value2, new String[0]);
        }
        this.mySchemeName = element2.getAttributeValue(NAME_ATTRIBUTE);
        this.DATE = new Date(Long.parseLong(element2.getAttributeValue(ATTRIBUTE_DATE)));
        this.myRecycled = Boolean.parseBoolean(element2.getAttributeValue(ATTRIBUTE_RECYCLED_CHANGELIST));
        this.myToDelete = Boolean.parseBoolean(element2.getAttributeValue(ATTRIBUTE_TOBE_DELETED_CHANGELIST));
        this.myIsDeleted = Boolean.parseBoolean(element2.getAttributeValue(ATTRIBUTE_DELETED_CHANGELIST));
        List children2 = element2.getChildren(ELEMENT_BINARY);
        this.myBinaryFiles = new ArrayList<ShelvedBinaryFile>(children2.size());
        for (Element child3 : children2) {
            ShelvedBinaryFile binaryFile = new ShelvedBinaryFile();
            binaryFile.readExternal(child3);
            this.myBinaryFiles.add(binaryFile);
        }
    }

    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(5);
        }
        ShelvedChangeList.writeExternal(element2, this);
    }

    private static void writeExternal(@NotNull Element element2, @NotNull ShelvedChangeList shelvedChangeList) {
        if (element2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(6);
        }
        if (shelvedChangeList == null) {
            ShelvedChangeList.$$$reportNull$$$0(7);
        }
        if (shelvedChangeList.path != null) {
            element2.addContent(new Element("option").setAttribute(NAME_ATTRIBUTE, "PATH").setAttribute("value", shelvedChangeList.path.toString().replace(File.separatorChar, '/')));
        }
        DefaultJDOMExternalizer.writeExternal((Object)shelvedChangeList, (Element)element2);
        element2.setAttribute(NAME_ATTRIBUTE, shelvedChangeList.getName());
        element2.setAttribute(ATTRIBUTE_DATE, Long.toString(shelvedChangeList.DATE.getTime()));
        element2.setAttribute(ATTRIBUTE_RECYCLED_CHANGELIST, Boolean.toString(shelvedChangeList.isRecycled()));
        if (shelvedChangeList.isMarkedToDelete()) {
            element2.setAttribute(ATTRIBUTE_TOBE_DELETED_CHANGELIST, Boolean.toString(shelvedChangeList.isMarkedToDelete()));
        }
        if (shelvedChangeList.isDeleted()) {
            element2.setAttribute(ATTRIBUTE_DELETED_CHANGELIST, Boolean.toString(shelvedChangeList.isDeleted()));
        }
        for (ShelvedBinaryFile file2 : shelvedChangeList.getBinaryFiles()) {
            Element child2 = new Element(ELEMENT_BINARY);
            file2.writeExternal(child2);
            element2.addContent(child2);
        }
    }

    @Nls
    public String toString() {
        return this.DESCRIPTION;
    }

    public void loadChangesIfNeeded(@NotNull Project project) {
        if (project == null) {
            ShelvedChangeList.$$$reportNull$$$0(8);
        }
        if (this.myChanges == null) {
            try {
                List<? extends FilePatch> list2 = ShelveChangesManager.loadPatchesWithoutContent(project, this.path, null);
                this.myChanges = ShelvedChangeList.createShelvedChangesFromFilePatches(project, this.path, list2);
            }
            catch (Exception e) {
                LOG.error("Failed to parse the file patch: [" + this.path + "]", (Throwable)e);
            }
        }
    }

    @Nullable
    public List<ShelvedChange> getChanges() {
        return this.myChanges;
    }

    @Deprecated
    public List<ShelvedChange> getChanges(Project project) {
        this.loadChangesIfNeeded(project);
        return this.getChanges();
    }

    void setChanges(List<ShelvedChange> shelvedChanges) {
        this.myChanges = shelvedChanges;
    }

    @NotNull
    static List<ShelvedChange> createShelvedChangesFromFilePatches(@NotNull Project project, @NotNull Path patchPath, @NotNull Collection<? extends FilePatch> filePatches) {
        if (project == null) {
            ShelvedChangeList.$$$reportNull$$$0(9);
        }
        if (patchPath == null) {
            ShelvedChangeList.$$$reportNull$$$0(10);
        }
        if (filePatches == null) {
            ShelvedChangeList.$$$reportNull$$$0(11);
        }
        ArrayList<ShelvedChange> changes = new ArrayList<ShelvedChange>();
        for (FilePatch filePatch : filePatches) {
            FileStatus status = filePatch.isNewFile() ? FileStatus.ADDED : (filePatch.isDeletedFile() ? FileStatus.DELETED : FileStatus.MODIFIED);
            changes.add(new ShelvedChange(project, patchPath, filePatch.getBeforeName(), filePatch.getAfterName(), status));
        }
        ArrayList<ShelvedChange> arrayList = changes;
        if (arrayList == null) {
            ShelvedChangeList.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public List<ShelvedBinaryFile> getBinaryFiles() {
        return this.myBinaryFiles;
    }

    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            ShelvedChangeList.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public void setName(@NotNull String newName2) {
        if (newName2 == null) {
            ShelvedChangeList.$$$reportNull$$$0(14);
        }
        this.mySchemeName = newName2;
    }

    public boolean isValid() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public void markToDelete(boolean toDeleted) {
        this.myToDelete = toDeleted;
    }

    public boolean isMarkedToDelete() {
        return this.myToDelete;
    }

    public void setDeleted(boolean isDeleted) {
        this.myIsDeleted = isDeleted;
    }

    public boolean isDeleted() {
        return this.myIsDeleted;
    }

    public void updateDate() {
        this.DATE = new Date(System.currentTimeMillis());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePatches";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createShelvedChangesFromFilePatches";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadChangesIfNeeded";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createShelvedChangesFromFilePatches";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

