/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilePathsNode;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0017J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserUnversionedFilesNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserSpecificFilePathsNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$Tag;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getSortWeight", "", "getTextPresentation", "", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "intellij.platform.vcs.impl"})
public final class ChangesBrowserUnversionedFilesNode
extends ChangesBrowserSpecificFilePathsNode<ChangesBrowserNode.Tag> {
    private final Project project;

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer2), (String)"renderer");
        super.render(renderer2, selected2, expanded, hasFocus);
        if (!this.project.isDisposed()) {
            ChangeListManagerImpl changeListManagerImpl = ChangeListManagerImpl.getInstanceImpl(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)changeListManagerImpl), (String)"ChangeListManagerImpl.getInstanceImpl(project)");
            if (changeListManagerImpl.isUnversionedInUpdateMode()) {
                this.appendUpdatingState(renderer2);
            }
        }
    }

    @Override
    @Nls
    @NotNull
    public String getTextPresentation() {
        return this.getUserObject().toString();
    }

    @Override
    public int getSortWeight() {
        return 9;
    }

    public ChangesBrowserUnversionedFilesNode(final @NotNull Project project, @NotNull List<? extends FilePath> files2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        super(ChangesBrowserSpecificFilePathsNode.UNVERSIONED_FILES_TAG, (Collection<FilePath>)files2, new Runnable(){

            @Override
            public final void run() {
                if (!project.isDisposed()) {
                    new UnversionedViewDialog(project).show();
                }
            }
        });
        this.project = project;
    }
}

