/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.ThreeStateCheckboxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vcs.changes.actions.RollbackDialogAction;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.commit.PartialCommitChangeNodeDecorator;
import com.intellij.vcs.commit.PartialCommitInclusionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleLocalChangeListsBrowser
extends CommitDialogChangesBrowser
implements Disposable {
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private final boolean myEnableUnversioned;
    private final boolean myEnablePartialCommit;
    @Nullable
    private Supplier<? extends JComponent> myBottomDiffComponent;
    @NotNull
    private final ChangeListChooser myChangeListChooser;
    @NotNull
    private final DeleteProvider myDeleteProvider;
    @NotNull
    private final PartialCommitInclusionModel myInclusionModel;
    @NotNull
    private LocalChangeList myChangeList;
    private final List<Change> myChanges;
    private final List<FilePath> myUnversioned;
    private boolean myHasHiddenUnversioned;
    @Nullable
    private Runnable mySelectedListChangeListener;
    private final RollbackDialogAction myRollbackDialogAction;

    MultipleLocalChangeListsBrowser(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, boolean enableUnversioned, boolean enablePartialCommit) {
        List allChangeLists;
        if (project == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(0);
        }
        super(project, showCheckboxes, highlightProblems);
        this.myUpdateQueue = new MergingUpdateQueue("MultipleLocalChangeListsBrowser", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this);
        this.myDeleteProvider = new VirtualFileDeleteProvider();
        this.myChanges = new ArrayList<Change>();
        this.myUnversioned = new ArrayList<FilePath>();
        this.myEnableUnversioned = enableUnversioned;
        this.myEnablePartialCommit = enablePartialCommit;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        this.myChangeList = changeListManager.getDefaultChangeList();
        this.myChangeListChooser = new ChangeListChooser();
        this.myRollbackDialogAction = new RollbackDialogAction();
        this.myRollbackDialogAction.registerCustomShortcutSet(this, null);
        if (!changeListManager.areChangeListsEnabled()) {
            this.myChangeListChooser.setVisible(false);
        } else if (Registry.is((String)"vcs.skip.single.default.changelist") && (allChangeLists = changeListManager.getChangeLists()).size() == 1 && ((LocalChangeList)allChangeLists.get(0)).isBlank()) {
            this.myChangeListChooser.setVisible(false);
        }
        this.myInclusionModel = new PartialCommitInclusionModel(this.myProject);
        Disposer.register((Disposable)this, (Disposable)this.myInclusionModel);
        this.getViewer().setInclusionModel(this.myInclusionModel);
        changeListManager.addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this);
        this.init();
        this.updateDisplayedChangeLists();
        this.updateSelectedChangeList(this.myChangeList);
        project.getMessageBus().connect((Disposable)this).subscribe(VcsManagedFilesHolder.TOPIC, () -> ApplicationManager.getApplication().invokeLater(() -> this.myViewer.repaint()));
    }

    @Override
    @Nullable
    protected JComponent createHeaderPanel() {
        return JBUI.Panels.simplePanel((Component)this.myChangeListChooser).withBorder((Border)JBUI.Borders.emptyLeft((int)6));
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        AnAction rollbackGroup = this.createRollbackGroup(true);
        List list2 = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{rollbackGroup, ActionManager.getInstance().getAction("ChangesView.Refresh"), ActionManager.getInstance().getAction("Vcs.CheckinProjectToolbar")});
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private AnAction createRollbackGroup(boolean popup2) {
        List<? extends AnAction> rollbackActions = this.createAdditionalRollbackActions();
        if (rollbackActions.isEmpty()) {
            return this.myRollbackDialogAction;
        }
        DefaultActionGroup group2 = new DefaultActionGroup(new AnAction[]{this.myRollbackDialogAction});
        group2.addAll(rollbackActions);
        ActionUtil.copyFrom((AnAction)group2, (String)"ChangesView.Revert");
        group2.setPopup(popup2);
        return group2;
    }

    protected List<? extends AnAction> createAdditionalRollbackActions() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>(super.createPopupMenuActions());
        result2.add(ActionManager.getInstance().getAction("ChangesView.Refresh"));
        if (this.myEnableUnversioned) {
            result2.add((AnAction)new ShowHideUnversionedFilesAction());
            result2.add((AnAction)UnversionedViewDialog.registerUnversionedPopupGroup((JComponent)((Object)this.myViewer)));
        } else {
            result2.add(ActionManager.getInstance().getAction("ChangesView.Move"));
        }
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)((Object)this.myViewer));
        result2.add(this.createRollbackGroup(false));
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        result2.add((AnAction)editSourceAction);
        result2.add(ActionManager.getInstance().getAction("Vcs.CheckinProjectMenu"));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createDiffActions() {
        List list2 = ContainerUtil.append(super.createDiffActions(), (Object[])new AnAction[]{new ToggleChangeDiffAction()});
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    protected void updateDiffContext(@NotNull DiffRequestChain chain) {
        if (chain == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(4);
        }
        super.updateDiffContext(chain);
        if (this.myBottomDiffComponent != null) {
            chain.putUserData(DiffUserDataKeysEx.BOTTOM_PANEL, (Object)this.myBottomDiffComponent.get());
        }
        chain.putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)this.myEnablePartialCommit);
        chain.putUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, (Object)true);
    }

    public void setBottomDiffComponent(@Nullable Supplier<? extends JComponent> value2) {
        this.myBottomDiffComponent = value2;
    }

    public void setSelectedListChangeListener(@Nullable Runnable runnable2) {
        this.mySelectedListChangeListener = runnable2;
    }

    private boolean isShowUnversioned() {
        return this.myEnableUnversioned && VcsConfiguration.getInstance((Project)this.myProject).SHOW_UNVERSIONED_FILES_WHILE_COMMIT;
    }

    private void setShowUnversioned(boolean value2) {
        VcsConfiguration.getInstance((Project)this.myProject).SHOW_UNVERSIONED_FILES_WHILE_COMMIT = value2;
        this.updateDisplayedChanges();
    }

    @Override
    @NotNull
    public LocalChangeList getSelectedChangeList() {
        LocalChangeList localChangeList = this.myChangeList;
        if (localChangeList == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(5);
        }
        return localChangeList;
    }

    public void setSelectedChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(6);
        }
        this.myChangeListChooser.setSelectedChangeList(list2);
    }

    private void updateSelectedChangeList(@NotNull LocalChangeList list2) {
        boolean isListChanged;
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(7);
        }
        boolean bl = isListChanged = !this.myChangeList.getId().equals(list2.getId());
        if (isListChanged) {
            LineStatusTrackerManager.getInstanceImpl(this.myProject).resetExcludedFromCommitMarkers();
        }
        this.myChangeList = list2;
        this.myChangeListChooser.setToolTipText(list2.getName());
        this.updateDisplayedChanges();
        if (isListChanged && this.mySelectedListChangeListener != null) {
            this.mySelectedListChangeListener.run();
        }
        this.myInclusionModel.setChangeLists((Collection<? extends LocalChangeList>)ContainerUtil.immutableSingletonList((Object)this.myChangeList));
    }

    @Override
    public void updateDisplayedChangeLists() {
        List changeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
        this.myChangeListChooser.setAvailableLists(changeLists);
    }

    public void updateDisplayedChanges() {
        this.myChanges.clear();
        this.myUnversioned.clear();
        this.myHasHiddenUnversioned = false;
        this.myChanges.addAll(this.myChangeList.getChanges());
        if (this.myEnableUnversioned) {
            List unversioned = ChangeListManager.getInstance((Project)this.myProject).getUnversionedFilesPaths();
            if (this.isShowUnversioned()) {
                this.myUnversioned.addAll(unversioned);
            }
            if (!this.isShowUnversioned() && !unversioned.isEmpty()) {
                this.myHasHiddenUnversioned = true;
            }
        }
        this.myViewer.rebuildTree();
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        PartialCommitChangeNodeDecorator decorator = new PartialCommitChangeNodeDecorator(this.myProject, RemoteRevisionsCache.getInstance(this.myProject).getChangesNodeDecorator());
        TreeModelBuilder builder2 = new TreeModelBuilder(this.myProject, this.getGrouping());
        builder2.setChanges(this.myChanges, decorator);
        builder2.setUnversioned(this.myUnversioned);
        if (this.myHasHiddenUnversioned) {
            this.myViewer.getEmptyText().setText(VcsBundle.message((String)"status.text.unversioned.files.available", (Object[])new Object[0])).appendText(VcsBundle.message((String)"plugins.configurable.show", (Object[])new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.setShowUnversioned(true));
        } else {
            this.myViewer.getEmptyText().setText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        }
        DefaultTreeModel defaultTreeModel = builder2.build();
        if (defaultTreeModel == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(8);
        }
        return defaultTreeModel;
    }

    @Override
    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object entry2) {
        if (entry2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(9);
        }
        if (entry2 instanceof FilePath) {
            return UnversionedDiffRequestProducer.create(this.myProject, (FilePath)entry2);
        }
        return super.getDiffRequestProducer(entry2);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(10);
        }
        if (ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return ChangesListView.getSelectedUnversionedFiles((JTree)((Object)this.myViewer));
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteProvider;
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return new ChangeList[]{this.myChangeList};
        }
        if (ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY.is(dataId)) {
            return ChangesListView.getExactlySelectedVirtualFiles((JTree)((Object)this.myViewer));
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public List<Change> getDisplayedChanges() {
        List<Change> list2 = VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Change> getSelectedChanges() {
        List<Change> list2 = VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Change> getIncludedChanges() {
        List<Change> list2 = VcsTreeModelData.included(this.myViewer).userObjects(Change.class);
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FilePath> getDisplayedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            List<FilePath> list2 = Collections.emptyList();
            if (list2 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(14);
            }
            return list2;
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.allUnderTag((JTree)((Object)this.myViewer), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            List list3 = ContainerUtil.newUnmodifiableList(this.myUnversioned);
            if (list3 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(15);
            }
            return list3;
        }
        List<FilePath> list4 = treeModelData.userObjects(FilePath.class);
        if (list4 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(16);
        }
        return list4;
    }

    @Override
    @NotNull
    public List<FilePath> getSelectedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            List<FilePath> list2 = Collections.emptyList();
            if (list2 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(17);
            }
            return list2;
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.selectedUnderTag((JTree)((Object)this.myViewer), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            List list3 = ContainerUtil.newUnmodifiableList(this.myUnversioned);
            if (list3 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(18);
            }
            return list3;
        }
        List<FilePath> list4 = treeModelData.userObjects(FilePath.class);
        if (list4 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(19);
        }
        return list4;
    }

    @Override
    @NotNull
    public List<FilePath> getIncludedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            List<FilePath> list2 = Collections.emptyList();
            if (list2 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(20);
            }
            return list2;
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.includedUnderTag(this.myViewer, ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            List list3 = ContainerUtil.newUnmodifiableList(this.myUnversioned);
            if (list3 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(21);
            }
            return list3;
        }
        List<FilePath> list4 = treeModelData.userObjects(FilePath.class);
        if (list4 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(22);
        }
        return list4;
    }

    private static boolean containsCollapsedUnversionedNode(@NotNull VcsTreeModelData treeModelData) {
        Optional<ChangesBrowserNode> node2;
        if (treeModelData == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(23);
        }
        if ((node2 = treeModelData.nodesStream().filter(it -> it instanceof ChangesBrowserUnversionedFilesNode).findAny()).isEmpty()) {
            return false;
        }
        ChangesBrowserUnversionedFilesNode unversionedFilesNode = (ChangesBrowserUnversionedFilesNode)node2.get();
        return unversionedFilesNode.isManyFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModelData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenuActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangeList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedChanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedChanges";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedUnversionedFiles";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnversionedFiles";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedUnversionedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateDiffContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedChangeList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedChangeList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestProducer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "containsCollapsedUnversionedNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListsChanged() {
            MultipleLocalChangeListsBrowser.this.myUpdateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)MultipleLocalChangeListsBrowser.this.myUpdateQueue, "updateChangeLists", () -> MultipleLocalChangeListsBrowser.this.updateDisplayedChangeLists()));
        }
    }

    private class ToggleChangeDiffAction
    extends ThreeStateCheckboxAction
    implements CustomComponentAction,
    DumbAware {
        ToggleChangeDiffAction() {
            super(VcsBundle.messagePointer((String)"commit.dialog.include.action.name", (Object[])new Object[0]));
        }

        @NotNull
        public ThreeStateCheckBox.State isSelected(AnActionEvent e) {
            Object object = this.getUserObject(e);
            if (object == null) {
                ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
                if (state == null) {
                    ToggleChangeDiffAction.$$$reportNull$$$0(0);
                }
                return state;
            }
            ThreeStateCheckBox.State state = MultipleLocalChangeListsBrowser.this.myInclusionModel.getInclusionState(object);
            if (state == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(1);
            }
            return state;
        }

        public void setSelected(AnActionEvent e, @NotNull ThreeStateCheckBox.State state) {
            Object object;
            if (state == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(2);
            }
            if ((object = this.getUserObject(e)) == null) {
                return;
            }
            if (state != ThreeStateCheckBox.State.NOT_SELECTED) {
                MultipleLocalChangeListsBrowser.this.myViewer.includeChange(object);
            } else {
                MultipleLocalChangeListsBrowser.this.myViewer.excludeChange(object);
            }
        }

        @Nullable
        private Object getUserObject(@NotNull AnActionEvent e) {
            Object object;
            if (e == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(3);
            }
            if ((object = e.getData(VcsDataKeys.CURRENT_CHANGE)) == null) {
                object = e.getData(VcsDataKeys.CURRENT_UNVERSIONED);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ToggleChangeDiffAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isSelected";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ToggleChangeDiffAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserObject";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class ShowHideUnversionedFilesAction
    extends ToggleAction
    implements DumbAware {
        private ShowHideUnversionedFilesAction() {
            super(VcsBundle.messagePointer((String)"action.ToggleAction.text.show.unversioned.files", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Vcs.ShowUnversionedFiles);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowHideUnversionedFilesAction.$$$reportNull$$$0(0);
            }
            return MultipleLocalChangeListsBrowser.this.isShowUnversioned();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowHideUnversionedFilesAction.$$$reportNull$$$0(1);
            }
            MultipleLocalChangeListsBrowser.this.setShowUnversioned(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ShowHideUnversionedFilesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ChangeListChooser
    extends JPanel {
        private static final int MAX_NAME_LEN = 35;
        @NotNull
        private final ComboBox<LocalChangeList> myChooser = new ComboBox();

        ChangeListChooser() {
            this.myChooser.setEditable(false);
            this.myChooser.setRenderer((ListCellRenderer)new ColoredListCellRenderer<LocalChangeList>(){

                protected void customizeCellRenderer(@NotNull JList<? extends LocalChangeList> list2, LocalChangeList value2, int index2, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String name = StringUtil.shortenTextWithEllipsis((String)value2.getName().trim(), (int)35, (int)0);
                    this.append(name, value2.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ChangeListChooser$1", "customizeCellRenderer"));
                }
            });
            this.myChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LocalChangeList changeList;
                    if (e.getStateChange() == 1 && (changeList = (LocalChangeList)ChangeListChooser.this.myChooser.getSelectedItem()) != null) {
                        MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(changeList);
                    }
                }
            });
            this.setLayout(new BorderLayout(4, 2));
            JLabel label2 = new JLabel(VcsBundle.message((String)"commit.dialog.changelist.label", (Object[])new Object[0]));
            label2.setLabelFor((Component)this.myChooser);
            this.add((Component)label2, "West");
            this.add((Component)this.myChooser, "Center");
        }

        public void setAvailableLists(@NotNull List<LocalChangeList> lists) {
            LocalChangeList currentList;
            if (lists == null) {
                ChangeListChooser.$$$reportNull$$$0(0);
            }
            if ((currentList = (LocalChangeList)ContainerUtil.find(lists, (Object)MultipleLocalChangeListsBrowser.this.getSelectedChangeList())) == null) {
                currentList = lists.get(0);
            }
            this.myChooser.setModel((ComboBoxModel)new CollectionComboBoxModel(lists, (Object)currentList));
            this.myChooser.setEnabled(lists.size() > 1);
            MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(currentList);
        }

        public void setSelectedChangeList(@NotNull LocalChangeList list2) {
            if (list2 == null) {
                ChangeListChooser.$$$reportNull$$$0(1);
            }
            ComboBoxModel model2 = this.myChooser.getModel();
            for (int i2 = 0; i2 < model2.getSize(); ++i2) {
                LocalChangeList element2 = (LocalChangeList)model2.getElementAt(i2);
                if (!element2.getName().equals(list2.getName())) continue;
                this.myChooser.setSelectedIndex(i2);
                MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(element2);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lists";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ChangeListChooser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setAvailableLists";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelectedChangeList";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

