/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CompoundVFileEvent {
    @NotNull
    private final VFileEvent myFileEvent;
    private boolean myInducedEventsCalculated;
    @NotNull
    private final List<VFileEvent> myInducedEvents;
    @NotNull
    private final List<Runnable> myApplyActions;

    public CompoundVFileEvent(@NotNull VFileEvent event) {
        if (event == null) {
            CompoundVFileEvent.$$$reportNull$$$0(0);
        }
        this.myInducedEvents = new SmartList();
        this.myApplyActions = new SmartList();
        this.myFileEvent = event;
    }

    @NotNull
    public VFileEvent getFileEvent() {
        VFileEvent vFileEvent = this.myFileEvent;
        if (vFileEvent == null) {
            CompoundVFileEvent.$$$reportNull$$$0(1);
        }
        return vFileEvent;
    }

    public boolean areInducedEventsCalculated() {
        return this.myInducedEventsCalculated;
    }

    @NotNull
    public List<VFileEvent> getInducedEvents() {
        this.calculateAdditionalEvents();
        List<VFileEvent> list2 = this.myInducedEvents;
        if (list2 == null) {
            CompoundVFileEvent.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public List<Runnable> getApplyActions() {
        this.calculateAdditionalEvents();
        List<Runnable> list2 = this.myApplyActions;
        if (list2 == null) {
            CompoundVFileEvent.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private void calculateAdditionalEvents() {
        if (!this.myInducedEventsCalculated) {
            this.myInducedEvents.addAll(VfsImplUtil.getJarInvalidationEvents(this.myFileEvent, this.myApplyActions));
            this.myInducedEventsCalculated = true;
        }
    }

    public String toString() {
        return "Compound " + this.myFileEvent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/CompoundVFileEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/CompoundVFileEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInducedEvents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

