/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowWatcher;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "bringOwnerToFront", "", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "getShowingComponentToRequestFocus", "Ljava/awt/Component;", "updateFocusedComponentForWatcher", "c", "updateToolWindow", "component", "intellij.platform.ide.impl"})
public final class RequestFocusInToolWindowKt {
    private static final Logger LOG;

    private static final void bringOwnerToFront(ToolWindowImpl toolWindow) {
        Window window = SwingUtilities.getWindowAncestor(toolWindow.getComponent());
        if (window == null) {
            return;
        }
        Window owner = window;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Intrinsics.checkNotNullExpressionValue((Object)keyboardFocusManager, (String)"KeyboardFocusManager.get\u2026entKeyboardFocusManager()");
        Window activeFrame = keyboardFocusManager.getActiveWindow();
        if (activeFrame != null && activeFrame != owner) {
            owner.toFront();
        }
    }

    @Nullable
    public static final Component getShowingComponentToRequestFocus(@NotNull ToolWindowImpl toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Object object = toolWindow.getContentManager().getSelectedContent();
        if (object != null && (object = object.getPreferredFocusableComponent()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            return (Component)it;
        }
        JComponent container = toolWindow.getComponentIfInitialized();
        if (container == null || !container.isShowing()) {
            Logger $this$debug$iv = LOG;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "tool window " + toolWindow.getId() + " parent container is hidden: " + container;
                logger.debug(string, (Throwable)e$iv);
            }
            return null;
        }
        FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
        if (policy == null) {
            LOG.warn(toolWindow.getId() + " tool window does not provide focus traversal policy");
            return null;
        }
        Component component2 = toolWindow.getToolWindowManager().getFocusManager().getFocusTargetFor(container);
        if (component2 == null && container.isFocusable()) {
            return container;
        }
        if (component2 == null || !component2.isShowing()) {
            Logger $this$debug$iv = LOG;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = " tool window " + toolWindow.getId() + " default component is hidden: " + container;
                logger.debug(string, (Throwable)e$iv);
            }
            return null;
        }
        return component2;
    }

    private static final void updateToolWindow(ToolWindowImpl toolWindow, Component component2) {
        if (component2.isFocusOwner()) {
            toolWindow.getToolWindowManager().updateToolWindow$intellij_platform_ide_impl(toolWindow, component2);
        }
        RequestFocusInToolWindowKt.updateFocusedComponentForWatcher(component2);
    }

    private static final void updateFocusedComponentForWatcher(Component c) {
        WindowManager windowManager = WindowManager.getInstance();
        if (windowManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
        }
        WindowWatcher watcher = ((WindowManagerImpl)windowManager).getWindowWatcher$intellij_platform_ide_impl();
        FocusWatcher focusWatcher = watcher.getFocusWatcherFor(c);
        if (focusWatcher != null && c.isFocusOwner()) {
            focusWatcher.setFocusedComponentImpl(c);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ToolWindowManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$bringOwnerToFront(ToolWindowImpl toolWindow) {
        RequestFocusInToolWindowKt.bringOwnerToFront(toolWindow);
    }

    public static final /* synthetic */ void access$updateToolWindow(ToolWindowImpl toolWindow, Component component2) {
        RequestFocusInToolWindowKt.updateToolWindow(toolWindow, component2);
    }
}

