/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.SquareStripeButton;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowIcon;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\fH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/wm/impl/SquareStripeButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "project", "Lcom/intellij/openapi/project/Project;", "button", "Lcom/intellij/openapi/wm/impl/StripeButton;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/impl/StripeButton;)V", "getButton", "()Lcom/intellij/openapi/wm/impl/StripeButton;", "getProject", "()Lcom/intellij/openapi/project/Project;", "showPopup", "", "component", "Ljava/awt/Component;", "x", "", "y", "updateToolTipText", "Companion", "HideAction", "MoveToAction", "SquareAnActionButton", "intellij.platform.ide.impl"})
public final class SquareStripeButton
extends ActionButton {
    @NotNull
    private final Project project;
    @NotNull
    private final StripeButton button;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    protected void updateToolTipText() {
        HelpTooltip helpTooltip = new HelpTooltip();
        ToolWindowImpl toolWindowImpl = this.button.toolWindow;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl, (String)"button.toolWindow");
        HelpTooltip helpTooltip2 = helpTooltip.setTitle(toolWindowImpl.getStripeTitle());
        ToolWindowImpl toolWindowImpl2 = this.button.toolWindow;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl2, (String)"button.toolWindow");
        helpTooltip2.setLocation(SquareStripeButton.Companion.getAlignment(toolWindowImpl2.getLargeStripeAnchor())).setShortcut((Shortcut)ActionManager.getInstance().getKeyboardShortcut(ActivateToolWindowAction.getActionIdForToolWindow(this.button.getId()))).setInitialDelay(0).setHideDelay(0).installOn((JComponent)this);
    }

    private final void showPopup(Component component2, int x, int y) {
        ActionManager actionManager = ActionManager.getInstance();
        ToolWindowsPane toolWindowsPane = this.button.pane;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)toolWindowsPane), (String)"button.pane");
        ToolWindowImpl toolWindowImpl = this.button.toolWindow;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl, (String)"button.toolWindow");
        ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu("ToolwindowPopup", (ActionGroup)SquareStripeButton.Companion.createPopupGroup(this.project, toolWindowsPane, toolWindowImpl));
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"ActionManager.getInstanc\u2026pane, button.toolWindow))");
        ActionPopupMenu popupMenu = actionPopupMenu;
        popupMenu.getComponent().show(component2, x, y);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final StripeButton getButton() {
        return this.button;
    }

    public SquareStripeButton(@NotNull Project project, @NotNull StripeButton button4) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)button4, (String)"button");
        super((AnAction)new SquareAnActionButton(project, button4), SquareStripeButton.Companion.createPresentation(button4), "ToolwindowToolbar", new Dimension(40, 40));
        this.project = project;
        this.button = button4;
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component component2, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                this.showPopup(component2, x, y);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final DefaultActionGroup createMoveGroup(@NotNull Project project, @Nullable ToolWindowsPane _toolWindowsPane, @NotNull ToolWindow toolWindow) {
        return Companion.createMoveGroup(project, _toolWindowsPane, toolWindow);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/wm/impl/SquareStripeButton$MoveToAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "toolWindowsPane", "Lcom/intellij/openapi/wm/impl/ToolWindowsPane;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "(Lcom/intellij/openapi/wm/impl/ToolWindowsPane;Lcom/intellij/openapi/wm/ToolWindow;Lcom/intellij/openapi/wm/ToolWindowAnchor;)V", "getAnchor", "()Lcom/intellij/openapi/wm/ToolWindowAnchor;", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindowsPane", "()Lcom/intellij/openapi/wm/impl/ToolWindowsPane;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.ide.impl"})
    private static final class MoveToAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final ToolWindowsPane toolWindowsPane;
        @NotNull
        private final ToolWindow toolWindow;
        @NotNull
        private final ToolWindowAnchor anchor;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            this.toolWindowsPane.onStripeButtonRemoved(project, this.toolWindow);
            this.toolWindow.setVisibleOnLargeStripe(true);
            this.toolWindow.setLargeStripeAnchor(this.anchor);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabledAndVisible(Intrinsics.areEqual((Object)this.toolWindow.getLargeStripeAnchor(), (Object)this.anchor) ^ true);
        }

        @NotNull
        public final ToolWindowsPane getToolWindowsPane() {
            return this.toolWindowsPane;
        }

        @NotNull
        public final ToolWindow getToolWindow() {
            return this.toolWindow;
        }

        @NotNull
        public final ToolWindowAnchor getAnchor() {
            return this.anchor;
        }

        public MoveToAction(@NotNull ToolWindowsPane toolWindowsPane, @NotNull ToolWindow toolWindow, @NotNull ToolWindowAnchor anchor2) {
            Intrinsics.checkNotNullParameter((Object)((Object)toolWindowsPane), (String)"toolWindowsPane");
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            Intrinsics.checkNotNullParameter((Object)anchor2, (String)"anchor");
            super(anchor2.getCapitalizedDisplayName());
            this.toolWindowsPane = toolWindowsPane;
            this.toolWindow = toolWindow;
            this.anchor = anchor2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/wm/impl/SquareStripeButton$HideAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "toolWindowsPane", "Lcom/intellij/openapi/wm/impl/ToolWindowsPane;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/wm/impl/ToolWindowsPane;Lcom/intellij/openapi/wm/ToolWindow;)V", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindowsPane", "()Lcom/intellij/openapi/wm/impl/ToolWindowsPane;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
    private static final class HideAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final ToolWindowsPane toolWindowsPane;
        @NotNull
        private final ToolWindow toolWindow;

        public void actionPerformed(@NotNull AnActionEvent e) {
            block1: {
                Object object;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                Intrinsics.checkNotNull((Object)project);
                this.toolWindowsPane.onStripeButtonRemoved(project, this.toolWindow);
                this.toolWindow.setVisibleOnLargeStripe(false);
                ToolWindow toolWindow = this.toolWindow;
                if (!(toolWindow instanceof ToolWindowImpl)) {
                    toolWindow = null;
                }
                if ((object = (ToolWindowImpl)toolWindow) == null || (object = ((ToolWindowImpl)object).getToolWindowManager()) == null) break block1;
                ((ToolWindowManagerImpl)((Object)object)).hideToolWindow(((ToolWindowImpl)this.toolWindow).getId(), false, true, ToolWindowEventSource.SquareStripeButton);
            }
        }

        @NotNull
        public final ToolWindowsPane getToolWindowsPane() {
            return this.toolWindowsPane;
        }

        @NotNull
        public final ToolWindow getToolWindow() {
            return this.toolWindow;
        }

        public HideAction(@NotNull ToolWindowsPane toolWindowsPane, @NotNull ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)((Object)toolWindowsPane), (String)"toolWindowsPane");
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            super(UIBundle.message((String)"tool.window.new.stripe.hide.action.name", (Object[])new Object[0]));
            this.toolWindowsPane = toolWindowsPane;
            this.toolWindow = toolWindow;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/wm/impl/SquareStripeButton$SquareAnActionButton;", "Lcom/intellij/ui/ToggleActionButton;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "button", "Lcom/intellij/openapi/wm/impl/StripeButton;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/impl/StripeButton;)V", "getButton", "()Lcom/intellij/openapi/wm/impl/StripeButton;", "getProject", "()Lcom/intellij/openapi/project/Project;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.platform.ide.impl"})
    private static final class SquareAnActionButton
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        private final Project project;
        @NotNull
        private final StripeButton button;

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            ToolWindowIcon toolWindowIcon = this.button.toolWindow.getIcon$intellij_platform_ide_impl();
            presentation2.setIcon(toolWindowIcon != null ? (Icon)((Object)toolWindowIcon) : AllIcons.Toolbar.Unknown);
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            Companion.scaleIcon(presentation3);
            ToolWindowImpl toolWindowImpl = this.button.toolWindow;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl, (String)"button.toolWindow");
            return toolWindowImpl.isVisible();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
            if (project.isDisposed()) {
                return;
            }
            ToolWindowManagerImpl manager2 = this.button.toolWindow.getToolWindowManager();
            if (!state) {
                String string = this.button.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"button.id");
                manager2.hideToolWindow(string, false, true, ToolWindowEventSource.SquareStripeButton);
            } else {
                ToolWindowImpl toolWindowImpl = this.button.toolWindow;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl, (String)"button.toolWindow");
                manager2.activated$intellij_platform_ide_impl(toolWindowImpl, ToolWindowEventSource.SquareStripeButton);
            }
            ((ToolWindowManagerListener)this.project.getMessageBus().syncPublisher(ToolWindowManagerListener.TOPIC)).stateChanged(manager2);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final StripeButton getButton() {
            return this.button;
        }

        public SquareAnActionButton(@NotNull Project project, @NotNull StripeButton button4) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)button4, (String)"button");
            super(button4.getText(), null);
            this.project = project;
            this.button = button4;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u000eH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/wm/impl/SquareStripeButton$Companion;", "", "()V", "createMoveGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "project", "Lcom/intellij/openapi/project/Project;", "_toolWindowsPane", "Lcom/intellij/openapi/wm/impl/ToolWindowsPane;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createPopupGroup", "toolWindowsPane", "createPresentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "button", "Lcom/intellij/openapi/wm/impl/StripeButton;", "getAlignment", "Lcom/intellij/ide/HelpTooltip$Alignment;", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "scaleIcon", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final Presentation createPresentation(StripeButton button4) {
            Presentation presentation2 = new Presentation(button4.getText());
            boolean bl = false;
            boolean bl2 = false;
            Presentation $this$apply = presentation2;
            boolean bl3 = false;
            Icon icon2 = button4.getIcon();
            if (icon2 == null) {
                icon2 = AllIcons.Toolbar.Unknown;
            }
            $this$apply.setIcon(icon2);
            Companion.scaleIcon($this$apply);
            $this$apply.setEnabledAndVisible(true);
            return presentation2;
        }

        private final void scaleIcon(Presentation $this$scaleIcon) {
            if ($this$scaleIcon.getIcon() instanceof ScalableIcon) {
                Icon icon2 = $this$scaleIcon.getIcon();
                if (icon2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.util.ScalableIcon");
                }
                $this$scaleIcon.setIcon(((ScalableIcon)icon2).scale(1.4f));
            }
        }

        private final DefaultActionGroup createPopupGroup(Project project, ToolWindowsPane toolWindowsPane, ToolWindow toolWindow) {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            boolean bl = false;
            boolean bl2 = false;
            DefaultActionGroup $this$apply = defaultActionGroup;
            boolean bl3 = false;
            $this$apply.add((AnAction)new HideAction(toolWindowsPane, toolWindow));
            $this$apply.addSeparator();
            $this$apply.add((AnAction)Companion.createMoveGroup(project, toolWindowsPane, toolWindow));
            return defaultActionGroup;
        }

        @JvmStatic
        @NotNull
        public final DefaultActionGroup createMoveGroup(@NotNull Project project, @Nullable ToolWindowsPane _toolWindowsPane, @NotNull ToolWindow toolWindow) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
            ToolWindowsPane toolWindowsPane = _toolWindowsPane;
            if (toolWindowsPane == null) {
                Object object;
                WindowManager windowManager = WindowManager.getInstance();
                if (!(windowManager instanceof WindowManagerImpl)) {
                    windowManager = null;
                }
                ToolWindowsPane toolWindowsPane2 = (object = (WindowManagerImpl)windowManager) != null && (object = ((WindowManagerImpl)((Object)object)).getProjectFrameRootPane(project)) != null ? ((IdeRootPane)object).getToolWindowPane() : (toolWindowsPane = null);
                if (toolWindowsPane == null) {
                    return new DefaultActionGroup();
                }
            }
            DefaultActionGroup defaultActionGroup = DefaultActionGroup.createPopupGroup((Supplier)createMoveGroup.1.INSTANCE);
            boolean bl = false;
            boolean bl2 = false;
            DefaultActionGroup $this$apply = defaultActionGroup;
            boolean bl3 = false;
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"ToolWindowAnchor.LEFT");
            $this$apply.add((AnAction)new MoveToAction(toolWindowsPane, toolWindow, toolWindowAnchor));
            ToolWindowAnchor toolWindowAnchor2 = ToolWindowAnchor.RIGHT;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor2, (String)"ToolWindowAnchor.RIGHT");
            $this$apply.add((AnAction)new MoveToAction(toolWindowsPane, toolWindow, toolWindowAnchor2));
            ToolWindowAnchor toolWindowAnchor3 = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor3, (String)"ToolWindowAnchor.BOTTOM");
            $this$apply.add((AnAction)new MoveToAction(toolWindowsPane, toolWindow, toolWindowAnchor3));
            DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
            Intrinsics.checkNotNullExpressionValue((Object)defaultActionGroup2, (String)"DefaultActionGroup.creat\u2026Anchor.BOTTOM))\n        }");
            return defaultActionGroup2;
        }

        public static /* synthetic */ DefaultActionGroup createMoveGroup$default(Companion companion, Project project, ToolWindowsPane toolWindowsPane, ToolWindow toolWindow, int n, Object object) {
            if ((n & 2) != 0) {
                toolWindowsPane = null;
            }
            return companion.createMoveGroup(project, toolWindowsPane, toolWindow);
        }

        private final HelpTooltip.Alignment getAlignment(ToolWindowAnchor anchor2) {
            ToolWindowAnchor toolWindowAnchor = anchor2;
            return Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT) ? HelpTooltip.Alignment.LEFT : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP) ? HelpTooltip.Alignment.LEFT : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT) ? HelpTooltip.Alignment.RIGHT : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM) ? HelpTooltip.Alignment.RIGHT : HelpTooltip.Alignment.RIGHT)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

