/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorBasedWidget
implements StatusBarWidget,
FileEditorManagerListener {
    @NonNls
    public static final String SWING_FOCUS_OWNER_PROPERTY = "focusOwner";
    @NotNull
    protected final Project myProject;
    protected StatusBar myStatusBar;
    protected MessageBusConnection myConnection;
    private volatile boolean myDisposed;

    protected EditorBasedWidget(@NotNull Project project) {
        if (project == null) {
            EditorBasedWidget.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @Nullable
    protected Editor getEditor() {
        Editor editor = StatusBarUtil.getCurrentTextEditor(this.myStatusBar);
        if (editor != null) {
            return editor;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        }
        return null;
    }

    public boolean isOurEditor(Editor editor) {
        return editor != null && editor.getComponent().isShowing() && !Boolean.TRUE.equals(editor.getUserData(EditorTextField.SUPPLEMENTARY_KEY)) && WindowManager.getInstance().getStatusBar((Component)editor.getComponent(), editor.getProject()) == this.myStatusBar;
    }

    @Nullable
    Component getFocusedComponent() {
        IdeFocusManager focusManager;
        Window frame;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null && (frame = (focusManager = IdeFocusManager.getInstance((Project)this.myProject)).getLastFocusedIdeWindow()) != null) {
            focusOwner = focusManager.getLastFocusedFor(frame);
        }
        return focusOwner;
    }

    @Nullable
    Editor getFocusedEditor() {
        Component component2 = this.getFocusedComponent();
        Editor editor = component2 instanceof EditorComponentImpl ? ((EditorComponentImpl)component2).getEditor() : this.getEditor();
        return editor != null && !editor.isDisposed() ? editor : null;
    }

    @Nullable
    protected VirtualFile getSelectedFile() {
        Editor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        return FileDocumentManager.getInstance().getFile(document);
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            EditorBasedWidget.$$$reportNull$$$0(1);
        }
        return project;
    }

    public void install(@NotNull StatusBar statusBar2) {
        if (statusBar2 == null) {
            EditorBasedWidget.$$$reportNull$$$0(2);
        }
        assert (statusBar2.getProject() == null || statusBar2.getProject().equals(this.myProject)) : "Cannot install widget from one project on status bar of another project";
        this.myStatusBar = statusBar2;
        Disposer.register((Disposable)this.myStatusBar, (Disposable)this);
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this);
        this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
    }

    public void dispose() {
        this.myDisposed = true;
        this.myStatusBar = null;
    }

    protected final boolean isDisposed() {
        return this.myDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/EditorBasedWidget";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/EditorBasedWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

