/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WelcomeScreenCustomization;
import com.intellij.openapi.wm.WelcomeScreenTab;
import com.intellij.openapi.wm.WelcomeTabFactory;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenEventCollector;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TabbedWelcomeScreen
extends AbstractWelcomeScreen {
    private final JBList<WelcomeScreenTab> tabList;

    TabbedWelcomeScreen() {
        this.setBackground(WelcomeScreenUIManager.getMainTabListBackground());
        CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel> mainPanel = TabbedWelcomeScreen.createCardPanel();
        DefaultListModel<WelcomeScreenTab> mainListModel = new DefaultListModel<WelcomeScreenTab>();
        for (WelcomeTabFactory tabFactory : WelcomeTabFactory.WELCOME_TAB_FACTORY_EP.getExtensionList()) {
            if (!tabFactory.isApplicable()) continue;
            mainListModel.addElement(tabFactory.createWelcomeTab((Disposable)this));
        }
        this.tabList = TabbedWelcomeScreen.createListWithTabs(mainListModel);
        this.tabList.addListSelectionListener(e -> {
            mainPanel.select((WelcomeScreenTab)this.tabList.getSelectedValue(), true);
            WelcomeScreenEventCollector.logTabSelected((WelcomeScreenTab)this.tabList.getSelectedValue());
        });
        this.tabList.getAccessibleContext().setAccessibleName(UIBundle.message((String)"welcome.screen.welcome.screen.categories.accessible.name", (Object[])new Object[0]));
        JComponent logoComponent = WelcomeScreenComponentFactory.createSmallLogo();
        logoComponent.setFocusable(false);
        logoComponent.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        NonOpaquePanel leftPanel = new NonOpaquePanel();
        leftPanel.add((Component)logoComponent, "North");
        leftPanel.add((Component)this.tabList, "Center");
        JComponent quickAccessPanel = TabbedWelcomeScreen.createQuickAccessPanel((Disposable)this);
        quickAccessPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
        leftPanel.add((Component)quickAccessPanel, "South");
        leftPanel.setPreferredSize(new Dimension(JBUI.scale((int)196), leftPanel.getPreferredSize().height));
        JComponent centralPanel = mainPanel;
        JComponent mainPanelToolbar = TabbedWelcomeScreen.createMainPanelToolbar((Disposable)this);
        if (mainPanelToolbar != null) {
            centralPanel = new JPanel(new BorderLayout());
            centralPanel.add(mainPanel, "Center");
            centralPanel.add((Component)mainPanelToolbar, "South");
        }
        this.add((Component)leftPanel, "West");
        this.add(centralPanel, "Center");
        if (!mainListModel.isEmpty()) {
            this.tabList.setSelectedIndex(0);
            JComponent firstShownPanel = mainListModel.get(0).getAssociatedComponent();
            UiNotifyConnector.doWhenFirstShown((JComponent)firstShownPanel, () -> {
                JComponent preferred = IdeFocusTraversalPolicy.getPreferredFocusedComponent(firstShownPanel);
                IdeFocusManager.getGlobalInstance().requestFocus((Component)Objects.requireNonNullElse(preferred, this.tabList), true);
                WelcomeScreenEventCollector.logWelcomeScreenShown();
            });
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        WelcomeScreenEventCollector.logWelcomeScreenHide();
    }

    @NotNull
    private static JBList<WelcomeScreenTab> createListWithTabs(@NotNull DefaultListModel<WelcomeScreenTab> mainListModel) {
        if (mainListModel == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(0);
        }
        JBList<WelcomeScreenTab> tabList = new JBList<WelcomeScreenTab>(mainListModel){

            public int locationToIndex(Point location) {
                int i2 = super.locationToIndex(location);
                return i2 == -1 || !this.getCellBounds(i2, i2).contains(location) ? -1 : i2;
            }
        };
        tabList.setBackground(WelcomeScreenUIManager.getMainTabListBackground());
        tabList.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        tabList.setCellRenderer((ListCellRenderer)new MyCellRenderer());
        JBList<WelcomeScreenTab> jBList = tabList;
        if (jBList == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(1);
        }
        return jBList;
    }

    private static JComponent createQuickAccessPanel(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(2);
        }
        NonOpaquePanel quickAccessPanel = new NonOpaquePanel((LayoutManager)new FlowLayout(0, 0, 0));
        WelcomeScreenCustomization.WELCOME_SCREEN_CUSTOMIZATION.getExtensionsIfPointIsRegistered().stream().map(c -> c.createQuickAccessComponent(parentDisposable)).filter(Objects::nonNull).forEach(((JPanel)quickAccessPanel)::add);
        return quickAccessPanel;
    }

    @Nullable
    private static JComponent createMainPanelToolbar(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(3);
        }
        return WelcomeScreenCustomization.WELCOME_SCREEN_CUSTOMIZATION.getExtensionsIfPointIsRegistered().stream().map(c -> c.createMainPanelToolbar(parentDisposable)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    private static CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel> createCardPanel() {
        return new CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel>(){

            @Override
            protected WelcomeScreenTab prepare(WelcomeScreenTab key) {
                return key;
            }

            @Override
            protected JPanel create(WelcomeScreenTab screenTab) {
                return JBUI.Panels.simplePanel((Component)screenTab.getAssociatedComponent());
            }
        };
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            TabbedWelcomeScreen.$$$reportNull$$$0(4);
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.tabList.getSelectedIndex();
    }

    public void setSelectedIndex(int idx) {
        this.tabList.setSelectedIndex(idx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainListModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createListWithTabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createListWithTabs";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createQuickAccessPanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMainPanelToolbar";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class DefaultWelcomeScreenTab
    implements WelcomeScreenTab,
    Accessible {
        protected final JComponent myKeyComponent;
        private JComponent myAssociatedComponent;
        private final JBLabel myLabel;
        private final WelcomeScreenEventCollector.TabType myType;

        public DefaultWelcomeScreenTab(@NotNull @Nls String tabName) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(0);
            }
            this(tabName, WelcomeScreenEventCollector.TabType.TabNavOther);
        }

        DefaultWelcomeScreenTab(@NotNull @Nls String tabName, @NotNull WelcomeScreenEventCollector.TabType tabType) {
            if (tabName == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(1);
            }
            if (tabType == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(2);
            }
            this.myLabel = new JBLabel(tabName);
            this.myType = tabType;
            this.myKeyComponent = ((BorderLayoutPanel)JBUI.Panels.simplePanel().addToLeft((Component)this.myLabel).withBackground(WelcomeScreenUIManager.getMainTabListBackground())).withBorder((Border)JBUI.Borders.empty((int)8, (int)0));
        }

        @NotNull
        public JComponent getKeyComponent(@NotNull JComponent parent) {
            if (parent == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(3);
            }
            JComponent jComponent = this.myKeyComponent;
            if (jComponent == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(4);
            }
            return jComponent;
        }

        @NotNull
        public JComponent getAssociatedComponent() {
            if (this.myAssociatedComponent == null) {
                this.myAssociatedComponent = this.buildComponent();
            }
            JComponent jComponent = this.myAssociatedComponent;
            if (jComponent == null) {
                DefaultWelcomeScreenTab.$$$reportNull$$$0(5);
            }
            return jComponent;
        }

        WelcomeScreenEventCollector.TabType getType() {
            return this.myType;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this.myLabel.getAccessibleContext();
        }

        protected abstract JComponent buildComponent();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen$DefaultWelcomeScreenTab";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/TabbedWelcomeScreen$DefaultWelcomeScreenTab";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAssociatedComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getKeyComponent";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyCellRenderer
    extends CellRendererPane
    implements ListCellRenderer<WelcomeScreenTab> {
        private MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends WelcomeScreenTab> list2, WelcomeScreenTab value2, int index2, boolean isSelected, boolean cellHasFocus) {
            JComponent keyComponent = value2.getKeyComponent(list2);
            BorderLayoutPanel wrappedPanel = JBUI.Panels.simplePanel((Component)keyComponent);
            UIUtil.setBackgroundRecursively((Component)wrappedPanel, (Color)(isSelected ? UIUtil.getListSelectionBackground((boolean)cellHasFocus) : WelcomeScreenUIManager.getMainTabListBackground()));
            UIUtil.setForegroundRecursively((Component)wrappedPanel, (Color)UIUtil.getListForeground((boolean)isSelected, (boolean)cellHasFocus));
            if (value2 instanceof Accessible) {
                wrappedPanel.getAccessibleContext().setAccessibleName(((Accessible)value2).getAccessibleContext().getAccessibleName());
            }
            return wrappedPanel;
        }
    }
}

