/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.SplashManager;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEventsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WelcomeFrameProvider;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WelcomeFrame
extends JFrame
implements IdeFrame,
AccessibleContextAccessor {
    public static final ExtensionPointName<WelcomeFrameProvider> EP = new ExtensionPointName("com.intellij.welcomeFrameProvider");
    @NonNls
    static final String DIMENSION_KEY = "WELCOME_SCREEN";
    private static IdeFrame ourInstance;
    private static Disposable ourTouchbar;
    private final WelcomeScreen myScreen;
    private final BalloonLayout myBalloonLayout;

    public WelcomeFrame() {
        SplashManager.hideBeforeShow(this);
        JRootPane rootPane = this.getRootPane();
        WelcomeScreen screen = WelcomeFrame.createScreen(rootPane);
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane);
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        this.setContentPane(screen.getWelcomePanel());
        this.setTitle(ApplicationNamesInfo.getInstance().getFullProductName());
        AppUIUtil.updateWindowIcon(this);
        final Disposable listenerDisposable = Disposer.newDisposable();
        ApplicationManager.getApplication().getMessageBus().connect(listenerDisposable).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)listenerDisposable);
                WelcomeFrame.this.dispose();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeFrame$1", "projectOpened"));
            }
        });
        this.myBalloonLayout = new BalloonLayoutImpl(rootPane, new Insets(8, 8, 8, 8));
        this.myScreen = screen;
        WelcomeFrame.setupCloseAction(this);
        MnemonicHelper.init((Component)this);
        this.myScreen.setupFrame((JFrame)this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)new Disposable(){

            public void dispose() {
                WelcomeFrame.this.dispose();
            }
        });
    }

    public static IdeFrame getInstance() {
        return ourInstance;
    }

    @Override
    public void dispose() {
        WelcomeFrame.saveLocation(this.getBounds());
        super.dispose();
        Disposer.dispose((Disposable)this.myScreen);
        WelcomeFrame.resetInstance();
    }

    private static void saveLocation(Rectangle location) {
        location.y = location.height / 2;
        Point middle2 = new Point(location.x + location.width / 2, location.y);
        DimensionService.getInstance().setLocation(DIMENSION_KEY, middle2, null);
    }

    static void setupCloseAction(final @NotNull JFrame frame) {
        if (frame == null) {
            WelcomeFrame.$$$reportNull$$$0(0);
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ProjectUtil.getOpenProjects().length == 0) {
                    ApplicationManager.getApplication().exit();
                } else {
                    frame.dispose();
                }
            }
        });
    }

    @NotNull
    private static WelcomeScreen createScreen(JRootPane rootPane) {
        for (WelcomeScreenProvider provider2 : WelcomeScreenProvider.EP_NAME.getExtensionList()) {
            WelcomeScreen screen;
            if (!provider2.isAvailable() || (screen = provider2.createWelcomeScreen(rootPane)) == null) continue;
            WelcomeScreen welcomeScreen = screen;
            if (welcomeScreen == null) {
                WelcomeFrame.$$$reportNull$$$0(1);
            }
            return welcomeScreen;
        }
        return new NewWelcomeScreen();
    }

    public static void resetInstance() {
        ourInstance = null;
        if (ourTouchbar != null) {
            Disposer.dispose((Disposable)ourTouchbar);
            ourTouchbar = null;
        }
    }

    public static void showNow() {
        if (ourInstance != null) {
            return;
        }
        Runnable show2 = WelcomeFrame.prepareToShow();
        if (show2 != null) {
            show2.run();
        }
    }

    @Nullable
    public static Runnable prepareToShow() {
        if (ourInstance != null) {
            return null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ActionManager.getInstance();
            if (SystemInfoRt.isMac) {
                TouchbarSupport.initialize();
            }
        });
        return () -> {
            if (ourInstance != null) {
                return;
            }
            IdeFrame frame = (IdeFrame)EP.computeSafeIfAny(provider2 -> provider2.createFrame());
            if (frame == null) {
                throw new IllegalStateException("No implementation of `com.intellij.welcomeFrameProvider` extension point");
            }
            JFrame jFrame = (JFrame)frame;
            WelcomeFrame.registerKeyboardShortcuts(jFrame.getRootPane());
            jFrame.setVisible(true);
            IdeMenuBar.installAppMenuIfNeeded(jFrame);
            ourInstance = frame;
            if (SystemInfoRt.isMac) {
                ourTouchbar = TouchbarSupport.showDialogButtons(frame.getComponent());
            }
        };
    }

    private static void registerKeyboardShortcuts(@NotNull JRootPane rootPane) {
        if (rootPane == null) {
            WelcomeFrame.$$$reportNull$$$0(2);
        }
        ActionListener helpAction = e -> {
            FeatureUsageUiEventsKt.getUiEventLogger().logClickOnHelpDialog(WelcomeFrame.class.getName(), WelcomeFrame.class);
            HelpManager.getInstance().invokeHelp("welcome");
        };
        ActionUtil.registerForEveryKeyboardShortcut((JComponent)rootPane, (ActionListener)helpAction, (ShortcutSet)CommonShortcuts.getContextHelp());
        rootPane.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
    }

    public static void showIfNoProjectOpened() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            WindowManagerImpl windowManager = (WindowManagerImpl)WindowManager.getInstance();
            windowManager.disposeRootFrame();
            if (windowManager.getProjectFrameHelpers().isEmpty()) {
                WelcomeFrame.showNow();
            }
        }, ModalityState.NON_MODAL);
    }

    @Nullable
    public StatusBar getStatusBar() {
        Container pane2 = this.getContentPane();
        return pane2 instanceof JComponent ? (StatusBar)UIUtil.findComponentOfType((JComponent)((JComponent)pane2), IdeStatusBarImpl.class) : null;
    }

    @Nullable
    public BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            WelcomeFrame.$$$reportNull$$$0(3);
        }
        return rectangle;
    }

    @NotNull
    public Project getProject() {
        Project project = ProjectManager.getInstance().getDefaultProject();
        if (project == null) {
            WelcomeFrame.$$$reportNull$$$0(4);
        }
        return project;
    }

    public void setFrameTitle(String title2) {
        this.setTitle(title2);
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeFrame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createScreen";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestChildFrameBounds";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupCloseAction";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerKeyboardShortcuts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

