/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.util.Condition;
import com.intellij.profiler.BaseCallTreeBuilder;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.Stack;
import com.intellij.profiler.api.SamplesCountMetric;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.AllThreadsMerged;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.model.ProxyCallTreeNodeImpl;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.model.ThreadInfoKt;
import com.intellij.profiler.model.Transformation;
import com.intellij.profiler.model.TreeNode;
import com.intellij.profiler.model.TreeNodeKt;
import com.intellij.profiler.model.TreeNodeWithParent;
import com.intellij.profiler.model.TreeTransformer;
import com.intellij.profiler.model.TreeTransformerKt;
import com.intellij.profiler.model.TreeUtilKt;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012H\u0016Jb\u0010\u0014\u001a6\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\b\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\b0\u0015\"\u0004\b\u0001\u0010\u0017\"\u0004\b\u0002\u0010\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u0002H\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u001b0\u001aH\u0002J\u0014\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001e0\u001dH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u001aJ\"\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00170\b\"\u0004\b\u0001\u0010\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00170\bH\u0002J\u001a\u0010&\u001a\u00020\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001aJ \u0010(\u001a\u00020\"2\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001aJ\u0018\u0010)\u001a\u00020*\"\u0004\b\u0001\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\bH\u0002R&\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Lcom/intellij/profiler/BaseCallTreeBuilder;", "ElementType", "", "Lcom/intellij/profiler/CallTreeBuilder;", "()V", "forest", "", "Lcom/intellij/profiler/model/ThreadInfo;", "Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;", "getForest", "()Ljava/util/Map;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "getMetric", "()Lcom/intellij/profiler/api/ValueMetric;", "setMetric", "(Lcom/intellij/profiler/api/ValueMetric;)V", "buildCallTree", "", "Lcom/intellij/profiler/model/CallTreeNode;", "createTransformer", "Lcom/intellij/profiler/model/TreeTransformer;", "Lcom/intellij/profiler/model/CallWithValue;", "T", "R", "transformer", "Lkotlin/Function1;", "Lcom/intellij/profiler/model/Transformation;", "getAllStacks", "", "Lcom/intellij/profiler/Stack;", "isEmpty", "", "mapTreeElements", "", "mapFunc", "mergeChildren", "node", "renameThreads", "nameMapFunc", "transformTreeElements", "ownValue", "", "MyTreeNode", "intellij.profiler.common"})
public abstract class BaseCallTreeBuilder<ElementType>
implements CallTreeBuilder<ElementType> {
    @NotNull
    private final Map<ThreadInfo, MyTreeNode<ElementType>> forest;
    @NotNull
    private ValueMetric metric;

    @NotNull
    protected final Map<ThreadInfo, MyTreeNode<ElementType>> getForest() {
        return this.forest;
    }

    @Override
    public boolean isEmpty() {
        return this.forest.isEmpty();
    }

    @Override
    @NotNull
    public ValueMetric getMetric() {
        return this.metric;
    }

    public void setMetric(@NotNull ValueMetric valueMetric) {
        Intrinsics.checkNotNullParameter((Object)valueMetric, (String)"<set-?>");
        this.metric = valueMetric;
    }

    /*
     * WARNING - void declaration
     */
    public final void renameThreads(@NotNull Function1<? super ThreadInfo, ? extends ThreadInfo> nameMapFunc) {
        void $this$mapKeysTo$iv$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv22;
        Intrinsics.checkNotNullParameter(nameMapFunc, (String)"nameMapFunc");
        Iterable $this$map$iv22 = this.forest.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            void it;
            ThreadInfo threadInfo = (ThreadInfo)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it instanceof AllThreadsMerged ? TuplesKt.to((Object)it, (Object)it) : TuplesKt.to((Object)it, (Object)nameMapFunc.invoke((Object)it));
            object2.add(object);
        }
        Map newNames = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        boolean $this$map$iv22 = CollectionsKt.toSet((Iterable)newNames.values()).size() == newNames.values().size();
        $i$f$map = false;
        boolean $this$mapTo$iv$iv22 = false;
        if (!$this$map$iv22) {
            boolean bl = false;
            String $this$mapTo$iv$iv22 = "Multiple old threads mapped to single new thread.";
            throw (Throwable)new IllegalArgumentException($this$mapTo$iv$iv22.toString());
        }
        Map<ThreadInfo, MyTreeNode<ElementType>> $this$mapKeys$iv = this.forest;
        boolean $i$f$mapKeys = false;
        Map<ThreadInfo, MyTreeNode<ElementType>> bl = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void $dstr$oldName$_u24__u24;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            void var15_27 = $dstr$oldName$_u24__u24;
            boolean bl3 = false;
            ThreadInfo oldName = (ThreadInfo)var15_27.getKey();
            object = (ThreadInfo)MapsKt.getValue((Map)newNames, (Object)oldName);
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object object3 = object;
            Object object4 = object2;
            boolean bl4 = false;
            Object v = it$iv$iv.getValue();
            object4.put(object3, v);
        }
        Map tmp = destination$iv$iv2;
        this.forest.clear();
        this.forest.putAll(tmp);
    }

    public final void mapTreeElements(@NotNull Function1<? super ElementType, ? extends ElementType> mapFunc) {
        Intrinsics.checkNotNullParameter(mapFunc, (String)"mapFunc");
        this.transformTreeElements((Function1)new Function1<ElementType, Transformation<ElementType>>(mapFunc){
            final /* synthetic */ Function1 $mapFunc;

            @NotNull
            public final Transformation<ElementType> invoke(@NotNull ElementType it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return new Transformation.Single<Object>(this.$mapFunc.invoke(it));
            }
            {
                this.$mapFunc = function1;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void transformTreeElements(@NotNull Function1<? super ElementType, ? extends Transformation<ElementType>> transformer) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        Map<ThreadInfo, MyTreeNode<ElementType>> $this$mapValues$iv = this.forest;
        boolean $i$f$mapValues = false;
        Map<ThreadInfo, MyTreeNode<ElementType>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$tree;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            boolean bl2 = false;
            void var18_17 = $dstr$_u24__u24$tree;
            boolean bl3 = false;
            MyTreeNode tree = (MyTreeNode)var18_17.getValue();
            MyTreeNode myTreeNode = this.mergeChildren(TreeTransformerKt.transformTree(this.createTransformer(transformer), (TreeNode)tree));
            map4.put(k2, myTreeNode);
        }
        Map tmp = destination$iv$iv;
        this.forest.clear();
        this.forest.putAll(tmp);
    }

    @Override
    @NotNull
    public Map<ThreadInfo, CallTreeNode<ElementType>> buildCallTree() {
        if (this.forest.isEmpty()) {
            return MapsKt.emptyMap();
        }
        if (!ThreadInfoKt.noThreadInfoInThreadList((Collection<? extends ThreadInfo>)this.forest.keySet())) {
            boolean bl = !this.forest.keySet().contains(AllThreadsMerged.INSTANCE);
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            MyTreeNode myTreeNode = MyTreeNode.Companion.root();
            bl3 = false;
            bl4 = false;
            MyTreeNode $this$apply22 = myTreeNode;
            boolean bl6 = false;
            $this$apply22.addAll$intellij_profiler_common(this.forest.values());
            MyTreeNode mergedRoot = myTreeNode;
            Object object = CollectionsKt.single(this.mergeChildren(mergedRoot).getChildren());
            bl4 = false;
            boolean $this$apply22 = false;
            MyTreeNode root = (MyTreeNode)object;
            boolean bl7 = false;
            root.setParent(null);
            Iterable $this$forEach$iv = (Iterable)TreeUtilKt.allNodesIterable((TreeNode)root);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MyTreeNode it = (MyTreeNode)element$iv;
                boolean bl8 = false;
                it.setRoot(root);
            }
            MyTreeNode fixed = (MyTreeNode)object;
            this.forest.put(AllThreadsMerged.INSTANCE, fixed);
        }
        Iterable $this$forEach$iv = this.forest.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MyTreeNode it = (MyTreeNode)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)TreeUtilKt.allNodesIterable((TreeNode)it);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                MyTreeNode p1 = (MyTreeNode)element$iv2;
                boolean bl9 = false;
                p1.pack$intellij_profiler_common();
            }
        }
        return this.forest;
    }

    private final <T> long ownValue(MyTreeNode<T> $this$ownValue) {
        return $this$ownValue.getValue() - SequencesKt.sumOfLong((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$ownValue.getChildren()), (Function1)ownValue.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> MyTreeNode<T> mergeChildren(MyTreeNode<T> node2) {
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv3;
        Collection $this$groupBy$iv;
        Object[] objectArray;
        boolean bl = node2.getRoot() == node2 && node2.getParent() == null && node2.getData() == null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        MyTreeNode myTreeNode = new MyTreeNode(node2.get_call(), node2.getValue(), node2.getDepth(), null, null, 24, null);
        bl3 = false;
        bl4 = false;
        MyTreeNode it = myTreeNode;
        boolean bl6 = false;
        it.setRoot(it);
        MyTreeNode newRoot = myTreeNode;
        Iterable iterable = node2.getChildren();
        int n = 0;
        MyTreeNode myTreeNode2 = newRoot;
        int n2 = 0;
        Object[] objectArray2 = objectArray = new StackFrame[1];
        boolean $i$f$groupBy = false;
        it = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv3) {
            Object object;
            MyTreeNode it2 = (MyTreeNode)element$iv$iv;
            boolean bl7 = false;
            Object key$iv$iv = it2.get_call();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl8 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map map2 = destination$iv$iv;
        List list2 = CollectionsKt.toList((Iterable)map2.values());
        int n3 = n;
        MyTreeNode myTreeNode3 = myTreeNode2;
        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00070\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001b\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00070\u0007H\u00c6\u0003JP\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00070\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"com/intellij/profiler/BaseCallTreeBuilder$mergeChildren$StackFrame", "", "node", "Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;", "nextGroupedChild", "", "groupedOriginal", "", "(Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;ILjava/util/List;)V", "getGroupedOriginal", "()Ljava/util/List;", "getNextGroupedChild", "()I", "setNextGroupedChild", "(I)V", "getNode", "()Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;", "component1", "component2", "component3", "copy", "(Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;ILjava/util/List;)Lcom/intellij/profiler/BaseCallTreeBuilder$mergeChildren$StackFrame;", "equals", "", "other", "hashCode", "toString", "", "intellij.profiler.common"})
        public final class StackFrame {
            @NotNull
            private final MyTreeNode<T> node;
            private int nextGroupedChild;
            @NotNull
            private final List<List<MyTreeNode<T>>> groupedOriginal;

            @NotNull
            public final MyTreeNode<T> getNode() {
                return this.node;
            }

            public final int getNextGroupedChild() {
                return this.nextGroupedChild;
            }

            public final void setNextGroupedChild(int n) {
                this.nextGroupedChild = n;
            }

            @NotNull
            public final List<List<MyTreeNode<T>>> getGroupedOriginal() {
                return this.groupedOriginal;
            }

            public StackFrame(@NotNull MyTreeNode<T> node2, int nextGroupedChild, @NotNull List<? extends List<MyTreeNode<T>>> groupedOriginal) {
                Intrinsics.checkNotNullParameter(node2, (String)"node");
                Intrinsics.checkNotNullParameter(groupedOriginal, (String)"groupedOriginal");
                this.node = node2;
                this.nextGroupedChild = nextGroupedChild;
                this.groupedOriginal = groupedOriginal;
            }

            @NotNull
            public final MyTreeNode<T> component1() {
                return this.node;
            }

            public final int component2() {
                return this.nextGroupedChild;
            }

            @NotNull
            public final List<List<MyTreeNode<T>>> component3() {
                return this.groupedOriginal;
            }

            @NotNull
            public final StackFrame copy(@NotNull MyTreeNode<T> node2, int nextGroupedChild, @NotNull List<? extends List<MyTreeNode<T>>> groupedOriginal) {
                Intrinsics.checkNotNullParameter(node2, (String)"node");
                Intrinsics.checkNotNullParameter(groupedOriginal, (String)"groupedOriginal");
                return new StackFrame(node2, nextGroupedChild, groupedOriginal);
            }

            public static /* synthetic */ StackFrame copy$default(StackFrame stackFrame, MyTreeNode myTreeNode, int n, List list2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    myTreeNode = stackFrame.node;
                }
                if ((n2 & 2) != 0) {
                    n = stackFrame.nextGroupedChild;
                }
                if ((n2 & 4) != 0) {
                    list2 = stackFrame.groupedOriginal;
                }
                return stackFrame.copy(myTreeNode, n, list2);
            }

            @NotNull
            public String toString() {
                return "StackFrame(node=" + this.node + ", nextGroupedChild=" + this.nextGroupedChild + ", groupedOriginal=" + this.groupedOriginal + ")";
            }

            public int hashCode() {
                MyTreeNode<T> myTreeNode = this.node;
                List<List<MyTreeNode<T>>> list2 = this.groupedOriginal;
                return ((myTreeNode != null ? myTreeNode.hashCode() : 0) * 31 + Integer.hashCode(this.nextGroupedChild)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StackFrame)) break block3;
                        StackFrame stackFrame = (StackFrame)object;
                        if (!Intrinsics.areEqual(this.node, stackFrame.node) || this.nextGroupedChild != stackFrame.nextGroupedChild || !Intrinsics.areEqual(this.groupedOriginal, stackFrame.groupedOriginal)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        objectArray[n2] = new StackFrame(myTreeNode3, n3, list2);
        List stack = CollectionsKt.mutableListOf((Object[])objectArray2);
        while (true) {
            void $this$groupByTo$iv$iv2;
            void $this$groupBy$iv2;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Object object;
            Collection<Long> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$groupBy$iv = stack;
            $i$f$groupBy = false;
            if (!(!$this$groupBy$iv.isEmpty())) break;
            StackFrame top = (StackFrame)CollectionsKt.last((List)stack);
            if (top.getNextGroupedChild() > CollectionsKt.getLastIndex(top.getGroupedOriginal())) {
                top.getNode().pack$intellij_profiler_common();
                stack.remove(CollectionsKt.getLastIndex((List)stack));
                continue;
            }
            List group2 = top.getGroupedOriginal().get(top.getNextGroupedChild());
            StackFrame stackFrame = top;
            int $this$groupByTo$iv$iv3 = stackFrame.getNextGroupedChild();
            stackFrame.setNextGroupedChild($this$groupByTo$iv$iv3 + 1);
            destination$iv$iv = group2;
            Object object2 = ((MyTreeNode)CollectionsKt.first(group2)).get_call();
            boolean $i$f$map22 = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                $this$getOrPut$iv$iv$iv = (MyTreeNode)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl9 = false;
                object = it3.getValue();
                collection.add((Long)object);
            }
            collection = (List)destination$iv$iv2;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n4 = 24;
            MyTreeNode myTreeNode4 = null;
            MyTreeNode myTreeNode5 = null;
            int n5 = ((MyTreeNode)CollectionsKt.first(group2)).getDepth();
            long l = CollectionsKt.sumOfLong((Iterable)collection);
            Object t = object2;
            MyTreeNode child2 = new MyTreeNode(t, l, n5, myTreeNode5, myTreeNode4, n4, defaultConstructorMarker);
            Collection collection2 = stack;
            Iterable $i$f$map22 = group2;
            int n6 = 0;
            object2 = child2;
            boolean $i$f$flatMap = false;
            destination$iv$iv2 = $this$flatMap$iv;
            Object destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MyTreeNode it4 = (MyTreeNode)element$iv$iv;
                boolean bl10 = false;
                Iterable list$iv$iv = it4.getChildren();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            object = (List)destination$iv$iv3;
            $this$flatMap$iv = (Iterable)object;
            boolean $i$f$groupBy2 = false;
            $this$flatMapTo$iv$iv = $this$groupBy$iv2;
            destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object3;
                MyTreeNode it5 = (MyTreeNode)element$iv$iv;
                boolean bl11 = false;
                Object key$iv$iv = it5.get_call();
                Object $this$getOrPut$iv$iv$iv2 = destination$iv$iv3;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl12 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv3;
            List list3 = CollectionsKt.toList((Iterable)object.values());
            int n7 = n6;
            Object object4 = object2;
            StackFrame stackFrame2 = new StackFrame(object4, n7, list3);
            boolean bl13 = false;
            collection2.add(stackFrame2);
            top.getNode().addChild$intellij_profiler_common(child2);
        }
        return newRoot;
    }

    private final <T, R> TreeTransformer<CallWithValue<T>, MyTreeNode<T>, CallWithValue<R>, MyTreeNode<R>> createTransformer(Function1<? super T, ? extends Transformation<R>> transformer) {
        return new TreeTransformer<CallWithValue<? extends T>, MyTreeNode<T>, CallWithValue<? extends R>, MyTreeNode<R>>(transformer){
            final /* synthetic */ Function1 $transformer;

            public boolean preConditionChecker(@NotNull MyTreeNode<T> node2) {
                Intrinsics.checkNotNullParameter(node2, (String)"node");
                return Intrinsics.areEqual(node2.getRoot(), node2) && node2.getParent() == null && node2.getDepth() == 0;
            }

            @NotNull
            public List<MyTreeNode<T>> children(@NotNull MyTreeNode<T> node2) {
                Intrinsics.checkNotNullParameter(node2, (String)"node");
                return node2.getChildren();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Transformation<MyTreeNode<R>> transform(@NotNull MyTreeNode<T> node2) {
                void $this$mapIndexedTo$iv$iv;
                Intrinsics.checkNotNullParameter(node2, (String)"node");
                if (node2.get_call() == null) {
                    MyTreeNode<T> myTreeNode = new MyTreeNode<T>(null, node2.getValue(), node2.getDepth(), null, null, 24, null);
                    boolean bl = false;
                    boolean bl2 = false;
                    MyTreeNode<T> it = myTreeNode;
                    boolean bl3 = false;
                    it.setRoot(it);
                    Unit unit = Unit.INSTANCE;
                    MyTreeNode<T> myTreeNode2 = myTreeNode;
                    return new Transformation.Single<MyTreeNode<T>>(myTreeNode2);
                }
                Iterable $this$mapIndexed$iv = ((Transformation)this.$transformer.invoke(node2.get_call())).getList();
                boolean $i$f$mapIndexed = false;
                Iterable it = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void i2;
                    void r;
                    int n = index$iv$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    T t = item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    MyTreeNode<T> myTreeNode = new MyTreeNode<T>(r, node2.getValue(), node2.getDepth() + i2, null, null, 24, null);
                    collection.add(myTreeNode);
                }
                List treeNodes = (List)destination$iv$iv;
                return new Transformation.ListOf<ResultType>(treeNodes);
            }

            public void postProcess(@NotNull MyTreeNode<R> alreadyMappedParent, @NotNull MyTreeNode<R> node2) {
                Intrinsics.checkNotNullParameter(alreadyMappedParent, (String)"alreadyMappedParent");
                Intrinsics.checkNotNullParameter(node2, (String)"node");
                alreadyMappedParent.addChild$intellij_profiler_common(node2);
            }
            {
                this.$transformer = $captured_local_variable$0;
            }
        };
    }

    @Override
    @NotNull
    public Iterable<Stack<ElementType>> getAllStacks() {
        Map<ThreadInfo, MyTreeNode<ElementType>> $this$filterKeys$iv = this.forest;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<ThreadInfo, MyTreeNode<ElementType>> result$iv = new LinkedHashMap<ThreadInfo, MyTreeNode<ElementType>>();
        Map<ThreadInfo, MyTreeNode<ElementType>> map2 = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry<ThreadInfo, MyTreeNode<ElementType>> entry$iv : map2.entrySet()) {
            ThreadInfo it = entry$iv.getKey();
            boolean bl2 = false;
            if (!(it != AllThreadsMerged.INSTANCE)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        JBIterable jBIterable = JBIterable.from((Iterable)((Map)result$iv).entrySet()).flatMap(new Function(this){
            final /* synthetic */ BaseCallTreeBuilder this$0;

            /*
             * WARNING - void declaration
             */
            public final Iterable<Stack<ElementType>> fun(Map.Entry<? extends ThreadInfo, MyTreeNode<ElementType>> $dstr$thread$tree) {
                void thread2;
                Map.Entry<ThreadInfo, MyTreeNode<ElementType>> entry2 = $dstr$thread$tree;
                boolean bl = false;
                ThreadInfo threadInfo = entry2.getKey();
                entry2 = $dstr$thread$tree;
                bl = false;
                MyTreeNode<ElementType> tree = entry2.getValue();
                return (Iterable)TreeUtilKt.allNodesIterable((TreeNode)tree).map(new Function(this){
                    final /* synthetic */ getAllStacks.2 this$0;

                    public final Pair<MyTreeNode<ElementType>, Long> fun(MyTreeNode<ElementType> it) {
                        BaseCallTreeBuilder baseCallTreeBuilder = this.this$0.this$0;
                        MyTreeNode<ElementType> myTreeNode = it;
                        Intrinsics.checkNotNullExpressionValue(myTreeNode, (String)"it");
                        return TuplesKt.to(it, (Object)BaseCallTreeBuilder.access$ownValue(baseCallTreeBuilder, myTreeNode));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).filter((Condition)getAllStacks.2.INSTANCE).map(new Function((ThreadInfo)thread2){
                    final /* synthetic */ ThreadInfo $thread;

                    /*
                     * WARNING - void declaration
                     */
                    public final Stack<ElementType> fun(Pair<MyTreeNode<ElementType>, Long> $dstr$n$ownValue) {
                        void n;
                        MyTreeNode myTreeNode = (MyTreeNode)$dstr$n$ownValue.component1();
                        long ownValue2 = ((Number)$dstr$n$ownValue.component2()).longValue();
                        JBIterable jBIterable = TreeNodeKt.parentsIterable((TreeNodeWithParent)n).map((Function)getAllStacks.1.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"n.parentsIterable().map { it._call }");
                        return new Stack<FrameType>(this.$thread, CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)CollectionsKt.reversed((Iterable)((Iterable)jBIterable)), n.get_call())), ownValue2);
                    }
                    {
                        this.$thread = threadInfo;
                    }
                });
            }
            {
                this.this$0 = baseCallTreeBuilder;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(forest.f\u2026, ownValue)\n      }\n    }");
        return (Iterable)jBIterable;
    }

    public BaseCallTreeBuilder() {
        boolean bl = false;
        this.forest = new HashMap();
        this.metric = SamplesCountMetric.INSTANCE;
    }

    public static final /* synthetic */ long access$ownValue(BaseCallTreeBuilder $this, MyTreeNode $this$access_u24ownValue) {
        return $this.ownValue($this$access_u24ownValue);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0004\u0018\u0000 @*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001@BC\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0000\u00a2\u0006\u0002\b+J!\u0010,\u001a\u00020)2\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000.H\u0000\u00a2\u0006\u0002\b/J\u001b\u00100\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0000\u00a2\u0006\u0002\b1J\u001b\u00102\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010\u0011\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00103J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0016J\u001b\u00106\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010\u0011\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00103J\u001d\u00107\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u00108\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\b9\u0010:J\r\u0010;\u001a\u00020)H\u0000\u00a2\u0006\u0002\b<J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0016J\b\u0010>\u001a\u00020?H\u0016R\u0015\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00028\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR \u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006A"}, d2={"Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;", "T", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/model/CallWithValue;", "_call", "value", "", "depth", "", "root", "parent", "(Ljava/lang/Object;JILcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;)V", "get_call", "()Ljava/lang/Object;", "Ljava/lang/Object;", "_children", "", "call", "getCall", "children", "", "getChildren", "()Ljava/util/List;", "data", "getData", "()Lcom/intellij/profiler/model/CallWithValue;", "getDepth", "()I", "setDepth", "(I)V", "getParent", "()Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;", "setParent", "(Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;)V", "getRoot", "setRoot", "getValue", "()J", "setValue", "(J)V", "add", "", "child", "add$intellij_profiler_common", "addAll", "values", "", "addAll$intellij_profiler_common", "addChild", "addChild$intellij_profiler_common", "excludeCall", "(Ljava/lang/Object;)Lcom/intellij/profiler/model/CallTreeNode;", "excludeSubTree", "node", "focusOnCall", "getOrCreateChild", "elem", "getOrCreateChild$intellij_profiler_common", "(Ljava/lang/Object;)Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;", "pack", "pack$intellij_profiler_common", "subTree", "toString", "", "Companion", "intellij.profiler.common"})
    protected static final class MyTreeNode<T>
    implements CallTreeNode<T>,
    CallWithValue<T> {
        private Object _children;
        @Nullable
        private final T _call;
        private long value;
        private int depth;
        @Nullable
        private MyTreeNode<T> root;
        @Nullable
        private MyTreeNode<T> parent;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @Nullable
        public CallWithValue<T> getData() {
            return this._call != null ? (CallWithValue)this : null;
        }

        @Override
        public T getCall() {
            T t = this._call;
            Intrinsics.checkNotNull(t);
            return t;
        }

        @Override
        @NotNull
        public List<MyTreeNode<T>> getChildren() {
            List list2;
            Object object = this._children;
            if (object == null) {
                list2 = CollectionsKt.emptyList();
            } else if (object instanceof MyTreeNode) {
                Object object2 = this._children;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.BaseCallTreeBuilder.MyTreeNode<T>");
                }
                list2 = CollectionsKt.listOf((Object)((MyTreeNode)object2));
            } else if (object instanceof Object[]) {
                Object object3 = this._children;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<com.intellij.profiler.BaseCallTreeBuilder.MyTreeNode<T>>");
                }
                list2 = ArraysKt.asList((Object[])((MyTreeNode[])object3));
            } else {
                Object object4 = this._children;
                if (object4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.intellij.profiler.BaseCallTreeBuilder.MyTreeNode<T>>");
                }
                list2 = (List)object4;
            }
            return list2;
        }

        @Override
        @NotNull
        public CallTreeNode<T> subTree() {
            return Intrinsics.areEqual(this.root, (Object)this) ? (CallTreeNode)this : (CallTreeNode)ProxyCallTreeNodeImpl.Companion.createSubTreeFrom(this);
        }

        @Override
        @NotNull
        public CallTreeNode<T> excludeSubTree(@NotNull CallTreeNode<T> node2) {
            Intrinsics.checkNotNullParameter(node2, (String)"node");
            MyTreeNode<T> myTreeNode = this.root;
            Intrinsics.checkNotNull(myTreeNode);
            return ProxyCallTreeNodeImpl.Companion.createFrom(myTreeNode).excludeSubTree((CallTreeNode)node2);
        }

        @Override
        @NotNull
        public CallTreeNode<T> excludeCall(T call) {
            MyTreeNode<T> myTreeNode = this.root;
            Intrinsics.checkNotNull(myTreeNode);
            return ProxyCallTreeNodeImpl.Companion.createFrom(myTreeNode).excludeCall((Object)call);
        }

        @Override
        @NotNull
        public CallTreeNode<T> focusOnCall(T call) {
            MyTreeNode<T> myTreeNode = this.root;
            Intrinsics.checkNotNull(myTreeNode);
            return ProxyCallTreeNodeImpl.Companion.createFrom(myTreeNode).focusOnCall((Object)call);
        }

        /*
         * WARNING - void declaration
         */
        public final void pack$intellij_profiler_common() {
            if (this._children instanceof List) {
                Object object = this._children;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.intellij.profiler.BaseCallTreeBuilder.MyTreeNode<T>>");
                }
                List list2 = (List)object;
                switch (list2.size()) {
                    case 0: {
                        this._children = null;
                        break;
                    }
                    case 1: {
                        this._children = list2.get(0);
                        break;
                    }
                    default: {
                        void it;
                        Collection $this$toTypedArray$iv = list2;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        MyTreeNode[] myTreeNodeArray = thisCollection$iv.toArray(new MyTreeNode[0]);
                        if (myTreeNodeArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        MyTreeNode[] myTreeNodeArray2 = myTreeNodeArray;
                        boolean bl = false;
                        boolean bl2 = false;
                        MyTreeNode[] myTreeNodeArray3 = myTreeNodeArray2;
                        MyTreeNode myTreeNode = this;
                        boolean bl3 = false;
                        void $this$sortByDescending$iv = it;
                        boolean $i$f$sortByDescending = false;
                        if (((void)$this$sortByDescending$iv).length > 1) {
                            boolean bl4 = false;
                            ArraysKt.sortWith((Object[])$this$sortByDescending$iv, (Comparator)new Comparator<T>(){

                                public final int compare(T a, T b) {
                                    boolean bl = false;
                                    T receiver = b;
                                    boolean bl2 = false;
                                    Comparable comparable = Long.valueOf(((MyTreeNode)receiver).getValue());
                                    receiver = a;
                                    Comparable comparable2 = comparable;
                                    bl2 = false;
                                    Long l = ((MyTreeNode)receiver).getValue();
                                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                                }
                            });
                        }
                        Unit unit = Unit.INSTANCE;
                        myTreeNode._children = myTreeNodeArray2;
                    }
                }
            }
        }

        public final void add$intellij_profiler_common(@NotNull MyTreeNode<T> child2) {
            Intrinsics.checkNotNullParameter(child2, (String)"child");
            Object object = this._children;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.profiler.BaseCallTreeBuilder.MyTreeNode<T>>");
            }
            TypeIntrinsics.asMutableList((Object)object).add(child2);
        }

        public final void addAll$intellij_profiler_common(@NotNull Collection<MyTreeNode<T>> values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Object object = this._children;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.profiler.BaseCallTreeBuilder.MyTreeNode<T>>");
            }
            TypeIntrinsics.asMutableList((Object)object).addAll(values2);
        }

        @NotNull
        public final MyTreeNode<T> getOrCreateChild$intellij_profiler_common(T elem) {
            Object object;
            Object v1;
            boolean bl;
            Object object2;
            block3: {
                Object object3 = this._children;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.profiler.BaseCallTreeBuilder.MyTreeNode<T>>");
                }
                List list2 = TypeIntrinsics.asMutableList((Object)object3);
                object2 = list2;
                boolean bl2 = false;
                Iterable iterable = object2;
                bl = false;
                for (Object t : iterable) {
                    MyTreeNode it = (MyTreeNode)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it._call, elem)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            if ((object = (MyTreeNode)v1) == null) {
                object2 = new MyTreeNode<T>(elem, 0L, this.getDepth() + 1, this.root, this);
                MyTreeNode myTreeNode = this;
                boolean bl4 = false;
                bl = false;
                Object p1 = object2;
                boolean bl5 = false;
                myTreeNode.add$intellij_profiler_common((MyTreeNode<T>)p1);
                object = object2;
            }
            return object;
        }

        public final void addChild$intellij_profiler_common(@NotNull MyTreeNode<T> child2) {
            Intrinsics.checkNotNullParameter(child2, (String)"child");
            this.add$intellij_profiler_common(child2);
            child2.setParent(this);
            child2.root = this.root;
        }

        @NotNull
        public String toString() {
            T t = this._call;
            if (t == null || (t = t.toString()) == null) {
                t = "root";
            }
            return t;
        }

        @Nullable
        public final T get_call() {
            return this._call;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        public void setValue(long l) {
            this.value = l;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int n) {
            this.depth = n;
        }

        @Nullable
        public final MyTreeNode<T> getRoot() {
            return this.root;
        }

        public final void setRoot(@Nullable MyTreeNode<T> myTreeNode) {
            this.root = myTreeNode;
        }

        @Override
        @Nullable
        public MyTreeNode<T> getParent() {
            return this.parent;
        }

        public void setParent(@Nullable MyTreeNode<T> myTreeNode) {
            this.parent = myTreeNode;
        }

        public MyTreeNode(@Nullable T _call, long value2, int depth, @Nullable MyTreeNode<T> root, @Nullable MyTreeNode<T> parent) {
            this._call = _call;
            this.value = value2;
            this.depth = depth;
            this.root = root;
            this.parent = parent;
            boolean bl = false;
            this._children = new ArrayList();
        }

        public /* synthetic */ MyTreeNode(Object object, long l, int n, MyTreeNode myTreeNode, MyTreeNode myTreeNode2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                myTreeNode = null;
            }
            if ((n2 & 0x10) != 0) {
                myTreeNode2 = null;
            }
            this(object, l, n, myTreeNode, myTreeNode2);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode$Companion;", "", "()V", "root", "Lcom/intellij/profiler/BaseCallTreeBuilder$MyTreeNode;", "T", "intellij.profiler.common"})
        public static final class Companion {
            @NotNull
            public final <T> MyTreeNode<T> root() {
                MyTreeNode myTreeNode = new MyTreeNode(null, 0L, 0, null, null, 24, null);
                boolean bl = false;
                boolean bl2 = false;
                MyTreeNode it = myTreeNode;
                boolean bl3 = false;
                it.setRoot(it);
                return myTreeNode;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

