/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profiler.sudo.ExecSudoCommandKt;
import com.intellij.profiler.sudo.SendResult;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005\u001a\"\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getChildrenProcessIDs", "", "", "myPid", "isProcessAlive", "", "pid", "killSudoProcessTreeSync", "process", "Ljava/lang/Process;", "sudoPassword", "", "signal", "intellij.profiler.common"})
public final class ProcessUtilKt {
    private static final Logger LOG;

    public static final boolean isProcessAlive(int pid2) {
        Optional<ProcessHandle> optional = ProcessHandle.of(pid2);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ProcessHandle.of(pid.toLong())");
        return optional.isPresent();
    }

    public static final boolean killSudoProcessTreeSync(@NotNull Process process2, @NotNull String sudoPassword, int signal) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)sudoPassword, (String)"sudoPassword");
        int pid2 = OSProcessUtil.getProcessID((Process)process2);
        List<Integer> children2 = ProcessUtilKt.getChildrenProcessIDs(pid2);
        if (children2.isEmpty()) {
            LOG.warn("Can't find children of process " + pid2 + " (sudo process)");
        } else if (children2.size() > 1) {
            LOG.warn("Too many children of process " + pid2 + ": " + children2 + ". Will kill all of them anyway");
        }
        Iterable $this$forEach$iv = children2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            ExecSudoCommandKt.sudoSendSignal(it, signal, sudoPassword);
        }
        if (process2.isAlive()) {
            return ExecSudoCommandKt.sudoSendSignal(pid2, signal, sudoPassword) != SendResult.FAILED;
        }
        return true;
    }

    public static /* synthetic */ boolean killSudoProcessTreeSync$default(Process process2, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 9;
        }
        return ProcessUtilKt.killSudoProcessTreeSync(process2, string, n);
    }

    @NotNull
    public static final List<Integer> getChildrenProcessIDs(int myPid) {
        boolean bl = false;
        List list2 = new ArrayList();
        UnixProcessManager.processPSOutput((String[])UnixProcessManager.getPSCmd((boolean)false), (Processor)new Processor(myPid, list2){
            final /* synthetic */ int $myPid;
            final /* synthetic */ List $list;

            public final boolean process(String line) {
                StringTokenizer st = new StringTokenizer(line, " ");
                String string = st.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"st.nextToken()");
                Integer parentPid = StringsKt.toIntOrNull((String)string);
                String string2 = st.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"st.nextToken()");
                Integer pid2 = StringsKt.toIntOrNull((String)string2);
                Integer n = parentPid;
                if (n != null && n == this.$myPid && pid2 != null) {
                    Collection collection = this.$list;
                    boolean bl = false;
                    collection.add(pid2);
                }
                return true;
            }
            {
                this.$myPid = n;
                this.$list = list2;
            }
        });
        return list2;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.profiler.dummy.ProcessUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026filer.dummy.ProcessUtil\")");
        LOG = logger;
    }
}

