/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.ProfilerManagerKt;
import com.intellij.profiler.api.AttachCanceledException;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.ProfilerAlreadyStartedException;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0010\b\u0000\u0010\u0002*\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"installErrorHandlers", "Lorg/jetbrains/concurrency/Promise;", "P", "Lcom/intellij/profiler/api/ProfilerProcess;", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.common"})
public final class ProfilerManagerKt {
    @NotNull
    public static final <P extends ProfilerProcess<? extends ProfilerTargetProcess>> Promise<P> installErrorHandlers(@NotNull Promise<P> $this$installErrorHandlers, @NotNull Project project) {
        Intrinsics.checkNotNullParameter($this$installErrorHandlers, (String)"$this$installErrorHandlers");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Promise promise = $this$installErrorHandlers.onError(new java.util.function.Consumer(project){
            final /* synthetic */ Project $project;

            public final void accept(Throwable err) {
                Throwable throwable = err;
                if (throwable instanceof MisConfiguredException) {
                    ProfilerManager.INSTANCE.showStickyError(((MisConfiguredException)((Object)err)).getUserFriendlyMessage(), this.$project, DumbAwareAction.create((String)((MisConfiguredException)((Object)err)).getFixActionName(), (Consumer)new Consumer(this, err){
                        final /* synthetic */ installErrorHandlers.1 this$0;
                        final /* synthetic */ Throwable $err;

                        public final void consume(AnActionEvent it) {
                            ((MisConfiguredException)((Object)this.$err)).fixAction(this.this$0.$project);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$err = throwable;
                        }
                    }));
                } else if (throwable instanceof AttachFailedException) {
                    ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, ((AttachFailedException)err).getUserFriendlyMessage(), this.$project, null, 4, null);
                } else if (throwable instanceof ProfilerAlreadyStartedException) {
                    ProfilerManager.INSTANCE.showStickyInfo(((ProfilerAlreadyStartedException)err).getUserFriendlyMessage(), this.$project);
                } else if (!(throwable instanceof AttachCanceledException)) {
                    String string = err.getMessage();
                    if (string == null) {
                        string = CommonProfilerBundleKt.profilerMessage("profiler.exceptions.attach.failed", new Object[0]);
                    }
                    ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, string, this.$project, null, 4, null);
                }
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"this.onError { err ->\n  \u2026roject)\n      }\n    }\n  }");
        return promise;
    }
}

