/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.SnapshotFile;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.ProfilerDumpWriterBase;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t\u001a\u0013\u0010\u000e\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0016\u0010\u0016\u001a\u00020\t*\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\tH\u0007\u001a\n\u0010\u0019\u001a\u00020\u0011*\u00020\t\u001a\n\u0010\u001a\u001a\u00020\u000b*\u00020\t\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001b"}, d2={"profilerDumpsDir", "Ljava/io/File;", "getProfilerDumpsDir", "()Ljava/io/File;", "profilerDumpsDir$delegate", "Lkotlin/Lazy;", "createSnapshotFile", "Lcom/intellij/profiler/SnapshotFile;", "name", "", "timestamp", "", "type", "ext", "dtraceOutputFile", "Lorg/jetbrains/annotations/NotNull;", "pid", "", "getDefaultSnapshotFolder", "Ljava/nio/file/Path;", "keepTempProfilerFiles", "", "explain", "", "prefix", "parseHexInt", "parseHexLong", "intellij.profiler.common"})
public final class UtilsKt {
    private static final Lazy profilerDumpsDir$delegate = LazyKt.lazy((Function0)profilerDumpsDir.2.INSTANCE);

    public static final long parseHexLong(@NotNull String $this$parseHexLong) {
        Intrinsics.checkNotNullParameter((Object)$this$parseHexLong, (String)"$this$parseHexLong");
        String string = StringsKt.startsWith$default((String)$this$parseHexLong, (String)"0x", (boolean)false, (int)2, null) ? StringsKt.drop((String)$this$parseHexLong, (int)2) : $this$parseHexLong;
        int n = 16;
        boolean bl = false;
        return Long.parseLong(string, CharsKt.checkRadix((int)n));
    }

    public static final int parseHexInt(@NotNull String $this$parseHexInt) {
        Intrinsics.checkNotNullParameter((Object)$this$parseHexInt, (String)"$this$parseHexInt");
        String string = StringsKt.startsWith$default((String)$this$parseHexInt, (String)"0x", (boolean)false, (int)2, null) ? StringsKt.drop((String)$this$parseHexInt, (int)2) : $this$parseHexInt;
        int n = 16;
        boolean bl = false;
        return Integer.parseInt(string, CharsKt.checkRadix((int)n));
    }

    public static final boolean keepTempProfilerFiles() {
        Application application = ApplicationManager.getApplication();
        boolean bl = false;
        boolean bl2 = false;
        Application it = application;
        boolean bl3 = false;
        Application application2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"it");
        return application2.isInternal() || it.isUnitTestMode();
    }

    @NotNull
    public static final File dtraceOutputFile(int pid2) {
        File file2 = FileUtil.createTempFile((File)UtilsKt.getProfilerDumpsDir(), (String)("raw-dtrace-" + pid2), (String)".dump", (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\u2026d\", \".dump\", true, false)");
        return file2;
    }

    private static final File getProfilerDumpsDir() {
        Lazy lazy = profilerDumpsDir$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    @NlsSafe
    @NotNull
    public static final String explain(@NotNull Throwable $this$explain, @Nls @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)$this$explain, (String)"$this$explain");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        CharSequence charSequence = prefix2;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0;
        bl = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl2 = false;
        bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        bl3 = false;
        bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl6 = false;
        $this$buildString.append(prefix2);
        if ($this$explain.getMessage() != null) {
            $this$buildString.append(": " + $this$explain.getMessage());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final SnapshotFile createSnapshotFile(@NotNull String name, long timestamp, @NotNull String type, @NotNull String ext) {
        Object object;
        File dumpFile;
        boolean temp;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
                temp = false;
                dumpFile = null;
                object = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getSnapshotOptions().getFolder();
                if (object == null) break block5;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object p1 = object2;
                boolean bl3 = false;
                CharSequence charSequence = (CharSequence)p1;
                boolean bl4 = false;
                object = !StringsKt.isBlank((CharSequence)charSequence) ? object2 : null;
                if (object == null) break block5;
                object2 = object;
                bl = false;
                bl2 = false;
                p1 = object2;
                boolean bl5 = false;
                object = Path.of((String)p1, new String[0]);
                if (object != null) break block6;
            }
            object = UtilsKt.getDefaultSnapshotFolder();
        }
        Object snapshotsFolder = object;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode() && PathKt.exists((Path)snapshotsFolder)) {
            String dumpFileName2 = new ProfilerDumpWriterBase(name, timestamp, name, timestamp, null){
                final /* synthetic */ String $name;
                final /* synthetic */ long $timestamp;

                public void writeDump(@NotNull File outputFile, @NotNull ProgressIndicator indicator2) {
                    Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
                    Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                }
                {
                    this.$name = $captured_local_variable$0;
                    this.$timestamp = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                }
            }.getDumpFileName();
            temp = false;
            File file2 = FileUtil.findSequentNonexistentFile((File)snapshotsFolder.toFile(), (String)FileUtil.sanitizeFileName((String)dumpFileName2), (String)ext);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.findSequentNone\u2026eName(dumpFileName), ext)");
            dumpFile = file2;
        } else {
            temp = true;
            File file3 = FileUtil.createTempFile((String)type, (String)('.' + ext), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"FileUtil.createTempFile(type, \".$ext\", true)");
            dumpFile = file3;
        }
        return new SnapshotFile(dumpFile, temp);
    }

    @NotNull
    public static final Path getDefaultSnapshotFolder() {
        String string = System.getProperty("snapshots.path", SystemProperties.getUserHome());
        boolean bl = false;
        boolean bl2 = false;
        String p1 = string;
        boolean bl3 = false;
        Path path2 = Path.of(p1, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"System.getProperty(\"snap\u2026UserHome()).let(Path::of)");
        return path2;
    }
}

