/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.charts;

import com.intellij.profiler.charts.ChartWrapper;
import com.intellij.profiler.charts.ChartWrapperKt;
import com.intellij.profiler.charts.Coordinates;
import com.intellij.profiler.charts.Grid;
import com.intellij.profiler.charts.GridLine;
import com.intellij.profiler.charts.MinMax;
import com.intellij.profiler.charts.ValueIterable;
import com.intellij.profiler.charts.XYChartComponent;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\"H\u0014J-\u0010#\u001a\u00020\u001e2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030 2\u0006\u0010%\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010&J-\u0010'\u001a\u00020\u001e2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030 2\u0006\u0010(\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010&J\u0014\u0010)\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*H&J)\u0010+\u001a\u00020\u001e2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*2\u0006\u0010%\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010-J)\u0010.\u001a\u00020\u001e2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*2\u0006\u0010(\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010-J,\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\"2\u0006\u00101\u001a\u00020\"2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*H\u0004R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0018\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R\u001e\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\n\u00a8\u00062"}, d2={"Lcom/intellij/profiler/charts/GridChartWrapper;", "X", "", "Y", "Lcom/intellij/profiler/charts/ChartWrapper;", "Lcom/intellij/profiler/charts/XYChartComponent;", "()V", "grid", "Lcom/intellij/profiler/charts/Grid;", "getGrid", "()Lcom/intellij/profiler/charts/Grid;", "gridColor", "Ljava/awt/Color;", "getGridColor", "()Ljava/awt/Color;", "setGridColor", "(Ljava/awt/Color;)V", "gridHeight", "", "getGridHeight", "()I", "gridLabelColor", "getGridLabelColor", "setGridLabelColor", "gridWidth", "getGridWidth", "ranges", "getRanges", "findGridLabelOffset", "Lcom/intellij/profiler/charts/Coordinates;", "", "line", "Lcom/intellij/profiler/charts/GridLine;", "g", "Ljava/awt/Graphics2D;", "findGridLineX", "gl", "x", "(Lcom/intellij/profiler/charts/GridLine;Ljava/lang/Number;)D", "findGridLineY", "y", "findMinMax", "Lcom/intellij/profiler/charts/MinMax;", "findX", "xy", "(Lcom/intellij/profiler/charts/MinMax;Ljava/lang/Number;)D", "findY", "paintGrid", "", "chart", "intellij.profiler.common"})
public abstract class GridChartWrapper<X extends Number, Y extends Number>
extends ChartWrapper
implements XYChartComponent<X, Y> {
    @NotNull
    private Color gridColor = (Color)new JBColor(new Color(0xF0F0F0), new Color(0x313335));
    @NotNull
    private Color gridLabelColor;

    @Override
    @NotNull
    public abstract Grid<X, Y> getRanges();

    @NotNull
    public final Grid<X, Y> getGrid() {
        return this.getRanges();
    }

    public final int getGridWidth() {
        return this.getWidth() - (this.getMargins().left + this.getMargins().right);
    }

    public final int getGridHeight() {
        return this.getHeight() - (this.getMargins().top + this.getMargins().bottom);
    }

    @NotNull
    public final Color getGridColor() {
        return this.gridColor;
    }

    public final void setGridColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.gridColor = color;
    }

    @NotNull
    public final Color getGridLabelColor() {
        return this.gridLabelColor;
    }

    public final void setGridLabelColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.gridLabelColor = color;
    }

    protected final void paintGrid(@NotNull Graphics2D grid, @NotNull Graphics2D chart2, @NotNull MinMax<X, Y> xy) {
        double x;
        double y;
        Coordinates<Double, Double> coordinates;
        GridLine<X, Y, Number> gl;
        GridLine<X, Y, Number> p1;
        boolean bl;
        boolean bl2;
        Iterable<Object> $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Color gc = new Color(this.gridColor.getRGB());
        Color gcd = gc.darker();
        Rectangle bounds2 = grid.getClipBounds();
        int xOrigin = this.getRanges().getXOriginInitialized() ? (int)this.findX(xy, this.getRanges().getXOrigin()) : 0;
        int yOrigin = this.getRanges().getYOriginInitialized() ? (int)this.findY(xy, this.getRanges().getYOrigin()) : this.getHeight();
        int tmp = 0;
        tmp = -1;
        Iterable<X> iterable = this.getRanges().getXLines();
        boolean bl3 = false;
        boolean bl4 = false;
        ValueIterable<X> valueIterable = iterable;
        boolean bl5 = false;
        valueIterable.setMin(xy.getXMin());
        valueIterable.setMax(xy.getXMax());
        iterable = iterable;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            Number it = (Number)t;
            boolean bl6 = false;
            GridLine<X, Y, Number> gridLine = new GridLine<X, Y, Number>(it, xy, 1);
            Object object = this.getRanges().getXPainter();
            bl2 = false;
            bl = false;
            p1 = gridLine;
            boolean bl7 = false;
            object.accept(p1);
            gl = gridLine;
            int px = MathKt.roundToInt((double)this.findGridLineX(gl, it));
            if (gl.getPaintLine()) {
                int n = tmp - px;
                bl2 = false;
                if (Math.abs(n) < 1) continue;
                tmp = px;
                grid.setColor(gl.getMajorLine() ? gcd : gc);
                grid.drawLine(px, bounds2.y, px, bounds2.y + bounds2.height);
            }
            String string = gl.getLabel();
            if (string == null) continue;
            object = string;
            bl2 = false;
            bl = false;
            Object label2 = object;
            boolean bl8 = false;
            chart2.setColor(this.gridLabelColor);
            coordinates = this.findGridLabelOffset(gl, chart2);
            double d = coordinates.component1();
            y = coordinates.component2();
            chart2.drawString((String)label2, px + this.getMargins().left - (int)x, yOrigin - this.getMargins().bottom + (int)y);
        }
        tmp = -1;
        $this$forEach$iv = this.getRanges().getYLines();
        $i$f$forEach = false;
        boolean bl9 = false;
        ValueIterable<Y> valueIterable2 = $this$forEach$iv;
        boolean bl10 = false;
        valueIterable2.setMin(xy.getYMin());
        valueIterable2.setMax(xy.getYMax());
        $this$forEach$iv = $this$forEach$iv;
        $i$f$forEach = false;
        for (Object object : $this$forEach$iv) {
            String string;
            Number it = (Number)object;
            boolean bl11 = false;
            GridLine px = new GridLine(it, xy, 0, 4, null);
            Consumer<GridLine<X, Y, Y>> consumer = this.getRanges().getYPainter();
            bl2 = false;
            bl = false;
            p1 = px;
            boolean bl12 = false;
            consumer.accept(p1);
            gl = px;
            int py = MathKt.roundToInt((double)this.findGridLineY(gl, it));
            if (gl.getPaintLine()) {
                int n = tmp - py;
                bl2 = false;
                if (Math.abs(n) < 1) continue;
                tmp = py;
                grid.setColor(gl.getMajorLine() ? gcd : gc);
                grid.drawLine(bounds2.x, py, bounds2.x + bounds2.width, py);
            }
            if (gl.getLabel() == null) continue;
            bl2 = false;
            bl = false;
            String label2 = string;
            boolean bl13 = false;
            chart2.setColor(this.gridLabelColor);
            coordinates = this.findGridLabelOffset(gl, chart2);
            x = coordinates.component1();
            y = coordinates.component2();
            chart2.drawString(label2, xOrigin + this.getMargins().left - (int)x, py + this.getMargins().top + (int)y);
        }
    }

    protected double findGridLineX(@NotNull GridLine<X, Y, ?> gl, @NotNull X x) {
        Intrinsics.checkNotNullParameter(gl, (String)"gl");
        Intrinsics.checkNotNullParameter(x, (String)"x");
        return this.findX(gl.getXY(), x);
    }

    protected double findGridLineY(@NotNull GridLine<X, Y, ?> gl, @NotNull Y y) {
        Intrinsics.checkNotNullParameter(gl, (String)"gl");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        return this.findY(gl.getXY(), y);
    }

    @NotNull
    public abstract MinMax<X, Y> findMinMax();

    protected double findX(@NotNull MinMax<X, Y> xy, @NotNull X x) {
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Intrinsics.checkNotNullParameter(x, (String)"x");
        int width = this.getWidth() - (this.getMargins().left + this.getMargins().right);
        return (double)width * (((Number)x).doubleValue() - ((Number)xy.getXMin()).doubleValue()) / (((Number)xy.getXMax()).doubleValue() - ((Number)xy.getXMin()).doubleValue());
    }

    protected double findY(@NotNull MinMax<X, Y> xy, @NotNull Y y) {
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        int height = this.getHeight() - (this.getMargins().top + this.getMargins().bottom);
        return (double)height - (double)height * (((Number)y).doubleValue() - ((Number)xy.getYMin()).doubleValue()) / (((Number)xy.getYMax()).doubleValue() - ((Number)xy.getYMin()).doubleValue());
    }

    @NotNull
    protected Coordinates<Double, Double> findGridLabelOffset(@NotNull GridLine<?, ?, ?> line, @NotNull Graphics2D g) {
        double d;
        double d2;
        Intrinsics.checkNotNullParameter(line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        double s = JBUI.scale((int)4);
        Rectangle2D b = g.getFontMetrics().getStringBounds(line.getLabel(), null);
        switch (line.getHorizontalAlignment()) {
            case 4: {
                d2 = -s;
                break;
            }
            case 0: {
                Rectangle2D rectangle2D = b;
                Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"b");
                d2 = rectangle2D.getWidth() / (double)2;
                break;
            }
            case 2: {
                Rectangle2D rectangle2D = b;
                Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"b");
                d2 = rectangle2D.getWidth() + s;
                break;
            }
            default: {
                d2 = -s;
            }
        }
        double x = d2;
        Rectangle2D rectangle2D = b;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"b");
        double d3 = rectangle2D.getHeight();
        switch (line.getVerticalAlignment()) {
            case 1: {
                d = b.getHeight() + s;
                break;
            }
            case 0: {
                d = b.getHeight() / (double)2 + s / (double)2;
                break;
            }
            case 3: {
                d = 0.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double y = d3 - d;
        return ChartWrapperKt.to(x, y);
    }

    public GridChartWrapper() {
        Color color = ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.6);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ColorUtil.withAlpha(JBColor.foreground(), 0.6)");
        this.gridLabelColor = color;
    }
}

