/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.model;

import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.model.PersistentMetric;
import com.intellij.profiler.model.ThreadMetric;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R$\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0016\u0010\r\u001a\u00020\u00028\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0002X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/model/ThreadIdMetric;", "Lcom/intellij/profiler/model/ThreadMetric;", "", "Lcom/intellij/profiler/model/PersistentMetric;", "()V", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "isVisibleByDefault", "", "()Z", "name", "getName", "()Ljava/lang/String;", "persistentName", "getPersistentName", "represent", "value", "intellij.profiler.common"})
public final class ThreadIdMetric
extends ThreadMetric<String>
implements PersistentMetric {
    @Nls
    @NotNull
    private static final String name;
    @NotNull
    private static final Comparator<String> comparator;
    @NotNull
    private static final String persistentName;
    private static final boolean isVisibleByDefault;
    @NotNull
    public static final ThreadIdMetric INSTANCE;

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public Comparator<String> getComparator() {
        return comparator;
    }

    @Override
    @NotNull
    public String getPersistentName() {
        return persistentName;
    }

    @Override
    public boolean isVisibleByDefault() {
        return isVisibleByDefault;
    }

    @Override
    @NotNull
    public String represent(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return "id=" + value2;
    }

    private ThreadIdMetric() {
    }

    static {
        ThreadIdMetric threadIdMetric;
        INSTANCE = threadIdMetric = new ThreadIdMetric();
        name = CommonProfilerBundleKt.profilerMessage("ui.threadlist.metrics.threadId", new Object[0]);
        Comparator comparator2 = NaturalComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"NaturalComparator.INSTANCE");
        comparator = comparator2;
        persistentName = "threadIdMetric";
    }

    @Override
    public boolean isVisible() {
        return PersistentMetric.DefaultImpls.isVisible(this);
    }

    @Override
    public void setVisible(boolean bl) {
        PersistentMetric.DefaultImpls.setVisible(this, bl);
    }
}

