/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a%\u0010\u0002\u001a\u0004\u0018\u00010\u0003\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00052\u0006\u0010\u0006\u001a\u0002H\u0004\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"isUnitTest", "", "getContextMenuPointData", "Ljava/awt/Point;", "T", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "nodeContent", "(Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;Ljava/lang/Object;)Ljava/awt/Point;", "intellij.profiler.common"})
public final class FlameGraphPanelKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUnitTest() {
        if (ApplicationManager.getApplication() == null) return true;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) return false;
        return true;
    }

    @Nullable
    public static final <T> Point getContextMenuPointData(@NotNull FlameGraphPanel<T> $this$getContextMenuPointData, T nodeContent) {
        Intrinsics.checkNotNullParameter($this$getContextMenuPointData, (String)"$this$getContextMenuPointData");
        FlameGraphNode<T> flameGraphNode = $this$getContextMenuPointData.getNodeBounds(nodeContent);
        if (flameGraphNode != null) {
            FlameGraphNode<T> flameGraphNode2 = flameGraphNode;
            boolean bl = false;
            boolean bl2 = false;
            FlameGraphNode<T> rect = flameGraphNode2;
            boolean bl3 = false;
            Point point = new Point($this$getContextMenuPointData.calculateX(rect), $this$getContextMenuPointData.calculateY(rect));
            int n = $this$getContextMenuPointData.getVisibleRect().x;
            int n2 = point.x;
            boolean bl4 = false;
            point.x = Math.max(n, n2) + 1;
            point.y = point.y + $this$getContextMenuPointData.calculateHeight(rect) - 1;
            return point;
        }
        return null;
    }

    public static final /* synthetic */ boolean access$isUnitTest() {
        return FlameGraphPanelKt.isUnitTest();
    }
}

