/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.sunburst;

import com.intellij.profiler.ui.sunburst.Sunburst;
import com.intellij.profiler.ui.sunburst.SunburstKt;
import com.intellij.profiler.ui.sunburst.SunburstModel;
import com.intellij.profiler.ui.sunburst.SunburstSection;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.NotNullProducer;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.Easing;
import com.intellij.util.animation.JBAnimator;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.ui.EDT;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.DoubleConsumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002OPB\u0005\u00a2\u0006\u0002\u0010\u0003J0\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110)2\u0012\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110)H\u0002JD\u00106\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020:2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u0015H\u0002J\u001d\u0010@\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\b\u0010A\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010BJ\u001e\u0010@\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:J\b\u0010C\u001a\u000203H\u0002J3\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110)2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\n\b\u0002\u0010E\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u000203H\u0007J\"\u0010H\u001a\u0002032\u001a\u0010I\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u001c0\u001bJ \u0010J\u001a\u0002032\u0018\u0010I\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010K\u001a\u0002032\u0006\u00107\u001a\u00020LH\u0014J\u0006\u0010+\u001a\u00020,J\u0016\u0010+\u001a\u0002032\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:J \u0010M\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110)H\u0002J\u001a\u0010N\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011*\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u0004\u0018\u00018\u00002\b\u0010\b\u001a\u0004\u0018\u00018\u0000@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR*\u0010\u000f\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u0010j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R0\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010*\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010-\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006Q"}, d2={"Lcom/intellij/profiler/ui/sunburst/Sunburst;", "T", "Ljavax/swing/JComponent;", "()V", "adjust", "", "animator", "Lcom/intellij/util/animation/JBAnimator;", "value", "center", "getCenter", "()Ljava/lang/Object;", "setCenter", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "Lkotlin/Comparator;", "hiddenItemsColor", "Lkotlin/Function1;", "Ljava/awt/Color;", "getHiddenItemsColor", "()Lkotlin/jvm/functions/Function1;", "setHiddenItemsColor", "(Lkotlin/jvm/functions/Function1;)V", "hover", "Ljava/util/function/BiConsumer;", "Ljava/awt/event/InputEvent;", "hovered", "getHovered", "()Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "setHovered", "(Lcom/intellij/profiler/ui/sunburst/SunburstSection;)V", "Lcom/intellij/profiler/ui/sunburst/SunburstModel;", "model", "getModel", "()Lcom/intellij/profiler/ui/sunburst/SunburstModel;", "setModel", "(Lcom/intellij/profiler/ui/sunburst/SunburstModel;)V", "sections", "", "select", "shift", "Ljava/awt/Point;", "thickness", "getThickness", "()D", "setThickness", "(D)V", "animate", "", "source", "target", "fillSection", "g", "Ljava/awt/Graphics2D;", "x", "", "y", "from", "to", "depth", "color", "findSection", "content", "(Ljava/lang/Object;)Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "fireMouseHoverEvent", "generate", "root", "(Lcom/intellij/profiler/ui/sunburst/SunburstModel;Ljava/lang/Object;)Ljava/util/Collection;", "ignorePowerSave", "onHover", "consumer", "onSelect", "paintComponent", "Ljava/awt/Graphics;", "getRootSection", "takeIfVisible", "MouseListener", "SortedIterable", "intellij.profiler.common"})
@ApiStatus.Experimental
public final class Sunburst<T>
extends JComponent {
    private double thickness = 20.0;
    @NotNull
    private SunburstModel<T> model = new SunburstModel.Empty();
    @Nullable
    private T center;
    @Nullable
    private SunburstSection<T> hovered;
    @Nullable
    private Function1<? super SunburstSection<T>, ? extends Color> hiddenItemsColor = new Function1<SunburstSection<T>, JBColor>(this){
        final /* synthetic */ Sunburst this$0;

        @NotNull
        public final JBColor invoke(@NotNull SunburstSection<T> base) {
            Intrinsics.checkNotNullParameter(base, (String)"base");
            return new JBColor(new NotNullProducer(this, base){
                final /* synthetic */ hiddenItemsColor.1 this$0;
                final /* synthetic */ SunburstSection $base;

                @NotNull
                public final Color produce() {
                    double proportion = ColorUtil.isDark((Color)this.this$0.this$0.getBackground()) ? 0.9 : 0.8;
                    return ColorUtil.mix((Color)this.$base.getColor(), (Color)this.this$0.this$0.getBackground(), (double)proportion);
                }
                {
                    this.this$0 = var1_1;
                    this.$base = sunburstSection;
                }
            });
        }
        {
            this.this$0 = sunburst;
            super(1);
        }
    };
    private final JBAnimator animator;
    private final Comparator<SunburstSection<T>> comparator;
    private Collection<SunburstSection<T>> sections;
    private double adjust;
    private final Point shift;
    private BiConsumer<SunburstSection<T>, InputEvent> hover;
    private BiConsumer<SunburstSection<T>, InputEvent> select;

    public final double getThickness() {
        return this.thickness;
    }

    public final void setThickness(double value2) {
        this.thickness = value2;
        this.repaint();
    }

    @NotNull
    public final SunburstModel<T> getModel() {
        return this.model;
    }

    public final void setModel(@NotNull SunburstModel<T> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.model = value2;
        this.setCenter(value2.getRoot());
    }

    @Nullable
    public final T getCenter() {
        return this.center;
    }

    public final void setCenter(@Nullable T value2) {
        this.center = value2;
        this.hovered = null;
        if (this.model instanceof SunburstModel.WithAnimation) {
            this.animate(this.sections, this.generate(this.model, value2));
        } else {
            this.sections = this.generate(this.model, value2);
            this.fireMouseHoverEvent();
            this.repaint();
        }
    }

    @Nullable
    public final SunburstSection<T> getHovered() {
        return this.hovered;
    }

    public final void setHovered(@Nullable SunburstSection<T> sunburstSection) {
        this.hovered = sunburstSection;
    }

    @Nullable
    public final Function1<SunburstSection<T>, Color> getHiddenItemsColor() {
        return this.hiddenItemsColor;
    }

    public final void setHiddenItemsColor(@Nullable Function1<? super SunburstSection<T>, ? extends Color> function1) {
        this.hiddenItemsColor = function1;
    }

    private final void fireMouseHoverEvent() {
        Point position;
        if (!GraphicsEnvironment.isHeadless() && (position = this.getMousePosition(true)) != null) {
            SunburstSection<T> section = this.findSection(position.x, position.y);
            MouseEvent event = new MouseEvent(this, 503, 0L, 0, position.x, position.y, 0, false);
            this.hover.accept(section, event);
        }
    }

    @TestOnly
    public final void ignorePowerSave() {
        this.animator.ignorePowerSaveMode();
    }

    public final void onHover(@NotNull BiConsumer<SunburstSection<T>, InputEvent> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        BiConsumer<SunburstSection<SunburstSection<T>>, InputEvent> biConsumer = this.hover.andThen(consumer);
        Intrinsics.checkNotNullExpressionValue(biConsumer, (String)"hover.andThen(consumer)");
        this.hover = biConsumer;
    }

    public final void onSelect(@NotNull BiConsumer<SunburstSection<T>, InputEvent> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        BiConsumer<SunburstSection<SunburstSection<T>>, InputEvent> biConsumer = this.select.andThen(consumer);
        Intrinsics.checkNotNullExpressionValue(biConsumer, (String)"select.andThen(consumer)");
        this.select = biConsumer;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SunburstSection<T> findSection(int x, int y) {
        Object v0;
        block2: {
            void angle;
            double dX = (double)x - (double)this.getWidth() / 2.0 + (double)this.shift.x;
            double dY = (double)y - (double)this.getHeight() / 2.0 + (double)this.shift.y;
            double d = dX * dX + dY * dY;
            boolean bl = false;
            double radius = Math.sqrt(d) - this.adjust;
            Ref.DoubleRef doubleRef = new Ref.DoubleRef();
            double d2 = -dY;
            boolean bl2 = false;
            doubleRef.element = Math.atan2(dX, d2);
            if (angle.element < 0.0) {
                angle.element += Math.PI * 2;
            }
            angle.element /= Math.PI * 2;
            Function1 condition2 = new Function1<SunburstSection<T>, Boolean>(this, (Ref.DoubleRef)angle, radius){
                final /* synthetic */ Sunburst this$0;
                final /* synthetic */ Ref.DoubleRef $angle;
                final /* synthetic */ double $radius;

                public final boolean invoke(@NotNull SunburstSection<T> s) {
                    Intrinsics.checkNotNullParameter(s, (String)"s");
                    return s.getStart() <= this.$angle.element && this.$angle.element <= s.getEnd() && (double)s.getDepth() * this.this$0.getThickness() <= this.$radius && this.$radius <= (double)(s.getDepth() + 1) * this.this$0.getThickness();
                }
                {
                    this.this$0 = sunburst;
                    this.$angle = doubleRef;
                    this.$radius = d;
                    super(1);
                }
            };
            Iterable iterable = this.sections;
            bl2 = false;
            Iterable iterable2 = iterable;
            boolean bl3 = false;
            for (Object t : iterable2) {
                if (!((Boolean)condition2.invoke(t)).booleanValue()) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        SunburstSection sunburstSection = v0;
        return sunburstSection != null ? this.takeIfVisible(sunburstSection) : null;
    }

    @Nullable
    public final SunburstSection<T> findSection(@Nullable T content2) {
        Object v0;
        block2: {
            if (content2 == null) {
                return null;
            }
            Iterable iterable = this.sections;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                SunburstSection it = (SunburstSection)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it.getContent(), content2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        SunburstSection sunburstSection = v0;
        return sunburstSection != null ? this.takeIfVisible(sunburstSection) : null;
    }

    private final SunburstSection<T> takeIfVisible(SunburstSection<T> $this$takeIfVisible) {
        SunburstSection<T> sunburstSection = $this$takeIfVisible;
        boolean bl = false;
        boolean bl2 = false;
        SunburstSection<T> it = sunburstSection;
        boolean bl3 = false;
        return SunburstKt.access$createShape(it, this.getWidth() / 2, this.getHeight() / 2, this.thickness, this.adjust) != null ? sunburstSection : null;
    }

    public final void shift(int x, int y) {
        this.shift.x = x;
        this.shift.y = y;
        this.repaint();
    }

    @NotNull
    public final Point shift() {
        return new Point(this.shift.x, this.shift.y);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        Rectangle bounds2 = g2d.getClipBounds();
        g2d.setPaint(this.getBackground());
        g2d.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
        int x = bounds2.width / 2 - this.shift.x;
        int y = bounds2.height / 2 - this.shift.y;
        Collection<SunburstSection<T>> collection = this.sections;
        boolean bl = false;
        if (!collection.isEmpty() && this.hiddenItemsColor != null) {
            SortedIterable<SunburstSection<T>> shadows = new SortedIterable<SunburstSection<T>>(this.sections, this.comparator);
            SunburstSection current2 = new SunburstSection((SunburstSection)CollectionsKt.first((Iterable)shadows));
            Iterable $this$forEach$iv = shadows;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SunburstSection next = (SunburstSection)element$iv;
                boolean bl2 = false;
                if (next.getStart() - current2.getEnd() >= 0.002777777777777778 || current2.getDepth() != next.getDepth()) {
                    Function1<? super SunburstSection<T>, ? extends Color> function1 = this.hiddenItemsColor;
                    this.fillSection((Graphics2D)g, x, y, current2.getStart(), current2.getEnd(), current2.getDepth(), function1 != null ? (Color)function1.invoke(current2) : null);
                    current2 = new SunburstSection(next);
                }
                current2.setEnd(next.getEnd());
            }
            Function1<? super SunburstSection<T>, ? extends Color> function1 = this.hiddenItemsColor;
            this.fillSection((Graphics2D)g, x, y, current2.getStart(), current2.getEnd(), current2.getDepth(), function1 != null ? (Color)function1.invoke(current2) : null);
        }
        Iterable $this$forEach$iv = this.sections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shape shape;
            SunburstSection it = (SunburstSection)element$iv;
            boolean bl3 = false;
            if (SunburstKt.access$createShape(it, x, y, this.thickness, this.adjust) == null) {
                continue;
            }
            Color color = it.getColor();
            g2d.setColor(this.hovered == it ? ColorUtil.mix((Color)color, (Color)Color.BLACK, (double)0.05) : color);
            g2d.fill(shape);
        }
    }

    private final void fillSection(Graphics2D g, int x, int y, double from2, double to, int depth, Color color) {
        Color color2 = color;
        if (color2 == null) {
            color2 = Color.GRAY;
        }
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"color ?: Color.GRAY");
        Shape stub = SunburstKt.access$createShape(new SunburstSection<Object>(null, from2, to, depth, color2), x, y, this.thickness, this.adjust);
        if (stub != null) {
            if (color != null) {
                g.setColor(color);
            }
            g.fill(stub);
        }
    }

    static /* synthetic */ void fillSection$default(Sunburst sunburst, Graphics2D graphics2D, int n, int n2, double d, double d2, int n3, Color color, int n4, Object object) {
        if ((n4 & 0x40) != 0) {
            color = null;
        }
        sunburst.fillSection(graphics2D, n, n2, d, d2, n3, color);
    }

    /*
     * WARNING - void declaration
     */
    private final void animate(Collection<SunburstSection<T>> source, Collection<SunburstSection<T>> target2) {
        void $this$apply;
        Animation[] animationArray;
        Object k;
        SunburstSection section;
        boolean bl;
        Map.Entry entry2;
        Map.Entry $dstr$k$section;
        Object content2;
        EDT.assertIsEdt();
        SunburstModel<T> sunburstModel = this.model;
        if (!(sunburstModel instanceof SunburstModel.WithAnimation)) {
            sunburstModel = null;
        }
        SunburstModel.WithAnimation withAnimation = (SunburstModel.WithAnimation)sunburstModel;
        if (withAnimation == null) {
            throw (Throwable)new IllegalStateException();
        }
        SunburstModel.WithAnimation model2 = withAnimation;
        SunburstSection<T> oldRoot = this.getRootSection(source);
        SunburstSection<T> newRoot = this.getRootSection(target2);
        int distance2 = oldRoot != null && newRoot != null ? model2.getDistance(oldRoot.getContent(), newRoot.getContent()) : 0;
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap((int)source.size());
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"CollectionFactory.create\u2026tSection<T>>(source.size)");
        Map sourceMap = map2;
        Iterable $this$forEach$iv = source;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SunburstSection it = (SunburstSection)element$iv;
            boolean bl2 = false;
            sourceMap.put(it.getContent(), it);
        }
        Map map3 = CollectionFactory.createSmallMemoryFootprintMap((int)target2.size());
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"CollectionFactory.create\u2026tSection<T>>(target.size)");
        Map targetMap = map3;
        Iterable $this$forEach$iv2 = target2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            SunburstSection it = (SunburstSection)element$iv;
            boolean bl3 = false;
            targetMap.put(it.getContent(), it);
        }
        Set set2 = CollectionFactory.createSmallMemoryFootprintSet((Collection)sourceMap.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"CollectionFactory.create\u2026intSet<T>(sourceMap.keys)");
        Set sameSet = set2;
        sameSet.retainAll(targetMap.keySet());
        SunburstSection<T> sunburstSection = newRoot;
        SunburstSection oldNewRoot = (SunburstSection)sourceMap.get(sunburstSection != null ? sunburstSection.getContent() : null);
        SunburstSection<T> sunburstSection2 = oldRoot;
        SunburstSection newOldRoot = (SunburstSection)targetMap.get(sunburstSection2 != null ? sunburstSection2.getContent() : null);
        boolean it = false;
        List animations2 = new ArrayList();
        animate.3 $fun$animation$3 = animate.3.INSTANCE;
        Object $this$forEach$iv22 = sameSet;
        boolean $i$f$forEach3 = false;
        Object object = $this$forEach$iv22.iterator();
        while (object.hasNext()) {
            SunburstSection to;
            SunburstSection from2;
            Object element$iv22 = object.next();
            content2 = element$iv22;
            boolean bl4 = false;
            if ((SunburstSection)sourceMap.get(content2) == null) {
                String string = "can't find value " + content2;
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if ((SunburstSection)targetMap.get(content2) == null) {
                String string = "can't find value " + content2;
                boolean bl6 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            animations2.add(animate.3.INSTANCE.invoke(from2.getStart(), to.getStart(), new DoubleConsumer(from2){
                final /* synthetic */ SunburstSection $from;

                public final void accept(double it) {
                    this.$from.setStart(it);
                }
                {
                    this.$from = sunburstSection;
                }
            }));
            animations2.add(animate.3.INSTANCE.invoke(from2.getEnd(), to.getEnd(), new DoubleConsumer(from2){
                final /* synthetic */ SunburstSection $from;

                public final void accept(double it) {
                    this.$from.setEnd(it);
                }
                {
                    this.$from = sunburstSection;
                }
            }));
        }
        if (oldNewRoot != null) {
            $this$forEach$iv22 = sourceMap;
            $i$f$forEach3 = false;
            object = $this$forEach$iv22;
            boolean element$iv22 = false;
            content2 = object.entrySet().iterator();
            while (content2.hasNext()) {
                Map.Entry element$iv;
                $dstr$k$section = element$iv = (Map.Entry)content2.next();
                boolean bl7 = false;
                entry2 = $dstr$k$section;
                bl = false;
                Object k2 = entry2.getKey();
                entry2 = $dstr$k$section;
                bl = false;
                section = (SunburstSection)entry2.getValue();
                if (sameSet.contains(k)) continue;
                animations2.add(animate.3.INSTANCE.invoke(section.getStart(), section.getStart() <= oldNewRoot.getStart() ? 0.0 : 1.0, new DoubleConsumer(section){
                    final /* synthetic */ SunburstSection $section;

                    public final void accept(double it) {
                        this.$section.setStart(it);
                    }
                    {
                        this.$section = sunburstSection;
                    }
                }));
                animations2.add(animate.3.INSTANCE.invoke(section.getEnd(), section.getEnd() < oldNewRoot.getEnd() ? 0.0 : 1.0, new DoubleConsumer(section){
                    final /* synthetic */ SunburstSection $section;

                    public final void accept(double it) {
                        this.$section.setEnd(it);
                    }
                    {
                        this.$section = sunburstSection;
                    }
                }));
            }
        }
        if (newOldRoot != null) {
            $this$forEach$iv22 = targetMap;
            $i$f$forEach3 = false;
            object = $this$forEach$iv22;
            boolean element$iv22 = false;
            content2 = object.entrySet().iterator();
            while (content2.hasNext()) {
                Map.Entry element$iv;
                $dstr$k$section = element$iv = (Map.Entry)content2.next();
                boolean bl8 = false;
                entry2 = $dstr$k$section;
                bl = false;
                k = entry2.getKey();
                entry2 = $dstr$k$section;
                bl = false;
                section = (SunburstSection)entry2.getValue();
                if (sameSet.contains(k)) continue;
                double start2 = section.getStart() <= newOldRoot.getStart() ? 0.0 : 1.0;
                double end = section.getEnd() < newOldRoot.getEnd() ? 0.0 : 1.0;
                SunburstSection fake = new SunburstSection(section.getContent(), start2, end, section.getDepth() + distance2, section.getColor());
                Collection<SunburstSection<T>> collection = this.sections;
                if (collection == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<com.intellij.profiler.ui.sunburst.SunburstSection<T>>");
                }
                TypeIntrinsics.asMutableCollection(collection).add(fake);
                animations2.add(animate.3.INSTANCE.invoke(fake.getStart(), section.getStart(), new DoubleConsumer(fake){
                    final /* synthetic */ SunburstSection $fake;

                    public final void accept(double it) {
                        this.$fake.setStart(it);
                    }
                    {
                        this.$fake = sunburstSection;
                    }
                }));
                animations2.add(animate.3.INSTANCE.invoke(fake.getEnd(), section.getEnd(), new DoubleConsumer(fake){
                    final /* synthetic */ SunburstSection $fake;

                    public final void accept(double it) {
                        this.$fake.setEnd(it);
                    }
                    {
                        this.$fake = sunburstSection;
                    }
                }));
            }
        }
        if (newOldRoot == null && oldNewRoot == null) {
            SunburstSection section2;
            boolean $this$forEach$iv3 = sameSet.isEmpty();
            $i$f$forEach3 = false;
            boolean bl9 = false;
            if (_Assertions.ENABLED && !$this$forEach$iv3) {
                boolean element$iv22 = false;
                String element$iv22 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)element$iv22));
            }
            $this$forEach$iv22 = sourceMap.values();
            $i$f$forEach3 = false;
            Iterator iterator2 = $this$forEach$iv22.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                section2 = (SunburstSection)element$iv;
                boolean bl10 = false;
                animations2.add(animate.3.INSTANCE.invoke(section2.getStart(), 1.0, new DoubleConsumer(section2){
                    final /* synthetic */ SunburstSection $section;

                    public final void accept(double it) {
                        this.$section.setStart(it);
                    }
                    {
                        this.$section = sunburstSection;
                    }
                }));
                animations2.add(animate.3.INSTANCE.invoke(section2.getEnd(), 1.0, new DoubleConsumer(section2){
                    final /* synthetic */ SunburstSection $section;

                    public final void accept(double it) {
                        this.$section.setEnd(it);
                    }
                    {
                        this.$section = sunburstSection;
                    }
                }));
            }
            $this$forEach$iv22 = targetMap.values();
            $i$f$forEach3 = false;
            iterator2 = $this$forEach$iv22.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                section2 = (SunburstSection)element$iv;
                boolean bl11 = false;
                SunburstSection fake = new SunburstSection(section2.getContent(), 0.0, 0.0, section2.getDepth(), section2.getColor());
                Collection<SunburstSection<T>> collection = this.sections;
                if (collection == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<com.intellij.profiler.ui.sunburst.SunburstSection<T>>");
                }
                TypeIntrinsics.asMutableCollection(collection).add(fake);
                animations2.add(animate.3.INSTANCE.invoke(fake.getStart(), section2.getStart(), new DoubleConsumer(fake){
                    final /* synthetic */ SunburstSection $fake;

                    public final void accept(double it) {
                        this.$fake.setStart(it);
                    }
                    {
                        this.$fake = sunburstSection;
                    }
                }));
                animations2.add(animate.3.INSTANCE.invoke(fake.getEnd(), section2.getEnd(), new DoubleConsumer(fake){
                    final /* synthetic */ SunburstSection $fake;

                    public final void accept(double it) {
                        this.$fake.setEnd(it);
                    }
                    {
                        this.$fake = sunburstSection;
                    }
                }));
            }
        } else {
            animations2.add($fun$animation$3.invoke(this.adjust, (double)(-distance2) * this.thickness, new DoubleConsumer(this){
                final /* synthetic */ Sunburst this$0;

                public final void accept(double it) {
                    Sunburst.access$setAdjust$p(this.this$0, it);
                }
                {
                    this.this$0 = sunburst;
                }
            }));
        }
        Animation animation = new Animation(new DoubleConsumer(animations2){
            final /* synthetic */ List $animations;

            public final void accept(double value2) {
                Iterable $this$forEach$iv = this.$animations;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DoubleConsumer it = (DoubleConsumer)element$iv;
                    boolean bl = false;
                    it.accept(value2);
                }
            }
            {
                this.$animations = list2;
            }
        });
        boolean bl12 = false;
        boolean bl13 = false;
        Animation element$iv = animation;
        int n = 0;
        Animation[] animationArray2 = animationArray = new Animation[1];
        JBAnimator jBAnimator = this.animator;
        boolean bl14 = false;
        $this$apply.setDuration(500);
        $this$apply.setEasing((Easing)animate.11.1.INSTANCE);
        $this$apply.runWhenUpdated(new Runnable(this, target2){
            final /* synthetic */ Sunburst this$0;
            final /* synthetic */ Collection $target$inlined;
            {
                this.this$0 = sunburst;
                this.$target$inlined = collection;
            }

            public final void run() {
                this.this$0.repaint();
            }
        });
        $this$apply.runWhenExpired(new Runnable(this, target2){
            final /* synthetic */ Sunburst this$0;
            final /* synthetic */ Collection $target$inlined;
            {
                this.this$0 = sunburst;
                this.$target$inlined = collection;
            }

            public final void run() {
                Sunburst.access$setSections$p(this.this$0, this.$target$inlined);
                Sunburst.access$setAdjust$p(this.this$0, 0.0);
                Sunburst.access$fireMouseHoverEvent(this.this$0);
                this.this$0.repaint();
            }
        });
        Unit unit = Unit.INSTANCE;
        animationArray[n] = animation;
        jBAnimator.animate(animationArray2);
    }

    private final Collection<SunburstSection<T>> generate(SunburstModel<T> model2, T root) {
        boolean bl = false;
        List result2 = new ArrayList();
        if (root == null) {
            return result2;
        }
        result2.add(new SunburstSection<T>(root, 0.0, 1.0, 0, model2.getColor(root)));
        SunburstKt.access$generate0(model2, result2, root, 0.0, 1.0, 1);
        CollectionsKt.sortWith((List)result2, this.comparator);
        return result2;
    }

    static /* synthetic */ Collection generate$default(Sunburst sunburst, SunburstModel sunburstModel, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = sunburstModel.getRoot();
        }
        return sunburst.generate(sunburstModel, object);
    }

    private final SunburstSection<T> getRootSection(Collection<SunburstSection<T>> $this$getRootSection) {
        Object v0;
        block1: {
            Iterable iterable = $this$getRootSection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                SunburstSection it = (SunburstSection)t;
                boolean bl3 = false;
                if (!(it.getDepth() == 0)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public Sunburst() {
        void $this$apply;
        JBAnimator jBAnimator = new JBAnimator();
        boolean bl = false;
        boolean bl2 = false;
        JBAnimator jBAnimator2 = jBAnimator;
        Sunburst sunburst = this;
        boolean bl3 = false;
        $this$apply.setPeriod(16);
        Unit unit = Unit.INSTANCE;
        sunburst.animator = jBAnimator;
        this.comparator = comparator.1.INSTANCE;
        boolean bl4 = false;
        this.sections = new ArrayList();
        this.shift = new Point(0, 0);
        this.hover = new BiConsumer(this){
            final /* synthetic */ Sunburst this$0;

            public final void accept(@Nullable SunburstSection<T> hover2, @NotNull InputEvent $noName_1) {
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                this.this$0.setHovered(hover2);
                this.this$0.repaint();
            }
            {
                this.this$0 = sunburst;
            }
        };
        this.select = select.1.INSTANCE;
        MouseListener listener2 = new MouseListener();
        this.addMouseMotionListener(listener2);
        this.addMouseListener(listener2);
    }

    public static final /* synthetic */ void access$setSelect$p(Sunburst $this, BiConsumer biConsumer) {
        $this.select = biConsumer;
    }

    public static final /* synthetic */ void access$setHover$p(Sunburst $this, BiConsumer biConsumer) {
        $this.hover = biConsumer;
    }

    public static final /* synthetic */ double access$getAdjust$p(Sunburst $this) {
        return $this.adjust;
    }

    public static final /* synthetic */ void access$setAdjust$p(Sunburst $this, double d) {
        $this.adjust = d;
    }

    public static final /* synthetic */ Collection access$getSections$p(Sunburst $this) {
        return $this.sections;
    }

    public static final /* synthetic */ void access$setSections$p(Sunburst $this, Collection collection) {
        $this.sections = collection;
    }

    public static final /* synthetic */ void access$fireMouseHoverEvent(Sunburst $this) {
        $this.fireMouseHoverEvent();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/sunburst/Sunburst$MouseListener;", "Ljava/awt/event/MouseAdapter;", "(Lcom/intellij/profiler/ui/sunburst/Sunburst;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "mouseMoved", "intellij.profiler.common"})
    private final class MouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getButton() != 1 || e.isConsumed()) {
                return;
            }
            SunburstSection section = Sunburst.this.findSection(e.getX(), e.getY());
            if (section != null) {
                Sunburst.this.select.accept(section, e);
                e.consume();
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Sunburst.this.hover.accept(Sunburst.this.findSection(e.getX(), e.getY()), e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Sunburst.this.hover.accept(null, e);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rH\u0096\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00028\u00010\nj\b\u0012\u0004\u0012\u00028\u0001`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/sunburst/Sunburst$SortedIterable;", "T", "", "collection", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/Collection;Ljava/util/Comparator;)V", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "iterator", "", "intellij.profiler.common"})
    private static final class SortedIterable<T>
    implements Iterable<T>,
    KMappedMarker {
        private final ArrayList<T> data;

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator<T> iterator2 = this.data.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"data.iterator()");
            return iterator2;
        }

        /*
         * WARNING - void declaration
         */
        public SortedIterable(@NotNull Collection<? extends T> collection, @NotNull Comparator<T> comparator2) {
            boolean isSorted;
            block2: {
                boolean bl;
                Intrinsics.checkNotNullParameter(collection, (String)"collection");
                Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
                this.data = new ArrayList<T>(collection);
                Sequence $this$all$iv = SequencesKt.zipWithNext((Sequence)CollectionsKt.asSequence((Iterable)this.data));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    void prev2;
                    Pair $dstr$prev$next = (Pair)element$iv;
                    boolean bl2 = false;
                    Object object = $dstr$prev$next.component1();
                    Object next = $dstr$prev$next.component2();
                    if (comparator2.compare(prev2, next) <= 0) continue;
                    bl = false;
                    break block2;
                }
                bl = isSorted = true;
            }
            if (!isSorted) {
                CollectionsKt.sortWith((List)this.data, comparator2);
            }
        }
    }
}

