/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.threadview;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ThreadListOptions;
import com.intellij.profiler.model.NoMetric;
import com.intellij.profiler.model.PersistentMetric;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.model.ThreadMetric;
import com.intellij.profiler.ui.ThreadList;
import com.intellij.profiler.ui.threadview.ThreadListSortActions;
import com.intellij.profiler.ui.threadview.ThreadListSynchronizer;
import com.intellij.ui.SortedListModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.swing.ListModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002 !B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0017H\u0002R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer;", "", "threads", "", "Lcom/intellij/profiler/model/ThreadInfo;", "(Ljava/util/Collection;)V", "initialModel", "Lcom/intellij/ui/SortedListModel;", "kotlin.jvm.PlatformType", "getInitialModel", "()Lcom/intellij/ui/SortedListModel;", "selector", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparatorSelector;", "sortActions", "Lcom/intellij/profiler/ui/threadview/ThreadListSortActions;", "getSortActions", "()Lcom/intellij/profiler/ui/threadview/ThreadListSortActions;", "sortActions$delegate", "Lkotlin/Lazy;", "threadLists", "", "Lcom/intellij/profiler/ui/ThreadList;", "isCurrentComparator", "", "comparator", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "register", "", "threadList", "updateModel", "newComparator", "state", "ThreadListComparator", "ThreadListComparatorSelector", "intellij.profiler.common"})
public final class ThreadListSynchronizer {
    private final List<ThreadList> threadLists;
    private final ThreadListComparatorSelector selector;
    @NotNull
    private final Lazy sortActions$delegate;
    @NotNull
    private final SortedListModel<ThreadInfo> initialModel;
    private final Collection<ThreadInfo> threads;

    @NotNull
    public final ThreadListSortActions getSortActions() {
        Lazy lazy = this.sortActions$delegate;
        ThreadListSynchronizer threadListSynchronizer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ThreadListSortActions)lazy.getValue();
    }

    @NotNull
    public final SortedListModel<ThreadInfo> getInitialModel() {
        return this.initialModel;
    }

    public final void register(@NotNull ThreadList threadList) {
        Intrinsics.checkNotNullParameter((Object)((Object)threadList), (String)"threadList");
        Collection collection = this.threadLists;
        boolean bl = false;
        collection.add(threadList);
    }

    private final boolean isCurrentComparator(ThreadListComparator comparator2) {
        ThreadListComparatorSelector threadListComparatorSelector = this.selector;
        return threadListComparatorSelector != null && threadListComparatorSelector.isSelected(comparator2);
    }

    private final void updateModel(ThreadListComparator newComparator, boolean state) {
        if (this.selector == null) {
            return;
        }
        if (state) {
            this.selector.select(newComparator);
        } else {
            this.selector.deselect(newComparator);
        }
        Iterable $this$forEach$iv = this.threadLists;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThreadList it = (ThreadList)((Object)element$iv);
            boolean bl = false;
            it.setModel((ListModel)new SortedListModel(this.threads, this.selector.getCurrentComparator().getComparator()));
            it.repaint();
        }
    }

    public ThreadListSynchronizer(@NotNull Collection<? extends ThreadInfo> threads) {
        Intrinsics.checkNotNullParameter(threads, (String)"threads");
        this.threads = threads;
        boolean bl = false;
        this.threadLists = new ArrayList();
        this.selector = ThreadListComparator.Companion.buildSelector(this.threads);
        this.sortActions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ThreadListSortActions>(this){
            final /* synthetic */ ThreadListSynchronizer this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ThreadListSortActions invoke() {
                Collection<ToggleAction> collection;
                void $this$mapTo$iv$iv;
                Object object = ThreadListSynchronizer.access$getSelector$p(this.this$0);
                if (object == null || (object = ((ThreadListComparatorSelector)object).getAllComparators()) == null) {
                    return new ThreadListSortActions(CollectionsKt.emptyList(), null, 2, null);
                }
                Object allComparators = object;
                Function1<ThreadListComparator, ToggleAction> $fun$createSortAction$1 = new Function1<ThreadListComparator, ToggleAction>(this, (List)allComparators){
                    final /* synthetic */ sortActions.2 this$0;
                    final /* synthetic */ List $allComparators;

                    @NotNull
                    public final ToggleAction invoke(@NotNull ThreadListComparator comparator2) {
                        Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
                        return (ToggleAction)new DumbAwareToggleAction(this, comparator2, comparator2.getName()){
                            final /* synthetic */ sortActions.1 this$0;
                            final /* synthetic */ ThreadListComparator $comparator;

                            public boolean isSelected(@NotNull AnActionEvent e) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                return ThreadListSynchronizer.access$isCurrentComparator(this.this$0.this$0.this$0, this.$comparator);
                            }

                            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                ThreadListSynchronizer.access$updateModel(this.this$0.this$0.this$0, this.$comparator, state);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void update(@NotNull AnActionEvent e) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                super.update(e);
                                if (this.$comparator instanceof ThreadListComparator.KeepingSimilarThreadsClose) {
                                    boolean bl;
                                    Presentation presentation2;
                                    block4: {
                                        void $this$any$iv;
                                        Presentation presentation3 = e.getPresentation();
                                        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
                                        Iterable iterable = this.this$0.$allComparators;
                                        ThreadListComparatorSelector threadListComparatorSelector = ThreadListSynchronizer.access$getSelector$p(this.this$0.this$0.this$0);
                                        presentation2 = presentation3;
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl = false;
                                        } else {
                                            for (T element$iv : $this$any$iv) {
                                                ThreadListComparator p1 = (ThreadListComparator)element$iv;
                                                boolean bl2 = false;
                                                if (!threadListComparatorSelector.isSelected(p1)) continue;
                                                bl = true;
                                                break block4;
                                            }
                                            bl = false;
                                        }
                                    }
                                    boolean bl3 = bl;
                                    presentation2.setEnabled(bl3);
                                }
                            }
                            {
                                this.this$0 = this$0;
                                this.$comparator = $captured_local_variable$1;
                                super($super_call_param$2);
                            }
                        };
                    }
                    {
                        this.this$0 = var1_1;
                        this.$allComparators = list2;
                        super(1);
                    }
                };
                Iterable $this$map$iv = (Iterable)allComparators;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ThreadListComparator threadListComparator = (ThreadListComparator)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    ToggleAction toggleAction = $fun$createSortAction$1.invoke((ThreadListComparator)it);
                    collection.add(toggleAction);
                }
                collection = (List)destination$iv$iv;
                ToggleAction toggleAction = $fun$createSortAction$1.invoke((ThreadListComparator)new ThreadListComparator.KeepingSimilarThreadsClose(ThreadListSynchronizer.access$getThreads$p(this.this$0), (ThreadListComparator)CollectionsKt.first((List)allComparators)));
                List list2 = collection;
                return new ThreadListSortActions(list2, toggleAction);
            }
            {
                this.this$0 = threadListSynchronizer;
                super(0);
            }
        }));
        Object object = this.selector;
        if (object == null || (object = ((ThreadListComparatorSelector)object).getCurrentComparator()) == null || (object = ((ThreadListComparator)object).getComparator()) == null) {
            object = ThreadListComparator.Default.INSTANCE.getComparator();
        }
        this.initialModel = new SortedListModel(this.threads, object);
    }

    public static final /* synthetic */ ThreadListComparatorSelector access$getSelector$p(ThreadListSynchronizer $this) {
        return $this.selector;
    }

    public static final /* synthetic */ boolean access$isCurrentComparator(ThreadListSynchronizer $this, ThreadListComparator comparator2) {
        return $this.isCurrentComparator(comparator2);
    }

    public static final /* synthetic */ void access$updateModel(ThreadListSynchronizer $this, ThreadListComparator newComparator, boolean state) {
        $this.updateModel(newComparator, state);
    }

    public static final /* synthetic */ Collection access$getThreads$p(ThreadListSynchronizer $this) {
        return $this.threads;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u00162\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u0014\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R$\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0003\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "", "name", "", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;)V", "baseComparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/model/ThreadInfo;", "Lkotlin/Comparator;", "getBaseComparator", "()Ljava/util/Comparator;", "comparator", "getComparator", "getName", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "ByPrimaryMetric", "Companion", "Default", "KeepingSimilarThreadsClose", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Default;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$ByPrimaryMetric;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$KeepingSimilarThreadsClose;", "intellij.profiler.common"})
    private static abstract class ThreadListComparator {
        @NotNull
        private final Comparator<ThreadInfo> baseComparator;
        @NotNull
        private final String name;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public abstract Comparator<ThreadInfo> getComparator();

        @NotNull
        protected final Comparator<ThreadInfo> getBaseComparator() {
            return this.baseComparator;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ui.threadview.ThreadListSynchronizer.ThreadListComparator");
            }
            ThreadListComparator cfr_ignored_0 = (ThreadListComparator)object2;
            return !(Intrinsics.areEqual((Object)this.name, (Object)((ThreadListComparator)other).name) ^ true);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        private ThreadListComparator(String name) {
            this.name = name;
            Comparator comparator2 = Comparator.comparingInt(baseComparator.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"Comparator.comparingInt \u2026se -> 3\n        }\n      }");
            this.baseComparator = comparator2;
        }

        public /* synthetic */ ThreadListComparator(String name, DefaultConstructorMarker $constructor_marker) {
            this(name);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Default;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "()V", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/model/ThreadInfo;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "intellij.profiler.common"})
        public static final class Default
        extends ThreadListComparator {
            @NotNull
            private static final Comparator<ThreadInfo> comparator;
            @NotNull
            public static final Default INSTANCE;

            @Override
            @NotNull
            public Comparator<ThreadInfo> getComparator() {
                return comparator;
            }

            private Default() {
                super(CommonProfilerBundleKt.profilerMessage("ui.threadlist.sort.by.name.action.message", new Object[0]), null);
            }

            static {
                Default default_;
                INSTANCE = default_ = new Default();
                Comparator<ThreadInfo> comparator2 = default_.getBaseComparator().thenComparing(Comparator.comparing(comparator.1.INSTANCE)).thenComparing(Comparator.comparing(comparator.2.INSTANCE)).thenComparing(Comparator.comparing(comparator.3.INSTANCE));
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"baseComparator\n        .\u2026readInfo -> t.nativeId })");
                comparator = comparator2;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R$\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$ByPrimaryMetric;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "primaryMetric", "Lcom/intellij/profiler/model/ThreadMetric;", "(Lcom/intellij/profiler/model/ThreadMetric;)V", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/model/ThreadInfo;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "getPrimaryMetric", "()Lcom/intellij/profiler/model/ThreadMetric;", "intellij.profiler.common"})
        public static final class ByPrimaryMetric
        extends ThreadListComparator {
            @NotNull
            private final Comparator<ThreadInfo> comparator;
            @NotNull
            private final ThreadMetric<?> primaryMetric;

            @Override
            @NotNull
            public Comparator<ThreadInfo> getComparator() {
                return this.comparator;
            }

            @NotNull
            public final ThreadMetric<?> getPrimaryMetric() {
                return this.primaryMetric;
            }

            public ByPrimaryMetric(@NotNull ThreadMetric<?> primaryMetric) {
                Intrinsics.checkNotNullParameter(primaryMetric, (String)"primaryMetric");
                super(CommonProfilerBundleKt.profilerMessage("ui.threadlist.sort.action.message", primaryMetric.getName()), null);
                this.primaryMetric = primaryMetric;
                Comparator<ThreadInfo> comparator2 = this.getBaseComparator().thenComparing(Comparator.comparing(comparator.1.INSTANCE));
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"baseComparator\n        .\u2026hreadInfo -> t.metrics })");
                this.comparator = comparator2;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R+\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00040\bj\b\u0012\u0004\u0012\u00020\u0004`\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00040\bj\b\u0012\u0004\u0012\u00020\u0004`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$KeepingSimilarThreadsClose;", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "threads", "", "Lcom/intellij/profiler/model/ThreadInfo;", "innerComparator", "(Ljava/util/Collection;Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;)V", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "comparator$delegate", "Lkotlin/Lazy;", "threadsOrder", "", "", "getThreadsOrder", "()Ljava/util/Map;", "threadsOrder$delegate", "wrappedComparator", "onlyLetters", "", "threadName", "intellij.profiler.common"})
        public static final class KeepingSimilarThreadsClose
        extends ThreadListComparator {
            @NotNull
            private final Lazy comparator$delegate;
            private final Comparator<ThreadInfo> wrappedComparator;
            private final Lazy threadsOrder$delegate;
            private final Collection<ThreadInfo> threads;

            @Override
            @NotNull
            public Comparator<ThreadInfo> getComparator() {
                Lazy lazy = this.comparator$delegate;
                KeepingSimilarThreadsClose keepingSimilarThreadsClose = this;
                Object var3_3 = null;
                boolean bl = false;
                return (Comparator)lazy.getValue();
            }

            private final Map<ThreadInfo, Integer> getThreadsOrder() {
                Lazy lazy = this.threadsOrder$delegate;
                KeepingSimilarThreadsClose keepingSimilarThreadsClose = this;
                Object var3_3 = null;
                boolean bl = false;
                return (Map)lazy.getValue();
            }

            /*
             * WARNING - void declaration
             */
            private final String onlyLetters(String threadName) {
                void $this$filterTo$iv$iv;
                String $this$filter$iv = threadName;
                boolean $i$f$filter = false;
                CharSequence charSequence = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterTo = false;
                int n = 0;
                int n2 = $this$filterTo$iv$iv.length();
                while (n < n2) {
                    void index$iv$iv;
                    char element$iv$iv;
                    char p1 = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
                    boolean bl = false;
                    char c = p1;
                    boolean bl2 = false;
                    if (Character.isLetter(c)) {
                        destination$iv$iv.append(element$iv$iv);
                    }
                    ++index$iv$iv;
                }
                String string = ((StringBuilder)destination$iv$iv).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
                return string;
            }

            public KeepingSimilarThreadsClose(@NotNull Collection<? extends ThreadInfo> threads, @NotNull ThreadListComparator innerComparator) {
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                Intrinsics.checkNotNullParameter((Object)innerComparator, (String)"innerComparator");
                super(CommonProfilerBundleKt.profilerMessage("ui.threadlist.keep.similar.threads.close.action.message", new Object[0]), null);
                this.threads = threads;
                this.comparator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Comparator<ThreadInfo>>(this){
                    final /* synthetic */ KeepingSimilarThreadsClose this$0;

                    public final Comparator<ThreadInfo> invoke() {
                        return Comparator.comparingInt(new ToIntFunction(this){
                            final /* synthetic */ comparator.2 this$0;

                            public final int applyAsInt(ThreadInfo it) {
                                Map map2 = KeepingSimilarThreadsClose.access$getThreadsOrder$p(this.this$0.this$0);
                                ThreadInfo threadInfo = it;
                                Intrinsics.checkNotNullExpressionValue((Object)threadInfo, (String)"it");
                                return ((Number)MapsKt.getValue((Map)map2, (Object)threadInfo)).intValue();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = keepingSimilarThreadsClose;
                        super(0);
                    }
                }));
                this.wrappedComparator = innerComparator.getComparator();
                this.threadsOrder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<ThreadInfo, ? extends Integer>>(this){
                    final /* synthetic */ KeepingSimilarThreadsClose this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Map<ThreadInfo, Integer> invoke() {
                        void $this$mapIndexedTo$iv$iv;
                        Iterable $this$flatMapTo$iv$iv;
                        Map topThreadToSimilarThreads2;
                        ThreadInfo threadInfo;
                        Object object;
                        void $this$associateByTo$iv$iv;
                        Object value$iv$iv$iv2;
                        Object key$iv$iv;
                        void $this$groupByTo$iv$iv;
                        Iterable $this$groupBy$iv = CollectionsKt.sortedWith((Iterable)KeepingSimilarThreadsClose.access$getThreads$p(this.this$0), (Comparator)KeepingSimilarThreadsClose.access$getWrappedComparator$p(this.this$0));
                        boolean $i$f$groupBy = false;
                        Iterable iterable = $this$groupBy$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$groupByTo22 = false;
                        for (T element$iv$iv : $this$groupByTo$iv$iv) {
                            Object object2;
                            ThreadInfo it = (ThreadInfo)element$iv$iv;
                            boolean bl = false;
                            key$iv$iv = KeepingSimilarThreadsClose.access$onlyLetters(this.this$0, it.getName());
                            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                            boolean $i$f$getOrPut = false;
                            value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                            if (value$iv$iv$iv2 == null) {
                                boolean bl2 = false;
                                List answer$iv$iv$iv = new ArrayList<E>();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                object2 = answer$iv$iv$iv;
                            } else {
                                object2 = value$iv$iv$iv2;
                            }
                            List list$iv$iv = (List)object2;
                            list$iv$iv.add(element$iv$iv);
                        }
                        Collection<V> similarThreads = destination$iv$iv.values();
                        Iterable $this$associateBy$iv = similarThreads;
                        boolean $i$f$associateBy = false;
                        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                        Iterable $i$f$groupByTo22 = $this$associateBy$iv;
                        Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv22);
                        boolean $i$f$associateByTo22 = false;
                        for (T element$iv$iv : $this$associateByTo$iv$iv) {
                            void list2;
                            key$iv$iv = (List)element$iv$iv;
                            object = destination$iv$iv2;
                            boolean bl = false;
                            Iterable $i$f$getOrPut = (Iterable)list2;
                            value$iv$iv$iv2 = KeepingSimilarThreadsClose.access$getWrappedComparator$p(this.this$0);
                            boolean answer$iv$iv$iv = false;
                            Iterator<T> iterator2 = $i$f$getOrPut.iterator();
                            if (!iterator2.hasNext()) {
                                throw (Throwable)new NoSuchElementException();
                            }
                            ThreadInfo it = (ThreadInfo)iterator2.next();
                            boolean bl3 = false;
                            ThreadInfo threadInfo2 = it;
                            while (iterator2.hasNext()) {
                                ThreadInfo it2 = (ThreadInfo)iterator2.next();
                                $i$a$-minOfWith-ThreadListSynchronizer$ThreadListComparator$KeepingSimilarThreadsClose$threadsOrder$2$topThreadToSimilarThreads$1$1 = false;
                                ThreadInfo threadInfo3 = it2;
                                if (value$iv$iv$iv2.compare((ThreadInfo)threadInfo2, (ThreadInfo)threadInfo3) <= 0) continue;
                                threadInfo2 = threadInfo3;
                            }
                            threadInfo = threadInfo2;
                            object.put(threadInfo, element$iv$iv);
                        }
                        Map $this$flatMap$iv = topThreadToSimilarThreads2 = MapsKt.toMap((Iterable)CollectionsKt.sortedWith((Iterable)MapsKt.toList((Map)destination$iv$iv2), (Comparator)new Comparator(this){
                            final /* synthetic */ threadsOrder.2 this$0;

                            public final int compare(Pair<? extends ThreadInfo, ? extends List<? extends ThreadInfo>> $dstr$k1$_u24__u24, Pair<? extends ThreadInfo, ? extends List<? extends ThreadInfo>> $dstr$k2$_u24__u24) {
                                ThreadInfo k1 = (ThreadInfo)$dstr$k1$_u24__u24.component1();
                                ThreadInfo k2 = (ThreadInfo)$dstr$k2$_u24__u24.component1();
                                return KeepingSimilarThreadsClose.access$getWrappedComparator$p(this.this$0.this$0).compare(k1, k2);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                        boolean $i$f$flatMap = false;
                        Map capacity$iv22 = $this$flatMap$iv;
                        Collection destination$iv$iv3 = new ArrayList<E>();
                        boolean $i$f$flatMapTo = false;
                        void $i$f$associateByTo22 = $this$flatMapTo$iv$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> element$iv$iv = $i$f$associateByTo22.entrySet().iterator();
                        while (element$iv$iv.hasNext()) {
                            Map.Entry<K, V> element$iv$iv2;
                            Map.Entry<K, V> it = element$iv$iv2 = element$iv$iv.next();
                            boolean bl4 = false;
                            Iterable list$iv$iv = (List)it.getValue();
                            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                        }
                        Iterable $this$mapIndexed$iv = (List)destination$iv$iv3;
                        boolean $i$f$mapIndexed = false;
                        $this$flatMapTo$iv$iv = $this$mapIndexed$iv;
                        destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                        boolean $i$f$mapIndexedTo = false;
                        int index$iv$iv = 0;
                        for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                            void i2;
                            void thread2;
                            int n = index$iv$iv++;
                            boolean bl5 = false;
                            if (n < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            ThreadInfo bl4 = (ThreadInfo)item$iv$iv;
                            int value$iv$iv$iv2 = n;
                            object = destination$iv$iv3;
                            boolean bl6 = false;
                            threadInfo = TuplesKt.to((Object)thread2, (Object)((int)i2));
                            object.add(threadInfo);
                        }
                        return MapsKt.toMap((Iterable)((List)destination$iv$iv3));
                    }
                    {
                        this.this$0 = keepingSimilarThreadsClose;
                        super(0);
                    }
                }));
            }

            public static final /* synthetic */ Map access$getThreadsOrder$p(KeepingSimilarThreadsClose $this) {
                return $this.getThreadsOrder();
            }

            public static final /* synthetic */ Collection access$getThreads$p(KeepingSimilarThreadsClose $this) {
                return $this.threads;
            }

            public static final /* synthetic */ Comparator access$getWrappedComparator$p(KeepingSimilarThreadsClose $this) {
                return $this.wrappedComparator;
            }

            public static final /* synthetic */ String access$onlyLetters(KeepingSimilarThreadsClose $this, String threadName) {
                return $this.onlyLetters(threadName);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001c\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Companion;", "", "()V", "buildSelector", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparatorSelector;", "threads", "", "Lcom/intellij/profiler/model/ThreadInfo;", "getCommonPrimaryMetric", "Lcom/intellij/profiler/model/ThreadMetric;", "intellij.profiler.common"})
        public static final class Companion {
            @Nullable
            public final ThreadListComparatorSelector buildSelector(@NotNull Collection<? extends ThreadInfo> threads) {
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                ThreadMetric<?> threadMetric = this.getCommonPrimaryMetric(threads);
                if (threadMetric == null) {
                    return null;
                }
                ThreadMetric<?> primaryMetric = threadMetric;
                ByPrimaryMetric byPrimaryMetric = new ByPrimaryMetric(primaryMetric);
                return new ThreadListComparatorSelector(threads, Default.INSTANCE, byPrimaryMetric);
            }

            /*
             * WARNING - void declaration
             */
            private final ThreadMetric<?> getCommonPrimaryMetric(Collection<? extends ThreadInfo> threads) {
                void $this$filterTo$iv$iv;
                ThreadMetric it;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = threads;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ThreadInfo threadInfo = (ThreadInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ThreadMetric<?> threadMetric = it.getMetrics().getPrimaryMetric().getMetric();
                    collection.add(threadMetric);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ThreadMetric)element$iv$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)NoMetric.INSTANCE) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (ThreadMetric)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fJ\b\u0010 \u001a\u00020\u001cH\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparatorSelector;", "", "threads", "", "Lcom/intellij/profiler/model/ThreadInfo;", "defaultComparator", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Default;", "byPrimaryMetricComparator", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$ByPrimaryMetric;", "(Ljava/util/Collection;Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$Default;Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator$ByPrimaryMetric;)V", "allComparators", "", "Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "getAllComparators", "()Ljava/util/List;", "currentComparator", "getCurrentComparator", "()Lcom/intellij/profiler/ui/threadview/ThreadListSynchronizer$ThreadListComparator;", "defaultSelected", "", "keepingSimilarThreadsCloseSelected", "lastComparator", "persistentPrimaryMetricOrNull", "Lcom/intellij/profiler/model/PersistentMetric;", "primaryMetricSelected", "threadListOptions", "Lcom/intellij/profiler/ThreadListOptions;", "deselect", "", "comparator", "isSelected", "select", "updatePersistentState", "intellij.profiler.common"})
    private static final class ThreadListComparatorSelector {
        private final PersistentMetric persistentPrimaryMetricOrNull;
        private final ThreadListOptions threadListOptions;
        private boolean defaultSelected;
        private boolean primaryMetricSelected;
        private boolean keepingSimilarThreadsCloseSelected;
        @NotNull
        private final List<ThreadListComparator> allComparators;
        private ThreadListComparator lastComparator;
        private final Collection<ThreadInfo> threads;
        private final ThreadListComparator.Default defaultComparator;
        private final ThreadListComparator.ByPrimaryMetric byPrimaryMetricComparator;

        @NotNull
        public final List<ThreadListComparator> getAllComparators() {
            return this.allComparators;
        }

        @NotNull
        public final ThreadListComparator getCurrentComparator() {
            ThreadListComparator result2;
            ThreadListComparator threadListComparator;
            if (this.defaultSelected) {
                threadListComparator = this.defaultComparator;
            } else {
                if (!this.primaryMetricSelected) {
                    return this.lastComparator;
                }
                threadListComparator = result2 = (ThreadListComparator)this.byPrimaryMetricComparator;
            }
            if (this.keepingSimilarThreadsCloseSelected) {
                result2 = new ThreadListComparator.KeepingSimilarThreadsClose(this.threads, result2);
            }
            ThreadListComparator threadListComparator2 = result2;
            boolean bl = false;
            boolean bl2 = false;
            ThreadListComparator it = threadListComparator2;
            boolean bl3 = false;
            this.lastComparator = it;
            return threadListComparator2;
        }

        public final boolean isSelected(@NotNull ThreadListComparator comparator2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
            ThreadListComparator threadListComparator = comparator2;
            if (threadListComparator instanceof ThreadListComparator.Default) {
                bl = this.defaultSelected;
            } else if (threadListComparator instanceof ThreadListComparator.ByPrimaryMetric) {
                bl = this.primaryMetricSelected;
            } else if (threadListComparator instanceof ThreadListComparator.KeepingSimilarThreadsClose) {
                bl = this.keepingSimilarThreadsCloseSelected;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        public final void select(@NotNull ThreadListComparator comparator2) {
            Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
            ThreadListComparator threadListComparator = comparator2;
            if (threadListComparator instanceof ThreadListComparator.Default) {
                this.defaultSelected = true;
                this.primaryMetricSelected = false;
            } else if (threadListComparator instanceof ThreadListComparator.ByPrimaryMetric) {
                this.defaultSelected = false;
                this.primaryMetricSelected = true;
            } else if (threadListComparator instanceof ThreadListComparator.KeepingSimilarThreadsClose) {
                this.keepingSimilarThreadsCloseSelected = true;
            }
            this.updatePersistentState();
        }

        public final void deselect(@NotNull ThreadListComparator comparator2) {
            Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
            ThreadListComparator threadListComparator = comparator2;
            if (threadListComparator instanceof ThreadListComparator.Default) {
                this.defaultSelected = false;
            } else if (threadListComparator instanceof ThreadListComparator.ByPrimaryMetric) {
                this.primaryMetricSelected = false;
            } else if (threadListComparator instanceof ThreadListComparator.KeepingSimilarThreadsClose) {
                this.keepingSimilarThreadsCloseSelected = false;
            }
            this.updatePersistentState();
        }

        private final void updatePersistentState() {
            this.threadListOptions.setSortByName(this.defaultSelected);
            PersistentMetric persistentMetric = this.persistentPrimaryMetricOrNull;
            if (persistentMetric != null) {
                PersistentMetric persistentMetric2 = persistentMetric;
                boolean bl = false;
                boolean bl2 = false;
                PersistentMetric metric = persistentMetric2;
                boolean bl3 = false;
                this.threadListOptions.getSortMetrics().put(metric.getPersistentName(), this.primaryMetricSelected);
            }
            this.threadListOptions.setKeepSimilarThreadsClose(this.keepingSimilarThreadsCloseSelected);
        }

        /*
         * WARNING - void declaration
         */
        public ThreadListComparatorSelector(@NotNull Collection<? extends ThreadInfo> threads, @NotNull ThreadListComparator.Default defaultComparator, @NotNull ThreadListComparator.ByPrimaryMetric byPrimaryMetricComparator) {
            Object object;
            block5: {
                block4: {
                    void metric;
                    Intrinsics.checkNotNullParameter(threads, (String)"threads");
                    Intrinsics.checkNotNullParameter((Object)defaultComparator, (String)"defaultComparator");
                    Intrinsics.checkNotNullParameter((Object)byPrimaryMetricComparator, (String)"byPrimaryMetricComparator");
                    this.threads = threads;
                    this.defaultComparator = defaultComparator;
                    this.byPrimaryMetricComparator = byPrimaryMetricComparator;
                    ThreadMetric<?> threadMetric = this.byPrimaryMetricComparator.getPrimaryMetric();
                    if (!(threadMetric instanceof PersistentMetric)) {
                        threadMetric = null;
                    }
                    this.persistentPrimaryMetricOrNull = (PersistentMetric)((Object)threadMetric);
                    this.threadListOptions = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getThreadListOptions();
                    this.defaultSelected = this.threadListOptions.getSortByName();
                    ThreadListComparatorSelector threadListComparatorSelector = this;
                    object = this.persistentPrimaryMetricOrNull;
                    if (object == null) break block4;
                    PersistentMetric persistentMetric = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    PersistentMetric persistentMetric2 = persistentMetric;
                    ThreadListComparatorSelector threadListComparatorSelector2 = threadListComparatorSelector;
                    boolean bl3 = false;
                    Boolean bl4 = this.threadListOptions.getSortMetrics().computeIfAbsent(metric.getPersistentName(), new Function((PersistentMetric)metric){
                        final /* synthetic */ PersistentMetric $metric;

                        @NotNull
                        public final Boolean apply(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.$metric.isVisibleByDefault();
                        }
                        {
                            this.$metric = persistentMetric;
                        }
                    });
                    threadListComparatorSelector = threadListComparatorSelector2;
                    object = bl4;
                    if (object != null) break block5;
                }
                object = true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"persistentPrimaryMetricO\u2026ByDefault }\n    } ?: true");
            threadListComparatorSelector.primaryMetricSelected = (Boolean)object;
            this.keepingSimilarThreadsCloseSelected = this.threadListOptions.getKeepSimilarThreadsClose();
            this.allComparators = CollectionsKt.listOf((Object[])new ThreadListComparator[]{this.defaultComparator, this.byPrimaryMetricComparator});
            this.lastComparator = this.getCurrentComparator();
        }
    }
}

