/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.timeline;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.profiler.charts.ChartUtils;
import com.intellij.profiler.charts.Grid;
import com.intellij.profiler.charts.GridChartWrapper;
import com.intellij.profiler.charts.GridLine;
import com.intellij.profiler.charts.MinMax;
import com.intellij.profiler.charts.ValueIterable;
import com.intellij.profiler.charts.XYChartComponent;
import com.intellij.profiler.charts.XYLineChart;
import com.intellij.profiler.ui.timeline.DefaultTimelineCellRenderer;
import com.intellij.profiler.ui.timeline.TimelineCellRenderer;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.profiler.ui.timeline.TimelineConverter;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.math.MathKt;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0016\u0018\u0000 9*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u00059:;<=B'\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002012\u0006\u00103\u001a\u000204H\u0014J\u000e\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002072\u0006\u00106\u001a\u00020\u0014R&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u00120\u0010R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR+\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u001e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\u001b\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010%\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0017\"\u0004\b'\u0010\u0019R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006>"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "T", "F", "Ljavax/swing/JComponent;", "model", "Lcom/intellij/profiler/ui/timeline/TimelineModel;", "values", "", "(Lcom/intellij/profiler/ui/timeline/TimelineModel;Ljava/lang/Iterable;)V", "cellRenderer", "Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "getCellRenderer", "()Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "setCellRenderer", "(Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;)V", "header", "Lcom/intellij/profiler/ui/timeline/TimelineComponent$Header;", "getHeader", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Header;", "<set-?>", "", "headerHeight", "getHeaderHeight", "()I", "setHeaderHeight", "(I)V", "headerHeight$delegate", "Lkotlin/properties/ReadWriteProperty;", "getModel", "()Lcom/intellij/profiler/ui/timeline/TimelineModel;", "Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "range", "getRange", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "setRange", "(Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;)V", "range$delegate", "rowHeight", "getRowHeight", "setRowHeight", "timeFormatter", "Lcom/intellij/profiler/ui/timeline/TimelineConverter;", "getTimeFormatter", "()Lcom/intellij/profiler/ui/timeline/TimelineConverter;", "setTimeFormatter", "(Lcom/intellij/profiler/ui/timeline/TimelineConverter;)V", "getValues", "()Ljava/lang/Iterable;", "addNotify", "", "paintComponent", "g", "Ljava/awt/Graphics;", "toScreenCoordinate", "x", "", "toWorldCoordinate", "Companion", "Header", "MyViewportListener", "Range", "RowDrawer", "intellij.profiler.common"})
public class TimelineComponent<T, F>
extends JComponent {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Header header;
    @NotNull
    private TimelineCellRenderer<T, F> cellRenderer;
    @NotNull
    private TimelineConverter timeFormatter;
    @NotNull
    private final ReadWriteProperty range$delegate;
    private int rowHeight;
    @NotNull
    private final ReadWriteProperty headerHeight$delegate;
    @NotNull
    private final TimelineModel<T, F> model;
    @NotNull
    private final Iterable<T> values;
    @NotNull
    private static final Range DEFAULT_RANGE;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(TimelineComponent.class, "range", "getRange()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(TimelineComponent.class, "headerHeight", "getHeaderHeight()I", 0))};
        Companion = new Companion(null);
        DEFAULT_RANGE = new Range(0L, 3600000L);
    }

    @NotNull
    public final Header getHeader() {
        return this.header;
    }

    @NotNull
    public final TimelineCellRenderer<T, F> getCellRenderer() {
        return this.cellRenderer;
    }

    public final void setCellRenderer(@NotNull TimelineCellRenderer<T, F> timelineCellRenderer2) {
        Intrinsics.checkNotNullParameter(timelineCellRenderer2, (String)"<set-?>");
        this.cellRenderer = timelineCellRenderer2;
    }

    @NotNull
    public final TimelineConverter getTimeFormatter() {
        return this.timeFormatter;
    }

    public final void setTimeFormatter(@NotNull TimelineConverter timelineConverter) {
        Intrinsics.checkNotNullParameter((Object)timelineConverter, (String)"<set-?>");
        this.timeFormatter = timelineConverter;
    }

    @NotNull
    public final Range getRange() {
        return (Range)this.range$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setRange(@NotNull Range range2) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"<set-?>");
        this.range$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)range2);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    public final int getHeaderHeight() {
        return ((Number)this.headerHeight$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    public final void setHeaderHeight(int n) {
        this.headerHeight$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)n);
    }

    /*
     * WARNING - void declaration
     */
    public final long toWorldCoordinate(int x) {
        Range range2 = this.getRange();
        boolean bl = false;
        boolean bl2 = false;
        Range $dstr$start$end = range2;
        boolean bl3 = false;
        long l = $dstr$start$end.component1();
        long end = $dstr$start$end.component2();
        if (this.getWidth() != 0) {
            void start2;
            return MathKt.roundToLong((double)((double)x / (double)this.getWidth() * (double)(end - start2))) + start2;
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public final int toScreenCoordinate(long x) {
        void start2;
        Range range2 = this.getRange();
        boolean bl = false;
        boolean bl2 = false;
        Range $dstr$start$end = range2;
        boolean bl3 = false;
        long l = $dstr$start$end.component1();
        long end = $dstr$start$end.component2();
        if (end != start2) {
            return MathKt.roundToInt((double)((double)(x - start2) / (double)(end - start2) * (double)this.getWidth()));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.getRowHeight() < 1) {
            return;
        }
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2d = (Graphics2D)graphics;
        Rectangle visibleRect = this.getVisibleRect();
        g2d.setClip(visibleRect);
        g2d.setColor((Color)JBColor.WHITE);
        g2d.fillRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
        g2d.setColor(this.header.getChart().getGridColor());
        Iterable $this$forEach$iv = this.header.getChart().getGrid().getXLines();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            int x = this.toScreenCoordinate(it);
            g2d.drawLine(x, visibleRect.y, x, visibleRect.y + visibleRect.height);
        }
        long startX = this.toWorldCoordinate(visibleRect.x);
        long endX = this.toWorldCoordinate(visibleRect.x + visibleRect.width);
        int startY = visibleRect.y - visibleRect.y % this.getRowHeight() + this.getInsets().top;
        int skippedRows = (startY - this.getInsets().top) / this.getRowHeight();
        Iterable<T> $this$forEachIndexed$iv = this.values;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            void any;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            T t = item$iv;
            int i2 = n;
            boolean bl2 = false;
            if (any == null) continue;
            if (this.cellRenderer.isSelected(skippedRows + i2)) {
                g2d.setColor(this.cellRenderer.getSelectionBackground());
                g2d.fillRect(0, startY + i2 * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
            Rectangle rectangle = visibleRect;
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"visibleRect");
            RowDrawer drawer = new RowDrawer(rectangle);
            Iterable<TimelineModel.TimelineInterval<F>> $this$forEach$iv2 = this.model.getIntervals(any);
            boolean $i$f$forEach2 = false;
            Iterator<TimelineModel.TimelineInterval<F>> iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int x2;
                int x1;
                TimelineModel.TimelineInterval<F> element$iv;
                TimelineModel.TimelineInterval<F> it = element$iv = iterator2.next();
                boolean bl3 = false;
                boolean isOutOfVisibleArea = it.getStart() > endX || it.getEnd() < startX;
                if (isOutOfVisibleArea || !drawer.canDraw(x1 = this.toScreenCoordinate(it.getStart()), x2 = this.toScreenCoordinate(it.getEnd()))) continue;
                int n2 = x2 - x1;
                int n3 = 1;
                boolean bl4 = false;
                Graphics graphics2 = g2d.create(x1, startY + i2 * this.getRowHeight(), Math.max(n2, n3), this.getRowHeight());
                if (graphics2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                }
                Graphics2D cg = (Graphics2D)graphics2;
                try {
                    this.cellRenderer.paint(this, cg, it);
                }
                finally {
                    cg.dispose();
                }
            }
        }
        g2d.dispose();
    }

    @Override
    public void addNotify() {
        block0: {
            super.addNotify();
            JScrollPane jScrollPane = ComponentUtil.getScrollPane((Component)this);
            if (jScrollPane == null) break block0;
            JScrollPane jScrollPane2 = jScrollPane;
            boolean bl = false;
            boolean bl2 = false;
            JScrollPane $this$apply = jScrollPane2;
            boolean bl3 = false;
            $this$apply.setColumnHeaderView((Component)((Object)this.header));
            $this$apply.getViewport().addChangeListener(new MyViewportListener());
        }
    }

    @NotNull
    public final TimelineModel<T, F> getModel() {
        return this.model;
    }

    @NotNull
    public final Iterable<T> getValues() {
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    public TimelineComponent(@NotNull TimelineModel<T, F> model2, @NotNull Iterable<? extends T> values2) {
        Integer initialValue$iv;
        void $this$apply;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.model = model2;
        this.values = values2;
        Header header2 = new Header();
        boolean bl = false;
        boolean bl2 = false;
        Header header3 = header2;
        TimelineComponent timelineComponent = this;
        boolean bl3 = false;
        $this$apply.setBorder(JBUI.Borders.customLine((Color)UIUtil.getBoundsColor(), (int)0, (int)0, (int)1, (int)0));
        $this$apply.setPreferredSize(new Dimension($this$apply.getWidth(), JBUI.getInt((String)"TableHeader.height", (int)25)));
        Unit unit = Unit.INSTANCE;
        timelineComponent.header = header2;
        this.cellRenderer = new DefaultTimelineCellRenderer();
        this.timeFormatter = new TimelineConverter(this){
            final /* synthetic */ TimelineComponent this$0;

            @NotNull
            public final String convert(int $noName_0, long time) {
                String string = NlsMessages.formatDuration((long)(time - this.this$0.getRange().getStart()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"NlsMessages.formatDuration(time - range.start)");
                return string;
            }
            {
                this.this$0 = timelineComponent;
            }
        };
        header2 = Delegates.INSTANCE;
        Range range2 = DEFAULT_RANGE;
        boolean $i$f$observable = false;
        this.range$delegate = (ReadWriteProperty)new ObservableProperty<Range>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ TimelineComponent this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = timelineComponent;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property2, Object oldValue, Object newValue2) {
                void newValue3;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                Range range2 = (Range)newValue2;
                Range range3 = (Range)oldValue;
                KProperty $noName_0 = property2;
                boolean bl = false;
                this.this$0.getHeader().getChart().getRanges().setXMin(newValue3.getStart());
                this.this$0.getHeader().getChart().getRanges().setXMax(newValue3.getStop());
            }
        };
        this.rowHeight = 20;
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = this.header.getPreferredSize().height;
        $i$f$observable = false;
        this.headerHeight$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ TimelineComponent this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = timelineComponent;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property2, Object oldValue, Object newValue2) {
                void newValue3;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                int n = ((Number)newValue2).intValue();
                int n2 = ((Number)oldValue).intValue();
                KProperty $noName_0 = property2;
                boolean bl = false;
                this.this$0.getHeader().setPreferredSize(new Dimension(this.this$0.getWidth(), (int)newValue3));
                this.this$0.getHeader().setSize(this.this$0.getPreferredSize());
                this.this$0.getHeader().revalidate();
                this.this$0.getHeader().repaint();
            }
        };
    }

    @NotNull
    public static final Range getDEFAULT_RANGE() {
        Companion companion = Companion;
        return DEFAULT_RANGE;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$RowDrawer;", "", "visibleRect", "Ljava/awt/Rectangle;", "(Ljava/awt/Rectangle;)V", "painted", "", "getVisibleRect", "()Ljava/awt/Rectangle;", "canDraw", "", "x1", "", "x2", "intellij.profiler.common"})
    private static final class RowDrawer {
        private final boolean[] painted;
        @NotNull
        private final Rectangle visibleRect;

        public final boolean canDraw(int x1, int x2) {
            int index2;
            int n;
            if (x1 < x2) {
                return true;
            }
            if (x1 == x2 && 0 <= (n = (index2 = x1 - this.visibleRect.x)) && this.painted.length > n) {
                boolean isPainted = this.painted[index2];
                this.painted[index2] = true;
                return !isPainted;
            }
            return false;
        }

        @NotNull
        public final Rectangle getVisibleRect() {
            return this.visibleRect;
        }

        public RowDrawer(@NotNull Rectangle visibleRect) {
            Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
            this.visibleRect = visibleRect;
            this.painted = new boolean[this.visibleRect.width + 1];
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "", "duration", "", "(J)V", "start", "stop", "(JJ)V", "getDuration", "()J", "getStart", "getStop", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.profiler.common"})
    public static final class Range {
        private final long start;
        private final long stop;

        public final long getDuration() {
            return this.stop - this.start;
        }

        public final long getStart() {
            return this.start;
        }

        public final long getStop() {
            return this.stop;
        }

        public Range(long start2, long stop2) {
            this.start = start2;
            this.stop = stop2;
        }

        public Range(long duration) {
            this(0L, duration);
        }

        public final long component1() {
            return this.start;
        }

        public final long component2() {
            return this.stop;
        }

        @NotNull
        public final Range copy(long start2, long stop2) {
            return new Range(start2, stop2);
        }

        public static /* synthetic */ Range copy$default(Range range2, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = range2.start;
            }
            if ((n & 2) != 0) {
                l2 = range2.stop;
            }
            return range2.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "Range(start=" + this.start + ", stop=" + this.stop + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.start) * 31 + Long.hashCode(this.stop);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Range)) break block3;
                    Range range2 = (Range)object;
                    if (this.start != range2.start || this.stop != range2.stop) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$Header;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "(Lcom/intellij/profiler/ui/timeline/TimelineComponent;)V", "chart", "Lcom/intellij/profiler/charts/XYLineChart;", "", "", "getChart", "()Lcom/intellij/profiler/charts/XYLineChart;", "value", "", "isDatasetVisible", "()Z", "setDatasetVisible", "(Z)V", "spaceWidth", "", "getSpaceWidth", "intellij.profiler.common"})
    public final class Header
    extends BorderLayoutPanel {
        @NotNull
        private final XYLineChart<Long, Double> chart = ChartUtils.lineChart((Function1)new Function1<XYLineChart<Long, Double>, Unit>(this){
            final /* synthetic */ Header this$0;

            public final void invoke(@NotNull XYLineChart<Long, Double> $this$lineChart) {
                Intrinsics.checkNotNullParameter($this$lineChart, (String)"$receiver");
                ChartUtils.ranges((XYChartComponent)$this$lineChart, Header.chart.1.INSTANCE);
                $this$lineChart.setDatasets(this.this$0.TimelineComponent.this.getModel().getCharts());
                ChartUtils.grid((GridChartWrapper)$this$lineChart, (Function1)new Function1<Grid<Long, Double>, Unit>(this, $this$lineChart){
                    final /* synthetic */ chart.1 this$0;
                    final /* synthetic */ XYLineChart $this_lineChart;

                    public final void invoke(@NotNull Grid<Long, Double> $this$grid) {
                        Intrinsics.checkNotNullParameter($this$grid, (String)"$receiver");
                        $this$grid.setXLines(new ValueIterable<Long>(this, $this$grid){
                            final /* synthetic */ chart.2 this$0;
                            final /* synthetic */ Grid $this_grid;

                            @NotNull
                            public Iterator<Long> iterator() {
                                int scale = ChartUtils.findScale(this.this$0.$this_lineChart, ((Number)this.$this_grid.getXMin()).longValue(), ((Number)this.$this_grid.getXMax()).longValue(), Header.access$getSpaceWidth(this.this$0.this$0.this$0));
                                long xMin = (((Number)this.$this_grid.getXMin()).longValue() - this.this$0.this$0.this$0.TimelineComponent.this.getRange().getStart()) / (long)scale * (long)scale + this.this$0.this$0.this$0.TimelineComponent.this.getRange().getStart();
                                long xMax = ((Number)this.$this_grid.getXMax()).longValue();
                                long l = xMin;
                                return (Iterator)RangesKt.step((LongProgression)((LongProgression)new LongRange(l, xMax)), (long)scale).iterator();
                            }
                            {
                                this.this$0 = this$0;
                                this.$this_grid = $receiver;
                            }
                        });
                        ChartUtils.xPainter($this$grid, (Function1)new Function1<GridLine<Long, Double, Long>, Unit>(this){
                            final /* synthetic */ chart.2 this$0;

                            public final void invoke(@NotNull GridLine<Long, Double, Long> $this$xPainter) {
                                Intrinsics.checkNotNullParameter($this$xPainter, (String)"$receiver");
                                int scale = ChartUtils.findScale(this.this$0.$this_lineChart, $this$xPainter.getXY().getXMin(), $this$xPainter.getXY().getXMax(), Header.access$getSpaceWidth(this.this$0.this$0.this$0));
                                $this$xPainter.setPaintLine(($this$xPainter.getValue() - this.this$0.this$0.this$0.TimelineComponent.this.getRange().getStart()) % (long)scale == 0L);
                                $this$xPainter.setVerticalAlignment(3);
                                $this$xPainter.setHorizontalAlignment(4);
                                if ($this$xPainter.getPaintLine()) {
                                    $this$xPainter.setLabel(this.this$0.this$0.this$0.TimelineComponent.this.getTimeFormatter().convert(scale, $this$xPainter.getValue()));
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        $this$grid.setYOrigin((Double)((Number)1.0));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_lineChart = xYLineChart;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = header2;
                super(1);
            }
        });
        private int spaceWidth = -1;

        @NotNull
        public final XYLineChart<Long, Double> getChart() {
            return this.chart;
        }

        public final boolean isDatasetVisible() {
            Collection collection = this.chart.getDatasets();
            boolean bl = false;
            return !collection.isEmpty();
        }

        public final void setDatasetVisible(boolean value2) {
            List list2 = this.chart.getDatasets();
            if (list2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.profiler.charts.XYLineDataset<kotlin.Long, kotlin.Double>>");
            }
            List list3 = TypeIntrinsics.asMutableList(list2);
            boolean bl = false;
            boolean bl2 = false;
            List $this$with = list3;
            boolean bl3 = false;
            if (value2) {
                $this$with.addAll((Collection)TimelineComponent.this.getModel().getCharts());
            } else {
                $this$with.clear();
            }
        }

        private final int getSpaceWidth() {
            if (this.spaceWidth < 0) {
                int n;
                Header header2;
                Header header3 = this;
                try {
                    header2 = header3;
                    String stub = TimelineComponent.this.getTimeFormatter().convert(0, TimelineComponent.this.getRange().getStart() + 23456789L);
                    FontRenderContext frc = new FontRenderContext(null, true, true);
                    Rectangle2D rectangle2D = this.getFont().getStringBounds(stub, frc);
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"font.getStringBounds(stub, frc)");
                    n = MathKt.roundToInt((double)rectangle2D.getWidth());
                }
                catch (Throwable ignored) {
                    header2 = header3;
                    n = 150;
                }
                header2.spaceWidth = n;
            }
            return this.spaceWidth;
        }

        public Header() {
            this.addToCenter(this.chart.getComponent());
        }

        public static final /* synthetic */ int access$getSpaceWidth(Header $this) {
            return $this.getSpaceWidth();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$MyViewportListener;", "Ljavax/swing/event/ChangeListener;", "()V", "stateChanged", "", "e", "Ljavax/swing/event/ChangeEvent;", "intellij.profiler.common"})
    private static final class MyViewportListener
    implements ChangeListener {
        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getSource();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.JViewport");
            }
            JViewport port = (JViewport)object;
            Component component2 = port.getView();
            if (component2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.profiler.ui.timeline.TimelineComponent<*, *>");
            }
            TimelineComponent line = (TimelineComponent)component2;
            int x = port.getViewPosition().x;
            int width = port.getWidth();
            Object object2 = line.getHeader().getChart().getRanges();
            boolean bl = false;
            boolean bl2 = false;
            Object $this$with = object2;
            boolean bl3 = false;
            ((MinMax)$this$with).setXMin(line.toWorldCoordinate(x));
            ((MinMax)$this$with).setXMax(line.toWorldCoordinate(x + width) + 1L);
            object2 = line.getHeader().getChart().getMargins();
            bl = false;
            bl2 = false;
            $this$with = object2;
            boolean bl4 = false;
            int start2 = line.toScreenCoordinate(((Number)line.getHeader().getChart().getRanges().getXMin()).longValue());
            int end = line.toScreenCoordinate(((Number)line.getHeader().getChart().getRanges().getXMax()).longValue());
            Rectangle rect = port.getViewRect();
            ((Insets)$this$with).left = start2 - rect.x;
            int n = rect.x;
            Container container = port.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"port.parent");
            ((Insets)$this$with).right = n + container.getWidth() - end;
            line.getHeader().setPreferredSize(new Dimension(width, line.getHeaderHeight()));
            line.getHeader().repaint();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineComponent$Companion;", "", "()V", "DEFAULT_RANGE", "Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "getDEFAULT_RANGE$annotations", "getDEFAULT_RANGE", "()Lcom/intellij/profiler/ui/timeline/TimelineComponent$Range;", "intellij.profiler.common"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getDEFAULT_RANGE$annotations() {
        }

        @NotNull
        public final Range getDEFAULT_RANGE() {
            return DEFAULT_RANGE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

