/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterfallSupport<T> {
    private final Map<T, T> myWaterfall;
    private final Traverser<T> myTraverser;
    private final Predicate<? super T> myFilter;
    private final T rootsParent;
    private final Consumer<T> empty;

    public WaterfallSupport(@NotNull Traverser<T> traverser, @NotNull Predicate<? super T> filter, @Nullable T root) {
        if (traverser == null) {
            WaterfallSupport.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            WaterfallSupport.$$$reportNull$$$0(1);
        }
        this.myWaterfall = new HashMap<T, T>();
        this.empty = v -> {};
        this.myTraverser = traverser;
        this.myFilter = filter;
        this.rootsParent = root == null ? null : this.myTraverser.getParent(root);
        Object v0 = this.rootsParent;
        if (root != null) {
            this.myWaterfall.put(root, root);
        }
    }

    public WaterfallSupport(@NotNull Traverser<T> traverser, @NotNull Predicate<? super T> filter) {
        if (traverser == null) {
            WaterfallSupport.$$$reportNull$$$0(2);
        }
        if (filter == null) {
            WaterfallSupport.$$$reportNull$$$0(3);
        }
        this(traverser, filter, null);
    }

    public T forward(T element2) {
        T forwardValue = this.myWaterfall.get(element2);
        if (forwardValue == null) {
            T waterfallValue = this.waterfall(element2);
            if (waterfallValue != element2) {
                if (this.backward(element2) == element2) {
                    this.myWaterfall.put(element2, waterfallValue);
                }
                return waterfallValue;
            }
            forwardValue = element2;
        }
        return forwardValue;
    }

    public T backward(T element2) {
        return this.backward(element2, this.empty);
    }

    public T backward(T element2, Consumer<? super T> consumer) {
        for (Map.Entry entry2 : this.myWaterfall.entrySet()) {
            if (entry2.getValue() != element2) continue;
            return this.backward(entry2.getValue(), v -> v != entry2.getKey(), consumer);
        }
        LinkedList parents2 = new LinkedList();
        Object backward = this.backward(element2, v -> !this.myWaterfall.containsKey(v), v -> parents2.add(v));
        if (!parents2.contains(this.myWaterfall.get(backward))) {
            parents2.forEach(consumer);
            return (T)backward;
        }
        return element2;
    }

    private T backward(T element2, Predicate<? super T> canContinue, Consumer<? super T> consumer) {
        T backwardValue = element2;
        while (canContinue.test(backwardValue)) {
            consumer.accept(backwardValue);
            if ((backwardValue = this.myTraverser.getParent(backwardValue)) != this.rootsParent) continue;
            consumer.accept(this.rootsParent);
            return element2;
        }
        consumer.accept(backwardValue);
        return backwardValue;
    }

    public List<T> fold(T start2, T end) {
        T current2 = end;
        ArrayList<T> nodes = new ArrayList<T>();
        T waterfall2 = this.waterfall(start2);
        while (current2 != start2 && current2 != this.rootsParent) {
            nodes.add(0, current2);
            if (waterfall2 == current2 && current2 != end) {
                throw new IllegalArgumentException(start2 + " and " + end + " cannot be folded");
            }
            current2 = this.myTraverser.getParent(current2);
        }
        if (current2 != start2) {
            throw new IllegalArgumentException(start2 + " isn't parent of " + end + " in this chain: ");
        }
        T oldValue = this.myWaterfall.get(current2);
        if (oldValue != null && oldValue != current2) {
            throw new IllegalArgumentException(current2 + " isn't equal to removed value " + oldValue);
        }
        this.myWaterfall.keySet().removeAll(nodes);
        if (this.myWaterfall.put(current2, end) != oldValue) {
            throw new IllegalStateException("Data changed while processing fold");
        }
        nodes.add(0, oldValue);
        return nodes;
    }

    public List<T> unfold(T start2, T end) {
        HashSet parents2 = new HashSet();
        Object left = this.backward(start2, v -> !this.myWaterfall.containsKey(v), parents2::add);
        if (!this.contains(left) || parents2.contains(this.myWaterfall.get(left))) {
            return Collections.emptyList();
        }
        Object right = this.waterfall(left);
        ArrayList<T> folded = new ArrayList<T>(10);
        T current2 = end;
        T startParent = this.myTraverser.getParent(start2);
        while (current2 != startParent) {
            this.myWaterfall.put(current2, current2);
            folded.add(0, current2);
            current2 = this.myTraverser.getParent(current2);
        }
        this.myWaterfall.put(end, right);
        this.myWaterfall.put(left, start2);
        return folded;
    }

    public boolean contains(T element2) {
        return this.myWaterfall.containsKey(element2);
    }

    public void clear() {
        this.myWaterfall.clear();
    }

    private T waterfall(T element2) {
        List<T> children2;
        if (!this.myFilter.test(element2) || this.myTraverser.getParent(element2) == this.rootsParent) {
            return element2;
        }
        T current2 = element2;
        while ((children2 = this.myTraverser.getChildren(current2)).size() == 1 && this.myFilter.test(children2.get(0))) {
            current2 = children2.get(0);
        }
        return current2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "traverser";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "filter";
                break;
            }
        }
        objectArray[1] = "com/intellij/profiler/ui/treetable/WaterfallSupport";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Traverser<T> {
        public T getParent(T var1);

        public List<T> getChildren(T var1);
    }
}

