/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.OutboundSemiGraph;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebugUtil {
    private static final Logger LOG = Logger.getInstance(DebugUtil.class);
    public static boolean CHECK;
    public static final boolean DO_EXPENSIVE_CHECKS;
    public static final boolean CHECK_INSIDE_ATOMIC_ACTION_ENABLED;
    private static final ThreadLocal<Object> ourPsiModificationTrace;
    private static final ThreadLocal<Integer> ourPsiModificationDepth;

    @NotNull
    public static String psiTreeToString(@NotNull PsiElement element2, boolean showWhitespaces) {
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(0);
        }
        ASTNode node2 = SourceTreeToPsiMap.psiElementToTree(element2);
        assert (node2 != null) : element2;
        return DebugUtil.treeToString(node2, showWhitespaces);
    }

    @NotNull
    public static String treeToString(@NotNull ASTNode root, boolean showWhitespaces) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(1);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, showWhitespaces, false, false, true);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String nodeTreeToString(@NotNull ASTNode root, boolean showWhitespaces) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(3);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, showWhitespaces, false, false, false);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String treeToString(@NotNull ASTNode root, boolean showWhitespaces, boolean showRanges) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(5);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, showWhitespaces, showRanges, false, true);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root, int indent, boolean showWhitespaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(7);
        }
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(8);
        }
        DebugUtil.treeToBuffer(buffer, root, indent, showWhitespaces, showRanges, showChildrenRanges, usePsi, null);
    }

    private static void treeToBuffer(Appendable buffer, ASTNode root, int indent, boolean showWhitespaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, @Nullable PairConsumer<? super PsiElement, ? super Consumer<? super PsiElement>> extra) {
        ((TreeElement)root).acceptTree(new TreeToBuffer(buffer, indent, showWhitespaces, showRanges, showChildrenRanges, usePsi, extra));
    }

    @NotNull
    public static String lightTreeToString(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, boolean showWhitespaces) {
        if (tree == null) {
            DebugUtil.$$$reportNull$$$0(9);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.lightTreeToBuffer(tree, (LighterASTNode)tree.getRoot(), buffer, 0, showWhitespaces);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void lightTreeToBuffer(FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode node2, Appendable buffer, int indent, boolean showWhitespaces) {
        if (node2 == null) {
            DebugUtil.$$$reportNull$$$0(11);
        }
        IElementType tokenType = node2.getTokenType();
        if (!showWhitespaces && tokenType == TokenType.WHITE_SPACE) {
            return;
        }
        boolean isLeaf = node2 instanceof LighterASTTokenNode;
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            if (tokenType == TokenType.ERROR_ELEMENT) {
                buffer.append("PsiErrorElement:").append(PsiBuilderImpl.getErrorMessage(node2));
            } else if (tokenType == TokenType.WHITE_SPACE) {
                buffer.append("PsiWhiteSpace");
            } else {
                buffer.append(isLeaf ? "PsiElement" : "Element").append('(').append(tokenType.toString()).append(')');
            }
            if (isLeaf) {
                String text2 = ((LighterASTTokenNode)node2).getText().toString();
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text2)).append("')");
            }
            buffer.append('\n');
            if (!isLeaf) {
                Ref kids = new Ref();
                int numKids = tree.getChildren((Object)node2, kids);
                if (numKids == 0) {
                    StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(indent + 2));
                    buffer.append("<empty list>\n");
                } else {
                    for (int i2 = 0; i2 < numKids; ++i2) {
                        DebugUtil.lightTreeToBuffer(tree, ((LighterASTNode[])kids.get())[i2], buffer, indent + 2, showWhitespaces);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public static String stubTreeToString(@NotNull Stub root) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(12);
        }
        StringBuilder builder2 = new StringBuilder();
        DebugUtil.stubTreeToBuffer(root, builder2, 0);
        String string = builder2.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static void stubTreeToBuffer(@NotNull Stub node2, @NotNull Appendable buffer, int indent) {
        if (node2 == null) {
            DebugUtil.$$$reportNull$$$0(14);
        }
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(15);
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            ObjectStubSerializer stubType = node2.getStubType();
            if (stubType != null) {
                buffer.append(stubType.toString()).append(':');
            }
            buffer.append(node2.toString()).append('\n');
            List children2 = node2.getChildrenStubs();
            for (Stub child2 : children2) {
                DebugUtil.stubTreeToBuffer(child2, buffer, indent + 2);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void doCheckTreeStructure(@Nullable ASTNode anyElement) {
        if (anyElement == null) {
            return;
        }
        ASTNode root = anyElement;
        while (root.getTreeParent() != null) {
            root = root.getTreeParent();
        }
        if (root instanceof CompositeElement) {
            DebugUtil.checkSubtree((CompositeElement)root);
        }
    }

    private static void checkSubtree(CompositeElement root) {
        if (root.rawFirstChild() == null) {
            if (root.rawLastChild() != null) {
                throw new IncorrectTreeStructureException(root, "firstChild == null, but lastChild != null");
            }
        } else {
            for (TreeElement child2 = root.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                if (child2 instanceof CompositeElement) {
                    DebugUtil.checkSubtree((CompositeElement)child2);
                }
                if (child2.getTreeParent() != root) {
                    throw new IncorrectTreeStructureException(child2, "child has wrong parent value");
                }
                if (child2 == root.getFirstChildNode()) {
                    if (child2.getTreePrev() != null) {
                        throw new IncorrectTreeStructureException(root, "firstChild.prev != null");
                    }
                } else {
                    if (child2.getTreePrev() == null) {
                        throw new IncorrectTreeStructureException(child2, "not first child has prev == null");
                    }
                    if (child2.getTreePrev().getTreeNext() != child2) {
                        throw new IncorrectTreeStructureException(child2, "element.prev.next != element");
                    }
                }
                if (child2.getTreeNext() != null || root.getLastChildNode() == child2) continue;
                throw new IncorrectTreeStructureException(child2, "not last child has next == null");
            }
        }
    }

    public static void checkParentChildConsistent(@NotNull ASTNode element2) {
        ASTNode treeParent;
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(16);
        }
        if ((treeParent = element2.getTreeParent()) == null) {
            return;
        }
        Object[] elements = treeParent.getChildren(null);
        if (ArrayUtil.find((Object[])elements, (Object)element2) == -1) {
            throw new IncorrectTreeStructureException(element2, "child cannot be found among parents children");
        }
    }

    public static void checkSameCharTabs(@NotNull ASTNode element1, @NotNull ASTNode element2) {
        CharTable toCharTab;
        CharTable fromCharTab;
        if (element1 == null) {
            DebugUtil.$$$reportNull$$$0(17);
        }
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(18);
        }
        LOG.assertTrue((fromCharTab = SharedImplUtil.findCharTableByTree(element1)) == (toCharTab = SharedImplUtil.findCharTableByTree(element2)));
    }

    @NotNull
    public static String psiToString(@NotNull PsiElement element2, boolean showWhitespaces) {
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(19);
        }
        return DebugUtil.psiToString(element2, showWhitespaces, false);
    }

    @NotNull
    public static String psiToString(@NotNull PsiElement root, boolean showWhitespaces, boolean showRanges) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(20);
        }
        return DebugUtil.psiToString(root, showWhitespaces, showRanges, null);
    }

    @NotNull
    public static String psiToString(@NotNull PsiElement root, boolean showWhitespaces, boolean showRanges, @Nullable PairConsumer<? super PsiElement, ? super Consumer<? super PsiElement>> extra) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(21);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.psiToBuffer(buffer, root, showWhitespaces, showRanges, extra);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String psiToStringIgnoringNonCode(@NotNull PsiElement element2) {
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(23);
        }
        StringBuilder buffer = new StringBuilder();
        ((TreeElement)element2.getNode()).acceptTree(new TreeToBuffer(buffer, 0, false, false, false, false, null){

            @Override
            protected boolean shouldShowNode(TreeElement node2) {
                return super.shouldShowNode(node2) && !(node2 instanceof PsiErrorElement) && !(node2 instanceof PsiComment) && (!(node2 instanceof LeafPsiElement) || !StringUtil.isEmptyOrSpaces((String)node2.getText())) && !(node2 instanceof OuterLanguageElement);
            }

            @Override
            protected boolean showEmptyChildren() {
                return false;
            }
        });
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static void psiToBuffer(Appendable buffer, PsiElement root, boolean showWhitespaces, boolean showRanges, @Nullable PairConsumer<? super PsiElement, ? super Consumer<? super PsiElement>> extra) {
        ASTNode node2 = root.getNode();
        if (node2 == null) {
            DebugUtil.psiToBuffer(buffer, root, 0, showWhitespaces, showRanges, showRanges, extra);
        } else {
            DebugUtil.treeToBuffer(buffer, node2, 0, showWhitespaces, showRanges, showRanges, true, extra);
        }
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root, int indent, boolean showWhitespaces, boolean showRanges, boolean showChildrenRanges) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(25);
        }
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(26);
        }
        DebugUtil.psiToBuffer(buffer, root, indent, showWhitespaces, showRanges, showChildrenRanges, null);
    }

    private static void psiToBuffer(Appendable buffer, PsiElement root, int indent, boolean showWhitespaces, boolean showRanges, boolean showChildrenRanges, @Nullable PairConsumer<? super PsiElement, ? super Consumer<? super PsiElement>> extra) {
        if (!showWhitespaces && root instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
        try {
            buffer.append(root.toString());
            PsiElement child2 = root.getFirstChild();
            if (child2 == null) {
                String text2 = root.getText();
                assert (text2 != null) : "text is null for <" + root + ">";
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text2)).append("')");
            }
            if (showRanges) {
                buffer.append(root.getTextRange().toString());
            }
            buffer.append("\n");
            while (child2 != null) {
                DebugUtil.psiToBuffer(buffer, child2, indent + 2, showWhitespaces, showChildrenRanges, showChildrenRanges, extra);
                child2 = child2.getNextSibling();
            }
            if (extra != null) {
                Consumer consumer = element2 -> DebugUtil.psiToBuffer(buffer, element2, indent + 2, !showWhitespaces, showChildrenRanges, showChildrenRanges, null);
                extra.consume((Object)root, (Object)consumer);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String fixWhiteSpaces(String text2) {
        return text2.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    @NotNull
    public static String currentStackTrace() {
        String string = ExceptionUtil.currentStackTrace();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static void beginPsiModification(@Nullable String trace) {
        Integer depth;
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        if (ourPsiModificationTrace.get() == null) {
            ourPsiModificationTrace.set(trace != null || ApplicationManagerEx.isInStressTest() ? trace : new Throwable());
        }
        if ((depth = ourPsiModificationDepth.get()) == null) {
            depth = 0;
        }
        ourPsiModificationDepth.set(depth + 1);
    }

    private static void endPsiModification() {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        Integer depth = ourPsiModificationDepth.get();
        if (depth == null) {
            LOG.warn("Unmatched PSI modification end", new Throwable());
            depth = 0;
        } else {
            Integer n = depth;
            Integer n2 = depth = Integer.valueOf(depth - 1);
            ourPsiModificationDepth.set(depth);
        }
        if (depth == 0) {
            ourPsiModificationTrace.set(null);
        }
    }

    public static <T extends Throwable> void performPsiModification(String trace, @NotNull ThrowableRunnable<T> runnable2) throws T {
        if (runnable2 == null) {
            DebugUtil.$$$reportNull$$$0(28);
        }
        DebugUtil.beginPsiModification(trace);
        try {
            runnable2.run();
        }
        finally {
            DebugUtil.endPsiModification();
        }
    }

    public static <T, E extends Throwable> T performPsiModification(String trace, @NotNull ThrowableComputable<T, E> runnable2) throws E {
        if (runnable2 == null) {
            DebugUtil.$$$reportNull$$$0(29);
        }
        DebugUtil.beginPsiModification(trace);
        try {
            Object object = runnable2.compute();
            return (T)object;
        }
        finally {
            DebugUtil.endPsiModification();
        }
    }

    public static void onInvalidated(@NotNull ASTNode treeElement) {
        Object trace;
        if (treeElement == null) {
            DebugUtil.$$$reportNull$$$0(30);
        }
        if ((trace = DebugUtil.calcInvalidationTrace(treeElement)) != null) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)treeElement, (Object)trace);
        }
    }

    public static void onInvalidated(@NotNull PsiElement o) {
        Object trace;
        if (o == null) {
            DebugUtil.$$$reportNull$$$0(31);
        }
        if ((trace = PsiInvalidElementAccessException.getInvalidationTrace((UserDataHolder)o)) == null) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)o, (Object)DebugUtil.currentInvalidationTrace());
        }
    }

    public static void onInvalidated(@NotNull FileViewProvider provider2) {
        Object trace;
        if (provider2 == null) {
            DebugUtil.$$$reportNull$$$0(32);
        }
        if ((trace = DebugUtil.calcInvalidationTrace(null)) != null) {
            PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)provider2, (Object)trace);
        }
    }

    @Nullable
    private static Object calcInvalidationTrace(@Nullable ASTNode treeElement) {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return null;
        }
        if (PsiInvalidElementAccessException.findInvalidationTrace((ASTNode)treeElement) != null) {
            return null;
        }
        return DebugUtil.currentInvalidationTrace();
    }

    @Nullable
    private static Object currentInvalidationTrace() {
        Object trace = ourPsiModificationTrace.get();
        return trace != null || ApplicationManagerEx.isInStressTest() ? trace : DebugUtil.handleUnspecifiedTrace();
    }

    private static Throwable handleUnspecifiedTrace() {
        Throwable trace = new Throwable();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("PSI invalidated outside transaction", trace);
        } else {
            LOG.info("PSI invalidated outside transaction", trace);
        }
        return trace;
    }

    public static void revalidateNode(@NotNull ASTNode element2) {
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(33);
        }
        PsiInvalidElementAccessException.setInvalidationTrace((UserDataHolder)element2, null);
    }

    public static void sleep(long millis) {
        TimeoutUtil.sleep((long)millis);
    }

    public static void checkTreeStructure(ASTNode element2) {
        if (CHECK) {
            DebugUtil.doCheckTreeStructure(element2);
        }
    }

    @NotNull
    public static String diagnosePsiDocumentInconsistency(@NotNull PsiElement element2, @NotNull Document document) {
        int docLength;
        FileViewProvider actualViewProvider;
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(34);
        }
        if (document == null) {
            DebugUtil.$$$reportNull$$$0(35);
        }
        PsiUtilCore.ensureValid((PsiElement)element2);
        PsiFile file2 = element2.getContainingFile();
        if (file2 == null) {
            String string = "no file for " + element2 + " of " + element2.getClass();
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(36);
            }
            return string;
        }
        PsiUtilCore.ensureValid((PsiElement)file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiDocumentManager manager2 = PsiDocumentManager.getInstance((Project)file2.getProject());
        Document actualDocument = viewProvider.getDocument();
        String fileDiagnostics = "File[" + file2 + " " + file2.getName() + ", " + file2.getLanguage() + ", " + viewProvider + "]";
        if (actualDocument != document) {
            String string = "wrong document for " + fileDiagnostics + "; expected " + document + "; actual " + actualDocument;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        PsiFile cachedPsiFile = manager2.getCachedPsiFile(document);
        FileViewProvider fileViewProvider = actualViewProvider = cachedPsiFile == null ? null : cachedPsiFile.getViewProvider();
        if (actualViewProvider != viewProvider) {
            String string = "wrong view provider for " + document + ", expected " + viewProvider + "; actual " + actualViewProvider;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(38);
            }
            return string;
        }
        if (!manager2.isCommitted(document)) {
            String string = "not committed document " + document + ", " + fileDiagnostics;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(39);
            }
            return string;
        }
        int fileLength = file2.getTextLength();
        if (fileLength != (docLength = document.getTextLength())) {
            String string = "file/doc text length different, " + fileDiagnostics + " file.length=" + fileLength + "; doc.length=" + docLength;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = "unknown inconsistency in " + fileDiagnostics;
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public static <T> String graphToString(@NotNull InboundSemiGraph<T> graph2) {
        if (graph2 == null) {
            DebugUtil.$$$reportNull$$$0(42);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.printNodes(graph2.getNodes().iterator(), node2 -> graph2.getIn(node2), 0, new HashSet(), buffer);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public static <T> String graphToString(@NotNull OutboundSemiGraph<T> graph2) {
        if (graph2 == null) {
            DebugUtil.$$$reportNull$$$0(44);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.printNodes(graph2.getNodes().iterator(), node2 -> graph2.getOut(node2), 0, new HashSet(), buffer);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    private static <T> void printNodes(Iterator<? extends T> nodes, Function<? super T, ? extends Iterator<? extends T>> getter, int indent, Set<? super T> visited, StringBuilder buffer) {
        while (nodes.hasNext()) {
            T node2 = nodes.next();
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indent);
            buffer.append(node2);
            if (visited.add(node2)) {
                buffer.append('\n');
                DebugUtil.printNodes((Iterator)getter.fun(node2), getter, indent + 2, visited, buffer);
                continue;
            }
            buffer.append(" [...]\n");
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.2")
    public static void startPsiModification(@Nullable String trace) {
        DebugUtil.beginPsiModification(trace);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.2")
    public static void finishPsiModification() {
        DebugUtil.endPsiModification();
    }

    static {
        Application application = ApplicationManager.getApplication();
        CHECK_INSIDE_ATOMIC_ACTION_ENABLED = DO_EXPENSIVE_CHECKS = application != null && application.isUnitTestMode();
        ourPsiModificationTrace = new ThreadLocal();
        ourPsiModificationDepth = new ThreadLocal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 20: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/DebugUtil";
                break;
            }
            case 7: 
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/DebugUtil";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "treeToString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeTreeToString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "lightTreeToString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "stubTreeToString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "psiToString";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "psiToStringIgnoringNonCode";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "currentStackTrace";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "diagnosePsiDocumentInconsistency";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "graphToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiTreeToString";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "treeToString";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nodeTreeToString";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "treeToBuffer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lightTreeToString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lightTreeToBuffer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "stubTreeToString";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "stubTreeToBuffer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkParentChildConsistent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkSameCharTabs";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "psiToString";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "psiToStringIgnoringNonCode";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "psiToBuffer";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "performPsiModification";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "onInvalidated";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "revalidateNode";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "diagnosePsiDocumentInconsistency";
                break;
            }
            case 42: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "graphToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 22: 
            case 24: 
            case 27: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IncorrectTreeStructureException
    extends RuntimeException {
        private final ASTNode myElement;

        IncorrectTreeStructureException(ASTNode element2, String message2) {
            super(message2);
            this.myElement = element2;
        }

        public ASTNode getElement() {
            return this.myElement;
        }
    }

    private static class TreeToBuffer
    extends RecursiveTreeElementWalkingVisitor {
        private final Appendable buffer;
        private final boolean showWhitespaces;
        private final boolean showRanges;
        private final boolean showChildrenRanges;
        private final boolean usePsi;
        private final PairConsumer<? super PsiElement, ? super Consumer<? super PsiElement>> extra;
        private int indent;

        private TreeToBuffer(Appendable buffer, int indent, boolean showWhitespaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, PairConsumer<? super PsiElement, ? super Consumer<? super PsiElement>> extra) {
            this.buffer = buffer;
            this.showWhitespaces = showWhitespaces;
            this.showRanges = showRanges;
            this.showChildrenRanges = showChildrenRanges;
            this.usePsi = usePsi;
            this.extra = extra;
            this.indent = indent;
        }

        @Override
        protected void visitNode(TreeElement root) {
            if (!this.shouldShowNode(root)) {
                this.indent += 2;
                return;
            }
            StringUtil.repeatSymbol((Appendable)this.buffer, (char)' ', (int)this.indent);
            try {
                if (root instanceof CompositeElement) {
                    if (this.usePsi) {
                        PsiElement psiElement = root.getPsi();
                        if (psiElement != null) {
                            this.buffer.append(psiElement.toString());
                        } else {
                            this.buffer.append(root.getElementType().toString());
                        }
                    } else {
                        this.buffer.append(root.toString());
                    }
                } else {
                    String text2 = DebugUtil.fixWhiteSpaces(root.getText());
                    this.buffer.append(root.toString()).append("('").append(text2).append("')");
                }
                if (this.showRanges) {
                    this.buffer.append(root.getTextRange().toString());
                }
                this.buffer.append("\n");
                this.indent += 2;
                if (root instanceof CompositeElement && root.getFirstChildNode() == null && this.showEmptyChildren()) {
                    StringUtil.repeatSymbol((Appendable)this.buffer, (char)' ', (int)this.indent);
                    this.buffer.append("<empty list>\n");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            super.visitNode(root);
        }

        protected boolean showEmptyChildren() {
            return true;
        }

        protected boolean shouldShowNode(TreeElement node2) {
            return this.showWhitespaces || node2.getElementType() != TokenType.WHITE_SPACE;
        }

        @Override
        protected void elementFinished(@NotNull ASTNode e) {
            PsiElement psiElement;
            if (e == null) {
                TreeToBuffer.$$$reportNull$$$0(0);
            }
            PsiElement psiElement2 = psiElement = this.extra != null && this.usePsi && e instanceof CompositeElement ? e.getPsi() : null;
            if (psiElement != null) {
                Consumer consumer = element2 -> DebugUtil.treeToBuffer(this.buffer, element2.getNode(), this.indent, this.showWhitespaces, this.showRanges, this.showChildrenRanges, true, (PairConsumer<? super PsiElement, ? super Consumer<? super PsiElement>>)null);
                this.extra.consume((Object)psiElement, (Object)consumer);
            }
            this.indent -= 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/impl/DebugUtil$TreeToBuffer", "elementFinished"));
        }
    }
}

