/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexTodoCacheManagerImpl
implements TodoCacheManager {
    private static final Logger LOG = Logger.getInstance(IndexTodoCacheManagerImpl.class);
    private final Project myProject;

    public IndexTodoCacheManagerImpl(@NotNull Project project) {
        if (project == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public PsiFile @NotNull [] getFilesWithTodoItems() {
        if (this.myProject.isDefault()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                IndexTodoCacheManagerImpl.$$$reportNull$$$0(1);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        HashSet allFiles = new HashSet();
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            for (IndexPattern indexPattern : IndexPatternUtil.getIndexPatterns()) {
                Collection files2 = fileBasedIndex.getContainingFiles(TodoIndex.NAME, (Object)new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), GlobalSearchScope.allScope((Project)this.myProject));
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                for (VirtualFile file2 : files2) {
                    ReadAction.run(() -> {
                        if (file2.isValid() && TodoIndexers.belongsToProject(this.myProject, file2)) {
                            ContainerUtil.addIfNotNull((Collection)allFiles, (Object)psiManager.findFile(file2));
                        }
                    });
                }
            }
        });
        PsiFile[] psiFileArray = allFiles.isEmpty() ? PsiFile.EMPTY_ARRAY : PsiUtilCore.toPsiFileArray(allFiles);
        if (psiFileArray == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(2);
        }
        return psiFileArray;
    }

    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPatternProvider patternProvider) {
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(3);
        }
        if (patternProvider == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(4);
        }
        return this.getTodoCountImpl(file2, patternProvider.getIndexPatterns());
    }

    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPattern pattern) {
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(6);
        }
        return this.getTodoCountImpl(file2, pattern);
    }

    private int getTodoCountImpl(@NotNull VirtualFile file2, IndexPattern ... indexPatterns) {
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(7);
        }
        if (indexPatterns == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(8);
        }
        if (this.myProject.isDefault()) {
            return 0;
        }
        if (file2 instanceof VirtualFileWindow) {
            return -1;
        }
        if (file2 instanceof LightVirtualFile) {
            return this.calculateTodoCount((LightVirtualFile)file2, indexPatterns);
        }
        if (!TodoIndexers.belongsToProject(this.myProject, file2)) {
            return 0;
        }
        return this.fetchTodoCountFromIndex(file2, indexPatterns);
    }

    private int calculateTodoCount(@NotNull LightVirtualFile file2, IndexPattern @NotNull [] indexPatterns) {
        TodoIndex extension2;
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(9);
        }
        if (indexPatterns == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(10);
        }
        if ((extension2 = (TodoIndex)((Object)FileBasedIndexExtension.EXTENSION_POINT_NAME.findExtension(TodoIndex.class))) == null) {
            return 0;
        }
        try {
            FileContent fc = FileContentImpl.createByFile((VirtualFile)file2, this.myProject);
            Map data2 = extension2.getIndexer().map((Object)fc);
            return IndexTodoCacheManagerImpl.getTodoCountForInputData(data2, indexPatterns);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return 0;
        }
    }

    private int fetchTodoCountFromIndex(@NotNull VirtualFile file2, IndexPattern @NotNull [] indexPatterns) {
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(11);
        }
        if (indexPatterns == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(12);
        }
        Ref inputData = Ref.create();
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            Map data2 = FileBasedIndex.getInstance().getFileData(TodoIndex.NAME, file2, this.myProject);
            inputData.set((Object)data2);
        });
        return IndexTodoCacheManagerImpl.getTodoCountForInputData((Map)inputData.get(), indexPatterns);
    }

    private static int getTodoCountForInputData(@Nullable Map<TodoIndexEntry, Integer> data2, IndexPattern @NotNull [] indexPatterns) {
        if (indexPatterns == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(13);
        }
        if (data2 == null) {
            return 0;
        }
        return Arrays.stream(indexPatterns).map(p -> new TodoIndexEntry(p.getPatternString(), p.isCaseSensitive())).mapToInt(e -> data2.getOrDefault(e, 0)).sum();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithTodoItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTodoCount";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTodoCountImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateTodoCount";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fetchTodoCountFromIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTodoCountForInputData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

