/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.application.Topics;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.project.ProjectKt;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLargeFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class PsiVFSListener
implements BulkFileListener {
    private static final Logger LOG = Logger.getInstance(PsiVFSListener.class);
    private final ProjectRootManager myProjectRootManager;
    private final PsiManagerImpl myManager;
    private final FileManagerImpl myFileManager;
    private final Project myProject;
    private boolean myReportedUnloadedPsiChange;
    private static final AtomicBoolean ourGlobalListenerInstalled = new AtomicBoolean(false);

    PsiVFSListener(@NotNull Project project) {
        if (project == null) {
            PsiVFSListener.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myProjectRootManager = ProjectRootManager.getInstance((Project)project);
        this.myManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
        this.myFileManager = (FileManagerImpl)this.myManager.getFileManager();
    }

    private static void installGlobalListener() {
        if (!ourGlobalListenerInstalled.compareAndSet(false, true)) {
            return;
        }
        Topics.subscribe((Topic)VirtualFileManager.VFS_CHANGES, null, (Object)new BulkFileListener(){

            public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Project project : ProjectUtil.getOpenProjects()) {
                    if (project.isDisposed()) continue;
                    ((PsiVFSListener)project.getService(PsiVFSListener.class)).before(events);
                }
            }

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                Project[] projects;
                if (events == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (Project project : projects = ProjectUtil.getOpenProjects()) {
                    PushedFilePropertiesUpdater updater = PushedFilePropertiesUpdater.getInstance((Project)project);
                    if (!(updater instanceof PushedFilePropertiesUpdaterImpl)) continue;
                    ((PushedFilePropertiesUpdaterImpl)updater).processAfterVfsChanges(events);
                }
                for (Project project : projects) {
                    ((PsiVFSListener)project.getService(PsiVFSListener.class)).after(events);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    private PsiDirectory getCachedDirectory(VirtualFile parent) {
        return parent == null ? null : this.myFileManager.getCachedDirectory(parent);
    }

    private void fileCreated(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            PsiVFSListener.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDirectory item;
            VirtualFile parent = vFile.getParent();
            PsiDirectory parentDir = this.getCachedDirectory(parent);
            if (parentDir == null) {
                this.handleVfsChangeWithoutPsi(vFile);
                return;
            }
            Object object = item = vFile.isDirectory() ? this.myFileManager.findDirectory(vFile) : this.myFileManager.findFile(vFile);
            if (item != null && item.getProject() == this.myManager.getProject()) {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
                treeEvent.setParent((PsiElement)parentDir);
                this.myManager.beforeChildAddition(treeEvent);
                treeEvent.setChild((PsiElement)item);
                this.myManager.childAdded(treeEvent);
            }
        });
    }

    private void beforeFileDeletion(@NotNull VFileDeleteEvent event) {
        VirtualFile vFile;
        VirtualFile parent;
        PsiDirectory parentDir;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(2);
        }
        if ((parentDir = this.getCachedDirectory(parent = (vFile = event.getFile()).getParent())) == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDirectory item;
            Object object = item = vFile.isDirectory() ? this.myFileManager.findDirectory(vFile) : this.myFileManager.getCachedPsiFile(vFile);
            if (item != null) {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
                treeEvent.setParent((PsiElement)parentDir);
                treeEvent.setChild((PsiElement)item);
                this.myManager.beforeChildRemoval(treeEvent);
            }
        });
    }

    private void filesDeleted(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(3);
        }
        boolean needToRemoveInvalidFilesAndDirs = false;
        for (VFileEvent vFileEvent : events) {
            PsiDirectory element2;
            VFileDeleteEvent de = (VFileDeleteEvent)vFileEvent;
            VirtualFile vFile = de.getFile();
            VirtualFile parent = vFile.getParent();
            PsiFile psiFile = this.myFileManager.getCachedPsiFileInner(vFile);
            if (psiFile != null) {
                this.myFileManager.setViewProvider(vFile, null);
                PsiFile element22 = psiFile;
            } else {
                PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
                if (psiDir != null) {
                    needToRemoveInvalidFilesAndDirs = true;
                    element2 = psiDir;
                } else {
                    if (parent != null) {
                        this.handleVfsChangeWithoutPsi(parent);
                        return;
                    }
                    element2 = null;
                }
            }
            PsiDirectory parentDir = this.getCachedDirectory(parent);
            if (element2 == null || parentDir == null) continue;
            ApplicationManager.getApplication().runWriteAction(() -> this.lambda$filesDeleted$2(parentDir, (PsiElement)element2));
        }
        if (needToRemoveInvalidFilesAndDirs) {
            this.myFileManager.removeInvalidFilesAndDirs(false);
        }
    }

    private void clearViewProvider(@NotNull VirtualFile vFile, @NotNull String why) {
        if (vFile == null) {
            PsiVFSListener.$$$reportNull$$$0(4);
        }
        if (why == null) {
            PsiVFSListener.$$$reportNull$$$0(5);
        }
        DebugUtil.performPsiModification(why, () -> this.myFileManager.setViewProvider(vFile, null));
    }

    private void beforePropertyChange(@NotNull VFilePropertyChangeEvent event) {
        PsiDirectory parentDir;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(6);
        }
        VirtualFile vFile = event.getFile();
        String propertyName = event.getPropertyName();
        FileViewProvider viewProvider = this.myFileManager.findCachedViewProvider(vFile);
        VirtualFile parent = vFile.getParent();
        PsiDirectory psiDirectory = parentDir = viewProvider != null && parent != null ? this.myFileManager.findDirectory(parent) : this.getCachedDirectory(parent);
        if (parent != null && parentDir == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeEvent.setParent((PsiElement)parentDir);
            if ("name".equals(propertyName)) {
                String newName2 = (String)event.getNewValue();
                if (parentDir == null) {
                    return;
                }
                if (vFile.isDirectory()) {
                    PsiDirectory psiDir = this.myFileManager.findDirectory(vFile);
                    if (psiDir != null) {
                        if (!FileTypeManager.getInstance().isFileIgnored(newName2)) {
                            treeEvent.setChild((PsiElement)psiDir);
                            treeEvent.setPropertyName("directoryName");
                            treeEvent.setOldValue(vFile.getName());
                            treeEvent.setNewValue(newName2);
                            this.myManager.beforePropertyChange(treeEvent);
                        } else {
                            treeEvent.setChild((PsiElement)psiDir);
                            this.myManager.beforeChildRemoval(treeEvent);
                        }
                    } else if (!(Registry.is((String)"ide.hide.excluded.files") && this.isExcludeRoot(vFile) || FileTypeManager.getInstance().isFileIgnored(newName2))) {
                        this.myManager.beforeChildAddition(treeEvent);
                    }
                } else {
                    FileViewProvider viewProvider1 = this.myFileManager.findViewProvider(vFile);
                    PsiFile psiFile = viewProvider1.getPsi(viewProvider1.getBaseLanguage());
                    PsiFile psiFile1 = this.createFileCopyWithNewName(vFile, newName2);
                    if (psiFile != null) {
                        if (psiFile1 == null) {
                            treeEvent.setChild((PsiElement)psiFile);
                            this.myManager.beforeChildRemoval(treeEvent);
                        } else if (!psiFile1.getClass().equals(psiFile.getClass())) {
                            treeEvent.setOldChild((PsiElement)psiFile);
                            this.myManager.beforeChildReplacement(treeEvent);
                        } else {
                            treeEvent.setChild((PsiElement)psiFile);
                            treeEvent.setPropertyName("fileName");
                            treeEvent.setOldValue(vFile.getName());
                            treeEvent.setNewValue(newName2);
                            this.myManager.beforePropertyChange(treeEvent);
                        }
                    } else if (psiFile1 != null) {
                        this.myManager.beforeChildAddition(treeEvent);
                    }
                }
            } else if ("writable".equals(propertyName)) {
                PsiFile psiFile = this.myFileManager.getCachedPsiFileInner(vFile);
                if (psiFile == null) {
                    return;
                }
                treeEvent.setElement((PsiElement)psiFile);
                treeEvent.setPropertyName("writable");
                treeEvent.setOldValue(event.getOldValue());
                treeEvent.setNewValue(event.getNewValue());
                this.myManager.beforePropertyChange(treeEvent);
            }
        });
    }

    private boolean isExcludeRoot(VirtualFile file2) {
        VirtualFile[] excludeRoots;
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            return false;
        }
        Module module = this.myProjectRootManager.getFileIndex().getModuleForFile(parent);
        if (module == null) {
            return false;
        }
        for (VirtualFile root : excludeRoots = ModuleRootManager.getInstance((Module)module).getExcludeRoots()) {
            if (!root.equals(file2)) continue;
            return true;
        }
        return false;
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
        PsiDirectory parentDir;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(7);
        }
        String propertyName = event.getPropertyName();
        VirtualFile vFile = event.getFile();
        FileViewProvider oldFileViewProvider = this.myFileManager.findCachedViewProvider(vFile);
        PsiFile oldPsiFile = this.myFileManager.getCachedPsiFile(vFile);
        VirtualFile parent = vFile.getParent();
        PsiDirectory psiDirectory = parentDir = oldPsiFile != null && parent != null ? this.myFileManager.findDirectory(parent) : this.getCachedDirectory(parent);
        if (oldFileViewProvider != null && "FileContentUtilCore.saveOrReload".equals(event.getRequestor())) {
            this.myFileManager.forceReload(vFile);
            return;
        }
        if (parentDir == null) {
            boolean fire;
            boolean bl = fire = "name".equals(propertyName) && vFile.isDirectory();
            if (fire) {
                PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
                boolean bl2 = fire = psiDir != null;
            }
            if (!fire && !"writable".equals(propertyName)) {
                this.handleVfsChangeWithoutPsi(vFile);
                return;
            }
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeEvent.setParent((PsiElement)parentDir);
            switch (propertyName) {
                case "name": {
                    if (vFile.isDirectory()) {
                        PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
                        if (psiDir != null) {
                            if (fileTypeManager.isFileIgnored(vFile)) {
                                this.myFileManager.removeFilesAndDirsRecursively(vFile);
                                treeEvent.setChild((PsiElement)psiDir);
                                this.myManager.childRemoved(treeEvent);
                                break;
                            }
                            treeEvent.setElement((PsiElement)psiDir);
                            treeEvent.setPropertyName("directoryName");
                            treeEvent.setOldValue(event.getOldValue());
                            treeEvent.setNewValue(event.getNewValue());
                            this.myManager.propertyChanged(treeEvent);
                            break;
                        }
                        PsiDirectory psiDir1 = this.myFileManager.findDirectory(vFile);
                        if (psiDir1 == null) break;
                        treeEvent.setChild((PsiElement)psiDir1);
                        this.myManager.childAdded(treeEvent);
                        break;
                    }
                    FileViewProvider fileViewProvider = this.myFileManager.createFileViewProvider(vFile, true);
                    PsiFile newPsiFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
                    if (oldPsiFile != null) {
                        if (newPsiFile == null) {
                            this.clearViewProvider(vFile, "PSI renamed");
                            treeEvent.setChild((PsiElement)oldPsiFile);
                            this.myManager.childRemoved(treeEvent);
                            break;
                        }
                        if (!FileManagerImpl.areViewProvidersEquivalent(fileViewProvider, oldFileViewProvider)) {
                            this.myFileManager.setViewProvider(vFile, fileViewProvider);
                            treeEvent.setOldChild((PsiElement)oldPsiFile);
                            treeEvent.setNewChild((PsiElement)newPsiFile);
                            this.myManager.childReplaced(treeEvent);
                            break;
                        }
                        FileManagerImpl.clearPsiCaches(oldFileViewProvider);
                        treeEvent.setElement((PsiElement)oldPsiFile);
                        treeEvent.setPropertyName("fileName");
                        treeEvent.setOldValue(event.getOldValue());
                        treeEvent.setNewValue(event.getNewValue());
                        this.myManager.propertyChanged(treeEvent);
                        break;
                    }
                    if (newPsiFile == null) break;
                    this.myFileManager.setViewProvider(vFile, fileViewProvider);
                    if (parentDir == null) break;
                    treeEvent.setChild((PsiElement)newPsiFile);
                    this.myManager.childAdded(treeEvent);
                    break;
                }
                case "writable": {
                    if (oldPsiFile == null) {
                        return;
                    }
                    treeEvent.setElement((PsiElement)oldPsiFile);
                    treeEvent.setPropertyName("writable");
                    treeEvent.setOldValue(event.getOldValue());
                    treeEvent.setNewValue(event.getNewValue());
                    this.myManager.propertyChanged(treeEvent);
                    break;
                }
                case "encoding": {
                    if (oldPsiFile == null) {
                        return;
                    }
                    treeEvent.setElement((PsiElement)oldPsiFile);
                    treeEvent.setPropertyName("encoding");
                    treeEvent.setOldValue(event.getOldValue());
                    treeEvent.setNewValue(event.getNewValue());
                    this.myManager.propertyChanged(treeEvent);
                }
            }
        });
    }

    private void beforeFileMovement(@NotNull VFileMoveEvent event) {
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(8);
        }
        VirtualFile vFile = event.getFile();
        PsiDirectory oldParentDir = this.myFileManager.findDirectory(event.getOldParent());
        PsiDirectory newParentDir = this.myFileManager.findDirectory(event.getNewParent());
        if (oldParentDir == null && newParentDir == null || FileTypeManager.getInstance().isFileIgnored(vFile)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            boolean isExcluded;
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            boolean bl = isExcluded = vFile.isDirectory() && Registry.is((String)"ide.hide.excluded.files") && this.myProjectRootManager.getFileIndex().isExcluded(vFile);
            if (oldParentDir != null && !isExcluded) {
                PsiDirectory eventChild = vFile.isDirectory() ? this.myFileManager.findDirectory(vFile) : this.myFileManager.findFile(vFile);
                treeEvent.setChild((PsiElement)eventChild);
                if (newParentDir != null) {
                    treeEvent.setOldParent((PsiElement)oldParentDir);
                    treeEvent.setNewParent((PsiElement)newParentDir);
                    this.myManager.beforeChildMovement(treeEvent);
                } else {
                    treeEvent.setParent((PsiElement)oldParentDir);
                    this.myManager.beforeChildRemoval(treeEvent);
                }
            } else {
                LOG.assertTrue(newParentDir != null);
                treeEvent.setParent((PsiElement)newParentDir);
                this.myManager.beforeChildAddition(treeEvent);
            }
        });
    }

    private void filesMoved(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(9);
        }
        ArrayList<PsiDirectory> oldElements = new ArrayList<PsiDirectory>(events.size());
        ArrayList<PsiDirectory> oldParentDirs = new ArrayList<PsiDirectory>(events.size());
        ArrayList<PsiDirectory> newParentDirs = new ArrayList<PsiDirectory>(events.size());
        for (VFileEvent vFileEvent : events) {
            VFileMoveEvent event = (VFileMoveEvent)vFileEvent;
            VirtualFile vFile = event.getFile();
            PsiDirectory oldParentDir = this.myFileManager.findDirectory(event.getOldParent());
            PsiDirectory newParentDir = this.myFileManager.findDirectory(event.getNewParent());
            PsiDirectory oldElement = vFile.isDirectory() ? this.myFileManager.getCachedDirectory(vFile) : this.myFileManager.getCachedPsiFileInner(vFile);
            oldElements.add(oldElement);
            oldParentDirs.add(oldParentDir);
            newParentDirs.add(newParentDir);
        }
        this.myFileManager.removeInvalidFilesAndDirs(true);
        for (int i2 = 0; i2 < events.size(); ++i2) {
            FileViewProvider newViewProvider;
            PsiDirectory newElement;
            VFileMoveEvent vFileMoveEvent = (VFileMoveEvent)events.get(i2);
            VirtualFile vFile = vFileMoveEvent.getFile();
            PsiDirectory oldParentDir = (PsiDirectory)oldParentDirs.get(i2);
            PsiDirectory newParentDir = (PsiDirectory)newParentDirs.get(i2);
            if (oldParentDir == null && newParentDir == null) continue;
            PsiElement oldElement = (PsiElement)oldElements.get(i2);
            if (vFile.isDirectory()) {
                newElement = this.myFileManager.findDirectory(vFile);
                newViewProvider = null;
            } else {
                newViewProvider = this.myFileManager.createFileViewProvider(vFile, true);
                newElement = newViewProvider.getPsi(this.myFileManager.findViewProvider(vFile).getBaseLanguage());
            }
            if (oldElement == null && newElement == null) continue;
            ApplicationManager.getApplication().runWriteAction(() -> this.lambda$filesMoved$7(oldElement, vFile, newViewProvider, newParentDir, (PsiElement)newElement, oldParentDir));
        }
    }

    @Nullable
    private PsiFile createFileCopyWithNewName(VirtualFile vFile, String name) {
        FileTypeManager instance = FileTypeManager.getInstance();
        if (instance.isFileIgnored(name)) {
            return null;
        }
        FileType fileTypeByFileName = instance.getFileTypeByFileName(name);
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        return PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText(name, fileTypeByFileName, document != null ? document.getCharsSequence() : "", vFile.getModificationStamp(), true, false);
    }

    private void handleVfsChangeWithoutPsi(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            PsiVFSListener.$$$reportNull$$$0(10);
        }
        if (!this.myReportedUnloadedPsiChange && this.isInRootModel(vFile)) {
            this.myFileManager.firePropertyChangedForUnloadedPsi();
            this.myReportedUnloadedPsiChange = true;
        }
    }

    private boolean isInRootModel(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiVFSListener.$$$reportNull$$$0(11);
        }
        if (ProjectKt.getStateStore(this.myProject).isProjectFile(file2)) {
            return false;
        }
        ProjectFileIndex index2 = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        return index2.isInContent(file2) || index2.isInLibrary(file2);
    }

    public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(12);
        }
        this.myReportedUnloadedPsiChange = false;
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.beforeFileDeletion((VFileDeleteEvent)vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                this.beforePropertyChange((VFilePropertyChangeEvent)vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            this.beforeFileMovement((VFileMoveEvent)vFileEvent);
        }
    }

    public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(13);
        }
        this.groupAndFire(events);
        this.myReportedUnloadedPsiChange = false;
    }

    private void groupAndFire(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(14);
        }
        StreamEx.of(events).groupRuns((event1, event2) -> event1 instanceof VFileDeleteEvent && event2 instanceof VFileDeleteEvent || event1 instanceof VFileMoveEvent && event2 instanceof VFileMoveEvent).forEach(this::fireForGrouped);
    }

    private void fireForGrouped(@NotNull List<? extends VFileEvent> subList) {
        VFileEvent event;
        if (subList == null) {
            PsiVFSListener.$$$reportNull$$$0(15);
        }
        if ((event = subList.get(0)) instanceof VFileDeleteEvent) {
            DebugUtil.performPsiModification(null, () -> this.filesDeleted(subList));
        } else if (event instanceof VFileMoveEvent) {
            this.filesMoved(subList);
        } else {
            assert (subList.size() == 1);
            if (event instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)event;
                VirtualFile copy2 = ce.getNewParent().findChild(ce.getNewChildName());
                if (copy2 != null) {
                    this.fileCreated(copy2);
                }
            } else if (event instanceof VFileCreateEvent) {
                VirtualFile file2 = event.getFile();
                if (file2 != null) {
                    this.fileCreated(file2);
                }
            } else if (event instanceof VFilePropertyChangeEvent) {
                this.propertyChanged((VFilePropertyChangeEvent)event);
            }
        }
    }

    private /* synthetic */ void lambda$filesMoved$7(PsiElement oldElement, VirtualFile vFile, FileViewProvider newViewProvider, PsiDirectory newParentDir, PsiElement newElement, PsiDirectory oldParentDir) {
        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
        if (oldElement == null) {
            this.myFileManager.setViewProvider(vFile, newViewProvider);
            treeEvent.setParent((PsiElement)newParentDir);
            treeEvent.setChild(newElement);
            this.myManager.childAdded(treeEvent);
        } else if (newElement == null) {
            this.clearViewProvider(vFile, "PSI moved");
            treeEvent.setParent((PsiElement)oldParentDir);
            treeEvent.setChild(oldElement);
            this.myManager.childRemoved(treeEvent);
        } else if (newElement instanceof PsiDirectory || FileManagerImpl.areViewProvidersEquivalent(newViewProvider, ((PsiFile)oldElement).getViewProvider())) {
            treeEvent.setOldParent((PsiElement)oldParentDir);
            treeEvent.setNewParent((PsiElement)newParentDir);
            treeEvent.setChild(oldElement);
            this.myManager.childMoved(treeEvent);
        } else {
            this.myFileManager.setViewProvider(vFile, newViewProvider);
            PsiTreeChangeEventImpl treeRemoveEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeRemoveEvent.setParent((PsiElement)oldParentDir);
            treeRemoveEvent.setChild(oldElement);
            this.myManager.childRemoved(treeRemoveEvent);
            PsiTreeChangeEventImpl treeAddEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeAddEvent.setParent((PsiElement)newParentDir);
            treeAddEvent.setChild(newElement);
            this.myManager.childAdded(treeAddEvent);
        }
    }

    private /* synthetic */ void lambda$filesDeleted$2(PsiDirectory parentDir, PsiElement element2) {
        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
        treeEvent.setParent((PsiElement)parentDir);
        treeEvent.setChild(element2);
        this.myManager.childRemoved(treeEvent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "why";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subList";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "filesDeleted";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clearViewProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePropertyChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileMovement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "filesMoved";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "handleVfsChangeWithoutPsi";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isInRootModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "groupAndFire";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "fireForGrouped";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyFileDocumentManagerListener
    implements FileDocumentManagerListener {
        private final FileManagerImpl fileManager;
        private final Project project;

        private MyFileDocumentManagerListener(@NotNull Project project) {
            if (project == null) {
                MyFileDocumentManagerListener.$$$reportNull$$$0(0);
            }
            this.project = project;
            this.fileManager = (FileManagerImpl)((PsiManagerImpl)PsiManager.getInstance((Project)project)).getFileManager();
        }

        public void fileWithNoDocumentChanged(@NotNull VirtualFile file2) {
            FileViewProvider viewProvider;
            if (file2 == null) {
                MyFileDocumentManagerListener.$$$reportNull$$$0(1);
            }
            if ((viewProvider = this.fileManager.findCachedViewProvider(file2)) == null) {
                ((PsiVFSListener)this.project.getService(PsiVFSListener.class)).handleVfsChangeWithoutPsi(file2);
            } else {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (FileDocumentManagerImpl.recomputeFileTypeIfNecessary(file2)) {
                        this.fileManager.forceReload(file2);
                    } else {
                        this.fileManager.reloadPsiAfterTextChange(viewProvider, file2);
                    }
                });
            }
        }

        public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
            if (file2 == null) {
                MyFileDocumentManagerListener.$$$reportNull$$$0(2);
            }
            if (document == null) {
                MyFileDocumentManagerListener.$$$reportNull$$$0(3);
            }
            FileViewProvider psiFile = this.fileManager.findCachedViewProvider(file2);
            if (!file2.isValid() || psiFile == null || !FileUtilRt.isTooLarge((long)file2.getLength()) || psiFile instanceof PsiLargeFile) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> this.fileManager.reloadPsiAfterTextChange(psiFile, file2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$MyFileDocumentManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileWithNoDocumentChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileContentReloaded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyAdditionalLibraryRootListener
    implements AdditionalLibraryRootsListener {
        private final PsiManagerImpl manager;
        private final FileManagerImpl fileManager;

        MyAdditionalLibraryRootListener(@NotNull Project project) {
            if (project == null) {
                MyAdditionalLibraryRootListener.$$$reportNull$$$0(0);
            }
            this.manager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
            this.fileManager = (FileManagerImpl)this.manager.getFileManager();
        }

        public void libraryRootsChanged(@Nullable @Nls String presentableLibraryName, @NotNull Collection<? extends VirtualFile> oldRoots, @NotNull Collection<? extends VirtualFile> newRoots, @NotNull String libraryNameForDebug) {
            if (oldRoots == null) {
                MyAdditionalLibraryRootListener.$$$reportNull$$$0(1);
            }
            if (newRoots == null) {
                MyAdditionalLibraryRootListener.$$$reportNull$$$0(2);
            }
            if (libraryNameForDebug == null) {
                MyAdditionalLibraryRootListener.$$$reportNull$$$0(3);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.manager);
                treeEvent.setPropertyName("roots");
                this.manager.beforePropertyChange(treeEvent);
                DebugUtil.performPsiModification(null, this.fileManager::possiblyInvalidatePhysicalPsi);
                treeEvent = new PsiTreeChangeEventImpl(this.manager);
                treeEvent.setPropertyName("roots");
                this.manager.propertyChanged(treeEvent);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldRoots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRoots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryNameForDebug";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$MyAdditionalLibraryRootListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "libraryRootsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyModuleRootListener
    implements ModuleRootListener {
        private int depthCounter;
        private final PsiManagerImpl manager;
        private final FileManagerImpl fileManager;

        private MyModuleRootListener(@NotNull Project project) {
            if (project == null) {
                MyModuleRootListener.$$$reportNull$$$0(0);
            }
            this.manager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
            this.fileManager = (FileManagerImpl)this.manager.getFileManager();
        }

        public void beforeRootsChange(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyModuleRootListener.$$$reportNull$$$0(1);
            }
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                ++this.depthCounter;
                if (this.depthCounter > 1) {
                    return;
                }
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.manager);
                treeEvent.setPropertyName("roots");
                this.manager.beforePropertyChange(treeEvent);
            });
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyModuleRootListener.$$$reportNull$$$0(2);
            }
            this.fileManager.dispatchPendingEvents();
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                --this.depthCounter;
                assert (this.depthCounter >= 0) : this.depthCounter;
                if (this.depthCounter > 0) {
                    return;
                }
                DebugUtil.performPsiModification(null, this.fileManager::possiblyInvalidatePhysicalPsi);
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.manager);
                treeEvent.setPropertyName("roots");
                this.manager.propertyChanged(treeEvent);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$MyModuleRootListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeRootsChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rootsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyStartUpActivity
    implements StartupActivity {
        MyStartUpActivity() {
        }

        public void runActivity(final @NotNull Project project) {
            if (project == null) {
                MyStartUpActivity.$$$reportNull$$$0(0);
            }
            MessageBusConnection connection = project.getMessageBus().connect();
            ExtensionPoint point = LanguageSubstitutors.getInstance().getPoint();
            if (point != null) {
                point.addChangeListener(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
                    ((FileManagerImpl)psiManager.getFileManager()).processFileTypesChanged(true);
                }, (Disposable)project);
            }
            connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyModuleRootListener(project));
            connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (Object)new MyAdditionalLibraryRootListener(project));
            connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

                public void fileTypesChanged(@NotNull FileTypeEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
                    ((FileManagerImpl)psiManager.getFileManager()).processFileTypesChanged(e.getRemovedFileType() != null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/impl/file/impl/PsiVFSListener$MyStartUpActivity$1", "fileTypesChanged"));
                }
            });
            connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new MyFileDocumentManagerListener(project));
            connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

                @Override
                public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                    if (pluginDescriptor == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
                    ((FileManagerImpl)psiManager.getFileManager()).processFileTypesChanged(true);
                }

                @Override
                public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                    if (pluginDescriptor == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
                    ((FileManagerImpl)psiManager.getFileManager()).processFileTypesChanged(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "pluginDescriptor";
                    objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$MyStartUpActivity$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "pluginLoaded";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforePluginUnload";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            PsiVFSListener.installGlobalListener();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/file/impl/PsiVFSListener$MyStartUpActivity", "runActivity"));
        }
    }
}

