/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class XmlAttributeDelegate {
    @NotNull
    private final XmlAttribute myAttribute;
    private volatile VolatileState myVolatileState;

    XmlAttributeDelegate(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(0);
        }
        this.myAttribute = attribute;
    }

    @Nullable
    XmlAttributeDescriptor getDescriptor() {
        XmlAttribute attribute = this.myAttribute;
        return (XmlAttributeDescriptor)CachedValuesManager.getCachedValue((PsiElement)attribute, () -> CachedValueProvider.Result.create((Object)XmlAttributeDelegate.getDescriptionImpl(attribute), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, XmlAttributeDelegate.externalResourceModificationTracker(attribute)}));
    }

    @Nullable
    private static XmlAttributeDescriptor getDescriptionImpl(@NotNull XmlAttribute attribute) {
        XmlElementDescriptor descr;
        XmlTag tag2;
        if (attribute == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(1);
        }
        if ((tag2 = attribute.getParent()) != null && (descr = tag2.getDescriptor()) != null) {
            return descr.getAttributeDescriptor(attribute);
        }
        return null;
    }

    @NotNull
    private static ModificationTracker externalResourceModificationTracker(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(2);
        }
        Project project = attribute.getProject();
        ExternalResourceManagerEx manager2 = ExternalResourceManagerEx.getInstanceEx();
        ModificationTracker modificationTracker = () -> manager2.getModificationCount(project);
        if (modificationTracker == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(3);
        }
        return modificationTracker;
    }

    @Nullable
    private Character getPreferredQuoteStyle() {
        ASTNode value2 = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this.myAttribute.getNode());
        String currentValue = (String)ObjectUtils.notNull((Object)((String)ObjectUtils.doIfNotNull((Object)value2, ASTNode::getText)), (Object)"");
        return currentValue.startsWith("'") ? Character.valueOf('\'') : (currentValue.startsWith("\"") ? Character.valueOf('\"') : null);
    }

    void setValue(@NotNull String valueText) throws IncorrectOperationException {
        if (valueText == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(4);
        }
        ASTNode value2 = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(this.myAttribute.getNode());
        XmlAttribute attribute = this.createAttribute(StringUtil.defaultIfEmpty((String)this.myAttribute.getName(), (String)"a"), valueText, this.getPreferredQuoteStyle());
        ASTNode newValue2 = XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild(attribute.getNode());
        ASTNode att = this.myAttribute.getNode();
        if (value2 != null) {
            if (newValue2 != null) {
                att.replaceChild(value2, newValue2.copyElement());
            } else {
                att.removeChild(value2);
            }
        } else if (newValue2 != null) {
            att.addChild(newValue2.getTreePrev().copyElement());
            att.addChild(newValue2.copyElement());
        }
    }

    protected XmlAttribute createAttribute(@NotNull String qname, @NotNull String value2, @Nullable Character quoteStyle) {
        if (qname == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(5);
        }
        if (value2 == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(6);
        }
        return XmlElementFactory.getInstance((Project)this.myAttribute.getProject()).createAttribute(qname, value2, quoteStyle, (PsiElement)this.myAttribute);
    }

    @NotNull
    String getNamespace() {
        String name = this.myAttribute.getName();
        String prefixByQualifiedName = XmlUtil.findPrefixByQualifiedName(name);
        if (prefixByQualifiedName.isEmpty()) {
            return "";
        }
        String string = this.myAttribute.getParent().getNamespaceByPrefix(prefixByQualifiedName);
        if (string == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    VolatileState getFreshState() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VolatileState state = this.myVolatileState;
        if (state == null) {
            state = this.recalculate();
        }
        return state;
    }

    protected void appendChildToDisplayValue(@NotNull StringBuilder buffer, @NotNull ASTNode child2) {
        if (buffer == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(8);
        }
        if (child2 == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(9);
        }
        buffer.append(child2.getChars());
    }

    @Nullable
    private VolatileState recalculate() {
        VolatileState volatileState;
        XmlAttributeValue value2 = this.myAttribute.getValueElement();
        if (value2 == null) {
            return null;
        }
        PsiElement firstChild = value2.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        ASTNode child2 = firstChild.getNode();
        TextRange valueTextRange = new TextRange(0, value2.getTextLength());
        if (child2 != null && child2.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            valueTextRange = new TextRange(child2.getTextLength(), valueTextRange.getEndOffset());
            child2 = child2.getTreeNext();
        }
        IntArrayList gapsStarts = new IntArrayList();
        IntArrayList gapsShifts = new IntArrayList();
        StringBuilder buffer = new StringBuilder(this.myAttribute.getTextLength());
        while (child2 != null) {
            int start2 = buffer.length();
            IElementType elementType = child2.getElementType();
            if (elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                valueTextRange = new TextRange(valueTextRange.getStartOffset(), child2.getTextRange().getStartOffset() - value2.getTextRange().getStartOffset());
                break;
            }
            if (elementType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                buffer.append(XmlUtil.getCharFromEntityRef(child2.getText()));
            } else if (elementType == XmlElementType.XML_ENTITY_REF) {
                buffer.append(XmlAttributeDelegate.getEntityValue((XmlEntityRef)child2));
            } else {
                this.appendChildToDisplayValue(buffer, child2);
            }
            int end = buffer.length();
            int originalLength = child2.getTextLength();
            if (end - start2 != originalLength) {
                gapsStarts.add(start2);
                gapsShifts.add(originalLength - (end - start2));
            }
            child2 = child2.getTreeNext();
        }
        int[] gapDisplayStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int[] gapPhysicalStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int currentGapsSum = 0;
        for (int i2 = 0; i2 < gapDisplayStarts.length; ++i2) {
            gapDisplayStarts[i2] = gapsStarts.getInt(i2);
            gapPhysicalStarts[i2] = gapDisplayStarts[i2] + (currentGapsSum += gapsShifts.getInt(i2));
        }
        this.myVolatileState = volatileState = new VolatileState(buffer.toString(), gapDisplayStarts, gapPhysicalStarts, valueTextRange);
        return volatileState;
    }

    @NotNull
    private static String getEntityValue(@NotNull XmlEntityRef entityRef) {
        XmlAttributeValue valueElement;
        XmlEntityDecl decl;
        if (entityRef == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(10);
        }
        if ((decl = entityRef.resolve(entityRef.getContainingFile())) != null && (valueElement = decl.getValueElement()) != null) {
            String string = valueElement.getValue();
            if (string == null) {
                XmlAttributeDelegate.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = entityRef.getText();
        if (string == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(12);
        }
        return string;
    }

    PsiReference @NotNull [] getDefaultReferences(@NotNull PsiReferenceService.Hints hints2) {
        PsiReference[] refs;
        XmlElement nameElement;
        if (hints2 == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(13);
        }
        if (hints2.offsetInElement != null && ((nameElement = this.myAttribute.getNameElement()) == null || hints2.offsetInElement > nameElement.getStartOffsetInParent() + nameElement.getTextLength())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                XmlAttributeDelegate.$$$reportNull$$$0(14);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] referencesFromProviders = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myAttribute, (PsiReferenceService.Hints)hints2);
        if (this.myAttribute.isNamespaceDeclaration()) {
            refs = new PsiReference[referencesFromProviders.length + 1];
            String localName = this.myAttribute.getLocalName();
            String prefix2 = XmlUtil.findPrefixByQualifiedName(this.myAttribute.getName());
            TextRange range2 = prefix2.isEmpty() ? TextRange.from((int)this.myAttribute.getName().length(), (int)0) : TextRange.from((int)(prefix2.length() + 1), (int)localName.length());
            refs[0] = new SchemaPrefixReference((XmlElement)this.myAttribute, range2, localName, null);
        } else {
            String prefix3 = this.myAttribute.getNamespacePrefix();
            if (!prefix3.isEmpty() && !this.myAttribute.getLocalName().isEmpty()) {
                refs = new PsiReference[referencesFromProviders.length + 2];
                XmlElement nameElement2 = this.myAttribute.getNameElement();
                TextRange prefixRange = TextRange.from((int)(nameElement2 == null ? 0 : nameElement2.getStartOffsetInParent()), (int)prefix3.length());
                refs[0] = new SchemaPrefixReference((XmlElement)this.myAttribute, prefixRange, prefix3, null);
                refs[1] = new XmlAttributeReference(this.myAttribute);
            } else {
                refs = new PsiReference[referencesFromProviders.length + 1];
                refs[0] = new XmlAttributeReference(this.myAttribute);
            }
        }
        System.arraycopy(referencesFromProviders, 0, refs, refs.length - referencesFromProviders.length, referencesFromProviders.length);
        if (refs == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(15);
        }
        return refs;
    }

    int physicalToDisplay(int physicalIndex) {
        VolatileState state = this.getFreshState();
        if (state == null) {
            return -1;
        }
        if (physicalIndex < 0 || physicalIndex > state.myValueTextRange.getLength()) {
            return -1;
        }
        if (state.myGapPhysicalStarts.length == 0) {
            return physicalIndex;
        }
        int bsResult = Arrays.binarySearch(state.myGapPhysicalStarts, physicalIndex);
        int gapIndex = bsResult > 0 ? bsResult : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return physicalIndex;
        }
        int shift = state.myGapPhysicalStarts[gapIndex] - state.myGapDisplayStarts[gapIndex];
        return Math.max(state.myGapDisplayStarts[gapIndex], physicalIndex - shift);
    }

    @NotNull
    PsiElement setName(@NotNull String nameText) throws IncorrectOperationException {
        if (nameText == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(16);
        }
        ASTNode name = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(this.myAttribute.getNode());
        String oldValue = (String)ObjectUtils.notNull((Object)this.myAttribute.getValue(), (Object)"");
        XmlAttribute newAttribute = this.createAttribute(nameText, oldValue, this.getPreferredQuoteStyle());
        ASTNode newName2 = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(newAttribute.getNode());
        if (!oldValue.isEmpty() && this.myAttribute.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
            CodeEditUtil.replaceChild(this.myAttribute.getNode().getTreeParent(), this.myAttribute.getNode(), newAttribute.getNode());
            XmlAttribute xmlAttribute = newAttribute;
            if (xmlAttribute == null) {
                XmlAttributeDelegate.$$$reportNull$$$0(17);
            }
            return xmlAttribute;
        }
        if (name != null && newName2 != null) {
            CodeEditUtil.replaceChild(this.myAttribute.getNode(), name, newName2);
        }
        XmlAttribute xmlAttribute = this.myAttribute;
        if (xmlAttribute == null) {
            XmlAttributeDelegate.$$$reportNull$$$0(18);
        }
        return xmlAttribute;
    }

    int displayToPhysical(int displayIndex) {
        VolatileState state = this.getFreshState();
        if (state == null) {
            return -1;
        }
        String displayValue = state.myDisplayText;
        if (displayIndex < 0 || displayIndex > displayValue.length()) {
            return -1;
        }
        int[] gapDisplayStarts = state.myGapDisplayStarts;
        if (gapDisplayStarts.length == 0) {
            return displayIndex;
        }
        int bsResult = Arrays.binarySearch(gapDisplayStarts, displayIndex);
        int gapIndex = bsResult > 0 ? bsResult - 1 : (bsResult < -1 ? -bsResult - 2 : -1);
        if (gapIndex < 0) {
            return displayIndex;
        }
        int shift = state.myGapPhysicalStarts[gapIndex] - gapDisplayStarts[gapIndex];
        return displayIndex + shift;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeDelegate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityRef";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeDelegate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "externalResourceModificationTracker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultReferences";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "externalResourceModificationTracker";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAttribute";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendChildToDisplayValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEntityValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultReferences";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class VolatileState {
        @NotNull
        final String myDisplayText;
        final int @NotNull [] myGapDisplayStarts;
        final int @NotNull [] myGapPhysicalStarts;
        @NotNull
        final TextRange myValueTextRange;

        VolatileState(@NotNull String displayText, int @NotNull [] gapDisplayStarts, int @NotNull [] gapPhysicalStarts, @NotNull TextRange valueTextRange) {
            if (displayText == null) {
                VolatileState.$$$reportNull$$$0(0);
            }
            if (valueTextRange == null) {
                VolatileState.$$$reportNull$$$0(1);
            }
            if (gapDisplayStarts == null) {
                VolatileState.$$$reportNull$$$0(2);
            }
            if (gapPhysicalStarts == null) {
                VolatileState.$$$reportNull$$$0(3);
            }
            this.myDisplayText = displayText;
            this.myGapDisplayStarts = gapDisplayStarts;
            this.myGapPhysicalStarts = gapPhysicalStarts;
            this.myValueTextRange = valueTextRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueTextRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gapDisplayStarts";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gapPhysicalStarts";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/xml/XmlAttributeDelegate$VolatileState";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

