/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PsiNavigateUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ClassRefactoringHandlerBase
implements RefactoringActionHandler,
ElementsHandler {
    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && this.acceptsElement(elements[0]);
    }

    protected static void navigate(PsiElement element2) {
        PsiNavigateUtil.navigate((PsiElement)element2);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiElement position;
        if (project == null) {
            ClassRefactoringHandlerBase.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element2 = position = file2.findElementAt(offset);
        while (true) {
            if (element2 == null || element2 instanceof PsiFile) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)this.getInvalidPositionMessage());
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.getTitle(), (String)this.getHelpId());
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element2)) {
                return;
            }
            if (this.acceptsElement(element2)) {
                this.invoke(project, new PsiElement[]{position}, dataContext);
                return;
            }
            element2 = element2.getParent();
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ClassRefactoringHandlerBase.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ClassRefactoringHandlerBase.$$$reportNull$$$0(2);
        }
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        this.showDialog(project, elements[0], editor, file2, dataContext);
    }

    protected abstract boolean acceptsElement(PsiElement var1);

    protected abstract void showDialog(Project var1, PsiElement var2, Editor var3, PsiFile var4, DataContext var5);

    protected abstract String getHelpId();

    @NlsContexts.DialogTitle
    protected abstract String getTitle();

    @NlsContexts.DialogMessage
    protected abstract String getInvalidPositionMessage();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/ClassRefactoringHandlerBase";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

