/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.ui.EnableDisableAction;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomaticRenamingDialog
extends DialogWrapper {
    private static final int CHECK_COLUMN = 0;
    private static final int OLD_NAME_COLUMN = 1;
    private static final int NEW_NAME_COLUMN = 2;
    private final Project myProject;
    private final AutomaticRenamer myRenamer;
    private final boolean[] myShouldRename;
    private final String[] myNewNames;
    private final PsiNamedElement[] myRenames;
    private final MyTableModel myTableModel;
    private JPanel myPanel;
    private JSplitPane mySplitPane;
    private JBTable myTable;
    private JPanel myOptionsPanel;
    private JBCheckBox mySearchInComments;
    private JBCheckBox mySearchTextOccurrences;
    private JButton mySelectAllButton;
    private JButton myUnselectAllButton;
    private JPanel myPanelForPreview;
    private UsagePreviewPanel myUsagePreviewPanel;
    private JLabel myUsageFileLabel;
    private ListSelectionListener myListSelectionListener;

    public AutomaticRenamingDialog(@NotNull Project project, @NotNull AutomaticRenamer renamer) {
        if (project == null) {
            AutomaticRenamingDialog.$$$reportNull$$$0(0);
        }
        if (renamer == null) {
            AutomaticRenamingDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myProject = project;
        this.myRenamer = renamer;
        this.$$$setupUI$$$();
        Map<PsiNamedElement, String> renames = renamer.getRenames();
        ArrayList<PsiNamedElement> temp = new ArrayList<PsiNamedElement>();
        for (PsiNamedElement namedElement : renames.keySet()) {
            String newName2 = renames.get(namedElement);
            if (newName2 == null) continue;
            temp.add(namedElement);
        }
        this.myRenames = temp.toArray(PsiNamedElement.EMPTY_ARRAY);
        Arrays.sort(this.myRenames, (e1, e2) -> Comparing.compare((Comparable)((Object)e1.getName()), (Comparable)((Object)e2.getName())));
        this.myNewNames = new String[this.myRenames.length];
        for (int i2 = 0; i2 < this.myNewNames.length; ++i2) {
            this.myNewNames[i2] = renames.get(this.myRenames[i2]);
        }
        this.myShouldRename = new boolean[this.myRenames.length];
        if (renamer.isSelectedByDefault()) {
            Arrays.fill(this.myShouldRename, true);
        }
        this.myTableModel = new MyTableModel(renamer.allowChangeSuggestedName());
        this.setTitle(renamer.getDialogTitle());
        this.init();
    }

    private void createUIComponents() {
        this.myTable = new JBTable();
        this.myTable.setRowHeight(this.myTable.getFontMetrics(UIManager.getFont("Table.font").deriveFont(1)).getHeight() + 4);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.rename.AutomaticRenamingDialog";
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JLabel(this.myRenamer.getDialogDescription()), "Center");
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.addAction((AnAction)this.createRenameSelectedAction()).setAsSecondary(true);
        panel2.add((Component)ActionManager.getInstance().createActionToolbar("AutoRenaming", (ActionGroup)actionGroup2, true).getComponent(), "East");
        Box box2 = Box.createHorizontalBox();
        box2.add(panel2);
        box2.add(Box.createHorizontalGlue());
        return box2;
    }

    public void show() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            super.show();
        }
    }

    private void handleChanges() {
        for (int i2 = 0; i2 < this.myNewNames.length; ++i2) {
            String newName2 = this.myNewNames[i2];
            if (!this.myShouldRename[i2] || RenameUtil.isValidName(this.myProject, (PsiElement)this.myRenames[i2], newName2)) continue;
            this.getOKAction().setEnabled(false);
            this.setErrorText(RefactoringBundle.message((String)"automatic.renaming.dialog.identifier.invalid.error", (Object[])new Object[]{newName2}));
            return;
        }
        this.getOKAction().setEnabled(true);
        this.setErrorText(null);
    }

    protected JComponent createCenterPanel() {
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation());
        this.myUsageFileLabel = new JLabel();
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTableModel.getSpaceAction().register();
        this.myTableModel.addTableModelListener(e -> this.handleChanges());
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                if (AutomaticRenamingDialog.this.myTable.getSelectedRows() != null) {
                    AutomaticRenamingDialog.this.compoundPopup().show(comp, x, y);
                }
            }
        });
        TableColumnModel columnModel = this.myTable.getColumnModel();
        columnModel.getColumn(0).setCellRenderer(new BooleanTableCellRenderer());
        TableUtil.setupCheckboxColumn((TableColumn)columnModel.getColumn(0), (int)0);
        columnModel.getColumn(2).setCellEditor(new StringTableCellEditor(this.myProject));
        this.mySelectAllButton.addActionListener(e -> {
            Arrays.fill(this.myShouldRename, true);
            this.fireDataChanged();
        });
        this.myUnselectAllButton.addActionListener(e -> {
            Arrays.fill(this.myShouldRename, false);
            this.fireDataChanged();
        });
        this.myListSelectionListener = e -> {
            this.myUsageFileLabel.setText("");
            int index2 = this.myTable.getSelectionModel().getLeadSelectionIndex();
            if (index2 != -1) {
                VirtualFile virtualFile2;
                PsiNamedElement element2 = this.myRenames[index2];
                UsageInfo usageInfo = new UsageInfo((PsiElement)element2);
                this.myUsagePreviewPanel.updateLayout(Collections.singletonList(usageInfo));
                PsiFile containingFile = element2.getContainingFile();
                if (containingFile != null && (virtualFile2 = containingFile.getVirtualFile()) != null) {
                    this.myUsageFileLabel.setText(virtualFile2.getName());
                }
            } else {
                this.myUsagePreviewPanel.updateLayout(null);
            }
        };
        this.myTable.getSelectionModel().addListSelectionListener(this.myListSelectionListener);
        this.myPanelForPreview.add((Component)this.myUsagePreviewPanel, "Center");
        this.myUsagePreviewPanel.updateLayout(null);
        this.myPanelForPreview.add((Component)this.myUsageFileLabel, "North");
        this.mySplitPane.setDividerLocation(0.5);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            SwingUtilities.invokeLater(() -> {
                if (this.myTableModel.getRowCount() != 0) {
                    this.myTable.getSelectionModel().addSelectionInterval(0, 0);
                }
            });
        }
        this.myOptionsPanel.setVisible(false);
        return this.myPanel;
    }

    private JPopupMenu compoundPopup() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)this.createRenameSelectedAction());
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group2);
        return menu.getComponent();
    }

    private RenameSelectedAction createRenameSelectedAction() {
        return new RenameSelectedAction((JTable)this.myTable, this.myTableModel){

            @Override
            protected boolean isValidName(String inputString, int selectedRow) {
                return RenameUtil.isValidName(AutomaticRenamingDialog.this.myProject, (PsiElement)AutomaticRenamingDialog.this.myRenames[selectedRow], inputString);
            }
        };
    }

    private void fireDataChanged() {
        int[] selectedRows = this.myTable.getSelectedRows();
        this.myTable.getSelectionModel().removeListSelectionListener(this.myListSelectionListener);
        this.myTableModel.fireTableDataChanged();
        for (int selectedRow : selectedRows) {
            this.myTable.addRowSelectionInterval(selectedRow, selectedRow);
        }
        this.myTable.getSelectionModel().addListSelectionListener(this.myListSelectionListener);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected void doOKAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        this.updateRenamer();
        super.doOKAction();
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        super.dispose();
    }

    private void updateRenamer() {
        for (int i2 = 0; i2 < this.myRenames.length; ++i2) {
            PsiNamedElement element2 = this.myRenames[i2];
            if (this.myShouldRename[i2]) {
                this.myRenamer.setRename(element2, this.myNewNames[i2]);
                continue;
            }
            this.myRenamer.doNotRename(element2);
        }
    }

    public void showOptionsPanel() {
        this.myOptionsPanel.setVisible(true);
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments.isSelected();
    }

    public boolean isSearchTextOccurrences() {
        return this.mySearchTextOccurrences.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "renamer";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/rename/AutomaticRenamingDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JButton jButton;
        JButton jButton2;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel3;
        JSplitPane jSplitPane;
        JPanel jPanel4;
        this.createUIComponents();
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(300);
        jSplitPane.setOrientation(0);
        jPanel4.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        jSplitPane.setLeftComponent(jPanel5);
        JBScrollPane jBScrollPane = new JBScrollPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel5.add((Component)jBScrollPane, gridBagConstraints);
        JBTable jBTable = this.myTable;
        jBScrollPane.setViewportView((Component)jBTable);
        this.myOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 3;
        jPanel5.add((Component)jPanel3, gridBagConstraints2);
        this.mySearchInComments = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/RefactoringBundle", AutomaticRenamingDialog.class).getString("search.in.comments.and.strings"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 17;
        jPanel3.add((Component)jBCheckBox2, gridBagConstraints3);
        this.mySearchTextOccurrences = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/RefactoringBundle", AutomaticRenamingDialog.class).getString("search.for.text.occurrences"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)jBCheckBox, gridBagConstraints4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.fill = 3;
        jPanel5.add((Component)jPanel6, gridBagConstraints5);
        this.mySelectAllButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/RefactoringBundle", AutomaticRenamingDialog.class).getString("select.all.button"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.anchor = 13;
        jPanel6.add((Component)jButton2, gridBagConstraints6);
        this.myUnselectAllButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/RefactoringBundle", AutomaticRenamingDialog.class).getString("unselect.all.button"));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.anchor = 13;
        gridBagConstraints7.insets = new Insets(0, 5, 0, 0);
        jPanel6.add((Component)jButton, gridBagConstraints7);
        this.myPanelForPreview = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jSplitPane.setRightComponent(jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static abstract class RenameSelectedAction
    extends AnAction {
        private final JTable myTable;
        private final AbstractTableModel myModel;

        public RenameSelectedAction(JTable table, AbstractTableModel model2) {
            super(RefactoringBundle.message((String)"automatic.renaming.dialog.rename.selected.title"));
            this.myTable = table;
            this.myModel = model2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RenameSelectedAction.$$$reportNull$$$0(0);
            }
            int[] selectedRows = this.myTable.getSelectedRows();
            String initial = (String)this.myModel.getValueAt(selectedRows[0], 2);
            String newName2 = Messages.showInputDialog((Component)this.myTable, (String)RefactoringBundle.message((String)"automatic.renaming.dialog.new.name.label"), (String)RefactoringBundle.message((String)"automatic.renaming.dialog.rename.selected.title"), null, (String)initial, (InputValidator)new InputValidatorEx(){

                public boolean canClose(String inputString) {
                    return this.checkInput(inputString);
                }

                @Nullable
                public String getErrorText(@NlsSafe String inputString) {
                    int selectedRow = myTable.getSelectedRow();
                    if (!this.isValidName(inputString, selectedRow)) {
                        return RefactoringBundle.message((String)"text.identifier.invalid", (Object[])new Object[]{inputString});
                    }
                    return null;
                }
            });
            if (newName2 == null) {
                return;
            }
            for (int i2 : selectedRows) {
                this.myModel.setValueAt(newName2, i2, 2);
            }
            this.myModel.fireTableDataChanged();
            for (int row2 : selectedRows) {
                this.myTable.getSelectionModel().addSelectionInterval(row2, row2);
            }
        }

        protected abstract boolean isValidName(String var1, int var2);

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RenameSelectedAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myTable.getSelectedRows().length > 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/refactoring/rename/AutomaticRenamingDialog$RenameSelectedAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private final boolean myAllowRename;

        private MyTableModel(boolean allowRename) {
            this.myAllowRename = allowRename;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return AutomaticRenamingDialog.this.myShouldRename.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AutomaticRenamingDialog.this.myShouldRename[rowIndex];
                }
                case 1: {
                    return "<html><nobr>" + RefactoringUIUtil.getDescription((PsiElement)AutomaticRenamingDialog.this.myRenames[rowIndex], true) + "</nobr></html>";
                }
                case 2: {
                    return AutomaticRenamingDialog.this.myNewNames[rowIndex];
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    AutomaticRenamingDialog.this.myShouldRename[rowIndex] = (Boolean)aValue;
                    break;
                }
                case 2: {
                    AutomaticRenamingDialog.this.myNewNames[rowIndex] = (String)aValue;
                }
            }
            AutomaticRenamingDialog.this.handleChanges();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1 && (this.myAllowRename || columnIndex != 2) && !(AutomaticRenamingDialog.this.myRenames[rowIndex] instanceof SyntheticElement);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column2) {
            switch (column2) {
                case 1: {
                    return RefactoringBundle.message((String)"automatic.renamer.entity.name.column", (Object[])new Object[]{AutomaticRenamingDialog.this.myRenamer.entityName()});
                }
                case 2: {
                    return RefactoringBundle.message((String)"automatic.renamer.rename.to.column");
                }
            }
            return " ";
        }

        private MyEnableDisable getSpaceAction() {
            return new MyEnableDisable();
        }

        private class MyEnableDisable
        extends EnableDisableAction {
            private MyEnableDisable() {
            }

            @Override
            protected JTable getTable() {
                return AutomaticRenamingDialog.this.myTable;
            }

            @Override
            protected boolean isRowChecked(int row2) {
                return AutomaticRenamingDialog.this.myShouldRename[row2];
            }

            @Override
            protected void applyValue(int[] rows, boolean valueToBeSet) {
                for (int row2 : rows) {
                    AutomaticRenamingDialog.this.myShouldRename[row2] = valueToBeSet;
                }
                AutomaticRenamingDialog.this.fireDataChanged();
            }
        }
    }
}

