/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.rename.Renamer;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.RenameKt;
import com.intellij.refactoring.rename.inplace.InplaceRenameKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/refactoring/rename/impl/RenameTargetRenamer;", "Lcom/intellij/refactoring/rename/Renamer;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "target", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/refactoring/rename/api/RenameTarget;)V", "getPresentableText", "", "performRename", "", "intellij.platform.lang.impl"})
public final class RenameTargetRenamer
implements Renamer {
    private final Project project;
    private final Editor editor;
    private final RenameTarget target;

    @NotNull
    public String getPresentableText() {
        return this.target.getPresentation().getPresentableText();
    }

    public void performRename() {
        if (this.editor != null) {
            EditorSettings editorSettings = this.editor.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
            if (editorSettings.isVariableInplaceRenameEnabled() && InplaceRenameKt.inplaceRename(this.project, this.editor, this.target)) {
                return;
            }
        }
        RenameKt.showDialogAndRename$default(this.project, this.target, null, 4, null);
    }

    public RenameTargetRenamer(@NotNull Project project, @Nullable Editor editor, @NotNull RenameTarget target2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        this.project = project;
        this.editor = editor;
        this.target = target2;
    }
}

