/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.model.Symbol;
import com.intellij.model.psi.impl.UtilKt;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.rename.Renamer;
import com.intellij.refactoring.rename.RenamerFactory;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.RenameTargetRenamer;
import com.intellij.refactoring.rename.symbol.RenameableSymbol;
import com.intellij.refactoring.rename.symbol.SymbolRenameTargetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/refactoring/rename/impl/SymbolRenameTargetRenamerFactory;", "Lcom/intellij/refactoring/rename/RenamerFactory;", "()V", "createRenamers", "", "Lcom/intellij/refactoring/rename/Renamer;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "renameTarget", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "project", "Lcom/intellij/openapi/project/Project;", "symbol", "Lcom/intellij/model/Symbol;", "intellij.platform.lang.impl"})
public final class SymbolRenameTargetRenamerFactory
implements RenamerFactory {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Renamer> createRenamers(@NotNull DataContext dataContext) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        Collection<Symbol> symbols = UtilKt.targetSymbols(dataContext);
        if (symbols.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = symbols;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RenameTarget renameTarget;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Symbol symbol = (Symbol)element$iv$iv;
            boolean bl2 = false;
            if (this.renameTarget(project2, symbol) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            RenameTarget it$iv$iv = renameTarget;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection allRenameTargets = (List)destination$iv$iv;
        Collection distinctRenameTargets = CollectionsKt.toSet((Iterable)allRenameTargets);
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        Iterable $this$map$iv = distinctRenameTargets;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void target2;
            element$iv$iv = (RenameTarget)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            RenameTargetRenamer renameTargetRenamer = new RenameTargetRenamer(project2, editor, (RenameTarget)target2);
            collection.add(renameTargetRenamer);
        }
        return (List)destination$iv$iv2;
    }

    private final RenameTarget renameTarget(Project project, Symbol symbol) {
        ExtensionPointName<SymbolRenameTargetFactory> extensionPointName = SymbolRenameTargetFactory.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"SymbolRenameTargetFactory.EP_NAME");
        for (SymbolRenameTargetFactory factory2 : (SymbolRenameTargetFactory[])extensionPointName.getExtensions()) {
            RenameTarget renameTarget = factory2.renameTarget(project, symbol);
            if (renameTarget == null) {
                continue;
            }
            return renameTarget;
        }
        if (symbol instanceof RenameableSymbol) {
            return ((RenameableSymbol)symbol).getRenameTarget();
        }
        if (symbol instanceof RenameTarget) {
            return (RenameTarget)symbol;
        }
        return null;
    }
}

