/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class DelayedRunner
implements Disposable {
    private static final int CHANGES_CHECK_TIME = 500;
    private static final int RUN_DELAY_TIME = 2000;
    private static final int NO_CHANGES = -1;
    private final Alarm myAlarm;
    private int myChangesPastTime;

    public DelayedRunner(@NotNull JComponent activationComponent) {
        if (activationComponent == null) {
            DelayedRunner.$$$reportNull$$$0(0);
        }
        this.myChangesPastTime = -1;
        this.myAlarm = new Alarm(activationComponent, (Disposable)this);
        this.queueChangesCheck();
    }

    private void queueChangesCheck() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.addRequest(() -> {
            this.checkChanges();
            this.queueChangesCheck();
        }, 500, ModalityState.any());
    }

    private void checkChanges() {
        if (this.wasChanged()) {
            this.myChangesPastTime = 0;
        } else if (this.myChangesPastTime != -1) {
            this.myChangesPastTime += 500;
            if (this.myChangesPastTime >= 2000) {
                this.myChangesPastTime = -1;
                this.run();
            }
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myAlarm);
    }

    protected abstract boolean wasChanged();

    protected abstract void run();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activationComponent", "com/intellij/remoteServer/util/DelayedRunner", "<init>"));
    }
}

