/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.text.StringCharacterIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Strings {
    private Strings() {
    }

    public static boolean isCapitalized(String word) {
        if (word.length() == 0) {
            return false;
        }
        boolean lowCase = true;
        for (int i2 = 1; i2 < word.length() && lowCase; ++i2) {
            lowCase = Character.isLowerCase(word.charAt(i2));
        }
        return Character.isUpperCase(word.charAt(0)) && lowCase;
    }

    public static boolean isCapitalized(@NotNull String text2, @NotNull TextRange range2) {
        if (text2 == null) {
            Strings.$$$reportNull$$$0(0);
        }
        if (range2 == null) {
            Strings.$$$reportNull$$$0(1);
        }
        if (range2.getLength() == 0) {
            return false;
        }
        StringCharacterIterator it = new StringCharacterIterator(text2, range2.getStartOffset() + 1, range2.getEndOffset(), range2.getStartOffset() + 1);
        boolean lowCase = true;
        char c = it.first();
        while (c != '\uffff') {
            lowCase = Character.isLowerCase(c);
            c = it.next();
        }
        return Character.isUpperCase(text2.charAt(range2.getStartOffset())) && lowCase;
    }

    public static boolean isUpperCased(@NotNull String text2, @NotNull TextRange range2) {
        if (text2 == null) {
            Strings.$$$reportNull$$$0(2);
        }
        if (range2 == null) {
            Strings.$$$reportNull$$$0(3);
        }
        if (range2.getLength() == 0) {
            return false;
        }
        StringCharacterIterator it = new StringCharacterIterator(text2, range2.getStartOffset(), range2.getEndOffset(), range2.getStartOffset());
        char c = it.first();
        while (c != '\uffff') {
            if (!Character.isUpperCase(c)) {
                return false;
            }
            c = it.next();
        }
        return true;
    }

    public static boolean isUpperCase(String word) {
        boolean upperCase = true;
        for (int i2 = 0; i2 < word.length() && upperCase; ++i2) {
            upperCase = Character.isUpperCase(word.charAt(i2));
        }
        return upperCase;
    }

    public static boolean isMixedCase(String word) {
        String lowerCase;
        if (word.length() < 2) {
            return false;
        }
        String tail = word.substring(1);
        return !tail.equals(lowerCase = StringUtil.toLowerCase((String)tail)) && !Strings.isUpperCase(word);
    }

    public static void capitalize(List<String> words) {
        for (int i2 = 0; i2 < words.size(); ++i2) {
            words.set(i2, StringUtil.capitalize((String)words.get(i2)));
        }
    }

    public static void upperCase(List<String> words) {
        for (int i2 = 0; i2 < words.size(); ++i2) {
            words.set(i2, StringUtil.toUpperCase((String)words.get(i2)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spellchecker/util/Strings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCapitalized";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isUpperCased";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

