/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.Scopes;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.StringToConstraintsTransformer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatchOptions
implements JDOMExternalizable {
    private final Map<String, MatchVariableConstraint> variableConstraints;
    private boolean looseMatching;
    private boolean recursiveSearch;
    private boolean caseSensitiveMatch;
    private String myUnknownFileType;
    private LanguageFileType myFileType;
    private Language myDialect;
    private SearchScope scope;
    private Scopes.Type scopeType;
    private String scopeDescriptor;
    private boolean searchInjectedCode;
    @NotNull
    private String pattern;
    private String myPatternContextId;
    @NonNls
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    @NonNls
    private static final String LOOSE_MATCHING_ATTRIBUTE_NAME = "loose";
    @NonNls
    private static final String RECURSIVE_ATTRIBUTE_NAME = "recursive";
    @NonNls
    public static final String OLD_CASE_SENSITIVE_ATTRIBUTE_NAME = "caseInsensitive";
    @NonNls
    public static final String CASE_SENSITIVE_ATTRIBUTE_NAME = "case_sensitive";
    @NonNls
    private static final String CONSTRAINT_TAG_NAME = "constraint";
    @NonNls
    private static final String FILE_TYPE_ATTR_NAME = "type";
    @NonNls
    private static final String DIALECT_ATTR_NAME = "dialect";
    @NonNls
    private static final String PATTERN_CONTEXT_ATTR_NAME = "pattern_context";
    @NonNls
    private static final String SCOPE_TYPE = "scope_type";
    @NonNls
    private static final String SCOPE_DESCRIPTOR = "scope_descriptor";
    @NonNls
    private static final String SEARCH_INJECTED_CODE = "search_injected";
    @NonNls
    public static final String INSTANCE_MODIFIER_NAME = "Instance";
    @NonNls
    public static final String MODIFIER_ANNOTATION_NAME = "Modifier";

    public MatchOptions() {
        this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>();
        this.looseMatching = true;
        this.searchInjectedCode = true;
        this.pattern = "";
    }

    MatchOptions(MatchOptions options2) {
        this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>(options2.variableConstraints.size());
        options2.variableConstraints.forEach((key, value2) -> this.variableConstraints.put((String)key, value2.copy()));
        this.looseMatching = options2.looseMatching;
        this.recursiveSearch = options2.recursiveSearch;
        this.caseSensitiveMatch = options2.caseSensitiveMatch;
        this.myUnknownFileType = options2.myUnknownFileType;
        this.myFileType = options2.myFileType;
        this.myDialect = options2.myDialect;
        this.scope = options2.scope;
        this.scopeType = options2.scopeType;
        this.scopeDescriptor = options2.scopeDescriptor;
        this.searchInjectedCode = options2.searchInjectedCode;
        this.pattern = options2.pattern;
        this.myPatternContextId = options2.myPatternContextId;
    }

    @NotNull
    public MatchOptions copy() {
        return new MatchOptions(this);
    }

    public void initScope(@NotNull Project project) {
        if (project == null) {
            MatchOptions.$$$reportNull$$$0(0);
        }
        if (this.scope == null && this.scopeType != null && this.scopeDescriptor != null) {
            this.scope = Scopes.createScope(project, this.scopeDescriptor, this.scopeType);
        }
    }

    public void addVariableConstraint(@NotNull MatchVariableConstraint constraint) {
        if (constraint == null) {
            MatchOptions.$$$reportNull$$$0(1);
        }
        this.variableConstraints.put(constraint.getName(), constraint);
    }

    public MatchVariableConstraint addNewVariableConstraint(@NotNull String name) {
        if (name == null) {
            MatchOptions.$$$reportNull$$$0(2);
        }
        MatchVariableConstraint constraint = new MatchVariableConstraint(name);
        this.variableConstraints.put(name, constraint);
        return constraint;
    }

    public Set<String> getUsedVariableNames() {
        LinkedHashSet<String> set2 = TemplateImplUtil.parseVariableNames(this.pattern);
        set2.add("__context__");
        return set2;
    }

    public void removeUnusedVariables() {
        Set<String> variables = this.getUsedVariableNames();
        this.variableConstraints.keySet().removeIf(key -> !variables.contains(key));
    }

    public MatchVariableConstraint getVariableConstraint(String name) {
        return this.variableConstraints.get(name);
    }

    public Set<String> getVariableConstraintNames() {
        return Collections.unmodifiableSet(this.variableConstraints.keySet());
    }

    public void setCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
    }

    public boolean isCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }

    public String toString() {
        return "match options:\npattern:\n" + this.pattern + "\nscope:\n" + (this.scope != null ? this.scope.toString() : "undefined scope") + "\nrecursive: " + this.recursiveSearch + "\ncase sensitive: " + this.caseSensitiveMatch + "\nloose: " + this.looseMatching;
    }

    public boolean isRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(boolean recursiveSearch) {
        this.recursiveSearch = recursiveSearch;
    }

    public boolean isLooseMatching() {
        return this.looseMatching;
    }

    public void setLooseMatching(boolean looseMatching) {
        this.looseMatching = looseMatching;
    }

    public void setSearchPattern(@NotNull String text2) {
        if (text2 == null) {
            MatchOptions.$$$reportNull$$$0(3);
        }
        this.pattern = text2;
    }

    @NlsSafe
    @NotNull
    public String getSearchPattern() {
        String string = this.pattern;
        if (string == null) {
            MatchOptions.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void fillSearchCriteria(@NotNull String criteria) {
        if (criteria == null) {
            MatchOptions.$$$reportNull$$$0(5);
        }
        if (!this.variableConstraints.isEmpty()) {
            this.variableConstraints.clear();
        }
        StringToConstraintsTransformer.transformCriteria(criteria, this);
    }

    @Nullable
    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope2) {
        this.scopeType = null;
        this.scopeDescriptor = null;
        this.scope = scope2;
    }

    public boolean isSearchInjectedCode() {
        return this.searchInjectedCode;
    }

    public void setSearchInjectedCode(boolean injectedCode) {
        this.searchInjectedCode = injectedCode;
    }

    public void writeExternal(Element element2) {
        element2.setAttribute(TEXT_ATTRIBUTE_NAME, this.pattern);
        if (!this.looseMatching) {
            element2.setAttribute(LOOSE_MATCHING_ATTRIBUTE_NAME, "false");
        }
        element2.setAttribute(RECURSIVE_ATTRIBUTE_NAME, String.valueOf(this.recursiveSearch));
        element2.setAttribute(OLD_CASE_SENSITIVE_ATTRIBUTE_NAME, String.valueOf(this.caseSensitiveMatch));
        if (this.myFileType != null) {
            element2.setAttribute(FILE_TYPE_ATTR_NAME, this.myFileType.getName());
        } else if (this.myUnknownFileType != null) {
            element2.setAttribute(FILE_TYPE_ATTR_NAME, this.myUnknownFileType);
        }
        if (this.myDialect != null && (this.myFileType == null || this.myFileType.getLanguage() != this.myDialect)) {
            element2.setAttribute(DIALECT_ATTR_NAME, this.myDialect.getID());
        }
        if (this.myPatternContextId != null) {
            element2.setAttribute(PATTERN_CONTEXT_ATTR_NAME, this.myPatternContextId);
        }
        if (this.scope != null) {
            element2.setAttribute(SCOPE_TYPE, Scopes.getType(this.scope).toString()).setAttribute(SCOPE_DESCRIPTOR, Scopes.getDescriptor(this.scope));
        }
        if (!this.searchInjectedCode) {
            element2.setAttribute(SEARCH_INJECTED_CODE, "false");
        }
        Set<String> constraintNames = this.getUsedVariableNames();
        for (MatchVariableConstraint matchVariableConstraint : this.variableConstraints.values()) {
            if (!constraintNames.contains(matchVariableConstraint.getName())) continue;
            Element infoElement = new Element(CONSTRAINT_TAG_NAME);
            element2.addContent(infoElement);
            matchVariableConstraint.writeExternal(infoElement);
        }
    }

    public void readExternal(Element element2) {
        this.pattern = StringUtil.notNullize((String)element2.getAttributeValue(TEXT_ATTRIBUTE_NAME));
        this.looseMatching = MatchVariableConstraint.getBooleanValue(element2, LOOSE_MATCHING_ATTRIBUTE_NAME, true);
        this.recursiveSearch = MatchVariableConstraint.getBooleanValue(element2, RECURSIVE_ATTRIBUTE_NAME, false);
        this.caseSensitiveMatch = MatchVariableConstraint.getBooleanValue(element2, OLD_CASE_SENSITIVE_ATTRIBUTE_NAME, false) || MatchVariableConstraint.getBooleanValue(element2, CASE_SENSITIVE_ATTRIBUTE_NAME, false);
        this.myUnknownFileType = element2.getAttributeValue(FILE_TYPE_ATTR_NAME);
        LanguageFileType languageFileType = this.myFileType = this.myUnknownFileType == null ? null : StructuralSearchUtil.getSuitableFileTypeByName(this.myUnknownFileType);
        if (this.myFileType != null) {
            this.myUnknownFileType = null;
        }
        this.myDialect = Language.findLanguageByID((String)element2.getAttributeValue(DIALECT_ATTR_NAME));
        this.myPatternContextId = element2.getAttributeValue(PATTERN_CONTEXT_ATTR_NAME);
        String value2 = element2.getAttributeValue(SCOPE_TYPE);
        this.scopeType = value2 == null ? null : Scopes.Type.valueOf(value2);
        this.scopeDescriptor = element2.getAttributeValue(SCOPE_DESCRIPTOR);
        this.searchInjectedCode = MatchVariableConstraint.getBooleanValue(element2, SEARCH_INJECTED_CODE, true);
        for (Element element1 : element2.getChildren(CONSTRAINT_TAG_NAME)) {
            MatchVariableConstraint constraint = new MatchVariableConstraint();
            constraint.readExternal(element1);
            this.addVariableConstraint(constraint);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchOptions)) {
            return false;
        }
        MatchOptions matchOptions = (MatchOptions)o;
        if (this.caseSensitiveMatch != matchOptions.caseSensitiveMatch) {
            return false;
        }
        if (this.looseMatching != matchOptions.looseMatching) {
            return false;
        }
        if (this.recursiveSearch != matchOptions.recursiveSearch) {
            return false;
        }
        if (!Objects.equals(this.scope, matchOptions.scope)) {
            return false;
        }
        if (this.searchInjectedCode != matchOptions.searchInjectedCode) {
            return false;
        }
        if (!this.pattern.equals(matchOptions.pattern)) {
            return false;
        }
        if (!this.variableConstraints.equals(matchOptions.variableConstraints)) {
            return false;
        }
        if (this.myUnknownFileType != matchOptions.myUnknownFileType) {
            return false;
        }
        if (this.myFileType != matchOptions.myFileType) {
            return false;
        }
        if (!Objects.equals(this.getDialect(), matchOptions.getDialect())) {
            return false;
        }
        return Objects.equals(this.myPatternContextId, matchOptions.myPatternContextId);
    }

    public int hashCode() {
        int result2 = this.looseMatching ? 1 : 0;
        result2 = 29 * result2 + (this.recursiveSearch ? 1 : 0);
        result2 = 29 * result2 + (this.caseSensitiveMatch ? 1 : 0);
        result2 = 29 * result2 + this.pattern.hashCode();
        result2 = 29 * result2 + this.variableConstraints.hashCode();
        if (this.scope != null) {
            result2 = 29 * result2 + this.scope.hashCode();
        }
        result2 = 29 * result2 + (this.searchInjectedCode ? 1 : 0);
        if (this.myUnknownFileType != null) {
            result2 = 29 * result2 + this.myUnknownFileType.hashCode();
        }
        if (this.myFileType != null) {
            result2 = 29 * result2 + this.myFileType.hashCode();
        }
        if (this.myDialect != null) {
            result2 = 29 * result2 + this.myDialect.hashCode();
        }
        if (this.myPatternContextId != null) {
            result2 = 29 * result2 + this.myPatternContextId.hashCode();
        }
        return result2;
    }

    public void setFileType(@NotNull LanguageFileType fileType) {
        if (fileType == null) {
            MatchOptions.$$$reportNull$$$0(6);
        }
        this.myFileType = fileType;
    }

    @Nullable
    public LanguageFileType getFileType() {
        return this.myFileType;
    }

    @Nullable
    public Language getDialect() {
        if (this.myDialect == null) {
            LanguageFileType fileType = this.getFileType();
            return fileType == null ? null : fileType.getLanguage();
        }
        return this.myDialect;
    }

    public void setDialect(Language dialect) {
        this.myDialect = dialect;
    }

    public PatternContext getPatternContext() {
        Language dialect = this.getDialect();
        return dialect == null ? null : StructuralSearchUtil.findPatternContextByID(this.myPatternContextId, dialect);
    }

    public void setPatternContext(PatternContext patternContext) {
        this.myPatternContextId = patternContext == null ? null : patternContext.getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = CONSTRAINT_TAG_NAME;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEXT_ATTRIBUTE_NAME;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/MatchOptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "criteria";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/MatchOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addVariableConstraint";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addNewVariableConstraint";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSearchPattern";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillSearchCriteria";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFileType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

