/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.LightTopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SkippingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfileBase
extends StructuralSearchProfile {
    private static final String DELIMITER_CHARS = ",;.[]{}():";

    @Override
    public void compile(PsiElement @NotNull [] elements, final @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(1);
        }
        PsiElement topElement = elements[0].getParent();
        PsiElement element2 = elements.length > 1 ? topElement : elements[0];
        element2.accept((PsiElementVisitor)new MyCompilingVisitor(globalVisitor, topElement));
        element2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                MatchingHandler delegate2;
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element2);
                if (DuplocatorUtil.isIgnoredNode(element2)) {
                    return;
                }
                CompiledPattern pattern = globalVisitor.getContext().getPattern();
                MatchingHandler handler2 = pattern.getHandler(element2);
                if (!(handler2 instanceof SubstitutionHandler || handler2 instanceof TopLevelMatchingHandler || handler2 instanceof LightTopLevelMatchingHandler)) {
                    pattern.setHandler(element2, new SkippingHandler(handler2));
                }
                if (handler2 instanceof LightTopLevelMatchingHandler && !((delegate2 = ((LightTopLevelMatchingHandler)handler2).getDelegate()) instanceof SubstitutionHandler)) {
                    pattern.setHandler(element2, new LightTopLevelMatchingHandler(new SkippingHandler(delegate2)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/StructuralSearchProfileBase$1", "visitElement"));
            }
        });
        final Language baseLanguage = element2.getContainingFile().getLanguage();
        globalVisitor.getContext().getPattern().setStrategy(new MatchingStrategy(){

            @Override
            public boolean continueMatching(PsiElement start2) {
                Language fileLanguage;
                Language language = start2.getLanguage();
                PsiFile file2 = start2.getContainingFile();
                if (file2 != null && (fileLanguage = file2.getLanguage()).isKindOf(language)) {
                    language = fileLanguage;
                }
                return language == baseLanguage;
            }

            @Override
            public boolean shouldSkip(PsiElement element2, PsiElement elementToMatchWith) {
                return DuplocatorUtil.shouldSkip(element2, elementToMatchWith);
            }
        });
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(2);
        }
        return new MyMatchingVisitor(globalVisitor);
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element2 -> DuplocatorUtil.isIgnoredNode(element2);
        if (nodeFilter == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(3);
        }
        return nodeFilter;
    }

    private static boolean containsOnlyDelimiters(String s) {
        int n = s.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (DELIMITER_CHARS.indexOf(s.charAt(i2)) >= 0) continue;
            return false;
        }
        return true;
    }

    protected abstract String @NotNull [] getVarPrefixes();

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new CompiledPattern(){

            @Override
            @NotNull
            protected SubstitutionHandler doCreateSubstitutionHandler(@NotNull String name, boolean target2, int minOccurs, int maxOccurs, boolean greedy) {
                if (name == null) {
                    3.$$$reportNull$$$0(0);
                }
                return new MySubstitutionHandler(name, target2, minOccurs, maxOccurs, greedy);
            }

            @Override
            public String @NotNull [] getTypedVarPrefixes() {
                String[] stringArray = StructuralSearchProfileBase.this.getVarPrefixes();
                if (stringArray == null) {
                    3.$$$reportNull$$$0(1);
                }
                return stringArray;
            }

            @Override
            public boolean isTypedVar(@NotNull String str) {
                if (str == null) {
                    3.$$$reportNull$$$0(2);
                }
                for (String prefix2 : StructuralSearchProfileBase.this.getVarPrefixes()) {
                    if (!str.startsWith(prefix2)) continue;
                    return true;
                }
                return false;
            }

            @Override
            @NotNull
            public String getTypedVarString(@NotNull PsiElement element2) {
                if (element2 == null) {
                    3.$$$reportNull$$$0(3);
                }
                PsiElement initialElement = element2;
                PsiElement child2 = SkippingHandler.getOnlyNonWhitespaceChild(element2);
                while (child2 != element2 && child2 != null && !(child2 instanceof LeafElement)) {
                    element2 = child2;
                    child2 = SkippingHandler.getOnlyNonWhitespaceChild(element2);
                }
                String string = child2 instanceof LeafElement ? element2.getText() : initialElement.getText();
                if (string == null) {
                    3.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchProfileBase$3";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfileBase$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypedVarPrefixes";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypedVarString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doCreateSubstitutionHandler";
                        break;
                    }
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isTypedVar";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypedVarString";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(4);
        }
        return language.isKindOf(this.getFileType().getLanguage());
    }

    @NotNull
    protected abstract LanguageFileType getFileType();

    @Override
    public void checkReplacementPattern(@NotNull Project project, @NotNull ReplaceOptions options2) {
        if (project == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(5);
        }
        if (options2 == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(6);
        }
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(7);
        }
        if (replaceOptions == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(8);
        }
        return new DocumentBasedReplaceHandler(project);
    }

    private static boolean canBePatternVariable(@NotNull PsiElement element2) {
        if (element2 == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(9);
        }
        if (element2 instanceof LeafElement) {
            return true;
        }
        while (!(element2 instanceof LeafElement) && element2 != null) {
            element2 = SkippingHandler.getOnlyNonWhitespaceChild(element2);
        }
        return element2 != null;
    }

    protected boolean isStringLiteral(PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        ASTNode astNode = element2.getNode();
        if (astNode == null) {
            return false;
        }
        IElementType elementType = astNode.getElementType();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element2.getLanguage());
        if (parserDefinition != null) {
            TokenSet literals = parserDefinition.getStringLiteralElements();
            return literals.contains(elementType);
        }
        return false;
    }

    private static boolean canBePatternVariableValue(@NotNull PsiElement element2) {
        if (element2 == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(10);
        }
        return !StructuralSearchProfileBase.containsOnlyDelimiters(element2.getText());
    }

    @Override
    public boolean canBeVarDelimiter(@NotNull PsiElement element2) {
        ASTNode node2;
        if (element2 == null) {
            StructuralSearchProfileBase.$$$reportNull$$$0(11);
        }
        return (node2 = element2.getNode()) != null && this.getVariableDelimiters().contains(node2.getElementType());
    }

    protected TokenSet getVariableDelimiters() {
        return TokenSet.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchProfileBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfileBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkReplacementPattern";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canBePatternVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canBePatternVariableValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canBeVarDelimiter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySubstitutionHandler
    extends SubstitutionHandler {
        final Set<PsiElement> myExceptedNodes;

        MySubstitutionHandler(@NotNull String name, boolean target2, int minOccurs, int maxOccurs, boolean greedy) {
            if (name == null) {
                MySubstitutionHandler.$$$reportNull$$$0(0);
            }
            super(name, target2, minOccurs, maxOccurs, greedy);
            this.myExceptedNodes = new HashSet<PsiElement>();
        }

        @Override
        public boolean matchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes, @NotNull MatchContext context2) {
            if (patternNodes == null) {
                MySubstitutionHandler.$$$reportNull$$$0(1);
            }
            if (matchNodes == null) {
                MySubstitutionHandler.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                MySubstitutionHandler.$$$reportNull$$$0(3);
            }
            if (this.doMatchSequentially(patternNodes, matchNodes, context2)) {
                return true;
            }
            PsiElement current2 = patternNodes.current();
            if (current2 != null) {
                this.myExceptedNodes.add(current2);
            }
            boolean result2 = this.doMatchSequentiallyBySimpleHandler(patternNodes, matchNodes, context2);
            this.myExceptedNodes.remove(current2);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternNodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchNodes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfileBase$MySubstitutionHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchSequentially";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMatchingVisitor
    extends PsiElementVisitor {
        private final GlobalMatchingVisitor myGlobalVisitor;

        MyMatchingVisitor(GlobalMatchingVisitor globalVisitor) {
            this.myGlobalVisitor = globalVisitor;
        }

        private boolean shouldIgnoreVarNode(PsiElement element2) {
            MatchingHandler handler2 = this.myGlobalVisitor.getMatchContext().getPattern().getHandlerSimple(element2);
            if (handler2 instanceof DelegatingHandler) {
                handler2 = ((DelegatingHandler)((Object)handler2)).getDelegate();
            }
            return handler2 instanceof MySubstitutionHandler && ((MySubstitutionHandler)handler2).myExceptedNodes.contains(element2);
        }

        public void visitElement(@NotNull PsiElement element2) {
            if (element2 == null) {
                MyMatchingVisitor.$$$reportNull$$$0(0);
            }
            super.visitElement(element2);
            EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(element2);
            if (descriptorProvider != null) {
                EquivalenceDescriptor descriptor1 = descriptorProvider.buildDescriptor(element2);
                EquivalenceDescriptor descriptor2 = descriptorProvider.buildDescriptor(this.myGlobalVisitor.getElement());
                if (descriptor1 != null && descriptor2 != null) {
                    boolean result2 = DuplocatorUtil.match(descriptor1, descriptor2, (AbstractMatchingVisitor)this.myGlobalVisitor, Collections.emptySet(), null);
                    this.myGlobalVisitor.setResult(result2);
                    return;
                }
            }
            if (StructuralSearchProfileBase.this.isStringLiteral(element2)) {
                this.visitLiteral(element2);
                return;
            }
            if (StructuralSearchProfileBase.canBePatternVariable(element2) && this.myGlobalVisitor.getMatchContext().getPattern().isRealTypedVar(element2) && !this.shouldIgnoreVarNode(element2)) {
                PsiElement matchedElement = this.myGlobalVisitor.getElement();
                PsiElement newElement = SkippingHandler.skipNodeIfNecessary(matchedElement);
                while (newElement != matchedElement) {
                    matchedElement = newElement;
                    newElement = SkippingHandler.skipNodeIfNecessary(matchedElement);
                }
                this.myGlobalVisitor.setResult(this.myGlobalVisitor.handleTypedElement(element2, matchedElement));
            } else if (element2 instanceof LeafElement) {
                this.myGlobalVisitor.setResult(element2.getText().equals(this.myGlobalVisitor.getElement().getText()));
            } else if (element2.getFirstChild() == null && element2.getTextLength() == 0) {
                this.myGlobalVisitor.setResult(true);
            } else {
                PsiElement patternChild = element2.getFirstChild();
                PsiElement matchedChild = this.myGlobalVisitor.getElement().getFirstChild();
                NodeIterator patternIterator = SsrFilteringNodeIterator.create(patternChild);
                NodeIterator matchedIterator = SsrFilteringNodeIterator.create(matchedChild);
                boolean matched = this.myGlobalVisitor.matchSequentially(patternIterator, matchedIterator);
                this.myGlobalVisitor.setResult(matched);
            }
        }

        private void visitLiteral(PsiElement literal) {
            PsiElement l2 = this.myGlobalVisitor.getElement();
            MatchingHandler handler2 = (MatchingHandler)literal.getUserData(CompiledPattern.HANDLER_KEY);
            if (handler2 instanceof SubstitutionHandler) {
                char c;
                int offset = 0;
                int length = l2.getTextLength();
                String text2 = l2.getText();
                if (length > 2 && ((c = text2.charAt(0)) == '\"' || c == '\'') && text2.charAt(length - 1) == c) {
                    boolean looseMatching = this.myGlobalVisitor.getMatchContext().getOptions().isLooseMatching();
                    if (!looseMatching && c != literal.getText().charAt(0)) {
                        this.myGlobalVisitor.setResult(false);
                        return;
                    }
                    --length;
                    ++offset;
                }
                this.myGlobalVisitor.setResult(((SubstitutionHandler)handler2).handle(l2, offset, length, this.myGlobalVisitor.getMatchContext()));
            } else if (handler2 != null) {
                this.myGlobalVisitor.setResult(handler2.match(literal, l2, this.myGlobalVisitor.getMatchContext()));
            } else {
                this.myGlobalVisitor.setResult(literal.textMatches(l2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/StructuralSearchProfileBase$MyMatchingVisitor", "visitElement"));
        }
    }

    private class MyCompilingVisitor
    extends PsiRecursiveElementVisitor {
        private final GlobalCompilingVisitor myGlobalVisitor;
        private final PsiElement myTopElement;
        private Pattern[] mySubstitutionPatterns;

        MyCompilingVisitor(GlobalCompilingVisitor globalVisitor, PsiElement topElement) {
            this.myGlobalVisitor = globalVisitor;
            this.myTopElement = topElement;
        }

        public void visitElement(@NotNull PsiElement element2) {
            if (element2 == null) {
                MyCompilingVisitor.$$$reportNull$$$0(0);
            }
            this.doVisitElement(element2);
            if (StructuralSearchProfileBase.this.isStringLiteral(element2)) {
                this.visitLiteral(element2);
            }
        }

        private void doVisitElement(@NotNull PsiElement element2) {
            String text2;
            ParserDefinition parserDefinition;
            if (element2 == null) {
                MyCompilingVisitor.$$$reportNull$$$0(1);
            }
            CompiledPattern pattern = this.myGlobalVisitor.getContext().getPattern();
            if (this.myGlobalVisitor.getCodeBlockLevel() == 0) {
                this.initTopLevelElement(element2);
                return;
            }
            if (StructuralSearchProfileBase.canBePatternVariable(element2) && pattern.isRealTypedVar(element2)) {
                this.myGlobalVisitor.handle(element2);
                MatchingHandler handler2 = pattern.getHandler(element2);
                handler2.setFilter(other -> StructuralSearchProfileBase.canBePatternVariableValue(other));
                super.visitElement(element2);
                return;
            }
            super.visitElement(element2);
            if (this.myGlobalVisitor.getContext().getSearchHelper().doOptimizing() && element2 instanceof LeafElement && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element2.getLanguage())) != null && StringUtil.isJavaIdentifier((String)(text2 = element2.getText()))) {
                this.myGlobalVisitor.processTokenizedName(text2, GlobalCompilingVisitor.OccurenceKind.CODE);
            }
        }

        private void visitLiteral(PsiElement literal) {
            String value2 = literal.getText();
            if (StringUtil.isQuotedString((String)value2)) {
                if (this.mySubstitutionPatterns == null) {
                    String[] prefixes = this.myGlobalVisitor.getContext().getPattern().getTypedVarPrefixes();
                    this.mySubstitutionPatterns = StructuralSearchUtil.createPatterns(prefixes);
                }
                for (Pattern substitutionPattern : this.mySubstitutionPatterns) {
                    @Nullable MatchingHandler handler2 = this.myGlobalVisitor.processPatternStringWithFragments(value2, GlobalCompilingVisitor.OccurenceKind.LITERAL, substitutionPattern);
                    if (handler2 == null) continue;
                    literal.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler2);
                    break;
                }
            }
        }

        private void initTopLevelElement(PsiElement element2) {
            CompiledPattern pattern = this.myGlobalVisitor.getContext().getPattern();
            PsiElement newElement = SkippingHandler.skipNodeIfNecessary(element2);
            if (element2 != newElement) {
                newElement.accept((PsiElementVisitor)this);
                pattern.setHandler(element2, new LightTopLevelMatchingHandler(pattern.getHandler(element2)));
            } else {
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() + 1);
                for (PsiElement el = element2.getFirstChild(); el != null; el = el.getNextSibling()) {
                    if (GlobalCompilingVisitor.getFilter().accepts(el)) {
                        if (!(el instanceof PsiWhiteSpace)) continue;
                        this.myGlobalVisitor.addLexicalNode(el);
                        continue;
                    }
                    el.accept((PsiElementVisitor)this);
                    MatchingHandler matchingHandler = pattern.getHandler(el);
                    pattern.setHandler(el, element2 == this.myTopElement ? new TopLevelMatchingHandler(matchingHandler) : new LightTopLevelMatchingHandler(matchingHandler));
                }
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() - 1);
                pattern.setHandler(element2, new TopLevelMatchingHandler(pattern.getHandler(element2)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfileBase$MyCompilingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doVisitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

