/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.XmlMatchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.ListNodeIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlMatchingVisitor
extends XmlElementVisitor {
    private final GlobalMatchingVisitor myMatchingVisitor;

    public XmlMatchingVisitor(@NotNull GlobalMatchingVisitor matchingVisitor) {
        if (matchingVisitor == null) {
            XmlMatchingVisitor.$$$reportNull$$$0(0);
        }
        this.myMatchingVisitor = matchingVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitXmlAttribute(XmlAttribute attribute) {
        XmlAttribute another = (XmlAttribute)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.getMatchContext().pushResult();
        XmlElement name = attribute.getNameElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)name);
        try {
            if (!this.myMatchingVisitor.setResult(isTypedVar || this.myMatchingVisitor.matchText((PsiElement)name, (PsiElement)another.getNameElement()))) {
                return;
            }
            XmlAttributeValue valueElement = attribute.getValueElement();
            this.myMatchingVisitor.setResult(valueElement == null || this.myMatchingVisitor.matchOptionally((PsiElement)valueElement, (PsiElement)another.getValueElement()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch((PsiElement)name, isTypedVar, (PsiElement)another);
        }
    }

    public void visitXmlAttributeValue(XmlAttributeValue value2) {
        XmlAttributeValue another = (XmlAttributeValue)this.myMatchingVisitor.getElement();
        String text2 = value2.getValue();
        if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text2)) {
            SubstitutionHandler handler2 = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(text2);
            String text22 = another.getText();
            int offset = StringUtil.isQuotedString((String)text22) ? 1 : 0;
            this.myMatchingVisitor.setResult(handler2.handle((PsiElement)another, offset, text22.length() - offset, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(text2, another.getValue()));
        }
    }

    public void visitXmlTag(XmlTag tag2) {
        XmlTagChild[] children2;
        ListNodeIterator matchNodes;
        NodeIterator matchNodes2;
        NodeIterator patternNodes;
        XmlToken name;
        XmlTag another = this.myMatchingVisitor.getElement(XmlTag.class);
        if (another == null) {
            return;
        }
        CompiledPattern pattern = this.myMatchingVisitor.getMatchContext().getPattern();
        boolean isTypedVar = pattern.isTypedVar((PsiElement)(name = XmlUtil.getTokenOfType((PsiElement)tag2, XmlTokenType.XML_NAME)));
        if (!this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText(tag2.getName(), another.getName())) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])tag2.getAttributes(), (PsiElement[])another.getAttributes()))) {
            return;
        }
        XmlTagChild[] children1 = tag2.getValue().getChildren();
        if (children1.length != 0 && (children1.length == 1 && pattern.isTypedVar((PsiElement)children1[0]) ? (patternNodes = SsrFilteringNodeIterator.create((PsiElement[])tag2.getValue().getChildren())).current() != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(patternNodes, matchNodes2 = SsrFilteringNodeIterator.create((PsiElement[])another.getValue().getChildren()))) : (children1.length != 1 || !XmlMatchUtil.isWhiteSpace((PsiElement)children1[0])) && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(patternNodes = new ListNodeIterator(XmlMatchUtil.getElementsToMatch(children1)), matchNodes = new ListNodeIterator(XmlMatchUtil.getElementsToMatch(children2 = another.getValue().getChildren())))))) {
            return;
        }
        if (isTypedVar) {
            SubstitutionHandler handler2 = (SubstitutionHandler)pattern.getHandler((PsiElement)name);
            this.myMatchingVisitor.setResult(handler2.handle((PsiElement)XmlUtil.getTokenOfType((PsiElement)another, XmlTokenType.XML_NAME), this.myMatchingVisitor.getMatchContext()));
        }
    }

    public void visitXmlText(XmlText text2) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)text2) ? this.myMatchingVisitor.handleTypedElement((PsiElement)text2, this.myMatchingVisitor.getElement()) : this.myMatchingVisitor.matchSequentially(text2.getFirstChild(), this.myMatchingVisitor.getElement().getFirstChild()));
    }

    public void visitXmlToken(XmlToken token2) {
        if (token2.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
            String text2 = token2.getText();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text2) ? this.myMatchingVisitor.handleTypedElement((PsiElement)token2, this.myMatchingVisitor.getElement()) : this.myMatchingVisitor.matchText(text2, this.myMatchingVisitor.getElement().getText()));
        }
    }

    public void visitXmlComment(XmlComment comment) {
        super.visitXmlComment(comment);
        PsiElement element2 = this.myMatchingVisitor.getElement();
        if (!(element2 instanceof XmlComment)) {
            return;
        }
        XmlComment other = (XmlComment)element2;
        XmlToken text2 = XmlUtil.getTokenOfType((PsiElement)comment, XmlTokenType.XML_COMMENT_CHARACTERS);
        assert (text2 != null);
        CompiledPattern pattern = this.myMatchingVisitor.getMatchContext().getPattern();
        boolean typedVar = pattern.isTypedVar((PsiElement)text2);
        if (typedVar) {
            SubstitutionHandler handler2 = (SubstitutionHandler)pattern.getHandler((PsiElement)text2);
            this.myMatchingVisitor.setResult(handler2.handle((PsiElement)XmlUtil.getTokenOfType((PsiElement)other, XmlTokenType.XML_COMMENT_CHARACTERS), this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(StructuralSearchUtil.normalize(text2.getText()), StructuralSearchUtil.normalize(other.getCommentText())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingVisitor", "com/intellij/structuralsearch/impl/matcher/XmlMatchingVisitor", "<init>"));
    }
}

