/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.jetbrains.annotations.NotNull;

public class TextFilter
extends FilterAction {
    boolean myShowHierarchy;

    public TextFilter() {
        super(SSRBundle.messagePointer("text.filter.name", new Object[0]));
    }

    @Override
    @NotNull
    public String getShortText(NamedScriptableDefinition variable) {
        if (!(variable instanceof MatchVariableConstraint)) {
            return "";
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        String text2 = constraint.getRegExp();
        if (text2.isEmpty()) {
            return constraint.isWithinHierarchy() ? SSRBundle.message("hierarchy.tooltip.message", new Object[0]) : "";
        }
        String string = SSRBundle.message("text.tooltip.message", constraint.isInvertRegExp() ? 1 : 0, text2, constraint.isWholeWordsOnly() ? 1 : 0, constraint.isWithinHierarchy() ? 1 : 0);
        if (string == null) {
            TextFilter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean hasFilter() {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        return variable != null && (!StringUtil.isEmpty((String)variable.getRegExp()) || variable.isWithinHierarchy());
    }

    @Override
    public void clearFilter() {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        if (variable == null) {
            return;
        }
        variable.setRegExp("");
        variable.setWholeWordsOnly(false);
        variable.setWithinHierarchy(false);
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target2) {
        if (!(this.myTable.getVariable() instanceof MatchVariableConstraint)) {
            return false;
        }
        this.myShowHierarchy = this.isApplicableConstraint("TEXT HIERARCHY", nodes, completePattern, target2);
        return this.isApplicableConstraint("TEXT", nodes, completePattern, target2);
    }

    @Override
    protected void setLabel(SimpleColoredComponent component2) {
        MatchVariableConstraint variable = this.myTable.getMatchVariable();
        if (variable == null) {
            return;
        }
        Object value2 = variable.isInvertRegExp() ? "!" + variable.getRegExp() : variable.getRegExp();
        this.myLabel.append(SSRBundle.message("text.0.label", value2));
        if (variable.isWholeWordsOnly()) {
            this.myLabel.append(SSRBundle.message("whole.words.label", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        if (variable.isWithinHierarchy()) {
            this.myLabel.append(SSRBundle.message("within.hierarchy.label", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public FilterEditor<MatchVariableConstraint> getEditor() {
        return new FilterEditor<MatchVariableConstraint>(this.myTable.getMatchVariable(), this.myTable.getConstraintChangedCallback()){
            private final EditorTextField myTextField;
            private final JCheckBox myHierarchyCheckBox;
            private final JLabel myTextLabel;
            private final ContextHelpLabel myHelpLabel;
            {
                this.myTextField = UIUtil.createRegexComponent("", TextFilter.this.myTable.getProject());
                this.myHierarchyCheckBox = new JCheckBox(SSRBundle.message("within.type.hierarchy.check.box", new Object[0]), false);
                this.myTextLabel = new JLabel(SSRBundle.message("text.label", new Object[0]));
                this.myHelpLabel = ContextHelpLabel.create((String)SSRBundle.message("text.filter.help.text", new Object[0]));
            }

            @Override
            protected void layoutComponents() {
                GroupLayout layout = new GroupLayout(this);
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myTextLabel).addComponent((Component)((Object)this.myTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel)).addGroup(layout.createSequentialGroup().addComponent(this.myHierarchyCheckBox)));
                layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myTextLabel).addComponent((Component)((Object)this.myTextField)).addComponent((Component)this.myHelpLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myHierarchyCheckBox)));
            }

            @Override
            protected void loadValues() {
                this.myTextField.setText((((MatchVariableConstraint)this.myConstraint).isInvertRegExp() ? "!" : "") + ((MatchVariableConstraint)this.myConstraint).getRegExp());
                this.myHierarchyCheckBox.setSelected(((MatchVariableConstraint)this.myConstraint).isWithinHierarchy());
                this.myHierarchyCheckBox.setVisible(TextFilter.this.myShowHierarchy);
            }

            @Override
            public void saveValues() {
                String text2 = this.myTextField.getText();
                if (text2.startsWith("!")) {
                    ((MatchVariableConstraint)this.myConstraint).setRegExp(text2.substring(1));
                    ((MatchVariableConstraint)this.myConstraint).setInvertRegExp(true);
                } else {
                    ((MatchVariableConstraint)this.myConstraint).setRegExp(text2);
                    ((MatchVariableConstraint)this.myConstraint).setInvertRegExp(false);
                }
                ((MatchVariableConstraint)this.myConstraint).setWholeWordsOnly(false);
                ((MatchVariableConstraint)this.myConstraint).setWithinHierarchy(this.myHierarchyCheckBox.isSelected());
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                return this.myTextField;
            }

            @Override
            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myTextField};
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/filters/TextFilter", "getShortText"));
    }
}

